/*------------------------------------------------------------------------*\
|                                                                          |
|           FIXFONT2.CMD - Version 1.0 - Version Date 1996-08-11           |
|                                                                          |
\*------------------------------------------------------------------------*/
/*

   Remove all unregistered OS/2 Typ 1 fonts from M:\FONTS\PSFONTS and
   M:\FONTS\PSFONTS\PFM

   Move all TrueType .FOT & .TTF files in Windows directories to
   M:\FONTS\TRUETYPE and correct path on .FOT if necessary.

*/
GBL. = ''             /* initialize stem */
parse Arg             GBL.CommandLine 
parse Version         GBL.RexxVersion,
                      GBL.RexxVersionLevel,
                      GBL.RexxVersionDay,
                      GBL.RexxVersionMonth,
                      GBL.RexxVersionYear    .
parse Source          GBL.OperatingSystem,
                      GBL.CallingEnvironment,
                      GBL.ProgramPathAndName   /* case is unreliable */   

parse value DATE('S') with,
   year +4,
   mm   +2,
   dd

GBL.Environment     = 'OS2ENVIRONMENT'
GBL.List            = 'GBL.'
GBL.BootDrive       = LEFT( VALUE( 'RUNWORKPLACE',, GBL.Environment ), 2 )
GBL.CurrentDate     = mm || '/' || dd || '/' || year
GBL.Hostname        = VALUE( 'MACHINENAME',, GBL.Environment )
GBL.Ramdrive        = VALUE( 'RAMDRIVE',, GBL.Environment )
GBL.ProgramVersion  = 1.0           /* version / mod of this program */
GBL.ProgramName     = STRIP( FILESPEC( 'N', GBL.ProgramPathAndName ) )
GBL.ProgramPath     = STRIP( FILESPEC( 'D', GBL.ProgramPathAndName ) ||,
                             FILESPEC( 'P', GBL.ProgramPathAndName ) )

parse var GBL.ProgramName,
   GBL.ProgramFn  '.',
   GBL.ProgramFe 
GBL.ProgramFe  = TRANSLATE( GBL.ProgramFe  )
call TIME 'R'                    /* reset elapsed timer - sssss.uuuuu */
say 'Begin' GBL.ProgramFn || '.' || GBL.ProgramFe  'at' TIME('N')

/*------------------------*\
|  Enable trap processing  |
|    if REXXLIB present    |
\*------------------------*/
   SIGNAL ON ERROR
   SIGNAL ON FAILURE
   SIGNAL ON HALT
   SIGNAL ON NOVALUE
   SIGNAL ON SYNTAX

crlf               = '0D0A'x
GBL.font_home_path = 'M:\FONTS\'

GBL.LogFile  =,
   GBL.ProgramPath  ||,
   GBL.ProgramFn  || '.LOG'
if STREAM( GBL.LogFile, 'C', 'QUERY EXISTS' ) = '' then
   do
      log_line = crlf || COPIES( '=', 76 )
      call LINEOUT GBL.LogFile, log_line
   end
log_line = GBL.ProgramFn || '.' || GBL.ProgramFe || ' Started on' DATE() 'at' TIME() ' CPU:' GBL.Hostname '-' GBL.OperatingSystem
call LINEOUT GBL.LogFile, log_line

/*------------------------------------------------------*\
|  Create associative array with all PM_Font file names  |
\*------------------------------------------------------*/
ini_font_stem. = ''
app_name = 'PM_Fonts'
call SysIni 'USER', app_name, 'ALL:', 'ini_font_stem'
if RESULT = 'ERROR:' then
   do
      log_line =,
         'Unable to locate' app_name 'in' VALUE( 'USER_INI',, GBL.Environment )
      call LINEOUT GBL.LogFile, log_line
      say log_line
      call EOJ
   end

do i = 1 to ini_font_stem.0
   key_name  = ini_font_stem.i
   key_value = STRIP( SysIni( 'USER', app_name, key_name ), 'T', '00'x )
   parse upper value FILESPEC( 'N', key_value ) with,
      ini_font_fn '.' ini_font_fe
   if ini_font_fe = 'FON' then iterate i
   ini_font_stem.INI_FONT_FN = i
end

/*------------------------------------*\
|  Delete any unregistered font files  |
|    from \PSFONTS & PSFONTS\PFM       |
\*------------------------------------*/
call SysFileTree GBL.font_home_path || 'PSFONTS\*.*' ,'stem', 'FST'
if stem.0 = 0 then
   do
      say '   Unable to find any files'
      call EOJ
   end

do s = 1 to stem.0
   parse upper value stem.s with,
      stem_timestamp,
      stem_size,
      stem_attr,
      stem_path_and_file_name
   stem_path_and_file_name = STRIP( stem_path_and_file_name )

   parse value FILESPEC( 'N', stem_path_and_file_name ) with,
      stem_fn '.' stem_fe

   if ini_font_stem.STEM_FN = '' then iterate s

   call SysFileDelete stem_path_and_file_name
   log_line =,
      stem_path_and_file_name 'was deleted'
   call LINEOUT GBL.LogFile, log_line
end

/*-----------------------------------------------*\
|  Table of path for all WIN.INI & ATM.INI files  |
\*-----------------------------------------------*/
p=0
p=p+1; path_table.p = 'C:\WIN-311\'
p=p+1; path_table.p = 'D:\OS2\MDOS\WINOS2\'
p=p+1; path_table.p = 'F:\OS2\MDOS\WINOS2\'
p=p+1; path_table.p = 'G:\OS2\MDOS\WINOS2\'
p=p+1; path_table.p = 'H:\OS2\MDOS\WINOS2\'
p=p+1; path_table.p = 'I:\OS2\MDOS\WINOS2\'
       path_table.0 = p

do p = 1 to path_table.0
   call ARRANGE_FOT_AND_TTF_FILES path_table.p || 'SYSTEM\'
end

call STREAM GBL.LogFile, 'C', 'CLOSE'

call EOJ 0


/*------------------------------------------------------------------------*\
|                                                                          |
|      Move TTF & FOT files to M:\FONTS\TRUETYPE & adjust path in FOT      |
|                                                                          |
\*------------------------------------------------------------------------*/
ARRANGE_FOT_AND_TTF_FILES:
   Procedure expose,
      (GBL.List)

parse ARG system_path

log_line =,
   'Move' system_path || '*.TTF to' GBL.font_home_path || 'TRUETYPE'
call LINEOUT GBL.LogFile, log_line
call STREAM  GBL.LogFile, 'C', 'CLOSE'

SIGNAL OFF ERROR
SIGNAL OFF FAILURE
'@copy' system_path || '*.TTF' GBL.font_home_path || 'TRUETYPE\*.* 1>>' || GBL.LogFile  '2>>&1'
'@del'  system_path || '*.TTF 1>>' || GBL.LogFile  '2>>&1'
SIGNAL ON ERROR
SIGNAL ON FAILURE

fot_path_ptr  = X2D( 400 ) + 1
fot_path_lgth = 96

call SysFileTree system_path || '*.FOT', 'fot_stem', 'FT'
do f = 1 to fot_stem.0
   parse value fot_stem.f with,
      original_fot_timestamp,
      original_fot_size,
      original_fot_attr,
      original_fot_path_and_file_name
   original_fot_path_and_file_name = STRIP(original_fot_path_and_file_name)

   parse upper value FILESPEC( 'N', original_fot_path_and_file_name ) with,
      original_font_fn '.' .

   /*---------------*\
   |  Get .FOT file  |
   \*---------------*/
   fot_area = CHARIN( original_fot_path_and_file_name, 1, original_fot_size )
   call STREAM original_fot_path_and_file_name, 'C', 'CLOSE'

   fot_change_count = 0

   /*--------------------------------------------------*\
   |  Extract and clear TTF path & name from .FOT file  |
   \*--------------------------------------------------*/
   original_ttf_path_and_file_name =,
      STRIP( SUBSTR( fot_area, fot_path_ptr, fot_path_lgth ), 'T', '00'x )
   if FILESPEC( 'P', original_ttf_path_and_file_name ) = '' then
      do
         original_tth_path_and_file_name =,
            system_path ||,
            original_ttf_path_and_file_name
      end

   /*--------------------------------------------*\
   |  Write new .FOT if TTF in M:\FONTS\TRUETYPE  |
   \*--------------------------------------------*/
   new_fot_path_and_file_name =,
      GBL.font_home_path || 'TRUETYPE\' || original_font_fn || '.FOT'
   new_ttf_path_and_file_name =,
      STREAM( GBL.font_home_path || 'TRUETYPE\' || original_font_fn || '.TTF',,
              'C', 'QUERY EXISTS' )
   if new_ttf_path_and_file_name = '' then
      do
         fot_area =,
            OVERLAY( COPIES( '00'x, fot_path_lgth ), fot_area, fot_path_ptr )
         fot_area =,
            OVERLAY( new_ttf_path_and_file_name, fot_area, fot_path_ptr )
         call SysFileDelete new_fot_path_and_file_name
         call CHAROUT new_fot_path_and_file_name, fot_area
         call STREAM  new_fot_path_and_file_name, 'C', 'CLOSE'
         call SysFileDelete original_fot_path_and_file_name
         iterate f
      end

   /*-------------------------------------------------------*\
   |  Copy .FOT to M:\FONTS\TRUETYPE if TTF exist elsewhere  |
   \*-------------------------------------------------------*/
   if STREAM( original_ttf_path_and_file_name, 'C', 'QUERY EXISTS' ) = '' then
      do
         call DOSCOPY original_fot_path_and_file_name, new_fot_path_and_file_name, 'R'
         call SysFileDelete original_fot_path_and_file_name
         iterate f
      end

   /*--------------------------*\
   |  No TTF file for FOT file  |
   \*--------------------------*/
   log_line =,
      'Unable to locate' original_ttf_path_and_file_name',',
      original_fot_path_and_file_name 'deleted'
   call LINEOUT GBL.LogFile, log_line
   call SysFileDelete original_fot_path_and_file_name

end

return


!tr!=VALUE('TRACE',, GBL.Environment); if !tr!<>'' then do;say 'Trace' !tr! 'started'; TRACE(!tr!);nop;end
/*------------------------------------------------------------------------*\
|                                                                          |
|                                End of Job                                |
|                                                                          |
\*------------------------------------------------------------------------*/
EOJ:
   Procedure expose,
      GBL.

if ARG() = 0 then
   eoj_rc = 0
else
   eoj_rc = ARG(1)

elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu */
parse value elapsed_time with seconds '.' micro_seconds
if LEFT( micro_seconds, 1, 1 ) >= 5 then
   seconds = seconds + 1
ss = FORMAT( seconds // 60, 2 )
minutes = ( seconds - ss ) / 60
mm = FORMAT( minutes // 60, 2 )
hh = FORMAT( ( minutes - mm ) / 60, 2 )
duration = hh':'mm':'ss

say 'EOJ   ' || GBL.ProgramFn || '.' || GBL.ProgramFe 'at' TIME('N') ||,
    ', duration' TRANSLATE( duration, '0', ' ' )
exit eoj_rc

/*------------------------------------------------------------------------*\
|                                                                          |
|                              Trap Routines                               |
|                                                                          |
\*------------------------------------------------------------------------*/
ERROR:       call TRAP_PROCESSING_01   SIGL, 'ERROR',   RC
FAILURE:     call TRAP_PROCESSING_01   SIGL, 'FAILURE', RC
HALT:        call TRAP_PROCESSING_01   SIGL, 'HALT',    ''
LOGIC_ERROR: call TRAP_PROCESSING_01   SIGL, 'LOGIC',   ARG( 1 )
NOVALUE:     call TRAP_PROCESSING_01   SIGL, 'NOVALUE', ''
SYNTAX:      call TRAP_PROCESSING_01   SIGL, 'SYNTAX',  RC

TRAP_PROCESSING_01:
   SIGNAL ON ERROR   name TRAP_PROCESSING_02 /* prevent recursion */
   SIGNAL ON FAILURE name TRAP_PROCESSING_02 /* prevent recursion */
   SIGNAL ON HALT    name TRAP_PROCESSING_02 /* prevent recursion */
   SIGNAL ON NOVALUE name TRAP_PROCESSING_02 /* prevent recursion */
   SIGNAL ON SYNTAX  name TRAP_PROCESSING_02 /* prevent recursion */
   ?Trap.   = ''     /* Revised 98/12/18 */
   TRAP_DMP = ''     /* .DMP path & file name */
   TRAP_DMP_TIMESTAMP = DATE( ) || COPIES(' ', 2 ) || LEFT( TIME('L'),11 )

/*---------------------*\
|  Program path & name  |
\*---------------------*/
parse Source  ?Trap.?OperatingSystem . ?Trap.?ProgramPathAndFileName
parse Version ?Trap.?RexxVersion

?Trap.?LineNumber = ARG( 1 )
if POS( ':', ?Trap.?ProgramPathAndFileName ) > 0 then
   /* get source line if it is available */
   do ?T = 1
      TRAP_SOURCE_LINE.?T =  SOURCELINE( ?Trap.?LineNumber )
      TRAP_SOURCE_LINE.0  = ?T
      if TRAP_SOURCE_LINE.?T == '' then
         do
            TRAP_SOURCE_LINE.?T = 'Source is not available'
            leave
         end
      ?Trap.?LineNumber   = ?Trap.?LineNumber + 1
      if RIGHT( TRAP_SOURCE_LINE.?T, 1 ) == ',' then
         do
            leave
         end
   end
else
   /* program is running in macrospace */
   do
      ?Trap.?ProgramPathAndFileName =,
         STRIP( DIRECTORY( ), 'T', '\' ) || '\' ||,
         ?Trap.?ProgramPathAndFileName
      TRAP_SOURCE_LINE.1 = 'Source line is not available.'
      TRAP_SOURCE_LINE.0 = 1
   end

parse value FILESPEC( 'N', ?Trap.?ProgramPathAndFileName ) with,
   ?Trap.?Fn '.' ?Trap.?Fe
TRAP_DMP =,
   FILESPEC( 'D', ?Trap.?ProgramPathAndFileName ) ||,
   FILESPEC( 'P', ?Trap.?ProgramPathAndFileName ) ||,
   ?Trap.?Fn || '.' || 'DMP'

/*-------------------------------------------*\
|  Determine whether ANSII or VX-REXX output  |
\*-------------------------------------------*/
?Trap.?VXREXX = ( RxFuncQuery( 'VRWindow' ) = 0 )
if ?Trap.?VXREXX then
   do
      /* see if Primary Window handle exists */
      ?Trap.?VXREXX = ( LEFT( VRWindow( ), 1 ) = '?' )
   end

/*------------------------------------------*\
|  Check for reason NOT to create .DMP file  |
\*------------------------------------------*/
select
   when ARG( 2 ) = 'HALT' then
      do
         TRAP_DMP = ''
      end
   when POS( ':', TRAP_DMP ) = 0 then
      do
         TRAP_DMP = ''
      end
   when ABBREV( ?Trap.?RexxVersion, 'OBJREXX' ) then
      do
         if RxFuncQuery( 'SysDumpVariables' ) <> 0 then
            do
               TRAP_DMP = ''
            end
      end
   when ?Trap.?OperatingSystem = 'OS/2' then
      do
         if RxFuncQuery( 'VARDUMP' ) <> 0 then
            do
               TRAP_DMP = ''
            end
      end
   otherwise
      do
         nop
      end
end

/*------------------------*\
|  Build trap message box  |
\*------------------------*/
?DBL.H     = 'CD'x                 /*  double line - horizontal   */
?DBL.V     = 'BA'x                 /*  double line - vertical     */
?DBL.BL    = 'C8'x                 /*  double line - bottom left  */
?DBL.BR    = 'BC'x                 /*  double line - bottom right */
?DBL.TL    = 'C9'x                 /*  double line - top left     */
?DBL.TR    = 'BB'x                 /*  double line - top right    */
if ?Trap.?OperatingSystem == 'WindowsNT' then
   do
      ?Trap.?RED = '1B'x || '[1;37;41m'  /* bright white on red    */
      ?Trap.?DUL = '1B'x || '[0m'        /* reset to normal        */
   end
?Trap.?Margin = COPIES( ' ', 2 )

TRAP_ERROR_DESCRIPTION =,
   'Error line = ' || ARG( 1 ) || '; ' || ARG( 2 ) || ' trap caught'
if ARG( 3 ) <> '' then
   TRAP_ERROR_DESCRIPTION = TRAP_ERROR_DESCRIPTION ||,
      '  Return code = ' || ARG( 3 )

?T=0
?T=?T+1; ?Trap.?line.?T = ?Trap.?Fn'.'?Trap.?Fe
?T=?T+1; ?Trap.?line.?T = TRAP_ERROR_DESCRIPTION
if TRAP_DMP <> '' then
   do
?T=?T+1; ?Trap.?line.?T = ''
?T=?T+1; ?Trap.?line.?T = 'See: ' || TRAP_DMP
   end
?T=?T+1; ?Trap.?line.?T = ''
?T=?T+1; ?Trap.?line.?T = 'Source line(s) at time of trap:'
do ?S = 1 to TRAP_SOURCE_LINE.0
   ?T=?T+1; ?Trap.?line.?T = ?Trap.?Margin || TRAP_SOURCE_LINE.?S
end
         ?Trap.?line.0 = ?T
if ?Trap.?VXREXX then
   do
      ?Trap.?PrimaryWindowHandle = VRWindow( )
      call VRSet  ?Trap.?PrimaryWindowHandle,,
                  'BackColor',      'White',,
                  'ForeColor',      'Red',,
                  ''

      call VRMessageStem ?Trap.?PrimaryWindowHandle,,
                         '?Trap.?line.',,
                         CENTER( ?Trap.?Fn 'Fatal error', 74 ),,
                         'E'
   end
else
   do
      ?Trap.?Width = MAX( 74, LENGTH( TRAP_ERROR_DESCRIPTION ) )
      say ?Trap.?RED || ?DBL.TL || COPIES( ?DBL.H,?Trap.?Width + 2 ) || ?DBL.TR || ?Trap.?DUL
      say ?Trap.?RED || ?DBL.V  || COPIES( ' ',   ?Trap.?Width + 2 ) || ?DBL.V  || ?Trap.?DUL
      do ?T = 1 to ?Trap.?line.0
      say ?Trap.?RED || ?DBL.V    LEFT( ?Trap.?line.?T, ?Trap.?Width )   ?DBL.V  || ?Trap.?DUL
      end
      say ?Trap.?RED || ?DBL.V  || COPIES( ' ',   ?Trap.?Width + 2 ) || ?DBL.V  || ?Trap.?DUL
      say ?Trap.?RED || ?DBL.BL || COPIES( ?DBL.H,?Trap.?Width + 2 ) || ?DBL.BR || ?Trap.?DUL
   end

/*---------------------------------*\
|  Create .DMP file if appropriate  |
\*---------------------------------*/
if TRAP_DMP <> '' then
   do
      /* remove meaningless labels from dump for clarity */
      drop ( GBL.DumpExclusionList )
      drop ?dbl. ?Trap. ?S ?T ?tr?
      call SysFileDelete TRAP_DMP
      select
         when RxFuncQuery( 'VARDUMP' ) == 0 then
            do
               call VARDUMP TRAP_DMP  /* write variables to program.DMP file */
            end
         when RxFuncQuery( 'SysDumpVariables' ) == 0 then
            do
               call SysDumpVariables TRAP_DMP  /* write variables to program.DMP file */
            end
         otherwise; nop
      end
   end

TRAP_PROCESSING_02:
   exit 255
