/* inetcfg
Copyright 2000 - 2001 by Chuck McKinnis,  Sandia Park, NM (USA) 04 Oct 2001
mckinnis@attglobal.net

REXX Program to install INetLog, set the parameters for the inetlog.cmd
and ijoylog.cmd, and convert existing an existing inetlog.ini file to inetcfg.cfg

   Right to freely use, modify, distribute granted but please acknowledge
   source as a courtesy if you build upon it.  Please pass on comments,
   suggestions, problems to mckinnis@attglobal.net
*/
Trace 'N'
Parse Upper Arg otherparms '|' pmrexx
our_parms = otherparms
pmrexx = (pmrexx <> '')

/* Where are we ? */
Parse Source . . install_path .
our_prog = install_path
inetlog_program = install_path
install_path = Filespec('D',install_path) || Filespec('P',install_path)
old_ini_file = install_path || 'inetlog.ini'
inetcfg_ini = install_path || 'inetcfg.ini'
inetsmp_ini = install_path || 'inetsmp.ini'
our_path = Strip(install_path, 'T', '\')
save_path = Directory(our_path)
null = '00'x

If Rxfuncquery('SysDropFuncs') Then
   Call Rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

quiet = 0

obj_id = '<INETCFG_RUN>'
If \pmrexx Then
   Do
      Call PMRexxGo 'START', obj_id, our_prog, 'Internet Log Anyalyzer Setup', our_parms
      Return
   End

Signal On Failure Name errhandler
Signal On Halt Name errhandler
Signal On Syntax Name errhandler


If Rx_fileexists(inetcfg_ini) Then      /* save any existing ini file */
   Do
      ini_save = Left(inetcfg_ini, Lastpos('.', inetcfg_ini)) || 'sav'
      Address cmd '@copy' inetcfg_ini ini_save '> nul'
   End

Call Read_config                              /* read the config file */

Call Read_me

Call Update_config                   /* update config file parameters */

Call Check_config                    /* check for config file updates */

Call Update_object                      /* get parameters for INetLog */

Call Create_object                /* create/update the INetLog object */

Call Cleanup                                   /* end of main program */

Return

/* read the documentation */
Read_me:
Say 'Would you like to read the documentation? Y/n'
Parse Upper Pull ans .
If \Abbrev(ans, 'N') Then
   Address cmd '@start e.exe' install_path || 'readme.txt'
Say 'Would you like to read the changes list? y/N'
Parse Upper Pull ans .
If Abbrev(ans, 'Y') Then
   Address cmd '@start e.exe' install_path || 'changes.txt'
Say 'Press any key to continue ...'
Parse Upper Pull ans .
Return

/* read the config file */
Read_config:
trace_save = Trace('N')
use_sample = 0
Call Config_sample                               /* build inetsmp.ini */
If Rx_fileexists(inetcfg_ini) Then        /* do we have a config file */
   input_file = inetcfg_ini
Else
   Do
      input_file = inetsmp_ini
      use_sample = 1
   End

Say 'Using configuration file -' input_file
cfg_common = SysIni(input_file, 'cfg_common', 'cfg_common')
If cfg_common <> 'ERROR:' Then
   Do i = 1 To Words(cfg_common)
      keyid = Word(cfg_common, i)
      Interpret keyid '= sysini("' || input_file || '", "cfg_common", "' || keyid || '")'
   End
Else
   Do
      Say 'cfg_common not found in' input_file
      Call Cleanup
   End
cfg_inetlog = SysIni(input_file, 'cfg_inetlog', 'cfg_inetlog')
If cfg_inetlog <> 'ERROR:' Then
   Do i = 1 To Words(cfg_inetlog)
      keyid = Word(cfg_inetlog, i)
      Interpret keyid '= sysini("' || input_file || '", "cfg_inetlog", "' || keyid || '")'
   End
Else
   Do
      Say 'cfg_inetlog not found in' input_file
      Call Cleanup
   End
cfg_ijoylog = SysIni(input_file, 'cfg_ijoylog', 'cfg_ijoylog')
If cfg_ijoylog <> 'ERROR:' Then
   Do i = 1 To Words(cfg_ijoylog)
      keyid = Word(cfg_ijoylog, i)
      Interpret keyid '= sysini("' || input_file || '", "cfg_ijoylog", "' || keyid || '")'
   End
Else
   Do
      Say 'cfg_ijoylog not found in' input_file
      Call Cleanup
   End
If use_sample Then
   Call Write_config inetcfg_ini, 'all'
Call Convert_ini old_ini_file          /* update from an old ini file */
Call SysIni inetcfg_ini, 'cfg_common', 'what_r_we', what_r_we
Say what_r_we
Trace(trace_save)
Return

/* convert or update config using an existing ini file */
Convert_ini:
trace_save = Trace('N')
Parse Arg old_ini_file
If Rx_fileexists(old_ini_file) ,
   & File_cmd(old_ini_file, 'D') > File_cmd(input_file, 'D') Then
   Do
      ini_key = 'IGN InJoy DataPath DisplayDailyReport PauseAsScreenFills' ,
         'WarnPercent ConnectDigits MinuteDigits HourDigits'
      key_key = 'ibm_dialer injoy_dialer data_path daily_report one_screen_at_a_time' ,
         'warn_pct sig_x sig_min sig_hr'
      /* get all keys */
      xrc = SysIni(old_ini_file, 'COMMON', 'ALL:', 'keys.')
      If keys.0 > 0 Then
         Do i = 1 To keys.0                 /* get all the key values */
            key_id = Word(key_key, Wordpos(keys.i, ini_key))
            key_value = "'" || SysIni(old_ini_file, 'COMMON', keys.i) || "'"
            Interpret key_id '=' key_value
         End
      ini_key = 'IniFileName OutputFileName SummaryFileName LastTimeStamp'
      key_key = 'ibm_dialer_ini_file ibm_output_file ibm_summary_file ibm_last_time_stamp'
      /* get all keys */
      xrc = SysIni(old_ini_file, 'INETLOG', 'ALL:', 'keys.')
      If keys.0 > 0 Then
         Do i = 1 To keys.0                 /* get all the key values */
            key_id = Word(key_key, Wordpos(keys.i, ini_key))
            key_value = "'" || SysIni(old_ini_file, 'INETLOG', keys.i) || "'"
            Interpret key_id '=' key_value
         End
      ini_key = 'InJoyOutput InJoySummary'
      key_key = 'injoy_output_file injoy_summary_file'
      /* get all keys */
      xrc = SysIni(old_ini_file, 'IJOYLOG', 'ALL:', 'keys.')
      If keys.0 > 0 Then
         Do i = 1 To keys.0                 /* get all the key values */
            key_id = keys.i
            If Wordpos(key_id, ini_key) > 0 Then
               Do
                  key_id = Word(key_key, Wordpos(keys.i, ini_key))
                  key_value = "'" || SysIni(old_ini_file, 'IJOYLOG', keys.i) || "'"
                  Interpret key_id '=' key_value
               End
         End
      injoy_total_logs = SysIni(old_ini_file, 'IJOYLOG', 'InJoyLogs')
      log_value = ''
      acct_value = ''
      user_value = ''
      time_value = ''
      Do i = 1 To injoy_total_logs
         key = 'InJoyLog_' || i
         log_value = log_value SysIni(old_ini_file, 'IJOYLOG', key)
         If log_value = 'ERROR:' Then
            log_value = Word(SysIni(old_ini_file, 'IJOYLOG', 'InJoyLog'), i)
         key = 'InJoyAcct_' || i
         acct_value = acct_value SysIni(old_ini_file, 'IJOYLOG', key)
         If acct_value = 'ERROR:' Then
            acct_value = Word(SysIni(old_ini_file, 'IJOYLOG', 'InJoyAcct'), i)
         key = 'InJoyUser_' || i
         user_value = user_value SysIni(old_ini_file, 'IJOYLOG', key)
         If user_value = 'ERROR:' Then
            user_value = Word(SysIni(old_ini_file, 'IJOYLOG', 'InJoyUser'), i)
         key = 'InJoyTimeStamp_' || i
         time_value = time_value SysIni(old_ini_file, 'IIJOYLOG', key)
         If time_value = 'ERROR:' Then
            time_value = Word(SysIni(old_ini_file, 'IJOYLOG', 'InJoyTimeStamp'), i)
      End
      If injoy_logs <> '' Then
         injoy_logs = Strip(log_value)
      Else
         injoy_logs = null
      If injoy_accts <> '' Then
         injoy_accts = Strip(acct_value)
      Else
         injoy_accts = null
      If injoy_users <> '' Then
         injoy_users = Strip(user_value)
      Else
         injoy_users = null
      If injoy_times <> '' Then
         injoy_times = Strip(time_value)
      Else
         injoy_times = null
      Call Write_config inetcfg_ini, 'all'
      Address cmd '@rename' old_ini_file 'inetini.sav > nul'
   End
Trace(trace_save)
Return

/* update config file */
Update_config:
trace_save = Trace('N')
If \use_sample Then
   Do
      Say 'Update all common data in -'
      Say inetcfg_ini '(y/N)'
      Parse Upper Pull ans .
   End
Else
   ans = 'Y'
If Abbrev(ans, 'Y') Then
   Do
      cfg_common = SysIni(inetsmp_ini, 'cfg_common', 'cfg_common')
      If cfg_common <> 'ERROR:' Then
         Do i = 1 To Words(cfg_common)
            keyid = Word(cfg_common, i)
            Interpret keyid '= sysini("' || inetsmp_ini || '", "cfg_common", "' || keyid || '")'
         End
      Else
         Do
            Say 'Application cfg_common has no keys'
            Call Cleanup
         End
      Call Write_config inetcfg_ini, 'cfg_common'
   End

If \use_sample Then
   Do
      Say 'Update all IBM dialer data in -'
      Say inetcfg_ini '(y/N)'
      Parse Upper Pull ans .
   End
Else
   ans = 'Y'
If Abbrev(ans, 'Y') Then
   Do
      cfg_inetlog = SysIni(inetsmp_ini, 'cfg_inetlog', 'cfg_inetlog')
      If cfg_inetlog <> 'ERROR:' Then
         Do i = 1 To Words(cfg_inetlog)
            keyid = Word(cfg_inetlog, i)
            Interpret keyid '= sysini("' || inetsmp_ini || '", "cfg_inetlog", "' || keyid || '")'
         End
      Else
         Do
            Say 'Application cfg_inetlog has no keys'
            Call Cleanup
         End
      Call Write_config inetcfg_ini, 'cfg_inetlog'
   End
If \use_sample Then
   Do
      Say 'Update all InJoy dialer data in -'
      Say inetcfg_ini '(y/N)'
      Parse Upper Pull ans .
   End
Else
   ans = 'Y'
If Abbrev(ans, 'Y') Then
   Do
      cfg_ijoylog = SysIni(inetsmp_ini, 'cfg_ijoylog', 'cfg_ijoylog')
      If cfg_ijoylog <> 'ERROR:' Then
         Do i = 1 To Words(cfg_ijoylog)
            keyid = Word(cfg_ijoylog, i)
            Interpret keyid '= sysini("' || inetsmp_ini || '", "cfg_ijoylog", "' || keyid || '")'
         End
      Else
         Do
            Say 'Application cfg_ijoylog has no keys'
            Call Cleanup
         End
      Call Write_config inetcfg_ini, 'cfg_ijoylog'
   End
Trace(trace_save)
Return

/* update the config file */
Check_config:
trace_save = Trace('N')
/* path to data files */
Call SysIni inetcfg_ini, 'cfg_common', 'data_path', data_path

/* create the data path sub-directory if needed */
If \Rx_fileexists(data_path) Then
   Call Rx_makepath data_path

/* IBM dialer support */
If ibm_dialer = null Then
   Do
      Say 'Support the IBM dialer (y/N)?'
      Parse Upper Pull ans .
      key_value = Abbrev(ans, 'Y')
      ibm_dialer = key_value
      Call SysIni inetcfg_ini, 'cfg_common', 'ibm_dialer', ibm_dialer
   End
/* process IBM dialer entries */
If ibm_dialer Then
   Do
      /* dialer ini file */
      If ibm_dialer_ini_file = null Then
         Do
            Say 'Please select your IBM dialer by number'
            Say '   1 - DIALER.EXE (1.67 and below)'
            Say '   2 - TCPDIAL.EXE (1.69 and above)'
            Parse Upper Pull ans .
            Select
               When ans = 1 Then
                  key_value = 'dialer.ini'
               When ans = 2 Then
                  key_value = 'tcpdial.ini'
               Otherwise Do
                  Say 'You did not chose a supported dialer'
                  key_value = null
               End
            End
            ibm_dialer_ini_file = key_value
         End
      Call Write_config inetcfg_ini, 'cfg_inetlog'
   End

/* InJoy dialer support */
If injoy_dialer = null Then
   Do
      Say 'Support the InJoy dialer (y/N)?'
      Parse Upper Pull ans .
      key_value = Abbrev(ans, 'Y')
      injoy_dialer = key_value
      Call SysIni inetcfg_ini, 'cfg_common', 'injoy_dialer', injoy_dialer
   End
/* process InJoy dialer entries */
If injoy_dialer Then
   Do
      If injoy_logs = null Then
         Do
            injoy_accts = null
            injoy_users = null
            injoy_times = null
            /* get path to InJoy */
            Say 'Enter the full path to the InJoy Dialer logs or hit enter to quit.'
            Parse Upper Pull ans .
            If ans <> '' Then
               Do
                  /* get all *.log file names */
                  log_path = ans
                  hosts. = ''
                  accounts. = ''
                  users. = ''
                  logs. = ''
                  x = 0
                  default_host_file = log_path || '\default.cfg'
                  default_host_file = Stream(log_path || '\default.cfg', 'c', 'query exists')
                  If default_host_file <> '' Then
                     Do
                        hosts_dat = ''
                        Do While Chars(default_host_file) > 0
                           hosts_dat = hosts_dat || Charin(default_host_file)
                        End
                        Parse Var hosts_dat . 3 host_name + 8 . 281 account_data_length + 2 . 765 host_log + 12 .
                        account_data_length = X2d(C2x(account_data_length))
                        Parse Var hosts_dat . 286 account_data + (account_data_length) .
                        If Pos('.', account_data) <> 0 Then
                           Do
                              user_name = Substr(account_data, Lastpos('.', account_data) + 1)
                              account_data = Left(account_data, Lastpos('.', account_data) - 1)
                              account_name = Substr(account_data, Lastpos('.', account_data) + 1)
                           End
                        Else
                           Do
                              account_name = ''
                              user_name = Strip(account_data)
                           End
                        host_log = Stream(log_path || '\' || Strip(host_log, , '00'x), 'c', 'query exists')
                        If host_log <> '' Then
                           Do
                              x = x + 1
                              hosts.x = Strip(host_name, , '00'x)
                              accounts.x = account_name
                              users.x = user_name
                              logs.x = Strip(host_log)
                              logs.0 = x
                           End
                     End
                  hosts_dat_file = Stream(log_path || '\hosts.dat', 'c', 'query exists')
                  If hosts_dat_file <> '' Then
                     Do
                        hosts_dat = ''
                        Do While Chars(hosts_dat_file) > 0
                           hosts_dat = hosts_dat || Charin(hosts_dat_file)
                        End
                        Do Until hosts_dat = ''
                           Parse Var hosts_dat host_rec 1178 hosts_dat
                           Parse Var host_rec . 281 account_data_length + 2 . 485 host_name + 8 . 765 host_log + 12 .
                           account_data_length = X2d(C2x(account_data_length))
                           Parse Var host_rec . 286 account_data + (account_data_length) .
                           If Pos('.', account_data) <> 0 Then
                              Do
                                 user_name = Substr(account_data, Lastpos('.', account_data) + 1)
                                 account_data = Left(account_data, Lastpos('.', account_data) - 1)
                                 account_name = Substr(account_data, Lastpos('.', account_data) + 1)
                              End
                           Else
                              Do
                                 account_name = ''
                                 user_name = Strip(account_data)
                              End
                           host_log = Stream(log_path || '\' || Strip(host_log, , '00'x), 'c', 'query exists')
                           If host_log <> '' Then
                              Do
                                 x = x + 1
                                 hosts.x = Space(Translate(host_name, , '5F'x, ' '))
                                 accounts.x = account_name
                                 users.x = user_name
                                 logs.x = Strip(host_log)
                                 logs.0 = x
                              End
                        End
                     End
                  /* loop through log file names to see the user wants them included */
                  If logs.0 > 0 Then
                     Do i = 1 To logs.0
                        Say 'Found InJoy log file -' logs.i '- for host -' hosts.i
                        Say 'Analyze this log (y/N)'
                        Parse Upper Pull ans
                        If Abbrev(ans, 'Y') Then
                           Do
                              injoy_logs = Space(injoy_logs logs.i)
                              If accounts.i <> '' Then
                                 injoy_accts = Space(injoy_accts accounts.i)
                              Else
                                 Do
                                    Say 'Enter an account id for InJoy log (enter = none)'
                                    Say logs.i
                                    Parse Pull accounts.i
                                    If accounts.i = '' Then
                                       accounts.i = 'none'
                                    injoy_accts = Strip(injoy_accts accounts.i)
                                 End
                              If users.i <> '' Then
                                 injoy_users = Space(injoy_users users.i)
                              Else
                                 Do
                                    Say 'Enter an user id for InJoy log (enter = none)'
                                    Say log.i 'and account id -' accounts.i
                                    Parse Pull users.i
                                    If users.i = '' Then
                                       users.i = 'none'
                                    injoy_users = Strip(injoy_users users.i)
                                 End
                              times.i = 'T00000000000000'
                              injoy_times = Strip(injoy_times times.i)
                           End
                     End
                  Else
                     Do
                        Say 'Unable to locate any logs in InJoy log path -' ans
                        Say 'InJoy logs in' ans 'will not be processed.'
                     End
               End
            Else
               Say 'InJoy logs will not be processed'
            If injoy_logs <> null Then
               injoy_logs = Space(Translate(injoy_logs, , null))
            If injoy_accts <> null Then
               injoy_accts = Space(Translate(injoy_accts, , null))
            If injoy_users <> null Then
               injoy_users = Space(Translate(injoy_users, , null))
            If injoy_times <> null Then
               injoy_times = Space(Translate(injoy_times, , null))
         End
      Call Write_config inetcfg_ini, 'cfg_ijoylog'
   End
Trace(trace_save)
Return

/* write the config file */
Write_config:
trace_save = Trace('N')
Parse Arg ini_file, ini_appl
If ini_appl = '' Then
   ini_appl = 'all'
If ini_appl = 'all' | ini_appl = 'cfg_common' Then
   Do
      Call SysIni ini_file, 'cfg_common', 'cfg_common', cfg_common
      Do i = 1 To Words(cfg_common)
         Call SysIni ini_file, 'cfg_common', Word(cfg_common, i), Value(Word(cfg_common, i))
      End
   End
If ini_appl = 'all' | ini_appl = 'cfg_inetlog' Then
   Do
      Call SysIni ini_file, 'cfg_inetlog', 'cfg_inetlog', cfg_inetlog
      Do i = 1 To Words(cfg_inetlog)
         Call SysIni ini_file, 'cfg_inetlog', Word(cfg_inetlog, i), Value(Word(cfg_inetlog, i))
      End
   End
If ini_appl = 'all' | ini_appl = 'cfg_ijoylog' Then
   Do
      Call SysIni ini_file, 'cfg_ijoylog', 'cfg_ijoylog', cfg_ijoylog
      Do i = 1 To Words(cfg_ijoylog)
         Call SysIni ini_file, 'cfg_ijoylog', Word(cfg_ijoylog, i), Value(Word(cfg_ijoylog, i))
      End
   End

Trace(trace_save)
Return

/* Get parameters for the INetLog object */
Update_object:
parmlist = ''
If ibm_dialer | injoy_dialer Then
   Do
      Say 'Do you want daily reports? y/N'
      Parse Upper Pull ans .
      If Abbrev(ans, 'Y') Then
         daily_report = 1
      Else
         daily_report = 0
      Call SysIni inetcfg_ini, 'cfg_common', 'daily_report', daily_report
      Say 'Do you want to run without output to the screen'
      Say 'and only generate the report files? y/N'
      Parse Upper Pull ans .
      If Abbrev(ans, 'Y') Then
         parmlist = parmlist 'QUIET'
   End
If ibm_dialer & injoy_dialer Then
   Do
      Say 'Do you want:'
      Say '   1 - individual reports for the IBM dialer and the'
      Say '       InJoy dialer'
      Say '   2 - a combined report for the IBM dialer and the'
      Say '       InJoy dialer as well as a report for each dialer'
      Say '   3 - only a combined report for both the IBM dialer'
      Say '       and the InJoy dialer'
      Say 'Select an option number'
      Parse Upper Pull ans .
      Select
         When ans = 1 Then
            Say 'Individual reports for all dialers will be generated'
         When ans = 2 Then
            Do
               Say 'A combined report for all dialers will be generated'
               parmlist = parmlist 'COMBINE'
            End
         When ans = 3 Then
            Do
               Say 'Only a combined report for all dialers will be generated'
               parmlist = parmlist 'COMBINEONLY'
            End
         Otherwise Do
            Say 'Invalid selection'
            Say 'Individual reports for all dialers will be generated'
         End
      End
   End
parmlist = Space(parmlist)
Return

/* Create INetLog objects */
Create_object:

/* Create INetLog folder */
classname = 'WPFolder'
location = '<WP_DESKTOP>'
title = 'Internet Log^Analyzer'
setup = 'OBJECTID=<WP_INETLOG>;'
If SysCreateObject(classname, title, location, setup, 'U') Then
   Do
      Say 'INetLog folder created/updated successfully'

      /* Create INetLog object */
      classname = 'WPProgram'
      location = '<WP_INETLOG>'
      title = 'Dialer Log^Analyzer'
      obj = 'OBJECTID=<INETLOGP>;'
      iconfile = 'ICONFILE=' || our_path || '\INETLOG.ICO;'
      our_exec = Stream(our_path || '\inetlog.cmd', 'c', 'query exists')
      exename = 'EXENAME=' || our_exec || ';'
      startupdir = 'STARTUPDIR=' || our_path || ';'
      setup = obj || iconfile || exename || startupdir || 'MINIMIZED=YES;'
      If parmlist <> '' Then
         setup = setup || 'PARAMETERS=' || parmlist || ';'
      If SysCreateObject(classname, title, location, setup, 'U') Then
         Do
            Say 'INetLog object created/updated successfully'
            rc = SysMkDir(our_path || '\DATA')
         End
      Else
         Say 'Unable to create/update INetLog object'

      /* Create INetCfg object */
      classname = 'WPProgram'
      location = '<WP_INETLOG>'
      title = 'Dialer Log^Configurator'
      obj = 'OBJECTID=<INETLOGC>;'
      iconfile = 'ICONFILE=' || our_path || '\INETLOG.ICO;'
      our_exec = Stream(our_path || '\install.cmd', 'c', 'query exists')
      exename = 'EXENAME=' || our_exec || ';'
      startupdir = 'STARTUPDIR=' || our_path || ';'
      setup = obj || iconfile || exename || startupdir || 'MINIMIZED=NO;'
      If SysCreateObject(classname, title, location, setup, 'U') Then
         Say 'INetCfg object created/updated successfully'
      Else
         Say 'Unable to create/update INetCfg object'
   End
Else
   Say 'Unable to create/update INetLog folder'

Return

Errhandler:
Call Beep 300, 500
Say 'Rexx error' rc 'in line' sigl||':' Errortext(rc)
Say Sourceline(sigl)
Call Cleanup
Return

Cleanup:                                                      /* Exit */
Say 'Press any key to exit...'
Parse Upper Pull .
If Rx_fileexists(inetsmp_ini) Then
   Call SysFileDelete inetsmp_ini
save_path = Directory(save_path)
Call PMRexxGo 'EXIT', obj_id
Return                                                 /* for Cleanup */

/* performs common Stream commands and returns 1 or a date if successful */
File_cmd: Procedure Expose result
trace_save = Trace('N')
Parse Arg file_name, command
command = Translate(command)
Select
   When command = 'X' Then
      Do
         result = Stream(file_name, 'c', 'QUERY EXISTS')
         answer = (result <> '')
      End
   When command = 'C' Then
      Do
         result = Stream(file_name, 'C', 'CLOSE')
         answer = Abbrev(result,'READY') | (result = '')
      End
   When command = 'W' Then
      Do
         result = Stream(file_name, 'C', 'OPEN WRITE')
         answer = Abbrev(result,'READY')
      End
   When command = 'R' Then
      Do
         result = Stream(file_name, 'C', 'OPEN READ')
         answer = Abbrev(result,'READY')
      End
   When command = 'D' Then
      Do
         result = Stream(file_name, 'C', 'QUERY DATETIME')
         If result <> '' Then
            Do
               Parse Var result date time
               date = Dateconv(Translate(date, '/', '-'), 'U', 'S')
               Parse Var time hr ':' min ':' sec
               answer = Strip(date) || Strip(hr) || Strip(min) || Strip(sec)
            End
         Else
            answer = '00000000000000'
      End
   Otherwise answer = 0
End
Trace(trace_save)
Return answer

Say_out:                             /* performs output to the screen */
Procedure Expose quiet
trace_save = Trace('N')
If quiet Then
   Return
Parse Arg line
Say line
Trace(trace_save)
Return

Say_message:       /* performs message output and returns key entered */
Procedure Expose quiet
trace_save = Trace('N')
Parse Arg msg
Say msg
answer = SysGetKey('NOECHO')
Trace(trace_save)
Return answer

Log_file_parms: Procedure
trace_save = Trace('N')
Parse Arg dialer_ini_name, dialer_ini
Select
   When Translate(dialer_ini_name) = 'DIALER.INI' Then
      Do
         dlog_eparm = 'AdvLog'
         dlog_nparm = 'Cfn'
         dlog_sparm = 'Cfs'
      End
   When Translate(dialer_ini_name) = 'TCPDIAL.INI' Then
      Do
         dlog_eparm = 'Common'
         dlog_nparm = 'LoggingCfn'
         dlog_sparm = 'LoggingCfs'
      End
   Otherwise Do
      Say 'Unable to recognize dialer ini file'
      Call Cleanup
      Exit
   End
End
dialer_log_file = Strip(SysIni(dialer_ini, dlog_eparm, dlog_nparm),,'00'x)
dialer_log_size = C2d(Left(SysIni(dialer_ini, dlog_eparm, dlog_sparm),3))
Trace(trace_save)
Return dialer_log_file dialer_log_size

/* set up config sample values */
Config_sample:
trace_save = Trace('N')
/* inetsmp.ini configuration file
   This file is read at startup to provide parameters
   for the inetlog.cmd and the ijoylog.cmd */

/* common values */
cfg_common = 'what_r_we ibm_dialer ibm_dialer injoy_dialer data_path daily_report warn_pct sig_x sig_min sig_hr'
/* version and date */
what_r_we = 'INetLog  v7.5 04 Oct 2001, Copyright 1995 - 2001 by Chuck McKinnis and Jerry Levy'
/* process IBM dialer logs (1 = yes, 0 = no) */
ibm_dialer = null
/* process InJoy dialer logs (1 = yes, 0 = no) */
injoy_dialer = null
/* path to data files - normally x:\inetlog\data */
data_path = install_path || 'data\'
/* display daily reports (1 = yes, 0 = no) */
daily_report = 0
/* warn if the IBM dialer log exceeds this percentage of the size */
warn_pct = 85
/* Leading digits for connects, minutes, hours per day or month
   You should not need to change these.  If you exceed 9,999
   connects, 9,999,999 minutes, or 999,999 hours per period
   you will crash, but then I think you have other problems */
/* significant digits for connects/day or conects/month */
sig_x = 4
/* ... for minutes/day or minutes/month */
sig_min = 7
/* ... for hours/day or hours/month */
sig_hr = 6

/* ibm log values */
cfg_inetlog = 'ibm_dialer_ini_file ibm_output_file ibm_summary_file ibm_last_time_stamp'
/* name of the IBM dialer ini file */
ibm_dialer_ini_file = null
/* output file for IBM dialer detail report */
ibm_output_file = data_path || 'inetlog.log'
/* output file for IBM dialer summary report */
ibm_summary_file = data_path || 'inetsum.log'
/* time stamp for last processed record of IBM dialer log */
ibm_last_time_stamp = 'T00000000000000'

/* injoy log values */
cfg_ijoylog = 'injoy_logs injoy_accts injoy_users injoy_times injoy_output_file injoy_summary_file'
/* path(s) to the InJoy dialer log file(s) */
injoy_logs = null
/* account(s) for the InJoy dialer log file(s) */
injoy_accts = null
/* users(s) for the InJoy dialer log file(s) */
injoy_users = null
/* time stamp(s) for the InJoy dialer log file(s) */
injoy_times = null
/* output file for InJoy dialer detail report */
injoy_output_file = data_path || 'ijoylog.log'
/* output file for InJoy dialer summary report */
injoy_summary_file = data_path || 'ijoysum.log'

/* build inetsmp.ini */
If Rx_fileexists(inetsmp_ini) Then
   Call SysFileDelete inetsmp_ini
Call Write_config inetsmp_ini, 'all'

Trace(trace_save)
Return

/* RxSearchLibpath
   search the current libpath for a module
   returns the fully qualified path if found or null if not found
   Copyright 2000 by Chuck McKinnis,  Sandia Park, NM (USA) 04 Feb 2000
   mckinnis@attglobal.net */
Rxsearchlibpath: Procedure
Trace('N')
Parse Arg dll
boot_drive = SysBootDrive()
config_sys = boot_drive || '\config.sys'
xrc = SysFileSearch('libpath', config_sys, 'lib_path.')
If xrc = 0 & lib_path.0 <> 0 Then
   Do i = 1 To lib_path.0
      lib_test = Space(Translate(lib_path.i))
      If Abbrev(lib_test, 'REM') Then
         Iterate i
      If \Abbrev(lib_test, 'LIBPATH') Then
         Iterate i
      lib_equal = Space(Substr(lib_test, 8))
      If \Abbrev(lib_equal, '=') Then
         Iterate i
      Parse Var lib_test . '=' lib_path
   End
lib_path = Space(lib_path)
our_path = SysTempFileName('lib????')
old_value = Value(our_path, lib_path, 'os2environment')
dll_path = SysSearchPath(our_path, dll)
old_value = Value(our_path, old_value, 'os2environment')
Return dll_path

/*:VRX         Rx_makepath
Usage:  rx_makepath(path_name)
Where:     path_name = fully qualified name of path to be created
Result:    1 if path created or exists, 0 otherwise
*/
Rx_makepath: Procedure Expose verbose log_out log_file
save_trace = Trace('N')
Parse Upper Arg path_name
If \Datatype(verbose, 'b') Then
   verbose = 1
If \Datatype(log_out, 'b') Then
   Do
      xrc = SysFileTree(log_file, 'test.', 'fo')
      If xrc = 0 & test.0 <> 0 Then
         log_out = 1
      Else
         log_out = 0
   End
path_name = Strip(path_name, 't', '\')
xrc = SysFileTree(path_name, 'test.', 'do')
If xrc = 0 & test.0 <> 0 Then
   xrc = 1
Else
   Do
      If Pos(':\', path_name) = 2 Then
         Do
            path_name = path_name || '\'
            path. = ''
            path.0 = 0
            path_pos = Pos('\', path_name, 4 )
            Do i = 1 Until path_pos = 0
               path.i = Left(path_name, path_pos - 1)
               path.0 = i
               path_pos = Pos('\', path_name, path_pos + 1)
            End
            Do i = 1 To path.0
               xrc = SysFileTree(path.i, 'test.', 'do')
               If xrc = 0 & test.0 <> 0 Then
                  xrc = 1
               Else
                  Do
                     xrc = SysMkDir(path.i)
                     xrc = (xrc = 0)
                  End
            End
         End
      Else
         xrc = 0
   End
Trace(save_trace)
Return xrc

/*:VRX         rx_fileexists
Usage:  rx_fileexists(file_name)
Where:     file_name = name of file or path to be tested
Result:    1 if file or path exists, 0 otherwise
*/
Rx_fileexists: Procedure Expose verbose log_out log_file
save_trace = Trace('N')
Parse Arg file_name
If \Datatype(verbose, 'b') Then
   verbose = 1
If \Datatype(log_out, 'b') Then
   Do
      xrc = SysFileTree(log_file, 'test.', 'fo')
      If xrc = 0 & test.0 <> 0 Then
         log_out = 1
      Else
         log_out = 0
   End
xrc = SysFileTree(file_name, 'test.', 'fo')
If xrc = 0 & test.0 <> 0 Then
   exists = 1
Else
   Do
      /* may be a directory */
      xrc = SysFileTree(file_name, 'test.', 'do')
      If xrc = 0 & test.0 <> 0 Then
         exists = 1
      Else
         exists = 0
   End
Trace(save_trace)
Return exists

/*:VRX         PMRexxGo
*/
/* setup to run under PMREXX */
Pmrexxgo: Procedure Expose quiet
save_trace = Trace('N')
Parse Arg action, obj_id, our_prog, title, our_parms
obj_id = '<' || obj_id || '>'

If action = 'START' Then
   Do
      our_dir = Left(our_prog, Lastpos('\', our_prog) - 1)
      pmrexx_name = SysSearchPath('PATH', 'PMREXX.EXE')
      If pmrexx_name <> '' Then
         Do
            class = 'WPProgram'
            location = '<WP_DESKTOP>'
            obj = 'OBJECTID=' || obj_id || ';'
            exec = 'EXENAME=' || pmrexx_name || ';'
            parm = 'PARAMETERS=' || our_prog our_parms '| X' || ';'
            startdir = 'STARTUPDIR=' || our_dir || ';'
            window = 'MAXIMIZED=NO;MINIMIZED=NO;NOAUTOCLOSE=NO;'
            setup = obj || exec || parm || startdir || window
            rc = SysCreateObject(class, title, location, setup, 'R')
            If rc Then
               Do
                  rc = SysSetObjectData(obj_id, 'OPEN=DEFAULT;CCVIEW=NO;')
                  If rc Then
                     Call Say_out 'Started' title 'under PMRexx'
                  Else
                     Call Say_out 'Unable to start' title 'under PMRexx'
                  Exit
               End
            Else
               Call Say_out 'Unable to create object' title
         End
   End
Else
   Do
      Call Say_out 'Press enter to terminate this program'
      Parse Upper Pull .
      Call SysDestroyObject obj_id
      Call SysSleep 2
   End
Trace(save_trace)
Return
