/*------------------------------------------------------------------
 * forward.cmd ver 1.0 by Nick Lepehin nickk@myflat.com 
 * based on  getpop.cmd by Christoph Lechleitner
 * This script fetches mail from pop3 server and forwards it to smtp server
 * multithreaded (uses rexxipc.dll)
 * controls hangs sockrcv function
 * uses auxiliary cmd files : process.cmd & sockrcv.cmd
 *------------------------------------------------------------------*/

trace off

parse arg filelist smtpserver logfile tempfdir
filelist=space(filelist)
smtpserver=space(smtpserver)
tempfdir=space(tempfdir)
logfile=space(logfile)

if (filelist='')|(smtpserver='')|(logfile='')|(tempfdir='') then
   do
   say "Usage: forward <config> <smtpserver to forward to> <logfile name> <dir for store temp files>"
   exit 1
   end

rc=stream(filelist,'c','open read')
rc1=stream(logfile,'c','open write')

if (rc<>"READY:")|(rc1<>"READY:")|(lines(filelist)=0) then
   do
   say "Usage: forward <config> <smtpserver to forward to> <logfile name> <dir for store temp files>"
   exit 1
   end


entrynum=0
do while lines(filelist)=1 
 curline=linein(filelist)
 if left(curline,1)<>';' then
  do
   entrynum=entrynum+1
   parse var curline servers.entrynum users.entrynum passwords.entrynum forwards.entrynum keeps.entrynum
   if (servers.entrynum = "")|(users.entrynum ='')|(passwords.entrynum ='')|(forwards.entrynum ='') then
    do
     say "Wrong format of config file."
     say "Should be: <pop3server> <user> <password> <forwarding address> [<keep>]" 
     exit 1
    end
  end
end

call saynlog ' '
/* call saynlog '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!' */
call saynlog substr(x2c('DB'),1,79,x2c('DB'))
call saynlog '----------Forward.cmd started 'Date('E')' at 'time()'-----------'
call saynlog 'Was found 'entrynum' entries in config file'

/*------------------------------------------------------------------
 * initialize function packages
 *------------------------------------------------------------------*/

call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
if RxFuncQuery("SockLoadFuncs") then
   do
    rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
    rc = SockLoadFuncs()
   end

if RxFuncQuery("IPCLoadFuncs") then
   do
    call RxFuncAdd 'IPCLoadFuncs', 'REXXIPC', 'IPCLoadFuncs'
    call IPCLoadFuncs
   end

/*-------------Starting processing the server list------------------*/
do cenum=1 to entrynum
 StartMessage.cenum=' 'x2c('FE')' Processing 'cenum' entry: Start at 'time('L')
 logc=logfile||'.l'||cenum
 call IPCContextCreate context.cenum
 call ProcCreateThread context.cenum, 'process.cmd', servers.cenum, users.cenum, passwords.cenum, forwards.cenum, keeps.cenum, cenum, smtpserver, logc, tempfdir 
 if result\=0 then call saynlog 'Error creating thread 'cenum' :'result
 call syssleep 0.5 /* Sometimes proccreatethread results error : process.cmd can't be read */
end

do cenum=1 to entrynum
 call IpcContextWait context.cenum
 call saynlog StartMessage.cenum||'. End at 'time('L')' 'x2c('FE')
end

fmask=logfile||'.l*'
rc=SysFileTree(fmask,'res','FO')
do i= 1 to res.0
 call lineout logfile, substr(x2c('DC'),1,79,x2c('DC'))
 fname=logfile||'.l'||i
 do while lines(fname)
  call lineout logfile, linein(fname)
 end
 rc=stream(fname,'c','close')
 '@del 'fname
end

call saynlog '----------Forward.cmd finished 'Date('E')' at 'time()'----------'
rc=stream(logfile,'c','close')
exit



/*------------------------------------------------------------------
 * exit with a message and return code
 *------------------------------------------------------------------*/
Error: procedure expose logfile
   sock = arg(1)
   msg  = arg(2)

   if (sock <> -1) then
      rc = SockSoClose(sock)
 
   call saynlog msg
   rc=stream(logfile,'c','close')
 return 0
/*-----------------------------*/
saynlog: procedure expose logfile
 mes=arg(1)
 say mes
 call lineout logfile , mes
return
