/* ftpbatch.cmd -- put and get files via rexx ftp */
/* Copyright (C) 1997, Jack J. Woehr jax@well.com */
/* PO Box 51, Golden, Colorado 80402-0051         */
/* http://www.well.com/user/jax/rcfb/             */
/* You may use this file freely, but it is        */
/* Freeware -- There Is No Warranty At All.       */

parse source platform launcher program
parse arg host userid password batchfile defaultMode

/* Is user asking for help? */
if host="/?" | host="-?"  then do
   call usage
   exit 0
end /* do */

/* Enough args? */
if batchfile='' then do
   call usage
   exit 1
end /* do */

/* Set the default transfer mode */
defaultMode = translate(defaultMode)
select
   when defaultMode=''   then defaultMode='Binary'
   when defaultMode='/B' then defaultMode='Binary'
   when defaultMode='/A' then defaultMode='ASCII'
   when defaultMode='-B' then defaultMode='Binary'
   when defaultMode='-A' then defaultMode='ASCII'
otherwise
   Say "Invalid default transfer mode" defaultMode
   call usage
   exit 2
   end

/* Open batch file destination */
result=stream(batchfile, 'c', 'open read')
if result \="READY:" then do
  say "Couldn't open" batchfile "as batchfile."
  call usage
  exit 3
  end

/* Parse batchfile */
Say "Parsing batchfile" batchfile'.'
batch.0 = 0
do while lines(batchfile)
  curr=(batch.0)+1
  batchLine = linein(batchfile)
  parse value batchLine with batch.curr.cmd batch.curr.remote batch.curr.local batch.curr.mode
  theCommand = translate(batch.curr.cmd)
  batch.curr.cmd = theCommand  /* write back command for later upcase comparison */

  /* Skip an empty line */
  if theCommand = '' then iterate

  /* Skip an invalid command */
  if theCommand \= 'GET' & theCommand \= 'PUT' & theCommand \= 'CD' then do
     Say "Skipping" batchLine',' "invalid command" theCommand'.'
     iterate
  end

  /* No local file? Nothing to do */
  if batch.curr.remote  = '' then do
     Say "Skipping" batchline'.' "no remote file name."
     iterate
  end

  /* No local file? Then becomes same as remote. */
  if batch.curr.local = '' then batch.curr.local = batch.curr.remote

  /* Default mode is binary */
  aMode=translate(batch.curr.mode)
  select
     when aMode=''   then aMode= defaultMode
     when aMode='/B' then aMode='Binary'
     when aMode='/A' then aMode='ASCII'
     when aMode='-B' then aMode='Binary'
     when aMode='-A' then aMode='ASCII'
  otherwise do
     Say "Skipping" batchLine',' "invalid mode" aMode
     iterate
     end
  end

  /* Now edit the command */
  batch.curr.mode = aMode

  /* We've got a command, increment count */
  batch.0 = (batch.0)+1
  Say batch.0 "command lines so far."

end  /* do while lines(batchfile) */

/* close our file */
call stream batchfile, 'c', 'CLOSE'

if batch.0 = 0 then do
  Say "No commands in batchfile" batchfile'.'
  exit 0
end

/* Load FTP API */
result = RxFuncAdd("FtpLoadFuncs","rxFtp","FtpLoadFuncs")
result = FtpLoadFuncs()
if result = 1 then do
  Say "Error loading FTP Functions was"  result'.'
  exit 4
end

/* Announce purpose */
say program "will contact host" host "on behalf of userid" userid "doing batch" batchfile "..."

/* Identifies the host, user ID, password, account for the remote host */
Say "Identifying user" userid "to host" host
Say "(This does not guarantee connection ..."
Say " check return values from subsequent fuctions.)"

result = FtpSetUser(host,userid,password /* , account */)
if result = 0 then do
   say "Passed-in host-user-password not syntactically valid."
   call usage
   exit 5
   end

/* Iterate through our commands */
/* TRACE ?A */
say FTPERRNO "is result of login."

do i = 1 to batch.0

  theCommand = batch.i.cmd

  /* These two variables are poorly named, */
  theLocalFile = batch.i.local
  theRemoteFile = batch.i.remote
  /* as are their instancings. They should */
  /* have been called something like       */
  /* "positionalArg1" and "positionalArg2".*/

  theMode = batch.i.mode

  select
     when theCommand = 'CD' then do
        Say "Changing dir to" theLocalFile
        result = FtpChDir(theLocalFile)
        Say "Result of CD is" result'.'
        if result \= 0 then say "FTP Error Number is" FTPERRNO'.'
        end
     when theCommand = 'PUT' then do
        /* Set transfer mode */
        call FtpSetBinary(theMode)
        /* Send  the file */
        Say "Putting" theRemoteFile "as" theLocalFile "in mode" theMode'.'
        result = FtpPut(theRemoteFile, theLocalFile, theMode)
        Say "Result of PUT is" result'.'
        if result \= 0 then say "FTP Error Number is" FTPERRNO'.'
        end
     when theCommand = 'GET' then do
        /* Set transfer mode */
        call FtpSetBinary(theMode)
        /* Get the file */
        Say "Getting" theLocalFile "from" theRemoteFile "in mode" theMode'.'
        result = FtpGet(theLocalFile, theRemoteFile, theMode)
        Say "Result of GET is" result'.'
        if result \= 0 then say "FTP Error Number is" FTPERRNO'.'
        end
  end
end

/* Logoff host */
Say "Logging off" host'.'
result = FtpLogoff()
Say "Result of Logoff is" result'.'
if result \= 0 then say "FTP Error Number is" FTPERRNO'.'

/* End of program */
call cleanup
exit 0   /* Phew! */

/* Clean up Rexx name space */
cleanup:
   result = FtpDropFuncs()
   return


/* Inform user of command syntax */
usage:
   PROCEDURE EXPOSE program
   csi = '1b'X
   emp = csi'[7m'
   nrm = csi'[m'
   program = Filespec('NAME', program)
   Say "Usage:" program" "emp"host "nrm" "emp"userid"nrm" "emp"password"nrm" "emp"batchfile"nrm" "emp"[default_transfer_mode]"nrm
   Say
   Say "     "program" executes "emp"batchfile"nrm" against the "emp"host"nrm" on behalf of "emp"userid"nrm"."
   Say
   Say "     The default transfer mode (/A or /B for ASCII or Binary) is"
   Say "     "emp"default_transfer_mode"nrm", or Binary if "emp"default_transfer_mode"nrm
   Say "     is omitted."
   Say
   Say "     "emp"batchfile"nrm" consists either of multiple lines of the form:"
   Say
   Say "              "emp"cmd"nrm" "emp"local|remote"nrm" "emp"[remote|local]"nrm" "emp"[mode]"nrm
   Say
   Say "     Supported commands are GET PUT and CD."
   Say "     e.g.:"
   Say
   Say "       CD /public/os2"
   Say "       GET REMOTEFILE.TXT LOCALFILE.TXT /A"
   Say "       PUT LOCALFILE.BIN REMOTEFILE.BIN /B"
   Say
   Say "     With GET and PUT, if the second file argument, "emp"remote|local"nrm" and "emp"mode"nrm" are missing,"
   Say "     the second file argument representing the remote (PUT) or local (GET) file name is assumed to be the same"
   Say "     as the first file argument, and the default transfer mode is the one represented by the optional "
   Say "     "emp"default_transfer_mode"nrm" argument to" program", or Binary if none specified. The latter is also"
   Say "     true when "emp"mode"nrm" only is omitted."
   Say
   Say program ""emp"/?"nrm" or "emp"-h"nrm" gives this help."
   return

exit

/* end of ftpbatch.cmd */

