/* VisPro/REXX */

_VPAppHandle = VpInit()
if _VPAppHandle='' then exit
_VPAppReturn = 0

/* Open first form */
Parse arg topic
_VPMainWindow = VpOpenForm('', 256, topic)
if _VPMainWindow='' then do
   call VpMessageBox 0,'VisPro/REXX','Unable to open Main form.  Verify that there is a Main form, that it has an id of 256, and that the form has controls within it.'
   signal _VPAppExit
end

do until ( _VPEventCall=='')
   _VPEventCall = VpGetMsg(_VPAppHandle)
   Interpret _VpEventCall
end
/* Terminate application */
_VPAppExit:
call VpQuit _VPAppHandle
return _VPAppReturn


/* ##258_1000.0 */
258_1000.0: /* Event Clicked/selected -  DRIVES_DDLB */
Arg window self

/* Delete all items SUBDIRS_CTR Container */
CALL VpDeleteItem window,'SUBDIRS_CTR','ALL'

/* Get index of first selected item DRIVES_DDLB Combo Box */
index=VpGetIndex(window,'DRIVES_DDLB','SELECTED',0)

/* Get item value at index DRIVES_DDLB Combo Box */
drvLetter=VpGetItemValue(window,'DRIVES_DDLB',index)

return

/* ##258_1002.0 */
258_1002.0: /* Event Clicked/selected - Container SUBDIRS_CTR */
Arg window self index

/* Get index of first selected item SUBDIRS_CTR Container */
index=VpGetIndex(window,'SUBDIRS_CTR','SELECTED',0)

/* Get item value at index SUBDIRS_CTR Container */
newMsgDir=VpGetItemValue(window,'SUBDIRS_CTR',index)

do until index = 0
    /* Get index of parent item SUBDIRS_CTR Container */
    index=VpGetIndex(window,'SUBDIRS_CTR','PARENT',index)

    /* Get item value at index SUBDIRS_CTR Container */
    pNewMsgDir=VpGetItemValue(window,'SUBDIRS_CTR',index)

    newMsgDir = pNewMsgDir||'\'||newMsgDir
    
end /* end do */

/* If we don't have the trailing "\" then append one */
if right(newMsgDir,1) <> '\'
    then newMsgDir = newMsgDir||'\'

tmpMsgDir = drvLetter||newMsgDir
parse upper var tmpMsgDir newMsgDir

/* Set item value NEWMSGDIR_EF Entry Field */
CALL VpSetItemValue window,'NEWMSGDIR_EF',newMsgDir
return

/* ##258_1002.16 */
258_1002.16: /* Event Mouse button 1 double click - Container SUBDIRS_CTR */
Arg window self index

/* Get item value NEWMSGDIR_EF Entry Field */
newMsgDir = VpGetItemValue(window,'NEWMSGDIR_EF')

/* If we don't have the trailing "\" then append one */
if right(newMsgDir,1) <> '\'
    then newMsgDir = newMsgDir||'\'

/* Does the newMsgDir exist? */
    call SysFileTree newMsgDir||'*.MSG', 'findDir', 'FO'

/* if we didn't find any .MSG files */
    if findDir.0 = 0
    	then
    	    Do
    	    	/* Tell the user that we couldn't find the messages directory */
    	     	response=VpMessageBox(window,'Error!','No message files were found in the directory:'||d2c(10)||newMsgDir||d2c(10)||'Do you wish to use this directory anyway?'||d2c(10)||d2c(10),'YESNO')
    	     	
		if response = 'YES'
		    then
		    	Do
		    	    msgDir = newMsgDir
		    	    CALL VpWindow window,'CLOSE'
			End
    	    End
    	else
    	    Do
    	    	msgDir = newMsgDir
		CALL VpWindow window,'CLOSE'
    	    End
return

/* ##258_1004.0 */
258_1004.0: /* Event Clicked/selected - ~Okay  1004 */
Arg window self

/* Get item value NEWMSGDIR_EF Entry Field */
newMsgDir = VpGetItemValue(window,'NEWMSGDIR_EF')

/* If we don't have the trailing "\" then append one */
if right(newMsgDir,1) <> '\'
    then newMsgDir = newMsgDir||'\'

/* Does the newMsgDir exist? */
    call SysFileTree newMsgDir||'*.MSG', 'findDir', 'FO'

/* if we didn't find any .MSG files */
    if findDir.0 = 0
    	then
    	    Do
    	    	/* Tell the user that we couldn't find the messages directory */
    	     	response=VpMessageBox(window,'Error!','No message files were found in the directory:'||d2c(10)||newMsgDir||d2c(10)||'Do you wish to use this directory anyway?'||d2c(10)||d2c(10),'YESNO')
    	     	
		if response = 'YES'
		    then
		    	Do
		    	    msgDir = newMsgDir
		    	    CALL VpWindow window,'CLOSE'
			End
    	    End
    	else
    	    Do
    	    	msgDir = newMsgDir
		CALL VpWindow window,'CLOSE'
    	    End
return

/* ##258_1005.0 */
258_1005.0: /* Event Clicked/selected - ~Cancel  1005 */
Arg window self

CALL VpWindow window,'CLOSE'

return

/* ##258_1006.0 */
258_1006.0: /* Event Clicked/selected - ~Get Directorys  1006 */
Arg window self

/* Get index of first selected item DRIVES_DDLB Combo Box */
index=VpGetIndex(window,'DRIVES_DDLB','SELECTED',0)

/* Get item value at index DRIVES_DDLB Combo Box */
value=VpGetItemValue(window,'DRIVES_DDLB',index)

CALL VpWindow window,'SETPOINTER',waitPtr

/* Load with directory folders SUBDIRS_CTR Container */
CALL VpLoadFromFile window,'SUBDIRS_CTR','FOLDERS',value

CALL VpWindow window,'SETPOINTER',arrowPtr

return

/* ##258_Form.1 */
258_Form.1: /* Event OPND - Form MMGR12\FindDir */
Arg window 


/* Center the window on the screen */
	xy=VpWindow(window,'GETSCREENSIZE')
	PARSE VAR xy x y

	scrWidth  = x
	scrHeight = y
	scrWCenter = scrWidth/2
	scrHCenter = scrHeight/2

	xy=VpWindow(window,'GETSIZE')
	PARSE VAR xy x y

	winWidth  = x
	winHeight = y
	winWCenter = winWidth/2
	winHCenter = winHeight/2
	CALL VpWindow window,'SETPOS', scrWCenter-winWCenter, scrHCenter-winHCenter, winWidth, WinHeight

driveMap = SysDriveMap(,'USED')

do count = 1 to WORDS(driveMap)
    /* Add item sorted ascending DRIVES_DDLB Combo Box */
    index=VpAddItem(window, 'DRIVES_DDLB','ASCENDING',WORD(driveMap,count))
end /* end do */

/* View as tree SUBDIRS_CTR Container */
rc=VpSetItemStyle(window,'SUBDIRS_CTR','TREE')

/* Select item DRIVES_DDLB Combo Box */
CALL VpSelect window,'DRIVES_DDLB',1,1

return

/* ##256_1001.0 */
256_1001.0: /* Event Clicked/selected - ~Select Directory SELDIR_PB */
Arg window self

/* Open the form D:\apps\langs\os2\rexx\VisProRx\Projects\FindDir\FindDir */
value=VpOpenForm(window, 258, 'topic name')

return

/* ##256_Form.1 */
256_Form.1: /* Event OPND - Form FINDDIR\Main */
Arg window 

/* Load our pointer from system resources */
    arrowPtr = VpLoadPicture('SYSICON',1)
    waitPtr = VpLoadPicture('SYSICON',3)
    
/* Load the RexxUtil dll */
    Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    Call SysLoadFuncs
    
msgDir = 'None'

/* Set item value SELDIR_EF Entry Field */
CALL VpSetItemValue window,'SELDIR_EF',msgDir

return

/* ##256_Form.3 */
256_Form.3: /* Event CLSNTFY - Form FINDDIR\Main */
Arg window fromtopic

/* Set item value SELDIR_EF Entry Field */
CALL VpSetItemValue window,'SELDIR_EF',msgDir
return
