/* eaInfo.CMD v0.2                                         */
/* Displays Subject, Keywords and Comments for the dropped */
/* object.                                                 */
/* dAc 10/94                                               */
ObjectTitle = "eaINFO"
wpsID = "<eaInformation>"

/* Load REXXUTIL */
   call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
   call sysloadfuncs

/* Get drop validation code and Target file */
   parse arg code TARGET

/* Get program's Name and location(home) */
   parse source junk1 junk2 ProgramName
   Home=SubStr(ProgramName,1,LastPos('\', ProgramName))
   CMDname=SubStr(ProgramName,LastPos('\', ProgramName)+1)

/* if Object started without drop, display usage */
   if (TARGET="") & (code='1') then do
      call Instructions
      exit
      end 

/* Run for the first time. Create the Object with */
/* validation flag (1) */
   if code<>"1" then do
      call Create 1
      call SysSetObjectData wpsID, "OPEN=DEFAULT;"
      exit
      end

/* Get Information from TARGET's EAs */
/* -- Subject -- */
   Subject=Read(".subject")
   if Subject="" then
      Subject="No Subject"
   else
      Subject=CleanUp(Subject," ")

/* -- Key Phrases -- */
   KeyPhrases=Read(".keyphrases")
   if KeyPhrases="" then
      KeyPhrases=" none"
   else
      KeyPhrases=CleanUp(KeyPhrases,",")

/* -- Comments -- */
   Comments=Read(".comments")
   if Comments="" then
      Comments="...No Comments found"
   else
      Comments=CleanUp(Comments," ")

   Body="Keys: "KeyPhrases||'0a'x'0d'x||,
   "Comments:"||'0a'x||,
   ""||'0a'x||Comments

   Subject=" "Subject||,
          " "

/* Display Message box */
   call rxMessageBox Body, Subject, OK, INFORMATION
exit

/*---------------------- SUBROUTINES ----------------------*/
/*-------- Get EA field -----------------------------------*/
READ:
   parse arg field
   if SysGetEA(TARGET,field,"rawEA") = 0 then
   /* parse past binary info */
   if field=".comments" | field=".keyphrases" then
      parse var rawEA 11 EAstring
   if field=".subject" then
      parse var rawEA 5 EAstring
   return EAstring

/* EA stuff 
   .type needs 11
   .subject needs 5
   .comments needs 11
   .keyphrases 11 first
*/

/*-------- Remove extra spaces and bad characters ---------*/
CleanUp:
   parse arg DirtyString,Separator
   Index=0
   DirtyString=ASCIIstrip(DirtyString)
   WordNumber=WORDS(DirtyString)
   do while Index < WordNumber
      Index=Index+1
      goodWord=STRIP(WORD(DirtyString,Index))
      if Index=1 then
         Clean = goodWord
      else
         Clean = Clean||Separator||goodWord
      end
   return Clean

/*-------- Remove unrecognizable characters ---------------*/
ASCIIstrip:
   parse arg BadString
   GoodString=""
   Position=0
   do length(BadString)
      Position=Position+1
      char=C2D(SUBSTR(BadString,Position,1))
      if char>31 & char<126 then
         GoodString=GoodString||D2C(char)
      else
         GoodString=GoodString" "
   end
   return GoodString

/*-------- Create/Recreate program object -----------------*/
Create:
   parse arg Mode
   rc=SysCreateObject("WPProgram",ObjectTitle,"<WP_DESKTOP>",,
      "OBJECTID="wpsID";"||,
      "ICONFILE="Home"eaInfo.ICO;"||,
      "EXENAME=PMREXX.EXE;"||,
      "PARAMETERS="CMDname Mode";"||,
      "STARTUPDIR="Home";"||,
      '', R);
   If rc<>1 Then Say "Object could not be created/updated !"
   return rc

/*-------- Display Instruction dialog/View ReadMe ---------*/
Instructions:
   Heading=" Instructions "
   Message='Please Drag and Drop the file you'||,
   ' wish to examine on the "'ASCIIstrip(ObjectTitle)'" object.'||,
   '0a'x'0d'x'Would you like to view the "'ObjectTitle'" Read me?'

   rc = rxMessageBox(Message,Heading,YESNO,QUESTION)
   if rc=6 then do
      rc=SysCreateObject("WPProgram","Temp eaREADME","<WP_NOWHERE>",,
      "OBJECTID=<TEMPeaREADME>;"||,
      "EXENAME=cmd.exe;"||,
      "PROGTYPE=WINDOWABLEVIO;"||,
      "MAXIMIZED=YES;"||,
      "NOAUTOCLOSE=NO;"||,
      "PARAMETERS=/c more < "Home"eaReadMe.TXT;"||,
      "STARTUPDIR="Home";", U)
      call SysSetObjectData "<TEMPeaREADME>", "OPEN=DEFAULT;"
      call SysSetObjectData "<TEMPeaREADME>", "OPEN=DEFAULT;"
      end
   return
