/* ************************************************** */
/* MAKEINC.CMD                                        */
/*                                                    */
/* Crer NAMED.BT, NAMEDHOS.INC,  NAMED???.REV et     */
/* NAMED???.INC  partir d'une table (flat file)      */
/* TCPFILE.TAB avec host_name=adresseIP               */
/*                                                    */
/* Des fichiers FRAME (*.FRM) sont utiliss pour la   */
/* commande interpret de REXX                         */
/*                                                    */
/* Version 1.0     19 dcembre 1995                   */
/* Par : Robert Graveline                             */
/* ************************************************** */

parse upper arg infile LeReste

if infile = "" then infile = "TCPFILE.TAB"
rc = stream(infile,"C","Query Exist")
if rc = "" then do
	say "Fichier" infile "inexistant."
	exit
end

domain_name = "test.qc.ca"

La_Date = date(S)
La_Date = substr(La_Date,3)
L_Heure = time(H)
Serial_Number = La_Date || L_Heure

outfile1 = "NAMEDHOS.INC"	/* Tous les HOSTS */

rc=stream(infile,'C','Open Read')
if rc <> 'READY:' then
   do
   SAY 'Fichier "'infile'" introuvable'
   exit(1)
   end

"@echo off"
"C:"
"CD \TCPIP\ETC\NAMEDB"
"if exist NAMED.DOM    DEL NAMED.DOM"
"if exist NAMEDHOS.INC DEL NAMEDHOS.INC"
"if exist NAMED???.IN  DEL NAMED???.IN"		/* Par SUBNET */
"if exist NAMED???.REV DEL NAMED???.REV"		/* Par SUBNET */
"if exist NAMED???.INC DEL NAMED???.INC"		/* Par SUBNET */

rc=stream(outfile1,'C','Open Write')
if rc <> 'READY:' then
   do
   SAY 'Impossible de crer le fichier de config : "'outfile1'"'
   signal abort_job
   end

i_rec = lines(infile)
do while i_rec <> 0
        ligne=linein(infile)
        if ligne = "" then iterate
        i = lastpos('=',ligne)
        if i > 0 then ligne1 = substr(ligne,1,i-1) || " " || substr(ligne,i+1)
        else ligne1 = ligne
        parse var ligne1 host_name IP_Address Le_Reste
        parse value IP_Address with Root "." test "." Subnet "." Host
/*      Host = right(Host,3,"0") */
        host_name1 = host_name || "                                    "
        host_name1 = substr(host_name1,1,8)

        ligne = host_name1 "86400 IN A" IP_Address
        rc = lineout(outfile1,ligne)
        if rc <> 0 then do
	   SAY 'Erreur d''criture sur le fichier "'outfile1'"'
                 signal abort_job
	   end

        ligne = Host "IN PTR" host_name"."domain_name"."
        outfile2 = "NAMED" || Subnet || ".INC"
        rc = lineout(outfile2,ligne)
        if rc <> 0 then do
	   SAY 'Erreur d''criture sur le fichier "'outfile2'"'
                 signal abort_job
	   end
        i_rec=lines(infile)
end

/* Fermer les fichiers */
rc=stream(infile,'C','Close')
if rc <> 'READY:' then
   do
   SAY 'Erreur de fermeture du fichier ' infile
   signal abort_job
   end
rc=stream(outfile1,'C','Close')
if rc <> 'READY:' then
   do
   SAY 'Erreur de fermeture du fichier ' outfile1
   signal abort_job
   end

/* ******************************************************************** */
/*        Recrer les fichier NAMED.DOM et REV  partir du *.FRM        */
/*        pour mettre un SERIAL NUMBER diffrent et tenir compte        */
/*        de tous les fichiers NAMEDsubnet.INC que l'on vient de        */
/*        crer.                                                        */
/* ******************************************************************** */

/* Fichier NAMED.DOM */
infile  = "NAMEDHOS.FRM"
outfile = "NAMED.DOM"

rc = stream(infile,'C','open read')
if rc <> 'READY:' then
   do
   SAY 'Fichier "'infile'" introuvable'
   signal abort_job
   end

"if exist NAMED.DOM del NAMED.DOM"
rc = stream(outfile,'C','open write')
if rc <> 'READY:' then
   do
   SAY 'Impossible de crer le fichier "'outfile'"'
   signal abort_job
   end

/* Replace des variables */
i_rec = lines(infile)
do while i_rec <> 0
        ligne=linein(infile)
        interpret 'ligne="'ligne'"'
        rc = lineout(outfile,ligne)
        if rc <> 0 then do
	   SAY 'Erreur lors de la copie du fichier sur "'outfile'"'
                 signal abort_job
	   end
        i_rec=lines(infile)
end
/* Fermeture des fichiers */

rc = stream(infile,'C','close')
if rc <> 'READY:' then
   do
   SAY 'Erreur de fermeture du fichier :' infile
   signal abort_job
   end

rc = stream(outfile,'C','close')
if rc <> 'READY:' then
   do
   SAY 'Erreur de fermeture du fichier :' outfile
   signal abort_job
   end


/* Crer les fichiers NAMED???.REV */
/* Faire une boucle pour tous les SUBNETS, de 1  255 si ???.INC existe */
"echo on"
"copy named_bt.frm named.bt > nul:"
i = 1
do while i < 256
   incfile = "NAMED"i".INC"
   rc2 =  stream(incfile,'C','Query Exists')
 if rc2 > "" then do
   Subnet = i
   infile  = "NAMEDREV.FRM"
   outfile = "NAMED"i".REV"
   say outfile
   "if exist" outfile "del" outfile
   ligne = "primary" i".100.142.in-addr.arpa c:\\tcpip\\etc\\namedb\\"outfile
   say ligne
   rc = lineout("NAMED.BT",ligne)

   rc = stream(infile,'C','open read')
   if rc <> 'READY:' then do
      SAY 'Fichier "'infile'" introuvable'
      signal abort_job
      end /* if do */

   rc = stream(outfile,'C','open write')
   if rc <> 'READY:' then do
      SAY 'Impossible de crer le fichier "'outfile'"'
      signal abort_job
      end /* if do */

   /* Replace des variables */
   ii = lines(infile)
   do while ii <> 0
           ligne=linein(infile)
           interpret 'ligne="'ligne'"'
           rc = lineout(outfile,ligne)
           if rc <> 0 then do
   	   SAY 'Erreur lors de la copie sur fichier "'outfile'"'
                   signal abort_job
	   end /* if do */
           ii=lines(infile)
   end /* do while */
   /* Fermeture des fichiers */
   
   rc = stream(infile,'C','close')
   if rc <> 'READY:' then do
      SAY 'Erreur de fermeture du fichier :' infile
      signal abort_job
      end /* if do */

   rc = stream(outfile,'C','close')
   if rc <> 'READY:' then do
      SAY 'Erreur de fermeture du fichier :' outfile
      signal abort_job
      end /* if do */
 end /* if do */
   i = i + 1
end /* do while */

/* Mettre  jour le DNS */
"nssig -HUP"


exit(0)

abort_job:
   exit(1)
