/* REXX * DISKIN ************************************************************/
/* Zweck...: Kopiert den Inhalt einer Digicam-Disk in ein Incoming-Verz.    */
/*           Dabei erhlt der Filename eine fortlaufende Nummer             */
/* Autor...: M. Dort (matthias.dort@epost.de)                               */
/*         : C. Beck (christian.beck11@epost.de)                            */
/* Date....: 8.7.2002                                                       */
vers = "1.6"                                             /* Programmversion */
/****************************************************************************/

/*****************************************************************************/
/* History:                                                                  */
/* V 1.0 - Original                                                          */
/* V 1.1 - Prfen, ob Quell UND Zielvereichnis bereit. Sonst Abbruch         */
/*         Verwendung von verschiedenen Extensions                           */
/*         Lschvorgang am Ende ohne Interaktion                             */
/* V 1.2 - Abfangen wenn fehlerhaft kopiert wird von Quell nach Ziellaufwerk */
/* V 1.3 - Ausgabe Erste letzte Nummer korrigiert /md                        */
/* V 1.4 - Vorbelegen der Variable "weiter" mit "J" zum automatischen Lschen*/
/*         Dateizhler macht fhrende 0000                                   */
/* V 1.5 - Ausgabe ber kopierte Dateien noch mal gendert.                  */
/*       - Funktion zum Auffllen mit 0 eingefhrt                           */
/* V 1.6 - Kommentare angepasst. Ausgaben Letzte Nummer, Es wurden insges..  */
/*         am Programende getauscht                                          */
/*****************************************************************************/

/*****************************************************************************/
/* ToDo:                                                                     */
/* momentan nix                                                              */
/*****************************************************************************/

/*****************************************************************************/
/* Ab hier bitte Variablen anpassen                                          */
/* --------------------------------                                          */
/* Quell-Laufwerk und Zielpfad (Incoming-Verzeichnis) definieren             */
/* Welche Dateiendungen sollen kopiert werden                                */
/*diskLW="e:\temp\diskin\diskette"         Becki-Test   */
/*incomingLW="e:\temp\diskin\platte"       Becki-Test   */

diskLW="g:\temp"                        /* Math-Test   */
incomingLW="g:\incom"                   /* Math-Test   */
/*****************************************************************************/

/* Hier werden die Extensions der Dateien eingetragen                        */
/* Wenn die eine oder andere hinzugefgt oder wegenommen wird, nicht         */
/* vergessen ext.0 entsprechend anzupassen !!!                               */
ext.0 = 3
ext.1 = "jpg"
ext.2 = "gif"
ext.3 = "mpeg"
/*****************************************************************************/

echo off
ARG parm .

/* for the test of the drive and SysFileDelete */
call rxfuncadd 'sysLoadFuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs

if (parm == "--HELP") | (parm == "-H") then do

/* Intro-Screen */

  say
  say "                        **********************"
  say "                        * - -  DISKIN  - - - *"
  say "                        *     ver. "vers "      *"
  say "                        **********************"
  say
  say "     Copies the content of a Digicam disc in an import directory"
  say "     There the file name has a increasing number"
  say
  say "     call diskin"
  say
  say "     (c) M. Dort, matthias.dort@epost.de"
  say "     (c) C. Beck, christian.beck11@epost.de"
exit
end

else do

  say
    say "diskin [--help]"
   say

end


/* test whether source drive is ready */
lw = substr(diskLW,1,2)
zeile = SysDriveInfo(lw)
if zeile == "" then
 do
   say 'source drive 'lw' is not ready'
   say 'is there a discette within the drive ??)'
   exit
 end
else
 do
   parse var zeile  . . . name
   say 'source drive 'lw' has the name: "'strip(name)'"'
 end

/* test whether the target drive is ready */
lw = substr(incomingLW,1,2)
zeile = SysDriveInfo(lw)
if zeile == "" then
 do
   say 'source drive 'lw' is  not ready'
   say '(no diskette put in ??)'
   exit
 end
else
 do
   parse var zeile  . . . name
   say 'source drive 'lw' has the name: "'strip(name)'"'
 end

/* temporary files should be erased */
"if exist "incomingLW"\*.tmp del "incomingLW"\*.tmp"

/* the counting file will be created if there is no one */
 rc = lines(incomingLW"\zaehler")

if rc = 0 then do
  tmp = lineout(incomingLW"\zaehler","00000",1)
end

/* counting index to read */
x = stream(incomingLW'\zaehler','c','close') /* this option allows new write accesses  */
fileindex=linein(incomingLW"\zaehler")

/* file index for later calculation saved */
fileindexalt=fileindex
/* information for the user       */
say "First new number is "fileindexalt

/* test whether files exist with correct extension on the medium */
/* if yes with comamd dir the names move in a temporary file within incoming directory */
/* the switcher "/f" works that only the files name with the path are shown */
do i = 1 to ext.0
  "if exist "diskLW"\*."ext.i "dir "diskLW"\*."ext.i" /f >> "incomingLW"\files.tmp"
end

/* the main program */
/* temporary file completly read, for each line one copy oder */
/* conunt index increased */
do while lines(incomingLW"\files.tmp") > 0
  filename = linein(incomingLW"\files.tmp")
  l = length(filename)
  p = lastpos('.',filename)
  endung = substr(filename,p+1,l-p)
  filename_neu = fileindex"."endung

  "copy "filename incomingLW"\"filename_neu
   if rc > 0 then
   do
     say 'Error during copy of 'filename' to 'incomingLW'\'filename_neu
     say 'Returncode = 'rc
     say 'program has finished'
     exit
   end
   rc = sysfiledelete(filename)
   if rc > 0 then
   do
     say 'the original file on the source facility ('filename')'
     say 'impossible to delete RC = 'rc
     say '   2              Error. File not found '
     say '   3              Error. Path not found '
     say '   5              Error. Access refused '
     say '   26             Error. No DOS data facility'
     say '   32             Error. Confilct during common access '
     say '   36             Error. Overflow of the buffer for the common access '
     say '   87             Error. Inavlid parameter '
     say '   206            Error. File name or file extension to long'
   end

   /* increase teh counter by 1 */
  fileindex = fileindex + 1
  fileindex = auffuellen(fileindex)
end

/* write back the couinting level into the fist line */
tmp = lineout(incomingLW"\"zaehler,fileindex,1)

/* Only if any action happened, user will be informed about last copied file */
if fileindex-fileindexalt \== 0 then do
  fileindex=fileindex-1
  fileindex = auffuellen(fileindex)
  say "last new number is  "fileindex
  fileindex = fileindex+1
end

/* Total number of copied files   */
say "There were totally  "fileindex-fileindexalt " files copied."

/* delete temporary file */
x = stream(incomingLW'\files.tmp','c','close') /* so further write oders are possibel */
"if exist "incomingLW"\*.tmp del "incomingLW"\*.tmp"

say "source drive "diskLW" can be erased"

/* delete diskette  */
/* the Sony-Mavica puts always for each image file a hidden file */
/* therefore the attributes are set back */

say diskLW " delete ? j/n (J)"
  pull weiter      /* store it */
  if (weiter = "J") | (weiter = "") then
   do
    "if exist "diskLW"\*" attrib diskLw"\* -h -r -s"
    "if exist "diskLW"\*" del diskLw"\* /N"
     say "to late : all the files are off"
   end

return 0

/* Function to fill the file index with 0. Always with 5 digits */
/* so the list can be better read */

auffuellen:
  arg variable
  /* for the best view of the user */
  if (variable > 0) & (variable < 10) then variable = '0000'variable
  if (variable > 9) & (variable < 100) then variable = '000'variable
  if (variable > 99) & (variable < 1000) then variable = '00'variable
  if (variable > 999) & (variable < 10000) then variable = '0'variable
return variable
