/*
 *  dirs.cmd
 *  Search for files
 *  1995-03-28, Rolf Lochbuehler
 */

call rxfuncadd 'sysfiletree', 'rexxutil', 'sysfiletree'

parse arg filename startdir

if filename = '' then 
  do       
  call help
  exit 2
  end

if translate(filename) = '-H' then 
  do
  call help
  exit 1
  end

if startdir <> '' then
  do
  currentdir = directory()
  call directory startdir
  end

call sysfiletree filename, 'filefound', 'fso'
if filefound.0 > 0 then
  do i = 1 to filefound.0
    say filefound.i
  end
else
  do
  say 'No files found that match' filename'.'
  exit 3
  end

if symbol(currentdir) <> 'VAR' then
  call directory currentdir

exit 0


help : procedure
  say ''
  say 'dirs -- V1.2, 1997-11-22, Rolf Lochbuehler <rolobue@ibm.net>'
  say 'Purpose:'
  say '  Print all file names matching a file name or file name template.'
  say 'Usage:'
  say '  dirs FILE [DIR]'  
  say 'Arguments:'
  say '  FILE   Name of file(s) to search for'
  say '  DIR    Directory in which to start the search'
  say '         (default: current working directory)'
  say 'Examples:'
  say '  dirs *.cmd'
  say '  dirs *.dll c:\'
  return


