/* DirEA.cmd
 * List a directory, showing any .SUBJECT and .COMMENTS EAs for each file.
 *
 * Copyright 1994 by William F. Schindler. Permission is granted for free
 * use and distribution.
 *
 * Author:  Bill Schindler
 * Created: 12-Jan-1994
 *
 * --------------------------------- History ---------------------------------
 * 05-Feb-1994	wfs  Check for directory in file spec argument
 *		     Add option for showing .COMMENTS EA
 *		     Add usage subroutine
 * ---------------------------------------------------------------------------
 */

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

/*
 * Process any command line arguments
 */
PARSE ARG filespec

i = 0
doComments = 0
doSubdirs = ''

DO WHILE Left(filespec, 1) = '/' | Left(filespec, 1) = '-'
  sep = Left(filespec, 1)
  PARSE VAR filespec (sep) pgmArg filespec
  pgmArg = Translate(pgmArg)

  SELECT
    WHEN pgmArg = 'C' THEN
      doComments = 1
    WHEN pgmArg = 'S' THEN
      doSubdirs = 'S'
    WHEN pgmArg = '?' | Abbrev('HELP', pgmArg, 1) THEN
      DO
      CALL ShowUsage
      SIGNAL EndIt
      END
    OTHERWISE
      DO
      SAY
      SAY "Invalid command line argument '" || sep || pgmArg || "'"
      SIGNAL EndIt
      END
  END
END

SELECT
  WHEN filespec = '' THEN
    filespec = '*.*'
  WHEN Right(filespec, 1) = '\' THEN
    filespec = filespec || '*.*'
  OTHERWISE
    NOP
END

/*
 * Read the directory
 */
CALL SysFileTree filespec, 'files.', 'FO' || doSubdirs

SAY 'Total of' files.0 'files found for "' || filespec || '":'
SAY

IF files.0 = 0 THEN
  SIGNAL EndIt

/*
 * Collect and parse the EAs for each file found
 */
longestFN = 4
longestType = 4
longestSubj = 7

DO i = 1 to files.0
  /*
   * Get .SUBJECT EA
   */
  longestFN = MAX(longestFN, LENGTH(FILESPEC('name', files.i)))
  IF SysGetEA(files.i, '.SUBJECT', 'eaStuff') = 0 THEN DO
    subjLen = '0'X
    PARSE VAR eaStuff 3 subjLen 4 . 5 subject
    subjLen = MIN(C2D(subjLen), 54)
    subject = LEFT(subject, subjLen)
    END
  ELSE
    subject = ''
  ea.subjects.i = subject
  longestSubj = MAX(longestSubj, LENGTH(subject))
  /*
   * Get .COMMENTS EA
   */
  IF doComments THEN
    IF SysGetEA(files.i, '.COMMENTS', 'eaStuff') = 0 THEN DO
      PARSE VAR eastuff 11 ea.comments.i
      END
END

/*
 * Display the files and associated EAs
 */
SAY ' 'CENTER('File', longestFN) '|' CENTER('Subject', longestSubj)
PARSE VALUE SysTextScreenSize() WITH rows cols

lastSubdir = ''
extraDirs = 0

DO i = 1 to files.0
  IF \ doComments THEN
    CALL PageIt

  IF doSubdirs = 'S' THEN
    IF lastSubdir >< FileSpec('PATH', files.i) THEN
      DO
      lastSubdir = FileSpec('PATH', files.i)
      SAY 'Directory:  ' || FileSpec('DRIVE', files.i) || lastSubdir
      extraDirs = extraDirs + 1
      IF \ doComments THEN
	CALL PageIt
      END
  /*
   * Build a single line with the file name and subject
   */
  fn = FILESPEC('name', files.i)
  IF LENGTH(fn) < longestFN THEN
    fn = INSERT(' ', fn, longestFN - 1)
  IF LENGTH(ea.subjects.i) < longestSubj THEN
    ea.subjects.i = INSERT(' ', ea.subjects.i, longestSubj - 1)
  SAY ' ' || fn '|' ea.subjects.i
  /*
   * If requested, show comments
   */
  IF doComments & ea.comments.i >< '' THEN
    DO
    SAY '  ' || ea.comments.i
    SAY
    END
END

EndIt:

EXIT

/* ---------------------------------------------------------------------------
 * P a g e I t
 */
PageIt:
  /*
   * Handle displaying more than one screen of data. Since we're not
   * calculating the length of a .COMMENTS EA, we don't bother paging
   * the output when the 'C' option is turned on.
   */
  IF ((i + extraDirs) // (rows - 2)) = 0 THEN DO
    SAY '--- more ---'
    PARSE VALUE SysCurPos() WITH row col
    CALL SysCurPos row - 1, col
    CALL SysGetKey 'NOECHO'
    END
  RETURN

/* ---------------------------------------------------------------------------
 * S h o w U s a g e
 */
ShowUsage:
  SAY
  SAY "dirEA: List comments and subject EAs for one or more files"
  SAY
  SAY "  Usage:  dirEA [options] [pathname]"
  SAY
  SAY "  Options:"
  SAY "    -?        Displays this usage screen"
  SAY "    -C        Displays .COMMENTS EA in addition to .SUBJECT EA"
  SAY "    -S        Processes pathname and its subdirectories"
  SAY
  SAY "  The pathname parameter defaults to '*.*'"
  RETURN
