/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         DDEAPP3_Close
*/
DDEAPP3_Close:

     /* get the values from the entry fields */
     database = VRGet( "EF_1", "Value")
     userid = VRGet( "EF_2", "Value" )
     password = VRGet( "EF_3", "Value" )

     /* No information entered setting a default */     
     if (database="" & userid="" & password="") then do
        ok = VRSet( "DDEAPP3", "StatusText", "Setting the default" )
        ok = VRSet("EF_1","Value","c:\wsql40\sample.db")
        ok = VRSet("EF_2","Value","dba")
        ok = VRSet("EF_3","Value","sql")
        call VRSet VRWindow(), 'Pointer', 'Wait'
        do i= 1 to 100000
        end
        call VRSet VRWindow(), 'Pointer', '<Default>'
     end
                  
     /* store the information used by another file */
     database = VRGet( "EF_1", "Value")
     userid = VRGet( "EF_2", "Value" )
     password = VRGet( "EF_3", "Value" )

     ok = VRMethod( "Application", "PutVar", "database", "database" )
     ok = VRMethod( "Application", "PutVar", "userid", "userid" )
     ok = VRMethod( "Application", "PutVar", "password", "password" )
     
     call Quit
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    window = VRWindow()
    call VRMethod window, "Activate"
    drop window
    database =""
    userid = ""
    password = ""
    call VRSet "DDEAPP3", "Visible", 0
    Buttons.1 = "Ok"
    Buttons.0 = 1
    call VRMessage VRWindow(), "The topic name identifies the user, and optionally, the database to be used", "FYI", "None", "Buttons."
    call VRSet "DDEAPP3", "Visible", 1
    call VRSet "DDEAPP3", "StatusText", "If empty fields are left empty then a default sample will be chosen." 
return

/*:VRX         PB_1_Click
*/
PB_1_Click: 
    call DDEAPP3_Close
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

