/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    windowmain = VRWindow()

    /* display the DDE Server Object Window */
    call VRLoadSecondary "sw_2"

    call VRMethod windowmain, "Activate"
    call VRSet "Window1", "StatusText", "Press 'Connect' To Start"
return    

/*:VRX         PB_10_Click
*/
PB_10_Click: 
 call quit
return

/*:VRX         PB_1_Click
*/
PB_1_Click: 
  /* Display Message that we are trying to find all avaiable DDE Servers */
  call VRSet "Window1", "StatusText", "Getting Available DDE Servers"

  /* Pause for status text to be read on bottom of window */
  do i=1 to 10000
  end

  /* Find all available DDE Servers and topics currently available and 
     store them in a stem variable called convs
  */
  call VRMethod "DDEC_1", "Initiate", "convs." 

  /* a secondary window to display the contents of the stem variable convs */ 
  window = VRLoadSecondary( "sw_1", "W" )

  /* display a message on for the Accept command on attempting to converse
     with WSQL DDE Server
  */
  call VRSet "Window1", "StatusText", "Attempting to converse with WSQL DDE Server"
  
  /* Accept the the only conversation */
  ok = VRMethod( "DDEC_1", "Accept", )

  /* check return code of Accept method */
  if ok = 1 then /* Accept operation is successful */
    call VRSet "Window1", "StatusText", "Conversation is established"
  else do /* Accept method failed must try again */
    call VRSet "Window1", "StatusText", "No Conversation established check connections then press Connect again."
    call DDEAPP7 VRWindow()
    return 
  end

  call VRSet "Window1", "StatusText", "Poking the CONNECT Command to WSQL DDE Server" 
  
  /* Dialog file to remind user that the connect
     command must done before you connect to the database
  */
  call VRSet "Window1", "Visible", 0
  call DDEAPP4 VRWindow()
  call VRSet "Window1", "Visible", 1

  /* connecting to database */ 
  status = VRMethod( "DDEC_1", "Poke", "CONNECT", ""   )
  if status = "error" then do
     call VRSet "Window1", "StatusText", "Error on trying to connect to database, resolve problem and press Link."
     call DDEAPP7 VRWindow()
     return 
  end 

  call VRSet "Window1", "Pointer", "Wait"
  do i = 1 to 50000
  end
  call VRSet "Window1", "Pointer", "<Default>"

  /* reset the text in the status area to null */
  call VRSet "Window1", "StatusText", ""

  /* enable poke, terminate, request, execute and 
     execute sample buttons
  */
  call VRSet "PB_2", "Enabled", 1 
  call VRSet "PB_3", "Enabled", 1
  call VRSet "PB_4", "Enabled", 1
  call VRSet "PB_5", "Enabled", 1
  call VRSet "PB_6", "Enabled", 1
  
  /* File Dialog to remind user of commands to can execute
     with DDE Server
  */
  call VRSet "Window1", "Visible", 0
  call DDEAPP5 VRWindow()
  call VRSet "Window1", "Visible", 1

return

/*:VRX         PB_2_Click
*/
PB_2_Click: 
    /* display file dialog about the poke command */
    call DDEAPP6 VRWindow()
return

/*:VRX         PB_3_Click
*/
PB_3_Click: 
    /* display file dialog on request command */
    call DDEAPP10 VRWindow()
return

/*:VRX         PB_4_Click
*/
PB_4_Click: 
    /* display file dialog on request execute command */
    call DDEAPP9 VRWindow()
return

/*:VRX         PB_5_Click
*/
PB_5_Click: 
    /* Do not allow the poke connect command to execute
       because connection with WSQLDDE is terminated
    */
    call VRSet "PB_9", "Enabled", 0

    /* Terminate the connection with the database*/
    call VRMethod "DDEC_1", "Terminate"
    call VRSet "Window1", "StatusText", "Terminating WSQL DDE Connection"
return

/*:VRX         PB_6_Click
*/
PB_6_Click: 
	/* Execute an automated example */
	call VRLoadSecondary "SW_3", "W"
return

/*:VRX         PB_7_Click
*/
PB_7_Click: 
  call VRSet "SW_3", "StatusText", "See Multi-Line Entry Field on Commands Executed and Output from 'Run'"

  /* pause */
  do i=1 to 10000
  end
  
  /* set the mouse arrow to a the clock */
  call VRSet "SW_3", "Pointer", "Wait"

  /* Clear the query buffer and add the SELECT statement to it */
  call VRMethod "DDEC_1", "Poke", "Clear", "SELECT * FROM Lab"
  call VRMethod "MLE_1", "Insert", "call VRMethod 'DDEC_1','Poke','Clear','SELECT * FROM Lab'"||"0d"x 

  call VRMethod "MLE_1", "Insert", "Notes: "
  call VRMethod "MLE_1", "Insert", "The query buffer is cleared and the SELECT statement is added to it"||"0d"x||"0d"x
  
  /* Get the column names and data and store them in a stem variable 
     Had the item been Column_Names then only the column names would
     have been stored in the stem variable. Similarily if the item 
     had been Data then just the data rows would have appeared
  */
  call VRMethod "DDEC_1", "RequestList", "Column_Names_And_Data", "column_and_data."
  call VRMethod "MLE_1", "Insert", "call VRMethod 'DDEC_1','RequestList','Column_Names_And_Data','column_and_data.'"
  
  /* Output the contents of the columns and data into a MLE */
  call VRMethod "MLE_1", "Insert", "0d"x
  call VRMethod "MLE_1", "Insert", "Output:"||"0d"x
  do i = 1 to column_and_data.0
      call VRMethod "MLE_1", "Insert", column_and_data.i 
  end

  call VRMethod "MLE_1", "Insert", "Notes: "
  call VRMethod "MLE_1", "Insert", "Had the Item in the RequestList method been 'Column_Names' then only the column names would have appeared in the above output. Similarly, if the item had been 'Data' then just the data rows would have appeared"||"0d"x 

  /* Clear the query buffer and add the SELECT statement to it */
  call VRMethod "DDEC_1", "Poke", "Clear", "SELECT Surname, Studnum FROM Student"
  call VRMethod "MLE_1", "Insert", "0d"x
  call VRMethod "MLE_1", "Insert", "call VRMethod 'DDEC_1','Poke','Clear','SELECT Surname,Studnum FROM Student'"||"0d"x 

  call VRMethod "MLE_1", "Insert", "Notes: "
  call VRMethod "MLE_1", "Insert", "The query buffer is cleared and the SELECT statement is added"||"0d"x||"0d"x

  /* The query buffer will contain: 
     SELECT Surname, Studnum FROM Student WHERE Studnum < 86009
  */
  call VRMethod "DDEC_1", "Poke", "Add", "where Studnum < 86009"
  call VRMethod "MLE_1", "Insert", "call VRMethod 'DDEC_1','Poke','Add','where Studnum < 86009'"||"0d"x
  
  call VRMethod "MLE_1", "Insert", "Notes: "
  call VRMethod "MLE_1", "Insert", "The query buffer now contains:SELECT Surname, Studnum FROM Student WHERE Studnum < 86009 "||"0d"x||"0d"x 

  /* The ORDER BY clause is appended to the query buffer, and the data 
     from the query is placed on the clipboard. The Item could have been
     Clip_Column_Names or Clip_Column_Names_And_Data
  */
  call VRMethod "DDEC_1", "Poke", "Clip_Data", "ORDER BY Surname"
  call VRMethod "MLE_1", "Insert", "call VRMethod 'DDEC_1','Poke','Clip_Data','ORDER BY Surname'"||"0d"x

  call VRMethod "MLE_1", "Insert", "Notes:"
  call VRMethod "MLE_1", "Insert", "The ORDER BY clause is appended to the query buffer, and the data form the query is placed on the clipboard.  The item could also have been 'Clip_Column_Names' or 'Clip_Column_Names_And_Data' "||"0d"x

  /* paste the contents of the clipboard onto the MLE */
  
  call VRMethod "MLE_1", "Insert", "0d"x||"Output:"||"0d"x
  text = VRMethod( "Application", "GetClipboard" )
  call VRMethod "MLE_1", "Insert", text

  /* Executing a command */
  call VRMethod "DDEC_1", "Poke", "Clear", "UPDATE Student SET Surname='BRIGGS-SMITH'"
  call VRMethod "MLE_1", "Insert", "0d"x
  call VRMethod "MLE_1", "Insert", "call VRMethod 'DDEC_1','Poke','Clear','UPDATE Student SET Surname='BRIGGS-SMITH''"||"0d"x||"0d"x 

  /* The WHERE clause is appended to the query buffer and the command 
     UPDATE Student SET Surname="BRIGGS-SMITH' WHERE surname='BRIGGS'
     is sent to the database engine
  */
  call VRMethod "DDEC_1", "Execute", "WHERE surname='BRIGGS'"
  call VRMethod "MLE_1", "Insert", "call VRMethod 'DDEC_1','Poke','Execute','WHERE surname='BRIGGS''"||"0d"x
 
  call VRMethod "MLE_1", "Insert", "Notes: "
  call VRMethod "MLE_1", "Insert", "The WHERE clause is appended to the query buffer and the command above is sent to the database engine"||"0d"x||"0d"x 

  /* Terminating the connection to the database engine
     DDE conversation still exists
  */
  call VRMethod "DDEC_1", "Poke", "Disconnect", ""
  call VRMethod "MLE_1", "Insert", "call VRMethod 'DDEC_1','Poke','Disconnect'"||"0d"x

  call VRMethod "MLE_1", "Insert", "Notes: "
  call VRMethod "MLE_1", "Insert", "The connection to the database engine is terminated. The DDE conversation still exists, so another POKE Connect could be done" 

  /* Allow to Poke the Connect Command to do the example again */
  call VRSet "PB_9", "Enabled", 1 
    
  /* set mouse pointer back to the arrow which is default */
  call VRSet "SW_3", "Pointer", "<Default>"

  call VRSet "PB_6", "Enabled", 0 
   
return

/*:VRX         PB_8_Click
*/
PB_8_Click: 
     call sw_3_close
return

/*:VRX         PB_9_Click
*/
PB_9_Click: 
    call VRMethod "DDEC_1", "Poke", "CONNECT", "" 

    /* Do not allow the command to be executed again 
       until the sample has been run again
    */
    call VRSet "PB_9", "Enabled", 0 

    /* Enable the sample to be executed again */
    call VRSet "PB_6", "Enabled", 1 
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         SW_1_Close
*/
SW_1_Close: 
   call SW_1_Fini
return

/*:VRX         SW_1_Create
*/
SW_1_Create: 
    call SW_1_Init
return

/*:VRX         SW_1_Fini
*/
SW_1_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window

    /* set the primary window visible */
    call VRSet "Window1", "Visible", 1
return
/*:VRX         SW_1_Init
*/
SW_1_Init: 
    ok = VRSet( "Window1", "Visible", 0 )
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window

    /* create field for container: Service Name and Topic 
       populate container with possible conversations
    */
    fieldHandle1 = VRMethod( "CN_1", "AddField", "String", "Service Name" )
    fieldHandle2 = VRMethod( "CN_1", "AddField", "String", "Topic" )
     if (convs.0 > 0) then do
       records.0 = convs.0
       do i = 1 to convs.0
          parse var convs.i server "," topic
          records.i = ";;;;;"||fieldHandle1||";"||server||";"||fieldHandle2||";"||topic
       end
       call VRMethod "CN_1", "AddRecordList", , "", records.
   end

   /* display dialog file with some notes about the information in the */
   /* container in SW_1 */
   call DDEAPP2 VRWindow()

   /* set the secondary window invisible */
   call VRSet "SW_1", "Visible", 0
   
   /* Get information about the topic */
   call DDEAPP3 VRWindow()
  
   /* Retrieve information handled in DDEAPP3 window file */
   call VRMethod "Application", "GetVar", "database", "database" 
   call VRMethod "Application", "GetVar", "password", "password"
   call VRMethod "Application", "GetVar", "userid", "userid"
   
   /* check for valid database name and path */
   if ( database \= "" ) then do
      parse arg database name'.'ext
      if ( (ext \= "db") | \VRFileExists(database) ) then do
         Do while ( \VRFileExists(database))
           Buttons.1 = "Ok"
           Buttons.0 = 1
           id = VRMessage( VRWindow(), "Invalid Database Name or Path", "Warning", "None", "Buttons.", ,  )
           Types.1 = "*.db"
           Types.0 = 1
           database = VRFileDialog( VRWindow(), "Choose WSQL Database", "Save", "c:\wsql40\*.db", , , "Types." )
         end
      end
   end   

   /* check whether a database was given or not */
   if database ="" then
      call VRMethod "DDEC_1", "Initiate", "wsql.", "WSQLDDE", userid||","||password 
   else
      call VRMethod "DDEC_1", "Initiate", "wsql.", "WSQLDDE", userid||","||password||","||database
     
   /* close the window */
   call SW_1_Fini 
return   

/*:VRX         SW_2_Close
*/
SW_2_Close: 
    call SW_2_Fini
return

/*:VRX         SW_2_Create
*/
SW_2_Create: 
    call SW_2_Init
return

/*:VRX         SW_2_Fini
*/
SW_2_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_2_Init
*/
SW_2_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        /* sets to align main window with SW_2 */
        ok = VRSet( "SW_2", "Top", 0 )
        call VRSet window, "Visible", 1
        height = VRGet( "SW_2", "Height" )
        ok = VRSet( "Window1", "Top", Height )
        call VRSet windowmain, "Visible", 1
    end
    drop window
return

/*:VRX         SW_3_Close
*/
SW_3_Close: 
    call SW_3_Fini
return

/*:VRX         SW_3_Create
*/
SW_3_Create: 
    call SW_3_Init
return

/*:VRX         SW_3_Fini
*/
SW_3_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_3_Init
*/
SW_3_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
    column_and_data.0=0
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call VRMethod "DDEC_1", "Terminate" 
    call Quit
return

