/*  This is CommandPak's xdel command.                       */
/*  (w) 1997-98 Ulrich Mller                                */

/*  WARNING: This is not documented yet and not an official  */
/*  part of CommandPak.                                      */

debug=0

unknownoptionMsg = 'Unknown option (-%a). Type "ln -h" for help.'
interruptMsg = "rm was interrupted externally."
noFilesMsg = "Error in rm: No files found to remove."
rmDirMsg = "Removing directory %a"
rmFileMsg = "Removing %a"
rmFileQs = 'Delete "%a"? (Y)es (N)o (A)ll '
rmSpecialQs = '"%a" is a %b file.'||nl||'Delete anyway? (Y)es (N)o (A)ll '

signal on halt; trace off

if RxFuncQuery("SysLoadFuncs") then do
    call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
    call SysLoadFuncs
end

parse arg args

if args = "" then do
    'call xhelp xdel'
    exit
end

verbose = 0
force = 0
interactive = 0
alwaysReplace = 0
deldir = 0

files.0 = 0
attr.0 = 0

do while (args \= "")
    parse value args with opt1 args
    if debug then Say "Parsing" opt1
    if (substr(opt1, 1, 1)="-") | (substr(opt1, 1, 1)="/") then do
        do optcount = 2 to length(opt1) by 1
            optchar = substr(opt1, optcount, 1)
            if debug then
                Say "Subparsing" optchar
            select
                when (optchar="D") then do
                    Say "Debug messages turned on."
                    debug = 1
                    verbose = 1
                end
                when (optchar="f") then
                    force = 1
                when (optchar="d") then
                    deldir = 1
                when (optchar="v") then
                    verbose = 1
                when (optchar="i") then do
                    interactive = 1
                    verbose = 1
                end
                when (optchar="h") | (optchar="?") then do
                    'call xhelp xdel'
                    exit
                end
            otherwise
                say strReplace(unknownoptionMsg, "%a", optchar)
            end /* select */
        end /* do */
    end /* if */
    else do
        rc = SysFileTree(opt1, temp.)
        old0 = files.0
        do i=1 to temp.0
                i2 = i+old0
                parse var temp.i fdate ftime size attr.i2 files.i2
        end
        files.0 = files.0+temp.0
    end /* else */
end /* do while */

if files.0 = 0 then
    say nofilesMsg

do i=1 to files.0
    confirm = ""
    OK = 1
    if (pos('D', attr.i) > 0) then
        if deldir then do
            say strReplace(rmDirMsg, '%a', files.i)
            'rd' files.i
            OK = 0
        end
        else iterate
    else do
        if (pos('H', attr.i) > 0) then
            confirm = "hidden"
        if (pos('R', attr.i) > 0) then
            confirm = confirm "read-only"
        if (pos('S', attr.i) > 0) then
            confirm = confirm "system"
        if (confirm \= "") then do
            OK = queryYN(strReplace(strReplace(rmSpecialQs, '%a', strip(files.i)), '%b', confirm))
            'attrib -h -r -s' files.i
        end
        else
            if interactive then
                OK = queryYN(strReplace(rmFileQs, '%a', strip(files.i)))
    end
    if OK then do
        if verbose then
            say strReplace(rmFileMsg, '%a', strip(files.i))
        'del' files.i
    end
end

exit

strReplace:
    /* syntax: result = strReplace(str, old, new) */
    /* will replace a by b in oldstr */
    parse arg str, old, new
    p = pos(old, str)
    if (p > 0) then
        return left(str, p-1)||new||substr(str,p+length(old))
    else
        return str

queryYN:
    if \alwaysReplace then do
        call charout , arg(1)
        key = ''
        do until pos(key,"YNA") > 0
           key = translate(SysGetKey("NOECHO"))
        end /* do */
        Say key
        if (key = "A") then
            alwaysReplace = 1
     end
     if (alwaysReplace) then key = "Y"
return (translate(key) = "Y")

halt:
    Say ""
    Say interruptMsg
    exit


