/* This is CommandPak's watchdrv command.               */
/* (w) 1997-98 Ulrich Mller                            */

'@echo off'

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
signal on error   /* When commands fail, call "error" routine. */
signal on halt    /* When interrupted, call "halt" routine. */
parse arg opt

do
    drive = ""
    play = 0
    ignore = 0
    interval = ""
    insound = ""
    outsound = ""
    do while (opt \= "")
        parse value opt with opt1 opt
        /* Say "Parsing" opt1 */
        select
            when (length(opt1)=2) & (substr(opt1, 2, 1)=":") then do
                drive = translate(opt1)
            end
            when (substr(opt1, 1, 2)="-h") | (substr(opt1, 1, 2)="-?") then do
                'call xhelp watchdrv'
                exit
            end
            when (substr(opt1, 1, 3)="-t:") then interval = substr(opt1, 4)
            when (substr(opt1, 1, 4)="-si:") then insound = substr(opt1, 5)
            when (substr(opt1, 1, 4)="-so:") then outsound = substr(opt1, 5)
            when (substr(opt1, 1, 2)="-i") then ignore = 1
            when (substr(opt1, 1, 6)="--play") then do
                play = 1
                Say 'Sorry, the "play" function is not implemented yet.'
                exit
                rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
                InitRC = mciRxInit()
            end
        otherwise do
            'call xhelp -f invalidOptionMsg watchdrv'
            exit
        end
        end /* select */
    end
    if (drive = "") then do
        drives = SysDriveMap()
        drive = word(drives, words(drives))
        'call xhelp -f wdAssumeMsg' drive
    end

    'call xhelp -f wdBeginMsg' drive

    if (interval="") then interval=2
    'call xhelp -f wdFrequencyMsg' interval
    'call xhelp -f wdMinimizeMsg' interval
    if ignore then do
        lastid = SysDriveInfo(drive)
        if (lastid \= "") then Say "Current media:" lastid
        else Say "Current media: none"
    end
    else lastid = ""
    do forever
        Call Charout ,"."
        id = SysDriveInfo(drive)
        if (id = "") & (play) then do
            rc = mciRxSendString('open cdaudio alias cd shareable wait', 'RetStr', '0', '0')
            rc = mciRxSendString('status cd media present wait', 'RetStr', '0', '0')
            if (RetStr = "TRUE") then id = "audio cd"
            rc = mciRxSendString('status cd mode wait', 'RetStr', '0', '0')
            rc = mciRxSendString('close cd wait', 'RetStr', '0', '0')
        end
        if (lastid \= id) then do
            if (id \= "") then do
                'call xhelp -f wdInsertMsg'
                Say id
                if (insound \= "") then 'call play file='||insound
                call SysOpenObject drive||"\","DEFAULT",1
            end
            else  do
                'call xhelp -f wdRemoveMsg'
                if (outsound \= "") then 'call play file='||outsound
            end
            lastid = id
        end
        call SysSleep interval
    end
end
exit

error:
    ErrRC = rc
    say 'Fehler' ErrRC 'in Zeile' sigl ', Quellenzeile:' sourceline(sigl)
    MacRC = mciRxExit()       /* Tell the DLL we're going away */
    exit ErrRC                /* exit, tell caller things went poorly */

halt:
    'call xhelp -f abortMsg watchdrv'
    exit

