/* ln.cmd - create shadows                                            */
/* (w) (c) 1996, 1997 Martin Lafaix, Ulrich Mller                    */

debug=0

unknownoptionMsg = 'Unknown option (-%a). Type "ln -h" for help.'
interruptMsg = "ln was interrupted externally."
noFilesMsg = "Error in ln: No files found to link."
norootMsg = "Error in ln: Root directory cannot be linked."
failedMsg = "Error in ln: Shadow creation failed (%a)."
invDestMsg = "Error in ln: Invalid destination."

signal on halt; trace off

if RxFuncQuery("SysLoadFuncs") then do
    call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
    call SysLoadFuncs
end

parse arg args

linkfrom = ""
linkto = ""
if args = "" then do
    'call xhelp ln'
    exit
end

verbose = 0
force = 0

do while (args \= "")
    parse value args with opt1 args
    if debug then Say "Parsing" opt1
    if (substr(opt1, 1, 1)="-") | (substr(opt1, 1, 1)="/") then do
        do optcount = 2 to length(opt1) by 1
            optchar = substr(opt1, optcount, 1)
            if debug then
                Say "Subparsing" optchar
            select
                when (optchar="D") then do
                    Say "Debug messages turned on."
                    debug = 1
                    verbose = 1
                end
                when (optchar="f") then
                    force = 1
                when (optchar="v") then
                    verbose = 1
                when (optchar="h") | (optchar="?") then do
                    'call xhelp ln'
                    exit
                end
            otherwise
                say strReplace(unknownoptionMsg, "%a", optchar)
            end /* select */
        end /* do */
    end /* if */
    else
        if linkfrom = "" then
            linkfrom = opt1
        else linkto = opt1
end /* do while */

curdir = directory()

if debug then
    say '  Given linkto:    "'linkto'"'

if (linkto = "") then
    linkto = directory()
else
    linkto = directory(linkto)

if debug then
    Say '  Enhanced linkto: "'linkto'"'

if (linkto = "") then do
    say invDestMsg
    exit
end

if debug then
    say '  linkfrom1: "'linkfrom'"'

linkfrom = expandPath(linkfrom)
frompath = filespec('drive', linkfrom)||filespec('path', linkfrom)

if debug then do
    Say '  linkfrom2: "'linkfrom'"'
    Say '  frompath: "'frompath'"'
end

call directory curdir

if (substr(linkfrom, 2)=":\") then
    say noRootMsg
else do
    rc = SysFileTree(linkfrom, linkfrom.)
    if (linkfrom.0 = 0) then
        Say noFilesMsg
    else do i=1 to linkfrom.0
        if debug then say i "-" linkfrom.i
        parse var linkfrom.i fdate ftime fsize fattr fname
        fromname = filespec('name', fname)
        if debug then say i '- frompath: "'frompath'"' 'fromname: "'fromname'"'
        if \CreateShadow(frompath||fromname, linkto) then
            say strReplace(failedMsg, '%a', fromname)
    end
end
exit

CreateShadow: /* syntax: rc=CreateShadow(fromfile, todir) */
    fname = filespec('name', arg(1))
    setup = 'SHADOWID='||arg(1)
    dest = strip(arg(2), 't', '\')
    if verbose then
        say "Creating shadow: "arg(1)
    if debug then do
        if force then call charout , "FORCING "
        say "  SysCreateObject('WPShadow', "fname", "dest", "setup")"
    end

    if force then
        rc = SysCreateObject('WPShadow', fname, dest, setup, 'F')
    else
        rc = SysCreateObject('WPShadow', fname, dest, setup)
return rc

halt:
    Say ""
    Say interruptMsg
    exit

strReplace:
    /* syntax: result = strReplace(str, old, new) */
    /* will replace a by b in oldstr */
    parse arg str, old, new
    p = pos(old, str)
    if (p > 0) then
        return left(str, p-1)||new||substr(str,p+length(old))
    else
        return str

expandPath:
    /* syntax: fullpath = expandPath(path) */
    /* Expl.: expandPath('bin\a.exe') ==> G:\Tools\bin\ if "G:\Tools" is current dir */

    file = arg(1)
    curdir2 = directory()

    if debug then say "  expandPath {"
    fdrive = filespec('drive', file)
    fpath = filespec('path', file)
    fname = filespec('name', file)
    if debug then say '    given:    "'fdrive'" "'fpath'" "'fname'"'

    /* first find out drive */
    if (fdrive = "") then
        fdrive = filespec('drive', curdir2)

    /* now expand the actual path */
    if (fpath = "\") then
        if (fname = "") then do
            fpath = ""
            fname = "\"
        end
        else
            fpath = "\"
    else do
        select
            when (fpath = "") | (fpath = ".\") then
                fpath = substr(directory(fdrive), 3)
            otherwise do
                /* add drive, strip trailing "\" */
                fpath = fdrive||left(fpath, length(fpath)-1)
                if debug then say '    fpath1: "'fpath'"'
                /* now check directory and remove drive again */
                fpath = substr(directory(fpath), 3)
            end
        end /* select */
        if (right(fpath, 1) \= "\") then
            fpath = fpath||"\"
    end

    fullPath = fdrive||fpath||fname
    if debug then do
        say '    returned: "'fdrive'" "'fpath'" "'fname'"'
        say '    --->      "'fullPath'"'
    end
    if debug then say "  } expandPath"
    call directory curdir2
return fullPath

