/* install cmdshl */
/* (w) (c) 1997 Ulrich Mller */

'@echo off'
signal on halt; trace off

call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

nl = '0a0d'x
foundList.0 = 0

say ""
say 'Please select your language -- Bitte whlen Sie Ihre Sprache'
say ""
say 'Please press "E" to install MLRXSHL/CommandPak in English.'
say 'Drcken Sie bitte "D", um MLRXSHL/CommandPak auf deutsch zu installieren.'

key = ''
do until pos(key,"ED") > 0
   key = translate(SysGetKey("NOECHO"))
end /* do */

select
    when (key = "D") then
        lang="049"
    when (key = "E") then
        lang="001"
end

callxhelpStr = "call xhelp -F inst"lang".msg"

cls

callxhelpStr "welcomeMsg"
call pause

callxhelpStr "disclaimerMsg"
call pause
'view cmdpak0 disclaimer'
callxhelpStr "pauseMsg"
call pause

callxhelpStr "checkingPrevious"
call filesExist "cmdshl.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "df.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "fl.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "less.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "ln.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "popd.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "pushd.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "query.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "sdir.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "watchdrv.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "whence.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "xcp.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "xdel.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "xdir.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "xhelp.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "xren.cmd", value('PATH',,'OS2ENVIRONMENT')
call filesExist "profile.shl", value('PATH',,'OS2ENVIRONMENT')
call filesExist "mlrxshl0.inf", value('BOOKSHELF',,'OS2ENVIRONMENT')
call filesExist "mlrxshl.inf", value('BOOKSHELF',,'OS2ENVIRONMENT')
call filesExist "cmdpak0.inf", value('BOOKSHELF',,'OS2ENVIRONMENT')
call filesExist "cmdpak.inf", value('BOOKSHELF',,'OS2ENVIRONMENT')
call filesExist "rexxvio.dll", getLibPath()
call filesExist "wptools.dll", getLibPath()
if foundList.0 > 0 then do
    callxhelpStr "foundPrevious"
    str = "<HTML><UL FIRST=3>"
    do x = 1 to foundList.0
        len = length(foundList.x)
        str=str "<UL FIRST=3 NEXT="len+4"><LI>" foundList.x
        do y = 1 to foundList.x.0
            str = str foundList.x.y
        end
        str = str "</UL>"
    end
    'call xhelp "'str'"'
    callxhelpStr "foundPrevious2"
    callxhelpStr "pauseMsg"
    call pause
end

directories:
callxhelpStr "targetDir"
targetDir = queryDir(value('PATH',,'OS2ENVIRONMENT'), 'PATH')

callxhelpStr "dllDir"
dllDir = queryDir(getLibPath(), 'LIBPATH')

/* callxhelpStr "profileDir"
profileDir = queryDir(value('DPATH',,'OS2ENVIRONMENT'), 'DPATH') */
profileDir = targetDir

callxhelpStr "helpDir"
infDir = queryDir(value('BOOKSHELF',,'OS2ENVIRONMENT'), 'BOOKSHELF')

callxhelpStr "readyQuery"
if (yesno() = "N") then signal directories

say ""
curdir = directory()
call checkDir targetDir
call checkDir dllDir
call checkDir profileDir
call checkDir infDir

call charout ,"Now copying files... "
call directory curdir
'copy *.cmd' targetDir '> NUL'
'copy *.msg' targetDir '> NUL'
'copy *.ico' targetDir '> NUL'
'copy readme*' targetDir '> NUL'
'copy history*' targetDir '> NUL'
'copy *.inf' infDir '> NUL'
'copy *.ipf' infDir '> NUL'
'copy *.dll' dllDir '> NUL'
'copy profile*' profileDir '> NUL'
say 'Done.'

/* now change language code */
call charout, "Setting language..."
profileFile = targetDir"\profile.shl"
if (stream(profileFile , "c", "QUERY EXIST" ) <> "") then do
    profileLength = chars(profileFile)
    call stream profileFile, "c", "OPEN READ"
    profileC = CharIn(profileFile, 1, profileLength )
    call stream profileFile, "c", "CLOSE"
    "if exist" targetDir"\profile.001 del" targetDir"\profile.001"
    "ren" profileFile "profile.001"
    profileC = strReplace(profileC, "'SET HELP.COUNTRY=001'", "'SET HELP.COUNTRY="lang"'")
    call stream profileFile, "c", "OPEN WRITE"
    call charout profileFile, profileC
    call stream profileFile, "c", "CLOSE"
end
say "Done."

parse version thisVersion .
if (thisVersion = "OBJREXX") then do
    callxhelpStr "compileQuery"
    if (yesno() = "Y") then do
        Say "Compiling. Please wait..."
        "ren" targetDir||"\cmdshl.cmd cmdshl.rex"
        "ren" targetDir||"\xdir.cmd xdir.rex"
        "rexxc" targetDir||"\cmdshl.rex" targetDir||"\cmdshl.cmd"
        "rexxc" targetDir||"\xdir.rex" targetDir||"\xdir.cmd"
    end
end

callxhelpStr "WPSQuery"
if (yesno() = "N") then signal nowps

if SysCreateObject("WPFolder", 'MLRXSHL / CommandPak', '<WP_DESKTOP>', 'OBJECTID=<CMDPAK_FOLDER>;ICONFILE='curdir'\fld.ico;ICONNFILE=1,'curdir'\fld1.ico', "REPLACE") then
    Say "Folder successfully created."
else
    Say "Folder creation failed! Something's gone wrong."

if SysCreateObject("WPProgram", 'CmdShl', '<CMDPAK_FOLDER>', 'OBJECTID=<CMDPAK_CMDSHL>;EXENAME='||targetdir||'\cmdshl.cmd;', "REPLACE") then
    Say "CmdShl object successfully created."
else
    Say "CmdShl object creation failed! Something's gone wrong."

if SysCreateObject("WPProgram", 'MLRXSHL / CommandPak Reference', '<CMDPAK_FOLDER>', 'OBJECTID=<CMDPAK_REFERENCE>;PARAMETERS='||infDir||'\cmdpak0.inf+'||infDir||'\mlrxshl.inf+'||infDir||'\cmdpak.inf;EXENAME=view.exe;', "REPLACE") then
    Say "Reference object successfully created."
else
    Say "Reference object object creation failed! Something's gone wrong."

if SysCreateObject("WPProgram", 'WatchDrive', '<CMDPAK_FOLDER>', 'OBJECTID=<CMDPAK_WATCHDRV>;EXENAME='||targetdir||'\watchdrv.cmd;', "REPLACE") then do
    Say "WatchDrive object successfully created."
end
else
    Say "WatchDrive object creation failed! Something's gone wrong."

if SysCreateObject("WPProgram", 'Read me!', '<CMDPAK_FOLDER>', 'OBJECTID=<CMDPAK_README>;PARAMETERS='||targetDir||'\readme.1st;EXENAME=e.exe;', "REPLACE") then
    Say "Readme object successfully created."
else
    Say "Readme object object creation failed! Something's gone wrong."

callxhelpStr "pauseMsg"
call pause

nowps:
BootDrive = GetBootDrive()
callxhelpStr "configSysQuery"
say "        SET COMSPEC="BootDrive"\OS2\CMD.EXE /C "targetDir"\cmdshl.cmd"
say "        SET OS2_SHELL="BootDrive"\OS2\CMD.EXE /C "targetDir"\cmdshl.cmd"
callxhelpStr "configSysQuery2"
if (yesno() = "Y") then do
    'start /f e.exe' BootDrive||'\CONFIG.SYS'
end

callxhelpStr "doneMsg"
call pause
rc = SysSetObjectData("<CMDPAK_README>","OPEN=DEFAULT")
exit

yesno:
key = ''
do until pos(key,"YN") > 0
   key = translate(SysGetKey("NOECHO"))
end /* do */
Say key
return translate(key)

halt:
say '0d0a'x'Installation aborted!'
exit

queryDir:
    callxhelpStr "dirPauseMsg"
    call pause

    callxhelpStr "foundDirsMsg"
    say arg(2)":"

    path. = ""
    path2 = arg(1)
    i = 1
    do while (path2 \= "")
        parse var path2 path3 ";" path2
        say format(i,4)||":" path3
        path.i = path3
        i=i+1
    end
    callxhelpStr "xAskMeMsg"
    path.0 = i-1
    callxhelpStr "enterNumberQuery"
    repeat:
    parse pull _dir
    if \((_dir = "x") | ((_dir > 0) & (_dir <= path.0))) then do
        callxhelpStr "invalidMsg"
        signal repeat
    end
    if (_dir = "x") then do
        callxhelpStr "enterFullQuery"
        parse pull dir
    end
    else dir = path._dir
    say dir
return dir

GetBootDrive: procedure
    parse upper value VALUE( "PATH",, "OS2ENVIRONMENT" ) with "\OS2\SYSTEM" -2 boot_drive +2
return boot_drive

GetLibPath: procedure
   bootDrive = GetBootDrive()
   thisRC = 0
   if bootDrive <> "" then do
                     /* get the LIBPATH value                          */
     configSys = left( bootDrive,1 ) || ":\CONFIG.SYS"
     lineSeparator = "0D0A"x
     libpathStmt = lineSeparator || "LIBPATH="

     if (stream( configSys, "c", "QUERY EXIST" ) <> "") then do
       configSysLength = chars( configSys )
       call stream configSys, "c", "OPEN READ"
       configSYS_ = CharIn( configSys, 1, configSysLength )
       call stream configSys, "c", "CLOSE"
       parse upper var ConfigSYS_ . (libPathStmt) LIBPATH (lineSeparator) .
       LIBPATH = strip( LIBPATH )
     end
     else
       thisRC = -1
    end
return LIBPATH

checkdir:
    if translate(directory(arg(1))) \= translate(arg(1)) then do
        call charout ,"Creating target directory... "
        'md' arg(1)
        say "Done."
    end
return

searchPath:
    leftPath = arg(1)
    sFile = arg(2)
    do while leftPath \= ""
        parse var leftPath curpath ";" leftPath
        if (stream(curpath"\"sFile,'c','query exists') \= "") & (curPath \= "") & (curPath \= ".") & (curPath \= directory()) then
            return curpath"\"sFile
    end
return 0

filesExist:
    rc = sysFileTree(arg(1), installFiles)
    searchPath = arg(2)
    curdir_ = directory()
    do i = 1 to installFiles.0
        parse var installFiles.i fdate ftime fsize fattr fname
        fname = filespec('NAME', fname)
        found = SearchPath(searchPath, fname)
        if (found \= "") then do
            fpath = filespec('D', found)||filespec('PATH', found)
            if fpath = "" then leave
            found2 = 0
            do j = 1 to foundList.0
                if foundList.j = fpath then
                    found2 = j
            end
            if (found2 = 0) then do
                k = foundList.0 + 1
                foundList.k = fpath
                foundList.k.0 = 1
                foundList.k.1 = fname
                foundList.0 = k
            end
            else do
                k2 = foundList.found2.0 + 1
                foundList.found2.0 = k2
                foundList.found2.k2 = fname
            end
        end
    end
return (foundList.0 > 0)

pause:  procedure
key = ""
do while (key = "")
   key = SysGetKey("NOECHO")
end /* do */
say ""
return

strReplace: procedure
    /* syntax: result = strReplace(str, old, new) */
    /* will replace a by b in oldstr */
    parse arg str, old, new
    p = pos(old, str)
    if (p > 0) then
        str = left(str, p-1)||new||substr(str,p+length(old))
return str

