/*
program: Global_Set.cmd
type:    REXXSAA-OS/2, version 2.x
purpose: Setup Globals for all rexx procedures.
version: 1.0
date:    1993-03-17
changed: 1.1    1993-07-21
                -Changed to allow UserID & UserName to be picked up.
         1.2    1993-10-05
                -Changed to allow WHOAMI info retrieved by External Function.
         1.3    1993-11-05
                -Fixed for better error handling.

author:  Byron Stephan

needs:   OS/2 2.0 GA & SP or higher,
         YDBAUTIL.DLL from RXU11.ZIP,
         RxNetInf.DLL written by David Brouse
 
Plans:    

Problems: none known

All rights reserved, copyrighted 1993, no guarantee that it works without
errors, etc. etc.

donated to the public domain granted that you are not charging anything (money
etc.) for it and derivates based upon it, as you did not write it,
etc. if that holds you may bundle it with commercial programs too

you may freely distribute this program, granted that no changes are made
to it.

Please, if you find an error, post me a message describing it, I will
try to fix and rerelease it to the net.

procedures:

usage:   Use these statments in another REXX procedure. 
   
Initialize: Procedure Expose Global. LocalGlobal.
   if Global_Set() <> 0 then do
      Say 'Unable to Initialize!'
      exit -1
   end
   numvar = rxVlist(, 'G', 'GlobalQueue')

   /* Suggested Addtional Local Global variables to add */
   parse source LocalGlobal.OS LocalGlobal.CommandType LocalGlobal.RexxPathName
   LocalGlobal.ProgramName = substr(LocalGlobal.RexxPathName,lastpos('\',LocalGlobal.RexxPathName)+1)

   LocalGlobal.Version = "1.0"
   LocalGlobal.Program = global.ibrightyellow||LocalGlobal.ProgramName,
                      ||" ("global.ibrightblue||LocalGlobal.Version||global.iBrightyellow,
                      ||"):"global.iNormal
   LocalGlobal.Author = global.ibrightgreen"Byron Stephan"global.iNormal


syntax:

flags:

*/
SIGNAL ON FAILURE NAME Error
SIGNAL ON HALT NAME Halt
SIGNAL ON ERROR NAME Error
SIGNAL ON SYNTAX NAME Error

Call SetColors
Say global.iYellow"Initializing..."global.inormal

/* Suggested Addtional Local Global variables to add */
parse source LocalGlobal.OS LocalGlobal.CommandType LocalGlobal.RexxPathName
LocalGlobal.ProgramName = substr(LocalGlobal.RexxPathName,lastpos('\',LocalGlobal.RexxPathName)+1)
LocalGlobal.Version = "1.3"
LocalGlobal.Program = global.ibrightyellow||LocalGlobal.ProgramName,
                   ||" ("global.ibrightblue||LocalGlobal.Version||global.iBrightyellow,
                   ||"):"global.iNormal
LocalGlobal.Author = global.ibrightgreen"Byron Stephan"global.iNormal

Call LoadFunctions
Call SetGlobal
Call StoreGlobal
EXIT 0
Return

SetColors:
   /* define some ANSI.SYS-colors */
   esc    = '1B'x          /* escape-char */

   /* define ANSI-colors */
   global.iNormal        = esc||"[0;40m"  /* reset attributes to normal */
   global.iRed           = esc||"[31;40m" /* red on black */
   global.iGreen         = esc||"[32;40m" /* green on black */
   global.iYellow        = esc||"[33;40m"    /* yellow on black */
   global.iBlue          = esc||"[34;40m"    /* blue on black */
   global.iMagenta       = esc||"[35;40m"    /* magenta on black */
   global.iCyan          = esc||"[36;40m"    /* cyan on black */
   global.iWhiteRed      = esc||"[1;41m"    /* white on red */
   global.iWhiteBlue     = esc||"[1;44m"    /* white on blue */
   global.iBlackWhite    = esc||"[30;47m"   /* black on white */
   global.iRedWhite      = esc||"[31;47m"   /* red on white*/
   global.iBrightRed     = esc||"[31;1;40m" /* red on black */
   global.iBrightGreen   = esc||"[32;1;40m" /* Bright Green */
   global.iBrightYellow  = esc||"[33;1;40m" /* Bright Yellow on black */
   global.iBrightBlue    = esc||"[34;1;40m" /* Bright Blue on black */
   global.iBrightCyan    = esc||"[36;1;40m" /* Bright Cyan on black */
   global.iBrightWhite   = esc||"[37;1;40m" /* Bright White on black */
   global.iBrightMagenta = esc||"[35;1;40m"    /* magenta on black */

return

LoadFunctions:
   /* check whether RxFuncs are loaded, if not, load them */
   IF RxFuncQuery('SysLoadFuncs') THEN
   DO
      /* load the load-function */
      CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      /* load the Sys* utilities */
      CALL SysLoadFuncs
   END

   /* check whether Additional Functions are loaded, if not, load them */
   IF RxFuncQuery('rxydbautilinit')  THEN
   DO
      /* load the load-function */
      CALL RxFuncAdd 'rxydbautilinit','ydbautil','rxydbautilinit'
      /* load the YDB* utilities */
      call rxydbautilinit
   END

   /* check whether LAN Info Functions are loaded, if not, load them */
   if RxFuncQuery( "RxNetLoadFuncs" ) then do
      if RxFuncAdd("RxNetLoadFuncs", "RxNetInf", "RxNetLoadFuncs") then do
         signal failure
      end
   end
   Call RxNetLoadFuncs
   Global.ComputerName = STRIP(RxNetGetWorkstation())
   Global.UserId       = STRIP(RxNetGetUserId())
   Global.Logon_Domain = STRIP(RxNetGetDomain())
   Call RxNetDropFuncs

Return

SetGlobal:
   Global.Username = Find_UserName(Global.Userid)

/*
   if Words(global.UserName) > 2 then
      Global.UserFirstName = word(Global.UserName,1)
      Global.UserLastName = word(Global.UserName,3)
   else do
*/
      Global.UserFirstName = word(Global.UserName,1)
      Global.UserLastName = word(Global.UserName,2)
/*
   end
*/

   /* get screen dimensions */
   PARSE VALUE SysTextScreenSize() WITH global.ScreenRows global.ScreenColumns

   /* hint for default yes or no */
   global.yesHint = global.iCyan || " (" || global.iYellow || "Y" || global.iCyan || "/n) " || global.iYellow
   global.noHint  = global.iCyan || " (y/" || global.iYellow || "N" || global.iCyan || ") " || global.iYellow

   global.iBlankLine = global.iRedWhite || RIGHT("", global.ScreenColumns - 1) || global.iCyan
   global.Seperator = global.iCyan ||copies("_", global.ScreenColumns - 1) || global.iNormal

   global.iNonPrintable = XRANGE("00"x, "1F"x) || D2C(255)
   global.iFilter       = COPIES("FA"x, 256)
   global.Bootdrive = substr(VALUE('PATH',,'OS2ENVIRONMENT'),POS('\OS2\SYSTEM',VALUE('PATH',,'OS2ENVIRONMENT')) - 2,2)
Return

/**********************************************************************/
StoreGlobal:
   numvar = rxVlist(global., 'V', 'GlobalQueue')

   /* Next lines would load to REXX macrospace
   qinfo = rxQueryMacro(Global_Set)
   if substr(qinfo,1,1) = 0 then
      NOP
   else
      addrc = rxaddmacro(Global_set, global_set.cmd)
   */
Return

Find_UserName: procedure
/****************************************************************
** Get UserName for Userid Passed. This procedure is Encapsulated.
*****************************************************************/
   userid = ARG(1)

   Queue_Name = RxQueue("Create")
   oq = RxQueue("Set",Queue_Name)
 
   /** Send Screen output to queue **/
   "@Net Who "Userid"| PIPE "Queue_Name

   /** Do while Queue Still has lines **/
   do Queued()
      /** Read next line in queue **/
      PARSE PULL line

      /** If line Has User's comment then line contains Name **/
      If POS("User's Comment:",line) > 0 then do

         /** Strip off Label **/
         Comment = STRIP(SUBSTR(line,POS(":",line)+1))

         /** Find last column poistion of name. Ignoring Case Number **/
         NameEnd = LASTPOS("CASE",Comment) -1

         /** Needed in case there is no CASE number in USERID **/
         if NameEnd = -1 then
            NameEnd = LENGTH(Comment)

         /** Get User's Name **/
         UserName = STRIP(SUBSTR(line,POS(":",line)+1,NameEnd))
         leave
      end
   end

   /** Free up memory by deleting queue **/
   oq = RxQueue("Delete",Queue_name)

Return UserName

HALT:
/****************************************************************
** User stopped program! Shame on them!!
*****************************************************************/
   trace off
   SAY LocalGlobal.Program||" User interrupted program."
   Call Pause
   EXIT -1

ERROR:
/****************************************************************
** Error of some sort occured!
*****************************************************************/
   trace off
   myrc = RC
   SAY LocalGlobal.Program||' error occurred !'
   SAY

   SAY 'REXX error' myrc 'in line' SIGL':' ||global.iRedWhite||ERRORTEXT(myrc)||global.iNormal
   SAY global.iBrightRed||Substr('     ',1,6-Length(SIGL))(SIGL)' *-*   'Sourceline(sigl)||global.iNormal

   SAY

IF MYRC = 43 THEN do
   SAY
   SAY '    Chances are you are in not in the correct subdirectory.'
   SAY '    This procedure MUST use some External Functions.'
   SAY '    You MUST have the DLL''s or CMD files for these External Functions'
   SAY '     in your LIBPATH or PATH.'
   SAY '    (Since your are in OS/2 2.x then you should have "." in your LIBPATH'
   SAY '    This would allow you to change to the directory with the DLL''s and run.)'
   SAY
   SAY global.iCyan||'Internally: YOU MUST BE IN K:\PUBLIC\REXX.'global.inormal
   SAY
end
else do
   SAY
   SAY global.iCyan||'Please contact the author with a description of the error.'||global.iNormal
end
   CALL Pause
   EXIT -99

Pause: procedure
/****************************************************************
** Politely Pause
*****************************************************************/
Say "Press any key to continue."
parse upper value SysGetKey('NOECHO') with key

Return

