/*
program: CEDIT.cmd
type:    REXXSAA-OS/2, version 2.x
purpose: Edit Config.SYS File
version: 1.0
date:    1992-08-27 (Internal)
changed: 1.1 1992-09-13 (Internal)
             -SET logic to allow additon of variable
              if it doesn't currently exist
             -Allow no duplicate directory adds on path or set statements
                (only valid if input has semicollons!!)
         2.0 1992-10-06 (External)
             -Can Now accept flags from the command line.
             -Commands changed for clarity.
         2.1 1993-03-11
             -Hide some additional output.
         2.2 1993-05-17
             -Standardize Global variables.
         3.0 1993-06-04 (Internal Beta)
             -Allow deletion of directories from paths...
         3.0a 1993-06-05 
             -Allow deletion of directories from paths...
         3.1 1993-11-05
             -Tell when error caused by bad paths.
             -Check for error on return from Global_Set.

             

author:  Byron Stephan
         Pennsylvania Blue Shield,
         External: Email through OS/2 Shareware BBS
         Internal: Call x25395

needs:   OS/2 2.0 & Rexx Fixes,
         GLOBAL_SET rexx procedure and it's requirements.
            --Global_Set is a standard routine to retrieve
              UserID, UserName, MachineName & Set the ANSI colors.
            --Loads OS/2 REXXUtil Functions,
              For Standard Utility Functions
            --Loads YDBAUTIL.DLL from RXU11.ZIP,
              Need to return Global. Stem variable to calling program.

Plans:   Only attempt to backup or copy if changes have been made.
         Need to standardize the Input logic for both File and Command-line
         Should check when a directory is involved that a Semi-colon is on the end.
         Should have SET input flag as error attempt to modify PATH, DPATH, ...
         ?Error if SET line previously had a semi-colon ending it?

Problems: Will not accept '/' in variables from Command line...
          --Works fine through file...
          --Hardcoding in Backup_File procedure.

All rights reserved, copyrighted 1992, 1993, no guarantee that it works without
errors, etc. etc.

donated to the public domain granted that you are not charging anything (money
etc.) for it and derivates based upon it, as you did not write it,
etc. if that holds you may bundle it with commercial programs too

you may freely distribute this program, granted that no changes are made
to it.

Please, if you find an error, post me a message describing it, I will
fix and rerelease it. And if you have good suggestions send me an Email and I will
see about adding it.

procedures:


usage:   CEDIT /?  _____
         CEDIT /H       \ --- Help
         CEDIT     _____/

         CEDIT /FH ---------- File Command Help

syntax:

flags:
    See Help usage above.

*/

/****************************************************************
** Set up error handling.
** Initialize.
** Parse Command line arguments.
** Process commands.
*****************************************************************/


SIGNAL ON FAILURE NAME Error
SIGNAL ON HALT NAME Halt
SIGNAL ON ERROR NAME Error
SIGNAL ON SYNTAX NAME Error

global. = ""
LocalGlobal. = ""

CALL Initialize                 /* initialize array "global."           */
CALL parse_args ARG(1)
CALL Process
exit


Initialize: PROCEDURE EXPOSE global. LocalGlobal.
/****************************************************************
** Set global variables.
** Set Standard LocalGlobal variables.
** Initialize Variables needed between functions.
*****************************************************************/
   if Global_Set() <> 0 then do
      Say 'Unable to Initialize!'
      exit -1
   end
   numvar = rxVlist(, 'G', 'GlobalQueue')

   parse source LocalGlobal.OS LocalGlobal.CommandType LocalGlobal.RexxPathName
   LocalGlobal.ProgramName = substr(LocalGlobal.RexxPathName,lastpos('\',LocalGlobal.RexxPathName)+1)

   LocalGlobal.Version = "3.1"
   LocalGlobal.Program = global.ibrightyellow||LocalGlobal.ProgramName,
                      ||" ("global.ibrightblue||LocalGlobal.Version||global.iBrightyellow,
                      ||"):"global.iNormal
   LocalGlobal.Author = global.ibrightgreen"Byron Stephan"global.iNormal
   
   LocalGlobal.cLibpath = ""
   LocalGlobal.cPath    = ""
   LocalGlobal.cDPath   = ""
   LocalGlobal.cDelLibpath = ""
   LocalGlobal.cDelPath    = ""
   LocalGlobal.cDelDPath   = ""
   LocalGlobal.AddBegin = ""
   LocalGlobal.AddEnd  = ""
   LocalGlobal.AddBegin.0 = 0
   LocalGlobal.AddEnd.0  = 0
   LocalGlobal.SetVar.0  = 0
   LocalGlobal.ConfigFile = "Config.sys"

RETURN

Parse_ARGS: PROCEDURE EXPOSE Global. LocalGlobal.
/****************************************************************
** If no arguments or Help switches.
**    Goto Help Display
** Parse various switches until no more switches.
** --While switches exist...
** --   Find next switch
** --   Parse Switch & Value to seperate them out
** --   (Note: Requires that a colon exist as part of the switch)
** --   For switch do appropriate action
*****************************************************************/

If ARG(1) = '' | POS('/?',ARG(1)) | POS('/H',TRANSLATE(ARG(1))) THEN
   SIGNAL Usage
If POS('/FH',TRANSLATE(ARG(1))) THEN
   SIGNAL FileUsage


SwitchPos = pos('/',ARG(1))
Do While SwitchPos > 0
   EndOfSwitchInd = pos(':',value,SwitchPos)
   if EndOfSwitchInd < 1 then 
      EndSwitchPos = Length(arg(1))
   else do
      EndSwitchPos = pos('/',value,pos(':',value,SwitchPos)) - 1
      if EndSwitchPos < 1 then
         EndSwitchPos = Length(arg(1))
   end

   Switch_value = substr(arg(1),SwitchPos,EndSwitchPos)

   parse value Switch_Value with '/' Switch ':' Value 
   Switch = TRANSLATE(Switch)
   Select
      /* Save Line to add at beginning of Config.Sys */
      when Switch = 'B' then do 
         LocalGlobal.AddBegin.0 = LocalGlobal.AddBegin.0 + 1
         iTemp = LocalGlobal.AddBegin.0
         LocalGlobal.AddBegin.iTemp = value
      end  /* Do */

      /* Save line to add at end of Config.Sys */
      when Switch = 'E' then do
         LocalGlobal.AddEnd.0 = LocalGlobal.AddEnd.0 + 1
         iTemp = LocalGlobal.AddEnd.0
         LocalGlobal.AddEnd.iTemp = value
      end  /* Do */

      /* Get Commands from a file */
      when Switch = 'F' then do
         global.filein = STRIP(Value)          /* get rid of leading and trailing spaces */
         global.eFilein = STREAM(global.filein, "C", "QUERY EXISTS") /* File exists? */

         IF global.eFilein = "" THEN do
            SAY Global.Program": file "||global.iGreen||"["||global.iCyan || global.filein || global.iGreen||"]"||global.iNormal" does not exist."
            EXIT -2
         END
         else
            call Read_File
      end  /* Do */

      /* Save Directory to add at end of LIBPath. */
      when Switch = 'L' then
         LocalGlobal.cLibpath = LocalGlobal.cLibpath||value

      /* Save Directory to add at end of DPath. */
      when Switch = 'D' then
         LocalGlobal.cDPath = LocalGlobal.cDPath||value

      /* Save Directory to add at end of Path. */
      when Switch = 'P' then
         LocalGlobal.cPath = LocalGlobal.cPath||value

      /* Save Directory to delete from LIBPath. */
      when Switch = 'LDELDIR' then
         LocalGlobal.cDelLibPath = LocalGlobal.cDelLibPath||value

      /* Save Directory to delete from DPath. */
      when Switch = 'DDELDIR' then
         LocalGlobal.cDelDPath = LocalGlobal.cDelDPath||value

      /* Save Directory to delete from Path. */
      when Switch = 'PDELDIR' then
         LocalGlobal.cDelPath = LocalGlobal.cDelPath||value

      /* Save Set Values to Add or replace. */
      when Switch = 'S' then do
         /* If SET keyword exists then add value to keywords value 
         ** else add new SET keyword and value. 
         */ 
         eVariableFound = 0
         PARSE VALUE value WITH keyword "=" value

         DO iTemp = 1 TO LocalGlobal.SetVar.0
            if LocalGlobal.SetVar.Keys.itemp = TRANSLATE(keyword) then do
               LocalGlobal.SetVar.KeyValue.iTemp = LocalGlobal.SetVar.KeyValue.iTemp||value
               eVariableFound = 1
            END
         END
         if eVariableFound = 0 then DO
            LocalGlobal.SetVar.0 = LocalGlobal.SetVar.0 + 1
            iTemp = LocalGlobal.SetVar.0

            LocalGlobal.SetVar.Keys.iTemp = TRANSLATE(keyword)
            LocalGlobal.SetVar.KeyValue.iTemp   = value
            LocalGlobal.SetVar.SetExists.iTemp = 0
         end
      END

   otherwise
      /* Unknown switch - show help */
      Signal Usage

end  /* select */

RETURN

Read_File: PROCEDURE EXPOSE global. LocalGlobal.
/****************************************************************
** While not EOF
**    Read line.
**    Ignore comments and blank lines.
**    Parse file input
**    If problem
**       show line and exit
*****************************************************************/
SAY "Reading Command file..."

iline_no = 0             /* line-number */
DO WHILE LINES(global.filein) > 0
   line = LINEIN(global.filein)
   iline_no = iline_no + 1

   /* no empty lines and no comments */
   IF line = "" | SUBSTR(STRIP(line), 1, 2) = "--" THEN ITERATE

   SAY "parsing "||global.iGreen||"["||global.iNormal || line || global.iGreen||"]"||global.iNormal

   IF Parse_File_Input(line, iline_no) > 0 THEN do
      SAY global.iredwhite
      SAY "Line No:" iline_no
      SAY ">>> " line global.inormal
      SAY 
      exit -3
   END
END

CALL STREAM global.filein, "C", "CLOSE"        /* make sure file is closed */

RETURN

Process: PROCEDURE EXPOSE global. LocalGlobal.
/****************************************************************
** Update temporary file.
** Backup Config.sys file
** If no problems then replace config.sys with temporary file.
*****************************************************************/

SAY "Creating temporary file..."

cTempFilename = SysTempFileName(Global.Bootdrive||'\Temp????.CON')
DO WHILE LINES(global.bootdrive||"\"||LocalGlobal.ConfigFile) > 0
   line = LINEIN(global.bootdrive||"\"||LocalGlobal.ConfigFile)
   UPPERline = TRANSLATE(LINE)

   SELECT
      WHEN ("IFS=" = SUBSTR(UPPERline,1,4)) THEN do
         CALL LINEOUT cTempFilename, line
         DO iTemp = 1 TO LocalGlobal.AddBegin.0
            CALL LINEOUT cTempFilename,LocalGlobal.AddBegin.iTemp
         END
      END
      WHEN ("LIBPATH=" = SUBSTR(UPPERline,1,8)) THEN do
         Path = CheckPath(upperline, LocalGlobal.cLibpath,, LocalGlobal.cDelLibpath)
         CALL LINEOUT cTempFilename,path 
      end
      WHEN ("SET PATH=" = SUBSTR(UPPERline,1,9)) THEN do
         Path = CheckPath(upperline, LocalGlobal.cPath,'', LocalGlobal.cDelPath)
         CALL LINEOUT cTempFilename,Path
      end
      WHEN ("SET DPATH=" = SUBSTR(UPPERline,1,10)) THEN do
         Path = CheckPath(upperline,LocalGlobal.cDPath,'', LocalGlobal.cDelDPath)
         CALL LINEOUT cTempFilename,path 
      end
      WHEN ("SET " = SUBSTR(UPPERline,1,4)) THEN do
         if LocalGlobal.SetVar.0 = 0 then
            CALL LINEOUT cTempFilename,line 
         else
            DO
            eKeywordFound = 0
            DO iTemp = 1 TO LocalGlobal.SetVar.0
               PARSE VAR UPPERline with "SET " keyword "=" 
               if LocalGlobal.SetVar.keys.iTemp = keyword then
                  DO
                  Path = CheckPath(upperline,LocalGlobal.SetVar.KeyValue.iTemp,"Set","","")
                  CALL LINEOUT cTempFilename,path
                  eKeywordFound = 1
                  LocalGlobal.SetVar.SetExists.iTemp = 1
                  END
            END
            if eKeywordFound = 0 then
               CALL LINEOUT cTempFilename,line 
            END
      END
    OTHERWISE
         CALL LINEOUT cTempFilename,line 
   END
END

DO iTemp = 1 TO LocalGlobal.SetVar.0
   if LocalGlobal.SetVar.SetExists.iTemp = 0 then do
       Path = CheckPath("",LocalGlobal.SetVar.KeyValue.iTemp,"Set")
       CALL LINEOUT cTempFilename, "SET "||LocalGlobal.SetVar.keys.iTemp||"="||path
   END
END


DO iTemp = 1 TO LocalGlobal.AddEnd.0
   CALL LINEOUT cTempFilename,LocalGlobal.AddEnd.iTemp 
END
CALL STREAM cTempFilename, "C", "CLOSE"        /* make sure file is closed */
CALL STREAM global.bootdrive||"\"||LocalGlobal.ConfigFile, "C", "CLOSE"        /* make sure file is closed */

call backup_file global.bootdrive||"\"||LocalGlobal.ConfigFile

SAY "Updating "||LocalGlobal.ConfigFile||" file..."

"@copy "||cTempFilename||" "||global.bootdrive||"\"||LocalGlobal.ConfigFile
RCODE=rc

RC = SysFileDelete(cTempFilename)
if RC = 0 then
   exit 0
else
   do
   say global.red||"ERROR!! File could not be deleted!!"||global.inormal
   exit -2
   end
*/
Say "Finished..."
return 0

Backup_File: PROCEDURE EXPOSE global. LocalGlobal.
/****************************************************************
** Backup file with Backini if exists
** else do generic backup
*****************************************************************/
original_file = arg(1)

SAY "Backing up "||LocalGlobal.ConfigFile||" file..."

"@k:\public\util\backini.exe "||original_file||" 5 >NUL 2>&1"

/*BackiniPath = SysSearchPath('PATH','Backini.exe')
if BackiniPath<>"" then do
    "@"||BackiniPath||" "||original_file||" 25"
    RCODE=rc
end
else do
   iBackup = 0
   DO FOREVER
      iBackup = iBackup + 1
      extension = lastpos(".", original_file)
      if extension = 0 then do
         extension = length(original_file) + 1
         backup_file = original_file||"."||iBackup
      end
      else
         backup_file = substr(original_file,1,extension)||iBackup

      global.eBackup = STREAM("CONFIG."||iBackup, "C", "QUERY EXISTS")
 
      IF global.eBackup = "" THEN do
         "copy "||original_file||" "||backup_file
         RCODE=rc
         leave
      END /* End-If */
   END /* End-DO */
END /* End-Else */
*/
return 0

Parse_File_Input: PROCEDURE EXPOSE global. LocalGlobal.
/****************************************************************
** Parse file records for keywords.
** If unknown keyword exists then return bad error code.
*****************************************************************/

to_parse = ARG(1)
line_no  = ARG(2)
iErrorExists = 0

PARSE VALUE to_parse WITH keyword "=" value

SELECT
   WHEN translate(keyword) = "LIBPATH" THEN
      LocalGlobal.cLibpath = LocalGlobal.cLibpath||value
   WHEN translate(keyword) = "DPATH" THEN
      LocalGlobal.cDPath = LocalGlobal.cDPath||value
   WHEN translate(keyword) = "PATH" THEN
      LocalGlobal.cPath = LocalGlobal.cPath||value
   WHEN translate(keyword) = "DELLIBPATH" THEN
      LocalGlobal.cDelLibpath = LocalGlobal.cDelLibpath||value
   WHEN translate(keyword) = "DELDPATH" THEN
      LocalGlobal.cDelDPath = LocalGlobal.cDelDPath||value
   WHEN translate(keyword) = "DELPATH" THEN
      LocalGlobal.cDelPath = LocalGlobal.cDelPath||value
   WHEN translate(keyword) = "ADDBEGIN" THEN
      DO
      LocalGlobal.AddBegin.0 = LocalGlobal.AddBegin.0 + 1
      iTemp = LocalGlobal.AddBegin.0
      LocalGlobal.AddBegin.iTemp = value
      END
   WHEN translate(keyword) = "ADDEND" THEN
      DO
      LocalGlobal.AddEnd.0 = LocalGlobal.AddEnd.0 + 1
      iTemp = LocalGlobal.AddEnd.0
      LocalGlobal.AddEnd.iTemp = value
      END
   WHEN translate(keyword) = "SETVAR" THEN
      DO
      eVariableFound = 0
      PARSE VALUE value WITH keyword "=" value

      DO iTemp = 1 TO LocalGlobal.SetVar.0
         if LocalGlobal.SetVar.Keys.itemp = TRANSLATE(keyword) then
            DO
            LocalGlobal.SetVar.KeyValue.iTemp = LocalGlobal.SetVar.KeyValue.iTemp||value
            eVariableFound = 1
            END
      END         
      if eVariableFound = 0 then
         DO
         LocalGlobal.SetVar.0 = LocalGlobal.SetVar.0 + 1
         iTemp = LocalGlobal.SetVar.0 

         LocalGlobal.SetVar.Keys.iTemp = TRANSLATE(keyword)
         LocalGlobal.SetVar.KeyValue.iTemp   = value
         LocalGlobal.SetVar.SetExists.iTemp = 0
         end
      END
   OTHERWISE
      iErrorExists = iErrorExists + 1
END

RETURN iErrorExists

CheckPath: PROCEDURE expose global. localglobal.
/****************************************************************
** If new value for SET statment doesn't have semi-colon 
**    Replace SET value
** else 
**    Check PATH being built for duplicate directory.
*****************************************************************/
line = arg(1)
Value = arg(2)
Parse upper var value value
Source = arg(3)
DelValue = arg(4)
Parse upper var delvalue delvalue
path = line
startingpos = pos('=',value) + 1
lastpos = pos(';',value)
if translate(source) = 'SET' & lastpos = 0 then do
   SetStatement = substr(line,1,pos('=',line))||value
   return SetStatement
end
else
   If DelValue <> '' then do
      lastpos = pos(';',DelValue)
      do while lastpos > 0
         subvalue = translate(substr(DelValue,startingpos,lastpos-startingpos+1))
         if pos(subvalue, path) > 0 then
            path = DELSTR(path,pos(subvalue, path), length(subvalue))
         else
            Say 'DelValue '||subvalue||' doesn''t exist in '||line
         Startingpos = lastpos + 1
         lastpos = pos(';',DelValue,startingpos)
      end
   end

   If Value <> '' then do
      lastpos = pos(';',value)
      do while lastpos > 0
         subvalue = translate(substr(value,startingpos,lastpos-startingpos+1))
         if pos(subvalue, path) > 0 then
            nop /*Say 'Value '||subvalue||' already exists in '||line*/
         else
            path = path||subvalue
         Startingpos = lastpos + 1
         lastpos = pos(';',value,startingpos)
      end
   end
trace off
return path


Pause: procedure
/****************************************************************
** Politely Pause
*****************************************************************/
Say "Press any key to continue."
parse upper value SysGetKey('NOECHO') with key

Return

USAGE:
/****************************************************************
** Help on switches
*****************************************************************/
   
   SAY LocalGlobal.Program||" Modifies "||LocalGlobal.ConfigFile||" file"
   SAY
   SAY "            /"||global.iBrightMagenta||"H"||global.iNormal"                  ... This Screen of switches"||global.iNormal
   SAY "            /"||global.iBrightMagenta||"?"||global.iNormal"                  ... This Screen of switches"||global.iNormal
   SAY "            /"||global.iBrightMagenta||"FH"||global.iNormal"                 ... Help for File commands"||global.iNormal
   SAY "            /"||global.iBrightMagenta||"F:"||global.iBrightGreen||"["||global.iBrightCyan||"filename"||global.iBrightGreen||"]"||global.iNormal"       ... contains file of commands"||global.iNormal
   SAY "            /"||global.iBrightMagenta||"L:"||global.iBrightGreen||"["global.iBrightCyan||"directory;"||global.iBrightGreen||"]"||global.iNormal"     ... contains directories to add to LIBPATH"||global.iNormal
   SAY "            /"||global.iBrightMagenta||"P:"||global.iBrightGreen||"["global.iBrightCyan||"directory;"||global.iBrightGreen||"]"||global.iNormal"     ... contains directories to add to PATH"||global.iNormal
   SAY "            /"||global.iBrightMagenta||"D:"||global.iBrightGreen||"["global.iBrightCyan||"directory;"||global.iBrightGreen||"]"||global.iNormal"     ... contains directories to add to DPATH"||global.iNormal
   SAY "      /"||global.iBrightMagenta||"LDELDIR:"||global.iBrightGreen||"["global.iBrightCyan||"directory;"||global.iBrightGreen||"]"||global.iNormal"     ... contains directories to delete from LIBPATH"||global.iNormal
   SAY "      /"||global.iBrightMagenta||"PDELDIR:"||global.iBrightGreen||"["global.iBrightCyan||"directory;"||global.iBrightGreen||"]"||global.iNormal"     ... contains directories to delete from  PATH"||global.iNormal
   SAY "      /"||global.iBrightMagenta||"DDELDIR:"||global.iBrightGreen||"["global.iBrightCyan||"directory;"||global.iBrightGreen||"]"||global.iNormal"     ... contains directories to delete from DPATH"||global.iNormal
   SAY global.iBrightBlue||"............         "||global.ired||"(Must use ; after directory names!) "||global.inormal
   SAY "            /"||global.iBrightMagenta||"B:"||global.iBrightGreen||"["global.iBrightCyan||LocalGlobal.ConfigFile||" line"||global.iBrightGreen||"]"||global.iNormal"    ... Complete "||LocalGlobal.ConfigFile||" Line"||global.iNormal
   SAY global.iBrightBlue||"............         "||global.iBrightCyan||"(After File System is loaded... After IFS Statement) "||global.inormal
   SAY "            /"||global.iBrightMagenta||"E:"||global.iBrightGreen||"["global.iBrightCyan||LocalGlobal.ConfigFile||" line"||global.iBrightGreen||"]"||global.iNormal"    ... Complete "||LocalGlobal.ConfigFile||" Line"||global.iNormal
   SAY global.iBrightBlue||".............         "||global.iBrightCyan||"(Add to end of "||LocalGlobal.ConfigFile||" file) "||global.inormal
   SAY "            /"||global.iBrightMagenta||"S:"||global.iBrightGreen||"["global.iBrightCyan||"Keyword"||global.iBrightGreen||"]"||global.iNormal||"="||global.iBrightGreen||"["global.iBrightCyan||"Value"||global.iBrightGreen||"]"||global.iNormal
   SAY global.iBrightBlue||"............     "||global.iyellow||"Keyword"||global.inormal||":"||global.iBrightCyan||" Keyword for SET Statment "||global.inormal
   SAY global.iBrightBlue||"............     "||global.iyellow||"Value"||global.inormal||":"||global.iBrightCyan||" Value to SET keyword "||global.inormal
   SAY global.iBrightBlue||"............   "||global.ired||"(Must use ; if VALUE is directory names!) "||global.inormal
   SAY global.iBrightBlue||"............   "||global.ired||"(Set Variable cannot have ""/"" for it's value "||global.inormal
   SAY global.iBrightBlue||"............   "||global.ired||"           - Do through command file) "||global.inormal

   SAY

   CALL Pause
   EXIT -1

FileUsage:
/****************************************************************
** Help on File Commands.
*****************************************************************/
   
   SAY LocalGlobal.Program||" Modifies "||LocalGlobal.ConfigFile||" file"
   SAY "    : File Format"
   SAY 
   SAY "            "||global.iBrightMagenta||"--"||global.iNormal||"                  ... Comment Line"
   SAY "       "||global.iBrightMagenta||"LIBPATH"||global.inormal||"="||global.iBrightGreen||"["global.iBrightCyan||"directory;"||global.iBrightGreen||"]"||global.iNormal
   SAY "          "||global.iBrightMagenta||"PATH"||global.inormal||"="||global.iBrightGreen||"["global.iBrightCyan||"directory;"||global.iBrightGreen||"]"||global.iNormal
   SAY "         "||global.iBrightMagenta||"DPATH"||global.inormal||"="||global.iBrightGreen||"["global.iBrightCyan||"directory;"||global.iBrightGreen||"]"||global.iNormal
   SAY "    "||global.iBrightMagenta||"DELLIBPATH"||global.inormal||"="||global.iBrightGreen||"["global.iBrightCyan||"directory;"||global.iBrightGreen||"]"||global.iNormal
   SAY "       "||global.iBrightMagenta||"DELPATH"||global.inormal||"="||global.iBrightGreen||"["global.iBrightCyan||"directory;"||global.iBrightGreen||"]"||global.iNormal
   SAY "      "||global.iBrightMagenta||"DELDPATH"||global.inormal||"="||global.iBrightGreen||"["global.iBrightCyan||"directory;"||global.iBrightGreen||"]"||global.iNormal
   SAY global.iBrightBlue||"......         "||global.ired||"(Must use ; after directory names!) "||global.inormal
   SAY "      "||global.iBrightMagenta||"AddBegin"||global.inormal||"="||global.iBrightGreen||"["global.iBrightCyan||LocalGlobal.ConfigFile||" line"||global.iBrightGreen||"]"||global.iNormal
   SAY global.iBrightBlue||"......         "||global.iBrightCyan||"(After File System is loaded... After IFS Statement) "||global.inormal
   SAY "        "||global.iBrightMagenta||"AddEnd"||global.inormal||"="||global.iBrightGreen||"["global.iBrightCyan||LocalGlobal.ConfigFile||" line"||global.iBrightGreen||"]"||global.iNormal
   SAY global.iBrightBlue||"......         "||global.iBrightCyan||"(Add to end of "||LocalGlobal.ConfigFile||" file) "||global.inormal
   SAY "        "||global.iBrightMagenta||"SetVar"||global.inormal||"="||global.iBrightGreen||"["global.iBrightCyan||"Keyword"||global.iBrightGreen||"]"||global.iNormal||"="||global.iBrightGreen||"["global.iBrightCyan||"Value"||global.iBrightGreen||"]"||g
   SAY global.iBrightBlue||"......         "||global.iyellow||"Keyword"||global.inormal||":"||global.iBrightCyan||" Keyword for SET Statment "||global.inormal
   SAY global.iBrightBlue||"......         "||global.iyellow||"Value"||global.inormal||":"||global.iBrightCyan||" Value to SET keyword "||global.inormal
   SAY global.iBrightBlue||"......         "||global.ired||"(Must use ; if VALUE is directory names!) "||global.inormal

   SAY
   CALL Pause

   EXIT -1

HALT:
/****************************************************************
** User stopped program! Shame on them!!
*****************************************************************/
   trace off
   CALL STREAM filein, "C", "CLOSE"             /* make sure, file is closed */
   SAY LocalGlobal.Program||" User interrupted program."
   CALL Pause
   EXIT -1

ERROR:        
/****************************************************************
** Error of some sort occured!
*****************************************************************/
   trace off
   myrc = RC
   SAY LocalGlobal.Program||' error occurred !'
   SAY

   SAY 'REXX error' myrc 'in line' SIGL':' ||global.iRedWhite||ERRORTEXT(myrc)||global.iNormal
   SAY global.iBrightRed||Substr('     ',1,6-Length(SIGL))(SIGL)' *-*   'Sourceline(sigl)||global.iNormal

IF MYRC = 43 THEN do
   SAY
   SAY '    Chances are you are in not in the correct subdirectory.'
   SAY '    This procedure MUST use some External Functions.'
   SAY '    You MUST have the DLL''s or CMD files for these External Functions'
   SAY '     in your LIBPATH or PATH.'
   SAY '    (Since your are in OS/2 2.x then you should have "." in your LIBPATH'
   SAY '    This would allow you to change to the directory with the DLL''s and run.)'
   SAY
   SAY global.iBrightCyan||'Internally: YOU MUST BE IN K:\PUBLIC\REXX.'Global.Normal
   SAY
end
else do
   SAY
   SAY global.iBrightCyan||'Please contact the author with a description of the error.'||global.iNormal
end
   CALL Pause
   EXIT -99

