/*  */

CalcBaseDate: Procedure
/* routine to convert a date passed in YY/MM/DD format (assumes the date is 19YY/MM/DD )
        to Base date format which is based upon an imaginary calendar date of 1/1/0001
        it then assumes there is a leap year every 4 years and every 400 years but not
        if the year is divisble by 100 */

/* initialize routine: */

NonLeap.=31
NonLeap.0=12
NonLeap.2=28
NonLeap.4=30
NonLeap.6=30
NonLeap.9=30
NonLeap.11=30

/* grab parameter and store it in cyear cmonth cdate */

parse arg cyear '/' cmonth '/' cdate ' ' .

/* grab year and convert it to YYYY */

fullyear = '19'||cyear
numyears = fullyear -1
basedays = numyears * 365
QuadCentury = numyears % 400
Century = numyears % 100
LeapYears = numyears % 4
basedays = basedays + (((LeapYears - Century) + QuadCentury) - 1)

do i = 1 to (cmonth -1)
   if i <> '2' then
        basedays = basedays + NonLeap.i
   else /* find if it's a leap year or not */
        if (fullyear // 4) > 0 then
                basedays=basedays + 28
        else
                if ((fullyear // 100) = 0) & ((fullyear // 400) > 0) then
                        basedays = basedays + 28  /* century not divisble by 400 */
                else
                        basedays = basedays + 29 /* quad century or regular leap year */
end /* do */

basedays = basedays + cdate
return basedays
