/*
 * Generator   : PPWIZARD version 2K.033
 *             : FREE tool for OS/2, Windows, DOS and UNIX by Dennis Bareis (dbareis@labyrinth.net.au)
 *             : http://www.labyrinth.net.au/~dbareis/ppwizard.htm
 * Time        : Wednesday, 2 Feb 2000 7:18:22pm
 * Input File  : E:\DB\PROJECTS\OS2\bintool\BINTOOL.x
 * Output File : .\OUT\BINTOOL.CMD
 */

if arg(1)="!CheckSyntax!" then exit(21924)

/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/BINTOOL.X_V   1.10   11 Jun 1998 19:04:46   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
PGM_VERSION     = '2K.033'
OneBeep         = ''
TwoBeep         = OneBeep || OneBeep
Indent          = "        * "
ExitRc          = 0
Dying           = 'N'
Tab             = d2c(9)
ColonColon      = ';' || ';'
LowerCase       = "abcdefghijklmnopqrstuvwxyz"
UpperCase       = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
AllLetters      = LowerCase || UpperCase
trace off
/*
* ADDCOMMA.XH Version 98.090 by Dennis Bareis
*            http://www.labyrinth.net.au/~dbareis/index.htm (db0@anz.com)
*/
signal EndOfADDCOMMACode

AddCommasToDecimalNumber: procedure
NoComma = strip( arg(1) )
if  pos(',', NoComma) <> 0 then
return(NoComma)
DotPos = pos('.', NoComma)
if  DotPos = 0 then
AfterDecimal = ''
else
do
if  DotPos = 1 then
return("0" || NoComma)
AfterDecimal = substr(NoComma, DotPos+1)
NoComma      = left(NoComma, DotPos-1)
end
NoComma = reverse(NoComma)
ResultWithCommas = ""
do  while length(NoComma) > 3
ResultWithCommas = ResultWithCommas || left(NoComma, 3) || ','
NoComma          = substr(NoComma, 4)
end
ResultWithCommas = ResultWithCommas || NoComma
ResultWithCommas = reverse(ResultWithCommas)
if  AfterDecimal <> '' then
ResultWithCommas = ResultWithCommas || '.' || AfterDecimal
return(ResultWithCommas)

EndOfADDCOMMACode:
/*
* REXXTRAP.XH Version 99.287 by Dennis Bareis
*             http://www.labyrinth.net.au/~dbareis/index.htm (db0@anz.com)
*/
signal on NOVALUE name _RexxTrapUninitializedVariable
signal on SYNTAX  name _RexxTrapSyntaxError
/*
* DUMPVAR.XH Version 99.339 by Dennis Bareis
*            http://www.labyrinth.net.au/~dbareis/index.htm (db0@anz.com)
*/
/*
* BIN2REXP.XH Version 99.134 by Dennis Bareis
*            http://www.labyrinth.net.au/~dbareis/index.htm (db0@anz.com)
*/
b2rNewSingleQuote = "' || " || '"' || "'" || '" || ' || "'"
b2rAllHexCodes    = ''
b2rAllAsciiCodes  = ''
do b2rCharCode = 0 to 31
b2rAllHexCodes = b2rAllHexCodes || d2c(b2rCharCode)
end
do b2rCharCode = 32 to 126
b2rAllAsciiCodes = b2rAllAsciiCodes || d2c(b2rCharCode)
end
do b2rCharCode = 127 to 255
b2rAllHexCodes = b2rAllHexCodes || d2c(b2rCharCode)
end
signal  EndBIN2REXPXh

_QuoteAscii:
b2rAscii2Quote = arg(1)
if  pos("'", b2rAscii2Quote) = 0 then
return("'" || b2rAscii2Quote || "'")
else
do
if  pos('"', b2rAscii2Quote) = 0 then
return('"' || b2rAscii2Quote || '"')
else
do
return("'" || ReplaceString(b2rAscii2Quote, "'", b2rNewSingleQuote) || "'")
end
end

_FormatHex:
b2rHexString    = arg(1)
b2rLengthHex    = length(b2rHexString)
b2rFormattedHex = "'"
if  b2rLengthHex > 7 then
do
b2rLeft1     = left(b2rHexString, 1)
b2rLeft1Pos  = verify(b2rHexString, b2rLeft1)
if  b2rLeft1Pos = 0 then
return( "copies('" || c2x(b2rLeft1) || "'x, " || b2rLengthHex || ")" )
else
do
if  b2rLeft1Pos > 7 then
do
b2rFormattedHex = "copies('" || c2x(b2rLeft1) || "'x, " || b2rLeft1Pos-1 || ") || '"
b2rHexString    = substr(b2rHexString, b2rLeft1Pos)
b2rLengthHex    = b2rLengthHex - (b2rLeft1Pos-1)
end
end
end
do  b2rCharPosn = 1 to b2rLengthHex
if  (b2rCharPosn // 8) = 1 then
do
if  b2rCharPosn <> 1 then
b2rFormattedHex = b2rFormattedHex || ' '
end
b2rFormattedHex = b2rFormattedHex || c2x(substr(b2rHexString, b2rCharPosn, 1))
end
b2rFormattedHex = b2rFormattedHex || "'x"
return(b2rFormattedHex)

_QuoteAsciiBreakIfRequired:
qabAscii  = arg(1)
qabLength = length(qabAscii)
qabReturn = ''
do  while qabLength > 256
qabLeft   = left(qabAscii, 256)
qabAscii  = substr(qabAscii, 256+1)
qabLength = qabLength - 256
if  qabReturn = '' then
qabReturn = _QuoteAscii(qabLeft)
else
qabReturn = qabReturn || " || " || _QuoteAscii(qabLeft)
end
if  qabLength = 0 then
return(qabReturn)
else
do
if  qabReturn = '' then
return( _QuoteAscii(qabAscii) )
else
return( qabReturn || " || " || _QuoteAscii(qabAscii) )
end

_FormatHexBreakIfRequired:
fhbHex    = arg(1)
fhbLength = length(fhbHex)
fhbReturn = ''
do  while fhbLength > 80
fhbLeft   = left(fhbHex, 80)
fhbHex    = substr(fhbHex, 80+1)
fhbLength = fhbLength - 80
if  fhbReturn = '' then
fhbReturn = _FormatHex(fhbLeft)
else
fhbReturn = fhbReturn || " || " || _FormatHex(fhbLeft)
end
if  fhbLength = 0 then
return(fhbReturn)
else
do
if  fhbReturn = '' then
return( _FormatHex(fhbHex) )
else
return( fhbReturn || " || " || _FormatHex(fhbHex) )
end

BIN2REXP:
call BIN2REXP_START
b2rValue       = arg(1)
b2rValueLength = length(b2rValue)
if  b2rValueLength = 0 then
call BIN2REXP_ONEBIT  '""'
else
do
do  while b2rValue \== ''
b2rEndAsciiPos = verify(b2rValue, b2rAllAsciiCodes)
if  b2rEndAsciiPos = 0 then
do
call BIN2REXP_ONEBIT _QuoteAsciiBreakIfRequired(b2rValue)
b2rValue = ''
end
else
do
if  b2rEndAsciiPos <> 1 then
do
call BIN2REXP_ONEBIT _QuoteAsciiBreakIfRequired(left(b2rValue, b2rEndAsciiPos-1))
b2rValue = substr(b2rValue, b2rEndAsciiPos)
end
else
do
b2rEndBinaryPos = verify(b2rValue, b2rAllHexCodes)
if  b2rEndBinaryPos = 0 then
do
call BIN2REXP_ONEBIT _FormatHexBreakIfRequired(b2rValue)
b2rValue = ''
end
else
do
call BIN2REXP_ONEBIT _FormatHexBreakIfRequired(left(b2rValue, b2rEndBinaryPos-1))
b2rValue = substr(b2rValue, b2rEndBinaryPos)
end
end
end
end
end
call BIN2REXP_END
return

EndBIN2REXPXh:
signal  EndDUMPVARXh

DumpVarsInExpression:
dv_RexxExp     = arg(1)
dv_Stem        = translate(arg(2))
dv_VarHeading  = arg(3)
dv_LineRoutine = arg(4)
if  dv_Stem <> '' then
do
dv_AutoDump = 'N'
dv_StemDot  = dv_Stem || '.'
if  symbol(dv_StemDot || '0') = 'VAR' then
dv_VarCount = value(dv_StemDot || '0')
else
do
call _DumpVarsLineOutput 'DumpVar: Could not find "' || dv_StemDot || '0' || '"'
return(0)
end
end
else
do
dv_AutoDump = 'Y'
dv_Stem     = 'DV_VARLIST'
dv_StemDot  = dv_Stem || '.'
dv_VarCount = 0
end
if  dv_VarCount = 0 then
dv_MaxVarLng = 0
do  while dv_RexxExp <> ''
parse value strip(dv_RexxExp, 'L') with dv_1stChar +1 dv_RexxExp
select
when    datatype(dv_1stChar, 'S') then
do
dv_OneVar = dv_1stChar
do  while dv_RexxExp <> ''
parse var dv_RexxExp dv_1stChar +1 dv_RexxExp
if  datatype(dv_1stChar, 'S') then
dv_OneVar = dv_OneVar || dv_1stChar
else
do
dv_RexxExp = dv_1stChar || dv_RexxExp
leave
end
end
call _RememberDumpedVar dv_OneVar
if  pos('.', dv_OneVar) <> 0 then
do
do  while dv_OneVar <> ''
parse var dv_OneVar dv_ThisBit '.' dv_OneVar
call _RememberDumpedVar dv_ThisBit
end
end
end
when    dv_1stChar = '"' | dv_1stChar = "'" then
do
dv_EndQuotePos = pos(dv_1stChar, dv_RexxExp)
if  dv_EndQuotePos = 0 then
dv_RexxExp = ''
else
dv_RexxExp = substr(dv_RexxExp, dv_EndQuotePos+1)
end
otherwise
nop
end
end
call value dv_StemDot || '0', dv_VarCount
if  dv_AutoDump = 'Y' then
call DumpVarsInExpressionNow dv_Stem, dv_VarHeading, dv_LineRoutine
return(dv_VarCount)

DumpVarsInExpressionNow:
dv_StemDot     = arg(1) || '.'
dv_VarHeading  = arg(2)
dv_LineRoutine = arg(3)
if  symbol(dv_StemDot || '0') = 'VAR' then
dv_VarCount    = value(dv_StemDot || '0')
else
do
call _DumpVarsLineOutput 'DumpVar: could not find "' || dv_StemDot || '0' || '"'
return(0)
end
if  dv_VarCount <> 0 & dv_VarHeading <> '' then
do
call _DumpVarsLineOutput ''
call _DumpVarsLineOutput dv_VarHeading
call _DumpVarsLineOutput copies('~', length(dv_VarHeading))
end
dv_ShowVarLng = dv_MaxVarLng
if  dv_MaxVarLng > 30 then
dv_ShowVarLng = 30
do  dv_Index = 1 to dv_VarCount
dv_OneVar = value(dv_StemDot || dv_Index)
if  length(dv_OneVar) >= dv_ShowVarLng then
ShowVar = dv_OneVar
else
ShowVar = right(dv_OneVar, dv_ShowVarLng)
dv_OneVarValue = value(translate(dv_OneVar))
if  datatype(dv_OneVarValue, 'N') = 0 then
do
call BIN2REXP dv_OneVarValue
dv_OneVarValue = dv_Value
end
call _DumpVarsLineOutput ShowVar || ' = ' || dv_OneVarValue
end
return

_RememberDumpedVar:
dv_ThisVar = arg(1)
if  symbol(dv_ThisVar) = 'VAR' then
do
dv_AlreadyHave  = 'N'
dv_ThisVarUpper = translate(dv_ThisVar)
do  dv_Index = 1 to dv_VarCount
if  dv_ThisVarUpper = translate(value(dv_StemDot || dv_Index)) then
do
dv_AlreadyHave = 'Y'
leave
end
end
if  dv_AlreadyHave = 'N' then
do
dv_VarCount = dv_VarCount + 1
call value dv_StemDot || dv_VarCount, dv_ThisVar
if  length(dv_ThisVar) > dv_MaxVarLng then
dv_MaxVarLng = length(dv_ThisVar)
end
end
return

_DumpVarsLineOutput:
if  dv_LineRoutine = '' then
say arg(1)
else
interpret 'call ' || dv_LineRoutine || ' arg(1)'
return

BIN2REXP_START:
dv_Value = ''
return

BIN2REXP_ONEBIT:
if  dv_Value <> '' then
dv_Value = dv_Value || ' || '
dv_Value = dv_Value || arg(1)
return

BIN2REXP_END:
return

EndDUMPVARXh:
signal RexxTrap_1

_FindLastLabel:
FailedOnLine = arg(1)
TryLine = FailedOnLine
do  while TryLine > 1
TryLine = TryLine - 1
TheLine  = sourceline(TryLine)
ColonPos = pos(':', TheLine)
if  ColonPos <> 0 then
do
MaybeLabel = strip(left(TheLine, ColonPos-1))
if  symbol(MaybeLabel) <> 'BAD' then
do
FoundLabelOnLine = TryLine
return(MaybeLabel || ':  (line #' || AddCommasToDecimalNumber(TryLine) || ')')
end
end
end
FoundLabelOnLine = 0
return('')

TrapHeadingColonData:
if  arg(1) = '' then
TrapMiddle = '  '
else
TrapMiddle = ': '
call ToStderr left(arg(1), 16) || TrapMiddle || arg(2), '$S'
return

_CommonTrapHandler:
FailingLine     = arg(1)
TrapHeading     = 'BUG: ' || arg(2)
TextDescription = arg(3)
Text            = arg(4)
FailingLineText = AddCommasToDecimalNumber(FailingLine)
call ToStderr copies('=+', 39), '$+'
parse source . . SourceFileName
call ToStderr TrapHeading, '$S'
call ToStderr copies('~', length(TrapHeading)), '$S'
call TrapHeadingColonData TextDescription, Text
BettaOnRegina = condition('D')
if  BettaOnRegina <> '' & BettaOnRegina <> Text then
call TrapHeadingColonData '', BettaOnRegina
parse version TheRexVer
parse source  TheOpSys .
call TrapHeadingColonData "Environment", TheOpSys || ' using ' || TheRexVer
if pos('REGINA', translate(TheRexVer)) <> 0 then
do
call TrapHeadingColonData '', uname()
end
call TrapHeadingColonData "Failing Module", SourceFileName
call TrapHeadingColonData "Failing Line #", FailingLineText
InRoutine = _FindLastLabel(FailingLine)
StartAt   = (FailingLine - 5) + 1
if  FoundLabelOnLine <> 0 then
do
if  FoundLabelOnLine > StartAt then
StartAt = FoundLabelOnLine
else
do
if  FoundLabelOnLine <> 0 then
do
if  (FailingLine-FoundLabelOnLine) < 10 then
StartAt = FoundLabelOnLine
else
call TrapHeadingColonData "After label", InRoutine
end
end
end
if  StartAt < 1 then
StartAt = 1
call ToStderr '',       '$SH'
call ToStderr 'SOURCE', '$SH'
call ToStderr '~~~~~~', '$SH'
vlist.0 = 0
do  ShowLine = StartAt to FailingLine
FailingSrcLineTxt = strip(SourceLine(ShowLine))
call ToStderr left(AddCommasToDecimalNumber(ShowLine), length(FailingLineText)) || ' : ' || FailingSrcLineTxt, '$SC'
call DumpVarsInExpression FailingSrcLineTxt, 'vlist'
end
call DumpVarsInExpressionNow 'vlist', 'VARIABLE LIST', 'ToStderr'
call ToStderr copies('=+', 39), '$+'
call PgmExit FailingLine

_RexxTrapSyntaxError:
ReginaBug = SIGL
call _CommonTrapHandler ReginaBug, 'SYNTAX ERROR!', 'Reason', errortext(Rc)

_RexxTrapUninitializedVariable:
ReginaBug = SIGL
call _CommonTrapHandler ReginaBug, 'UNKNOWN VARIABLE!', 'Unknown Variable', condition('D')

RexxTrap_1:
signal on HALT    name RexxCtrlC
if translate(strip(arg(1))) = 'DEBUG' then
call DisplayCopyright
/*
* REXSYSTM.XH Version 00.019 By Dennis Bareis
*            http://www.labyrinth.net.au/~dbareis/index.htm (db0@anz.com)
*/
parse version RexVersionInfo
if pos('REGINA', translate(RexVersionInfo)) <> 0 then
do
RexWhich = 'REGINA'
parse value translate(RexVersionInfo) with . 'REGINA_' RexVerRegina ' '
RexVerRegina = translate(RexVerRegina, '.', '_')
end
else
do
RexVerRegina = ''
RexWhich = 'STANDARD_OS/2'
end
parse source RexSystemOpSys .
if RexSystemOpSys = "WIN32" then
do
parse value uname() with RexSystemOpSys .
if  RexSystemOpSys <> "WIN95" & RexSystemOpSys <> "WIN98" & RexSystemOpSys <> "WINNT" then
do
call CommandFailure 'Regina uname() returned "' || uname() || '" (expected WIN95, WIN98 or WINNT)'
end
end
RexSystmRexxPgmName = '?'; RexSystmRexxPgmName = RexGetFullSourceName()
if  arg(2) <> '' then
call CommandFailure 'ARG(2) contains unexpected data of ' || arg(2) || '.'
if translate(strip(arg(1))) = 'DEBUG' then
do
call RexDumpSystemInfo
exit(0)
end
if RexWhich = 'STANDARD_OS/2' then
do
call RxFuncAdd  'SysSleep',        'RexxUtil', 'SysSleep'
call RxFuncAdd  'SysFileDelete',   'RexxUtil', 'SysFileDelete'
call RxFuncAdd  'SysSearchPath',   'RexxUtil', 'SysSearchPath'
call RxFuncAdd  'SysFileTree',     'RexxUtil', 'SysFileTree'
call RxFuncAdd  'SysTempFileName', 'RexxUtil', 'SysTempFileName'
call SetLocal
RexEnvVarPool = 'OS2ENVIRONMENT'
RexStdoutStream = 'STDOUT'
RexStderrStream = 'STDERR'
RexTmpFileCntr = random(90000)
end
else
do
OPTIONS 'NOEXT_COMMANDS_AS_FUNCS'
numeric digits 11
RexEnvVarPool = 'SYSTEM'
RexStdoutStream = '<stdout>'
RexStderrStream = '<stderr>'
end
if RexSystemOpSys <> "UNIX" then
do
RexDirChar    = '\'
RexOptionChar = '/'
end
else
do
RexDirChar    = '/'
RexOptionChar = '-'
end
signal REXSYSTM_2

RexDumpSystemInfo: 
say 'Program Name  : ' || RexSystmRexxPgmName
say 'Op System     : ' || RexSystemOpSys
say 'Rexx Ver      : ' || RexVersionInfo
say 'Which System  : ' || RexWhich
if RexWhich = 'REGINA' then
say 'regina uname(): ' || uname()
return

RexNeedReginaWorkAround:
if  RexWhich = 'STANDARD_OS/2' then
return('N')
else
return('Y')

RexGetFullSourceName: 
parse source . . TmpRexxSrc
if RexWhich = 'REGINA' then
TmpRexxSrc = stream(strip(TmpRexxSrc), 'c', 'query exists')
if   TmpRexxSrc = '' then
call CommandFailure 'Could not determine the name of the rexx program!'
return(TmpRexxSrc)

RexQueryExists: 
if  arg(1) = '' then
return('')
else
return( stream(arg(1), 'c', 'query exists') )

RexGetNameOfTmpDir: 
TmpDir = strip(GetEnv('TMP'))
if  TmpDir = '' then
TmpDir = strip(GetEnv('TEMP'))
if  TmpDir = '' then
do
if RexSystemOpSys = "UNIX" then
TmpDir = '/tmp'
end
if  right(TmpDir, 1) == RexDirChar then
TmpDir = left(TmpDir, length(TmpDir)-1)
return(TmpDir)

RedirectStdOutAndErr2:
if  RexSystemOpSys = "DOS" | RexSystemOpSys = "WIN95" | RexSystemOpSys = "WIN98" then
do
return(' >' || arg(1))
end
else
do
return(' >' || arg(1) || ' 2>&1')
end

NameOfNulDevice:
if  RexSystemOpSys = "UNIX" then
return('/dev/null')
else
return('nul')

AllCmdOutput2Nul:
return( RedirectStdOutAndErr2(NameOfNulDevice()) )

AddressCmd: 
SysCmd2Exec = arg(1)
if  RexWhich = 'STANDARD_OS/2' then
SysCmd2Exec = '@' || SysCmd2Exec
SysCmd2Exec
SysCmdRc = Rc
Rc = SysCmdRc
return(SysCmdRc)

StderrLine: 
return( lineout(RexStderrStream, arg(1)) )

_filespec: 
fsCmd = translate( arg(1) )
select
when fsCmd = 'D' | fsCmd = 'DRIVE' then
do
if RexSystemOpSys = "UNIX" then
return('')
fsPos = pos(':', arg(2))
if  fsPos = 0 then
return('')
else
return( left(arg(2), fsPos) )
end
when fsCmd = 'P' | fsCmd = 'PATH' then
do
fsStartWith = substr(arg(2), length(_filespec('D', arg(2)))+1)
fsPos = lastpos(RexDirChar, fsStartWith)
if  fsPos = 0 then
return('')
else
return(left(fsStartWith, fsPos))
end
when fsCmd = 'N' | fsCmd = 'NAME' then
do
return( substr(arg(2), length(_filespec('L', arg(2)))+1) )
end
when fsCmd = 'L' | fsCmd = 'LOCATION' then
do
return( _filespec('D', arg(2)) || _filespec('P', arg(2)) )
end
when fsCmd = 'E' | fsCmd = 'EXTN' then
do
fsDotPos = lastpos('.', arg(2))
if fsDotPos = 0 then
return('')
else
return(substr(arg(2), fsDotPos+1))
end
when fsCmd = 'W' | fsCmd = 'WITHOUTEXTN' then
do
fsDotPos = lastpos('.', arg(2))
if fsDotPos = 0 then
return(arg(2))
else
return(left(arg(2), fsDotPos-1))
end
otherwise
call CommandFailure 'Unknown _filespec() command of "' || arg(1) || '"'
end
return

_SysFileDelete: 
if  RexWhich = 'STANDARD_OS/2' then
return( SysFileDelete(arg(1)) )
if RexSystemOpSys = "DOS" | RexSystemOpSys = "WIN95" | RexSystemOpSys = "WIN98" then
return( AddressCmd('if exist ' || arg(1) || ' del ' || arg(1) || AllCmdOutput2Nul()) )
else
do
if  RexSystemOpSys = "UNIX" then
return( AddressCmd('rm -f '  || arg(1) || AllCmdOutput2Nul()) )
else
return( AddressCmd('del '    || arg(1) || AllCmdOutput2Nul()) )
end

GetEnv: 
rsGetEnv = value(arg(1),, RexEnvVarPool)
if  rsGetEnv == '' & arg(2) = 'Y' then
call CommandFailure 'Could not find the environment variable "' || arg(1) || '"'
return(rsGetEnv)

REXSYSTM_2:
ThisProgramName = RexSystmRexxPgmName
ThisProgramDir  = _filespec('drive', ThisProgramName) || _filespec('path', ThisProgramName)
if RexSystemOpSys = "OS/2" then
call SetColorCodes
else
call RemoveColorCodes
/*
* REPLSTR.XH Version 99.134 By Dennis Bareis
*            http://www.labyrinth.net.au/~dbareis/index.htm (db0@anz.com)
*/
ReplaceCount = 0
signal EndREPLSTR

ReplaceString: 
parse arg rs?TheString, rs?ChangeFrom
rs?FoundPosn = pos(rs?ChangeFrom, rs?TheString)
if  rs?FoundPosn = 0 then
return(rs?TheString)
rs?ChangeTo = arg(3)
rs?ChangeFromLength = length(rs?ChangeFrom)
rs?LeftPart         = ''
do  until rs?FoundPosn = 0
rs?LeftPart      = rs?LeftPart || left(rs?TheString, rs?FoundPosn-1) || rs?ChangeTo
rs?TheString     = substr(rs?TheString, rs?FoundPosn+rs?ChangeFromLength)
ReplaceCount = ReplaceCount + 1
rs?FoundPosn = pos(rs?ChangeFrom, rs?TheString)
end
return(rs?LeftPart || rs?TheString)

EndREPLSTR:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/OPENCLOS.XHV   1.2   11 Jun 1998 18:48:10   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
signal EndOpenClosXh

ProcessCmdOpenFile:
OpenMode      = arg(1)
NameOfNewFile = RemoveAnyQuotesAroundFilename(arg(2))
CloseRc       = stream(NameOfNewFile, 'c', 'close')
call ProcessCmdCloseFile
if  OpenMode = "OPENNEW" then
do
if  CommandNeedsFileDeleted(NameOfNewFile) <> 0 then
return
end
if  OpenMode = "OPENREAD" then
OpenMode = 'open read'
else
OpenMode = 'open'
CurrentFile = NameOfNewFile
OpenRc      = stream(CurrentFile, 'c', OpenMode)
if  left(OpenRc, 6) = 'READY:' then
do
FileLength = stream(CurrentFile, 'c', 'seek <0')
SeekRc     = stream(CurrentFile, 'c', 'seek =1')
call UpdateDumpAddress 0
if  FileLength = '' then
call ProgressMsg 'File Opened'
else
call ProgressMsg 'File Opened, ' || AddCommasToDecimalNumber(FileLength-1) || ' byte(s) in file.'
end
else
do
CloseRc     = stream(CurrentFile, 'c', 'close')
FailFile    = CurrentFile
CurrentFile = ''
call CommandFailure 'Open of "' || FailFile || '" failed (' || OpenRc || ')'
end
return

ProcessCmdCloseFile:
if  CurrentFile <> '' then
do
if  Dying = 'N' then
call IoError CurrentFile
CloseRc     = stream(CurrentFile, 'c', 'close')
CurrentFile = ''
end
return

EndOpenClosXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/WRITE.XHV   1.2   02 Jun 1998 19:05:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
signal EndWriteXh

WriteToFile:
if  ExpectToHaveCurrentFile() = '!' then
return
ToWrite = InterpretCommand(arg(1))
if  ToWrite = "!@#$DB$FAILED%$#" then
return
call charout CurrentFile, ToWrite
call UpdateDumpAddress
call IoError CurrentFile
return

InterpretCommand:
ExecuteTheCommand = 'NewValue = ' || arg(1)
signal ON SYNTAX   name InvalidRexxCommand
signal ON NOVALUE  name InvalidRexxCommand
interpret ExecuteTheCommand
return(NewValue)

InterpretExactCommand:
signal ON SYNTAX   name InvalidRexxCommand
signal ON NOVALUE  name InvalidRexxCommand
interpret arg(1)
return("OK")

InvalidRexxCommand:
if  condition('C') = 'NOVALUE' then
call CommandFailure 'Incorrectly quoted string? (variable ' || condition('D') || ' is unknown)!'
else
call CommandFailure 'REXX Syntax error (' || errortext(Rc) || ')!'
if  Interactive = 'Y' then
return("!@#$DB$FAILED%$#")
else
PgmExit(ThisLineNumber())

EndWriteXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/VERIFY.XHV   1.1   02 Jun 1998 19:05:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
signal EndVerifyXh

VerifyBytesInFile:
if  ExpectToHaveCurrentFile() = '!' then
return
dStartAddress = GetCurrentSeekPositionInFile()
if  dStartAddress = '!' then
return
ToVerify = InterpretCommand(arg(1))
if  ToVerify = "!@#$DB$FAILED%$#" then
return
FromFile = charin(CurrentFile,, length(ToVerify))
Dummy = GotoSpecificSeekPositionInFile(dStartAddress)
CompareRc = compare(ToVerify, FromFile)
if  CompareRc <> 0 then
do
call DumpValue  dStartAddress-1, FromFile
call CommandFailure 'Verification Failed (difference starts at byte ' || CompareRc || ')'
end
call IoError CurrentFile
return

EndVerifyXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/VERIFYF.XHV   1.1   11 Jun 1998 18:48:16   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
signal EndVerifyfXh

VerifyFileContents:
if  MustNotHaveFileOpen() = '!' then
return
parse value arg(1) with '"'WhichFile'"' FileSize FileCrcInHex .
if  WhichFile = '' then
do
call CommandFailure 'Could not determine file name (it must be in double quotes)!'
return
end
if  stream(WhichFile, 'c', 'query exists') = '' then
do
call CommandFailure 'The file "' || WhichFile || '" does not exist!'
return
end
call ProgressMsg 'File exists'
if  FileSize = '' then
return
CloseRc    = stream(WhichFile, 'c', 'close')
RealLength = stream(WhichFile, 'c', 'query size')
call ProgressMsg 'File is ' || AddCommasToDecimalNumber(RealLength) || ' byte(s) long'
if  RealLength <> FileSize then
do
call CommandFailure 'The file "' || WhichFile || '" is ' || AddCommasToDecimalNumber(RealLength) || ' bytes long.  We expected ' || AddCommasToDecimalNumber(FileSize) || ' bytes!'
return
end
if  FileCrcInHex = '' then
return
FileCrcInHex = translate(FileCrcInHex)
if  length(FileCrcInHex) <> 8 then
do
call CommandFailure 'Expected a full 8 character hexadecimal CRC (got "' || FileCrcInHex || '")'
return
end
BytesToRead = FileSize
Crc32       = Crc32PrePostConditioning()
do  while BytesToRead > 0
FromFile    = charin(WhichFile,, 4096)
BytesToRead = BytesToRead - 4096
Crc32 = UpdateCrc32(Crc32, FromFile)
end
Crc32 = Crc32PrePostConditioning(Crc32)
Crc32 = Crc32InDisplayableForm(Crc32)
call ProgressMsg 'Calculated a CRC of ' || Crc32
IoRc    = IoError(WhichFile)
CloseRc = stream(WhichFile, 'c', 'close')
if  IoRc = 'Y' then
return
if  Crc32 <> FileCrcInHex then
do
call CommandFailure 'CRC of "' || Crc32 || '" does not match! We expected "' || FileCrcInHex || '"'
return
end
return

EndVerifyfXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/MOVETO.XHV   1.2   02 Jun 1998 19:05:02   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
signal EndMoveToXh

ProcessCmdMoveTo:
if  ExpectToHaveCurrentFile() = '!' then
return
parse value arg(1) with SeekCmd SeekParms
SeekCmd = translate(SeekCmd)
BeforeMoveTo = GetCurrentSeekPositionInFile()
if  BeforeMoveTo = '!' then
return
select
when SeekCmd = 'START' then
SeekParms = '=1'
when SeekCmd = 'END' then
SeekParms = '<0'
when SeekCmd = '+' | SeekCmd = 'FORWARDS' then
do
if  SeekParms = '' then
SeekParms = '1'
MoveToValue = GetInteger(SeekParms)
if  MoveToValue = '!' then
do
call CommandFailure 'Invalid value of "' || SeekParms || '" specified.'
return
end
SeekParms = '=' || BeforeMoveTo + MoveToValue
end
when SeekCmd = '-' | SeekCmd = 'BACKWARDS' then
do
if  SeekParms = '' then
SeekParms = '1'
MoveToValue = GetInteger(SeekParms)
if  MoveToValue = '!' then
do
call CommandFailure 'Invalid value of "' || SeekParms || '" specified.'
return
end
NewLocation = BeforeMoveTo - MoveToValue
if  NewLocation < 1 then
do
call CommandFailure "You can't move back " || SeekParms || ' from ' || GetDisplayableCurrentOffset() || '!'
return
end
SeekParms = '=' || NewLocation
end
otherwise
do
if  SeekCmd = '' then
do
call CommandFailure 'Invalid MoveTo command of "' || SeekCmd || '" specified.'
return
end
MoveToValue = GetInteger(SeekCmd)
if  MoveToValue = '!' then
do
call CommandFailure 'Invalid value of "' || SeekCmd || '" specified.'
return
end
MoveToValue = MoveToValue + 1
SeekParms = '=' || MoveToValue
end
end
CloseRc = stream(CurrentFile, 'c', 'close')
OpenRc = stream(CurrentFile, 'c', OpenMode)
if  left(OpenRc, 6) <> 'READY:' then
do
CurrentFile = ''
call CommandFailure "Can't reopen file!"
return
end
SeekRc = stream(CurrentFile, 'c', 'seek ' || SeekParms)
if  datatype(SeekRc, 'Whole Number') = 0 then
do
if  SeekRc <> '' then
SeekRc = ' (Reason=' || SeekRc || ')'
call CommandFailure 'Seek failed' || SeekRc
return
end
call IoError CurrentFile
call UpdateDumpAddress
return

EndMoveToXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/REBUILD.XHV   1.2   02 Jun 1998 19:05:02   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
signal EndRebuildXh

BIN2REXP_START:
return

BIN2REXP_ONEBIT:
if  pos(ColonColon, arg(1)) = 0 then
call lineout RebuildCmdFile, "WRITE   " || arg(1)
else
call lineout RebuildCmdFile, "WRITE   " || arg(1) || '    ;' || ";Warning Leave this!"
return

BIN2REXP_END:
call IoError RebuildCmdFile
CloseRc = stream(RebuildCmdFile, 'c', 'close')
return

ProcessCmdRebuild:
if  ExpectToHaveCurrentFile() = '!' then
return
RebuildCmdFile = RemoveAnyQuotesAroundFilename(arg(1))
if  CommandNeedsFileDeleted(RebuildCmdFile) <> 0 then
return
call lineout RebuildCmdFile, ';' || copies('-', 78)
call lineout RebuildCmdFile, '; Automatically Generated (' || date('Normal') || ' at ' || GetAmPmTime() || ' by BINTOOL version ' || PGM_VERSION || ')'
call lineout RebuildCmdFile, ';' || copies('-', 78)
call lineout RebuildCmdFile, ''
call lineout RebuildCmdFile, ';Source Details'
call lineout RebuildCmdFile, ';~~~~~~~~~~~~~~~'
call lineout RebuildCmdFile, ';Source File : ' || stream(CurrentFile, 'c', 'query exists')
call lineout RebuildCmdFile, ';Source Size : ' || AddCommasToDecimalNumber( stream(CurrentFile, 'c', 'query size') )
call lineout RebuildCmdFile, ';Source Time : ' || stream(CurrentFile, 'c', 'query datetime')
call lineout RebuildCmdFile, ';Start Offset: ' || GetDisplayableCurrentOffset()
call lineout RebuildCmdFile, ''
call lineout RebuildCmdFile, ''
call lineout RebuildCmdFile, "OpenNew " || CurrentFile
DumpWhat = charin(CurrentFile,, 99999999)
call BIN2REXP DumpWhat
call UpdateDumpAddress 0
call lineout RebuildCmdFile, "Close"
call IoError RebuildCmdFile
CloseRc = stream(RebuildCmdFile, 'c', 'close')
return

EndRebuildXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/DUMP.XHV   1.3   11 Jun 1998 18:48:10   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
DumpFrom = 0
call SetDumpCharToDefault
signal EndDumpXh

UpdateDumpAddress:
DumpFrom = arg(1)
if  DumpFrom = '' then
do
NewDumpFrom = GetCurrentSeekPositionInFile()
if  NewDumpFrom = '!' then
return
DumpFrom = NewDumpFrom - 1
end
return

SetDumpCharToDefault:
do Char = 0 to 31
DumpArray.Char = '.'
end
do Char = 32 to 126
DumpArray.Char = d2c(Char)
end
do Char = 127 to 255
DumpArray.Char = '.'
end
return

ProcessDumpChar:
NewSetFile = RemoveAnyQuotesAroundFilename(arg(1))
if  NewSetFile = '' then
do
call SetDumpCharToDefault
call ProgressMsg 'Restored default dump character set.'
return
end
DotPos = pos('.', _filespec('name', NewSetFile))
if  DotPos = 0 then
NewSetFile = NewSetFile || '.TBL'
FullName = stream(NewSetFile, 'c', 'query exists')
if  FullName = '' then
do
SlashPos = pos('\', NewSetFile)
if  SlashPos = 0 then
do
FullName = ThisProgramDir || NewSetFile
FullName = stream(FullName, 'c', 'query exists')
end
if  FullName = '' then
do
call CommandFailure 'The file "' || NewSetFile || '" does not exist.'
return
end
end
CloseRc  = stream(FullName, 'c', 'close')
FromFile = charin(FullName,, 9)
if  FromFile <> "DUMPCHAR|" then
do
CloseRc  = stream(FullName, 'c', 'close')
call CommandFailure 'The specified file does not have a valid header.'
return
end
FromFile = charin(FullName,, 9999)
IoRc    = IoError(FullName)
CloseRc = stream(FullName, 'c', 'close')
if  IoRc = 'Y' then
return
parse var FromFile Description'|'CharSet
if  length(CharSet) <> 256 then
do
call CommandFailure 'A dump character set must be 256 bytes long (not ' || AddCommasToDecimalNumber(length(CharSet)) || ')'
return
end
do  Char = 0 to 255
DumpArray.Char = substr(CharSet, Char+1, 1)
end
call ProgressMsg 'Dump character set updated (' || strip(Description) || ')'
return

ProcessCmdDump:
if  ExpectToHaveCurrentFile() = '!' then
return
StartAddress = GetCurrentSeekPositionInFile()
if  StartAddress = '!' then
return
if  arg(1) = '' then
DumpLength = 16 * 6
else
do
DumpLength = GetInteger(arg(1))
if  DumpLength = '!' then
do
call CommandFailure 'Invalid value of "' || arg(1) || '" specified.'
return
end
end
SeekRc = GotoSpecificSeekPositionInFile(DumpFrom+1)
if  SeekRc = '!' then
return
DumpWhat = charin(CurrentFile,, DumpLength)
if  IoError(CurrentFile) = 'Y' then
return
call DumpValue  DumpFrom, DumpWhat
DumpFrom = DumpFrom + DumpLength
Dummy = GotoSpecificSeekPositionInFile(StartAddress)
return

_ShowDebugLine:
sdLine = dvAddressBit || left(dvHexStr, 41) || '  | ' || dvAsciiStr || ' |'
say sdLine
if  RecordFile <> '' then
call RecordLine ';' || Indent || sdLine
return

DumpValue:
dvAddress  = arg(1)
dvValue    = arg(2)
dvValueLng = length(dvValue)
dvMaxAddress = dvAddress + dvValueLng
if  InHexMode = 'N' then
dvAddressWidth = length(dvMaxAddress)
else
dvAddressWidth = length(d2x(dvMaxAddress))
dvAsciiStr   = ""
dvHexStr     = ""
dvWantSpace  = 'Y'
dvAddressBit = ''
do dvCharPosn = 1 to dvValueLng
if dvCharPosn // 16 = 1 then
do
if  dvAsciiStr \== "" then
do
call _ShowDebugLine
dvAsciiStr  = ""
dvHexStr    = ""
dvWantSpace = 'Y'
end
if  InHexMode = 'N' then
dvThisAddress = dvAddress
else
dvThisAddress = d2x(dvAddress)
dvAddressBit = right(dvThisAddress, dvAddressWidth) || ':'
dvAddress = dvAddress + 16
end
dvCharacter  = substr(dvValue, dvCharPosn, 1)
CharHexValue = c2x(dvCharacter)
if  dvWantSpace = 'Y' then
do
dvHexStr    = dvHexStr || ' ' || CharHexValue
dvWantSpace = 'N'
end
else
do
dvHexStr    = dvHexStr || CharHexValue
dvWantSpace = 'Y'
end
CharValue    = c2d(dvCharacter)
dvAsciiStr     = dvAsciiStr || DumpArray.CharValue
end
if  dvAsciiStr \== "" then
call _ShowDebugLine
return

EndDumpXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/RECORD.XHV   1.1   11 Jun 1998 18:48:12   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
RecordFile  = ''
signal EndRecordfXh

RecordLine:
if  RecordFile <> '' then
do
call lineout RecordFile, arg(1)
IoRc = IoError(RecordFile)
end
return

CloseRecordFile:
if  RecordFile <> '' then
do
CloseRc = stream(RecordFile, 'c', 'close')
RecordFile = ''
end
return

ProcessRecordCommand:
if  OnlyAllowedInInteractiveMode() = '!' then
return
NewRecordFile = RemoveAnyQuotesAroundFilename(arg(1))
if  NewRecordFile = '' then
do
if  RecordFile = '' then
call ProgressMsg 'Recording was already off!'
else
call ProgressMsg 'Recording now turned off!'
call CloseRecordFile
end
else
do
call CloseRecordFile
call CommandNeedsFileDeleted NewRecordFile
RecordFile = NewRecordFile
call RecordLine ';' || copies('-', 78)
call RecordLine '; Automatically Generated (' || date('Normal') || ' at ' || GetAmPmTime() || ' by BINTOOL version ' || PGM_VERSION || ')'
call RecordLine ';' || copies('-', 78)
call RecordLine ''
end
return

EndRecordfXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/FIND.XHV   1.0   11 Jun 1998 18:48:10   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
signal EndFindXh

ProcessFindCommand:
if  ExpectToHaveCurrentFile() = '!' then
return
ToFind          = arg(1)
CaseInsensitive = arg(2)
FindRestoreToRel1 = GetCurrentSeekPositionInFile()
if  FindRestoreToRel1 = '!' then
return
ToFind = InterpretCommand(arg(1))
if  ToFind = "!@#$DB$FAILED%$#" then
return
if  CaseInsensitive = 'N' then
call ProgressMsg 'Case sensitive search.'
else
do
if  verify(ToFind, AllLetters, 'M') <> 0 then
call ProgressMsg 'Case insensitive search.'
else
do
call ProgressMsg 'Case insensitive search requested (doing faster sensitive search).'
CaseInsensitive = 'N'
end
end
ToFindLng = length(ToFind)
call ProgressMsg 'Looking for ' || ToFindLng || ' bytes starting from current location.'
if  CaseInsensitive = 'Y' then
ToFind = translate(ToFind)
StartingAddressRel1 = FindRestoreToRel1
SearchIn            = ''
Found               = 'N'
do  while chars(CurrentFile) <> 0
if  CaseInsensitive = 'Y' then
FromFile = translate( charin(CurrentFile,, 40960) )
else
FromFile = charin(CurrentFile,, 40960)
FromFileLng = length(FromFile)
SearchIn    = SearchIn || FromFile
FoundPos = pos(ToFind, SearchIn)
if  FoundPos <> 0 then
do
FindRestoreToRel1 = StartingAddressRel1 + (FoundPos - 1)
call UpdateDumpAddress FindRestoreToRel1-1
call ProgressMsg 'Found match at ' || ConvertDecimalToCurrentBase(FindRestoreToRel1-1)
Found = 'Y'
leave
end
DropLeftNum         = length(SearchIn) - ToFindLng
SearchIn            = right(SearchIn, ToFindLng)
StartingAddressRel1 = StartingAddressRel1 + DropLeftNum
end
Dummy = GotoSpecificSeekPositionInFile(FindRestoreToRel1)
if  Found = 'N' then
do
call CommandFailure 'The search string was not found!'
return
end
call IoError CurrentFile
return

EndFindXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/LOCATE.XHV   1.0   11 Jun 1998 18:48:10   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
signal EndLocateXh

ProcessLocateCommand:
if  ExpectToHaveCurrentFile() = '!' then
return
ToLocate   = arg(1)
VerifyType = arg(2)
LocateRestoreToRel1 = GetCurrentSeekPositionInFile()
if  LocateRestoreToRel1 = '!' then
return
ToLocate = InterpretCommand(arg(1))
if  ToLocate = "!@#$DB$FAILED%$#" then
return
if  VerifyType = 'M' then
call ProgressMsg 'Locating first byte that is in the supplied list.'
else
call ProgressMsg 'Locating first byte that is NOT in the supplied list.'
StartingAddressRel1 = LocateRestoreToRel1
Found               = 'N'
do  while chars(CurrentFile) <> 0
FromFile    = charin(CurrentFile,, 40960)
FromFileLng = length(FromFile)
FoundPos = verify(FromFile, ToLocate, VerifyType)
if  FoundPos <> 0 then
do
LocateRestoreToRel1 = StartingAddressRel1 + (FoundPos - 1)
call UpdateDumpAddress LocateRestoreToRel1-1
call ProgressMsg 'Found match at ' || ConvertDecimalToCurrentBase(LocateRestoreToRel1-1)
Found = 'Y'
leave
end
StartingAddressRel1 = StartingAddressRel1 + FromFileLng
end
Dummy = GotoSpecificSeekPositionInFile(LocateRestoreToRel1)
if  Found = 'N' then
do
call CommandFailure 'The locate failed to find what you were after!'
return
end
call IoError CurrentFile
return

EndLocateXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/LABELS.XHV   1.0   11 Jun 1998 18:48:10   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
LabelsToLine = 0
signal EndLabelsXh

SaveLabel:
if  CurrentLineNumber <= LabelsToLine then
return
LabelsToLine = CurrentLineNumber
if  symbol("LabelCL." || arg(1)) = 'VAR' then
do
call CommandFailure 'Label "' || arg(1) || '" has been reused on line ' || CurrentLineNumber
return
end
interpret "LabelCL." || arg(1) || '= CurrentLineNumber'
slSeekAddress = stream(ScriptFile, 'c', 'seek')
if  datatype(slSeekAddress, 'Whole Number') = 0 then
do
call CommandFailure "Can't determine current seek address of the script" || ' "' || ScriptFile || '"'
return
end
interpret "LabelSP." || arg(1) || '= slSeekAddress'
return

GotoLabel:
glLabelName = translate( strip(arg(1)) )
glLineNumSym = "LabelCL." || glLabelName
if  symbol(glLineNumSym) = 'VAR' then
do
interpret 'CurrentLineNumber = '         || glLineNumSym
interpret 'SeekTo            = LabelSP.' || glLabelName
SeekRc = stream(ScriptFile, 'c', 'seek =' || SeekTo)
if  datatype(SeekRc, 'Whole Number') = 0 then
do
if  SeekRc <> '' then
SeekRc = ' (Reason=' || SeekRc || ')'
call CommandFailure 'Seek to label "' || glLabelName || '" failed' || SeekRc
return('!')
end
return('')
end
else
do
StartedLookingAtLine  = CurrentLineNumber
do  while lines(ScriptFile) <> 0
CurrentLine       = HandleWhitespaceInCommand( linein(ScriptFile) )
CurrentLineNumber = CurrentLineNumber + 1
if  left(CurrentLine, 1) = ':' then
do
ThisLabel = translate( substr(CurrentLine, 2) )
call SaveLabel ThisLabel
if  ThisLabel = glLabelName then
return('')
end
end
call IoError ScriptFile
CloseRc = stream(ScriptFile, 'c', 'close')
CurrentLineNumber = StartedLookingAtLine
call CommandFailure 'The label "' || glLabelName || '" could not be located.'
return('!')
end

EndLabelsXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/USEFUL.XHV   1.2   11 Jun 1998 18:48:16   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
signal EndUsefulXh

B2C:

Binary:
return( x2c(b2x(arg(1))) )

EOL:
return('0D0A'x)

CurrentOffset:
if  ExpectToHaveCurrentFile() = '!' then
return('!')
coOffset = GetCurrentSeekPositionInFile()
if  coOffset <> '!' then
coOffset = coOffset - 1
return(coOffset)

AddCommasToDecimalNumber: procedure
NoComma = strip( arg(1) )
if  pos(',', NoComma) <> 0 then
return(NoComma)
DotPos = pos('.', NoComma)
if  DotPos = 0 then
AfterDecimal = ''
else
do
if  DotPos = 1 then
return("0" || NoComma)
AfterDecimal = substr(NoComma, DotPos+1)
NoComma      = left(NoComma, DotPos-1)
end
NoComma = reverse(NoComma)
ResultWithCommas = ""
do  while length(NoComma) > 3
ResultWithCommas = ResultWithCommas || left(NoComma, 3) || ','
NoComma          = substr(NoComma, 4)
end
ResultWithCommas = ResultWithCommas || NoComma
ResultWithCommas = reverse(ResultWithCommas)
if  AfterDecimal <> '' then
ResultWithCommas = ResultWithCommas || '.' || AfterDecimal
return(ResultWithCommas)

EndUsefulXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/OPTIONS.XHV   1.0   11 Jun 1998 18:48:10   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
signal EndOptionsXh

SwitchMustNotHaveOptions:
TheCmd     = arg(1)
TheOptions = arg(2)
Value2Set  = arg(3)
if  TheOptions <> '' then
UserSyntaxError('No parameters are expected for the "' || TheCmd || '" command!')
return(Value2Set)

SwitchOptionsValidateAgainstList:
TheCmd    = arg(1)
TheOption = translate(arg(2))
ValidList = ',' || translate(arg(3)) || ','
if  pos(',' || TheOption || ',', ValidList) <> 0 then
return(TheOption)
UserSyntaxError('An invalid parameter of "' || TheOption || '" was specified on the "' || TheCmd || '" command!')

SwitchWantsYesOrNo:
TheCmd    = arg(1)
TheOption = translate(arg(2))
Default   = arg(3)
if  TheOption = '' then
return(Default)
else
return( left(SwitchOptionsValidateAgainstList(TheCmd, TheOption, "Y,N,YES,NO"), 1) )

NotAvailableUnderNtYet:
TheCmd = arg(1)
if  RexWhich = 'REGINA' then
UserSyntaxError('"' || TheCmd || '" can not be performed under NT (or regina).... Yet...')
return

EndOptionsXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/REXXHDR/GETRESP.XHV   1.1   01 Jun 1998 17:57:56   Dennis_Bareis  $
*/
GetRespVer = "98.152"
call RxFuncAdd  'SysCurPos', 'RexxUtil', 'SysCurPos'
call RxFuncAdd  'SysGetKey', 'RexxUtil', 'SysGetKey'
CursorTAvailable  = 'Y'
trace off
CurrentCursorMode = -1
signal SkipOver_GETRESP

GetKeyFromUser:
if  CursorTAvailable = 'Y' then
do
WantedCursorMode = !CmdLine.History.insert
if  WantedCursorMode <> CurrentCursorMode then
do
if  WantedCursorMode = "0" then
CursorSize = "0 15"
else
CursorSize = "13 15"
address cmd '@CursorT.EXE ' || CursorSize || ' >nul 2>&1'
if  Rc = 0 then
CurrentCursorMode = WantedCursorMode
else
CursorTAvailable = 'N'
end
end
return( SysGetKey("NoEcho") )

GetRespErrorBeep:
call beep 400, 50
return

CmdLineProcedure: procedure expose !history. CurrentCursorMode

CmdLine:
CmdLine.Hidden=0
CmdLine.History=1
CmdLine.Keep=1
CmdLine.SameLine=0
CmdLine.Required=0
CmdLine.Reset=0
CmdLine.Valid=xrange()
CmdLine.Upper=0
CmdLine.Lower=0
CmdLine.Width=0
CmdLine.AutoSkip=0
/* DB$ */ EscapeCancels = 0; InitialValue = ""
parse value SysCurPos() with x y
do i=1 to arg()
cmd=translate(left(arg(i),1))
parm=""
if pos("=",arg(i))\=0 then
parse value arg(i) with ."="parm
select
when arg(i)="~Esc~" then
EscapeCancels=1
when cmd="B" then
do
parse value SysCurPos() with x y
if parm="" then
do
i = i + 1
parm=arg(i)
end
InitialValue = parm
end
when cmd="X" then
do
parse value SysCurPos() with x y
if parm="" then
do;i=i+1;parm=arg(i);end
if datatype(parm,"W") then
Call SysCurPos parm,y
end
when cmd="Y" then
do
parse value SysCurPos() with x y
if parm="" then
do;i=i+1;parm=arg(i);end
if datatype(parm,"W") then
Call SysCurPos x,parm
end
when cmd="T" then
do
if parm="" then
do;i=i+1;parm=arg(i);end
call charout, parm
end
when cmd="H" then
do
CmdLine.Hidden=1
CmdLine.Keep=0
CmdLine.History=0
end
when cmd="C" then
CmdLine.Reset=1
when cmd="O" then
!CmdLine.History.insert = 0
when cmd="I" then
!CmdLine.History.insert = 1
when cmd="F" then
CmdLine.Keep=0
when cmd="S" then
CmdLine.SameLine=1
when cmd="R" then
CmdLine.Required=1
when cmd="V" then
do
if parm="" then
do;i=i+1;parm=arg(i);end
CmdLine.Valid=parm
CmdLine.History=0
CmdLine.Keep=0
end
when cmd="U" then
do; CmdLine.Upper=1; CmdLine.Lower=0; CmdLine.History=0; CmdLine.Keep=0; end
when cmd="L" then
do; CmdLine.Upper=0; CmdLine.Lower=1; CmdLine.History=0; CmdLine.Keep=0; end
when cmd="A" then
CmdLine.AutoSkip=1
when cmd="W" then
do
if parm="" then
do;i=i+1;parm=arg(i);end
CmdLine.Width=parm
if \datatype(CmdLine.Width,"Whole") then CmdLine.Width=0
if CmdLine.Width<0 then CmdLine.Width=0
CmdLine.History=0
CmdLine.Keep=0
end
otherwise nop
end
end
if CmdLine.Width=0 then CmdLine.AutoSkip=0
if CmdLine.Reset then
do
drop !CmdLine.History.
return ""
end
if symbol("!CmdLine.History.0")="LIT" then
!CmdLine.History.0=0
if symbol("!CmdLine.History.insert")="LIT" then
!CmdLine.History.insert = 1
word = InitialValue
if word <> "" then
call charout, word
pos = length(word)
historical=-1
TheKey = GetKeyFromUser()
do forever
if TheKey=d2c(13) then
if CmdLine.Required & word="" then
call GetRespErrorBeep
else
leave
else if (TheKey=d2c(8)) then
do
if  pos = 0 then
call GetRespErrorBeep
else
do
word=delstr(word,pos,1)
call rubout 1
pos=pos-1
if pos<length(word) then
do
if  \CmdLine.Hidden then
call charout, substr(word,pos+1)||" "
else
call charout, copies("*",length(substr(word,pos+1)))||" "
call charout, copies(d2c(8),length(word)-pos+1)
end
end
end
else if TheKey=d2c(27) then
do
if   EscapeCancels then
do
if  word == '' then
do
word="~Esc~"
pos=0
leave
end
end
historical=-1
if pos<length(word) then
do
if \CmdLine.Hidden then
call charout, substr(word,pos+1)
else
call charout, copies("*",length(substr(word,pos+1)))
end
call rubout length(word)
word=""
pos=0
/*
*if pos<length(word) then
*    if \CmdLine.Hidden then call charout, substr(word,pos+1)
*    else call charout, copies("*",length(substr(word,pos+1)))
* call rubout length(word)
* word=""
* pos=0
*/
end
else if TheKey=d2c(10) | TheKey=d2c(9) then
nop
else if TheKey=d2c(224) | TheKey=d2c(0) then
do
key2 = GetKeyFromUser()
select
when key2=d2c(59) then
if (CmdLine.History) & (!CmdLine.History.0<>0) then
do
if  symbol('search')='LIT' then
search=word
if  symbol('LastFind')='LIT' then
search=word
else
do
if  LastFind\=word then
search=word
end
if  historical=-1 then
start=!CmdLine.History.0
else
start=historical-1
if  start=0 then
start=!CmdLine.History.0
found=0
do i=start to 1 by -1
if abbrev(!CmdLine.History.i,search) then
do
found=1
historical=i
LastFind=!CmdLine.History.i
leave
end
end
if found then
do
if pos<length(word) then
do
if  \CmdLine.Hidden then
call charout, substr(word,pos+1)
else
call charout, copies("*",length(substr(word,pos+1)))
end
call rubout length(word)
word=!CmdLine.History.historical
pos=length(word)
if   \CmdLine.Hidden then
call charout, word
else
call charout, copies("*",length(word))
end
end
when key2=d2c(72) then
if (CmdLine.History) & (!CmdLine.History.0<>0) then
do
if historical=-1 then
historical=!CmdLine.History.0
else historical=historical-1
if historical=0 then
historical=!CmdLine.History.0
if pos<length(word) then
if \CmdLine.Hidden then call charout, substr(word,pos+1)
else call charout, copies("*",length(substr(word,pos+1)))
call rubout length(word)
word=!CmdLine.History.historical
pos=length(word)
if \CmdLine.Hidden then call charout, word
else call charout, copies("*",length(word))
end
when key2=d2c(80) then
if (CmdLine.History) & (!CmdLine.History.0<>0) then
do
if historical=-1 then
historical=1
else historical=historical+1
if historical>!CmdLine.History.0 then
historical=1
if pos<length(word) then
if \CmdLine.Hidden then call charout, substr(word,pos+1)
else call charout, copies("*",length(substr(word,pos+1)))
call rubout length(word)
word=!CmdLine.History.historical
pos=length(word)
if \CmdLine.Hidden then call charout, word
else call charout, copies("*",length(word))
end
when key2=d2c(75) then
if pos>0 then
do
call Charout, d2c(8)
pos=pos-1
end
when key2=d2c(77) then
if pos<length(word) then
do
if \CmdLine.Hidden then call Charout, substr(word,pos+1,1)
else call charout, "*"
pos=pos+1
end
when key2=d2c(115) then
if pos>0 then
do
call charout, d2c(8)
pos=pos-1
do forever
if pos=0 then leave
if substr(word,pos+1,1)\==" " & substr(word,pos,1)==" " then
leave
else
do
call charout, d2c(8)
pos=pos-1
end
end
end
when key2=d2c(116) then
if pos<length(word) then
do
if \CmdLine.Hidden then call Charout, substr(word,pos+1,1)
else call charout, "*"
pos=pos+1
do forever
if pos=length(word) then
leave
if substr(word,pos,1)==" " & substr(word,pos+1,1)\==" " then
leave
else
do
if \CmdLine.Hidden then call Charout, substr(word,pos+1,1)
else call charout, "*"
pos=pos+1
end
end
end
when key2=d2c(83) then
if pos<length(word) then
do
word=delstr(word,pos+1,1)
if \CmdLine.Hidden then call Charout, substr(word,pos+1)||" "
else call Charout, copies("*",length(substr(word,pos+1)))||" "
call charout, copies(d2c(8),length(word)-pos+1)
end
when key2=d2c(82) then
!CmdLine.History.insert = \!CmdLine.History.insert
when key2=d2c(79) then
if pos<length(word) then
do
if \CmdLine.Hidden then call Charout, substr(word,pos+1)
else call Charout, copies("*",length(substr(word,pos+1)))
pos=length(word)
end
when key2=d2c(71) then
if pos\=0 then
do
call Charout, copies(d2c(8),pos)
pos=0
end
when key2=d2c(117) then
if pos<length(word) then
do
call Charout, copies(" ",length(word)-pos)
call Charout, copies(d2c(8),length(word)-pos)
word=left(word,pos)
end
when key2=d2c(119) then
if pos>0 then
do
if pos<length(word) then
if \CmdLine.Hidden then call charout, substr(word,pos+1)
else call charout, copies("*",length(substr(word,pos+1)))
call rubout length(word)
word=substr(word,pos+1)
if \CmdLine.Hidden then call Charout, word
else call Charout, copies("*",length(word))
call Charout, copies(d2c(8),length(word))
pos=0
end
otherwise
if CmdLine.History & symbol('!CmdLine.History.key.'||c2d(key2))\='LIT' then
do
if pos<length(word) then
if \CmdLine.Hidden then call charout, substr(word,pos+1)
else call charout, copies("*",length(substr(word,pos+1)))
call rubout length(word)
i=c2d(key2)
word=!CmdLine.History.key.i
pos=length(word)
if \CmdLine.Hidden then call charout, word
else call charout, copies("*",length(word))
end
end
end
else
if CmdLine.Width=0 | (length(word)<CmdLine.Width | (pos<CmdLine.Width & !CmdLine.History.insert = 0)) then
do
if CmdLine.Upper then TheKey=translate(TheKey)
if CmdLine.Lower then TheKey=translate(TheKey,"abcdefghijklmnopqrstuvwxyz","ABCDEFGHIJKLMNOPQRSTUVWXYZ")
if pos(TheKey,CmdLine.Valid)\=0 then
do
if \CmdLine.Hidden then
call Charout, TheKey
else
call charout, "*"
if !CmdLine.History.insert then
word=insert(TheKey,word,pos)
else
word=overlay(TheKey,word,pos+1)
pos=pos+1
if pos<length(word) then
do
if \CmdLine.Hidden then
call Charout, substr(word,pos+1)
else
call Charout, copies("*", length(substr(word,pos+1)))
call Charout, copies(d2c(8),length(word)-pos)
end
end
else
call GetRespErrorBeep
end
else
call GetRespErrorBeep
if CmdLine.AutoSkip & length(word)=CmdLine.Width then leave
TheKey = GetKeyFromUser()
end
if \CmdLine.SameLine then say
if (CmdLine.Keep) & (word\=="") then
do
historical=!CmdLine.History.0
if word\=!CmdLine.History.historical then
do
!CmdLine.History.0=!CmdLine.History.0+1
historical=!CmdLine.History.0
!CmdLine.History.historical=word
end
end
return word

rubout: procedure
arg n
do i=1 to n
call Charout, d2c(8)||" "||d2c(8)
end
return

SkipOver_GETRESP:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/VERIFY.XHV   1.1   02 Jun 1998 19:05:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
StartsReplacement = '<' || '@'
EndsReplacement   = '>'
signal EndRexxVarXh

ReplaceRexxVariables:
RightBit      = arg(1)
ChangeVarName = arg(2)
LeftBit     = ''
ChangesMade = 'N'
VarPos      = pos(StartsReplacement, RightBit)
do while VarPos <> 0
LeftBit  = LeftBit || left(RightBit, VarPos-1)
RightBit = substr(RightBit, VarPos+2)
RightBitT    = translate(RightBit, ' ', EndsReplacement)
VariableName = word(RightBitT, 1)
RightBit     = strip( substr(RightBit, length(VariableName)+1) )
if  symbol(VariableName) <> 'VAR' then
call CommandFailure 'The rexx variable "' || VariableName || '" has not been set!'
else
VariableCont = value(VariableName)
RightBit = substr(RightBit ,2)
LeftBit     = LeftBit || VariableCont
ChangesMade = 'Y'
VarPos = pos(StartsReplacement, RightBit)
end
TheString = LeftBit || RightBit
if  ChangeVarName <> '' then
call value ChangeVarName, ChangesMade
return(TheString)

EndRexxVarXh:
/*
* $Header:   E:/DB/PVCS.IT/OS2/BINTOOL/SUNDRY.XHV   1.5   11 Jun 1998 18:48:16   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.4   07 Nov 1997 15:40:04   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.3   07 Nov 1997 15:18:38   Dennis_Bareis  $/htmlpp/HtmlPP.cmv   1.2   07 Nov 1997 10:57:22   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.5   11 Oct 1996 16:40:40   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.4   11 Oct 1996 16:26:28   Dennis_Bareis  $/PLATFORM/PLATFRM.X_V   1.3   17 Sep 1996 10:51:38   Dennis_Bareis  $
*/
signal EndSundryXh

GetCurrentSeekPositionInFile:
gcsSeekAddress = stream(CurrentFile, 'c', 'seek')
if  datatype(gcsSeekAddress, 'Whole Number') = 0 then
do
call CommandFailure "Can't determine current seek address"
return('!')
end
return(gcsSeekAddress)

GotoSpecificSeekPositionInFile:
SeekRc = stream(CurrentFile, 'c', 'seek =' || arg(1))
if  datatype(SeekRc, 'Whole Number') = 0 then
do
if  SeekRc <> '' then
SeekRc = ' (Reason=' || SeekRc || ')'
call CommandFailure 'Seek to ' || arg(1) || ' failed' || SeekRc
return('!')
end
return(SeekRc)

GetInteger:
giString = strip( arg(1) )
select
when left(giString, 1) = '$' then
do
giHex    = 'N'
giString = substr(giString, 2)
end
when translate(left(giString, 1)) = 'X' then
do
giHex    = 'Y'
giString = substr(giString, 2)
end
otherwise
giHex = InHexMode
end
if  giHex = 'Y' then
do
if  datatype(giString, 'X') = 0 then
return('!')
return( x2d(giString) )
end
else
do
if  datatype(giString, 'W') = 0 then
return('!')
return( giString )
end

RemoveAnyQuotesAroundFilename:
rqaFileName = arg(1)
rqaLq = left(rqaFileName, 1)
if  rqaLq <> '"' & rqaLq <> "'" then
return(rqaFileName)
else
do
rqaRq = right(rqaFileName, 1)
if  rqaLq <> rqaRq then
return(rqaFileName)
else
return( substr(rqaFileName, 2, length(rqaFileName)-2) )
end

ExpectToHaveCurrentFile:
if  CurrentFile <> '' then
return('')
else
do
call CommandFailure 'There is no file open!'
return('!')
end

OnlyAllowedInInteractiveMode:
if  Interactive = 'Y' then
return('')
else
do
call CommandFailure 'This command can only be used in interactive mode!'
return('!')
end

NotAllowedInInteractiveMode:
if  Interactive = 'N' then
return('')
else
do
call CommandFailure 'This command is not allowed in interactive mode!'
return('!')
end

MustNotHaveFileOpen:
if  CurrentFile = '' then
return('')
else
do
call CommandFailure 'You should not have a file open when executing this command!'
return('!')
end

CommandNeedsFileDeleted:
CloseRc = stream(arg(1), 'c', 'close')
if  stream(arg(1), 'c', 'query exists') <> '' then
do
DosDelRc   = _SysFileDelete(arg(1))
if  stream(arg(1), 'c', 'query exists') <> '' then
do
call CommandFailure 'Could not delete "' || arg(1) || '" (DosRc=' || DosDelRc || ')'
return(ThisLineNumber())
end
end
return(0)

ConvertDecimalToCurrentBase:
cdDecimal   = arg(1)
cdMinDigits = arg(2)
if  InHexMode = 'N' then
do
cdReturn = cdDecimal
cdSymbol = '$'
if  cdMinDigits = '' then
cdMinDigits = 1
end
else
do
cdReturn = d2x(cdDecimal)
cdSymbol = 'x'
if  cdMinDigits = '' then
cdMinDigits = 4
end
if  length(cdReturn) < cdMinDigits then
cdReturn = right(cdReturn, cdMinDigits, '0')
return(cdSymbol || cdReturn)

GetDisplayableCurrentOffset:
if  CurrentFile = '' then
dcoAddress = '?'
else
do
dcoAddress = stream(CurrentFile, 'c', 'seek')
if  datatype(dcoAddress, 'Whole Number') = 0 then
dcoAddress = '??'
else
do
dcoAddress = ConvertDecimalToCurrentBase(dcoAddress - 1)
end
end
if  arg(1) <> '' then
do
if  length(dcoAddress) < arg(1) then
dcoAddress = left(dcoAddress, arg(1), ' ')
end
return(dcoAddress)

GetAmPmTime:  procedure
CivilTime  = time('C');  if length(CivilTime)  = 6 then CivilTime=' 'CivilTime
TheTime    = time();     NumSeconds = ':'substr(TheTime, 7, 2)
return( insert(NumSeconds, CivilTime, 5) )

RexxCtrlC:
LineCtrlC = SIGL
call ToStderr ''
call ToStderr ColorError || copies('=+', 39)
call ToStderr "Come on, you pressed Ctrl+C or Break didn't you!"
call ToStderr copies('=+', 39) || Reset
PgmExit(LineCtrlC)

UserSyntaxError:
call ToStderr ColorError || "SYNTAX ERROR"
call ToStderr "~~~~~~~~~~~~"
call ToStderr '    ' || arg(1)
call ToStderr ''
call ToStderr 'CORRECT SYNTAX'
call ToStderr '~~~~~~~~~~~~~~'
call ToStderr '    BINTOOL[.CMD] ScriptFile   OR'
call ToStderr '    BINTOOL[.CMD] ?'
call ToStderr ''
call ToStderr ''
call ToStderr 'If "?" is used the program works interactively.  If you use the "RECORD"'
call ToStderr 'command you can keep a record of the commands you use so you can replay them.'
call ToStderr TwoBeep || Reset
PgmExit(ThisLineNumber())

ThisLineNumber:
return(SIGL)

IoError:
FileState = stream(arg(1), 'State')
if  FileState = 'READY' then
return('N')
IoReason = stream(arg(1), 'Description')
if  IoReason == 'NOTREADY:EOF' then
return('N')
call CommandFailure 'I/O failure on "' || arg(1) || '" (' || IoReason || ').'
return('Y')

ProgressMsg:
IntMsg = arg(1)
if  OptionSeeProgress = 'Y' then
do
IntMsgColor = arg(2)
if  IntMsgColor = '' then
IntMsgColor = ColorProgress
say IntMsgColor || Indent || IntMsg || Reset
end
call RecordLine ';' || Indent || IntMsg
return

CommandFailure:
CallersLine = SIGL
if  Interactive = 'Y' then
do
call ProgressMsg arg(1), ColorError
return
end
FailHeader  = "Failure on line " || CurrentLineNumber
if  OnError <> '' then
do
call ProgressMsg FailHeader
call ProgressMsg copies('~', length(FailHeader))
call ProgressMsg arg(1)
ErrorHandler = OnError
OnError      = ''
if  GotoLabel(ErrorHandler) <> '!' then
return
end
else
do
call ToStderr ColorError || FailHeader
call ToStderr copies('~', length(FailHeader))
call ToStderr arg(1) || Reset
PgmExit(CallersLine)
end

ToStderr:
call StderrLine arg(1)
call RecordLine ';' || arg(1)
return

DisplayLine:
call charout, arg(1)
say arg(2)
call charout, Reset
return

EndSundryXh:
/*
* CRC32REX.XH Version 98.153 by Dennis Bareis
*            http://www.labyrinth.net.au/~dbareis/index.htm (db0@anz.com)
*/
_Crc32.0  = '00000000'x
_Crc32.1  = '77073096'x
_Crc32.2  = 'EE0E612C'x
_Crc32.3  = '990951BA'x
_Crc32.4  = '076DC419'x
_Crc32.5  = '706AF48F'x
_Crc32.6  = 'E963A535'x
_Crc32.7  = '9E6495A3'x
_Crc32.8  = '0EDB8832'x
_Crc32.9  = '79DCB8A4'x
_Crc32.10 = 'E0D5E91E'x
_Crc32.11 = '97D2D988'x
_Crc32.12 = '09B64C2B'x
_Crc32.13 = '7EB17CBD'x
_Crc32.14 = 'E7B82D07'x
_Crc32.15 = '90BF1D91'x
_Crc32.16 = '1DB71064'x
_Crc32.17 = '6AB020F2'x
_Crc32.18 = 'F3B97148'x
_Crc32.19 = '84BE41DE'x
_Crc32.20 = '1ADAD47D'x
_Crc32.21 = '6DDDE4EB'x
_Crc32.22 = 'F4D4B551'x
_Crc32.23 = '83D385C7'x
_Crc32.24 = '136C9856'x
_Crc32.25 = '646BA8C0'x
_Crc32.26 = 'FD62F97A'x
_Crc32.27 = '8A65C9EC'x
_Crc32.28 = '14015C4F'x
_Crc32.29 = '63066CD9'x
_Crc32.30 = 'FA0F3D63'x
_Crc32.31 = '8D080DF5'x
_Crc32.32 = '3B6E20C8'x
_Crc32.33 = '4C69105E'x
_Crc32.34 = 'D56041E4'x
_Crc32.35 = 'A2677172'x
_Crc32.36 = '3C03E4D1'x
_Crc32.37 = '4B04D447'x
_Crc32.38 = 'D20D85FD'x
_Crc32.39 = 'A50AB56B'x
_Crc32.40 = '35B5A8FA'x
_Crc32.41 = '42B2986C'x
_Crc32.42 = 'DBBBC9D6'x
_Crc32.43 = 'ACBCF940'x
_Crc32.44 = '32D86CE3'x
_Crc32.45 = '45DF5C75'x
_Crc32.46 = 'DCD60DCF'x
_Crc32.47 = 'ABD13D59'x
_Crc32.48 = '26D930AC'x
_Crc32.49 = '51DE003A'x
_Crc32.50 = 'C8D75180'x
_Crc32.51 = 'BFD06116'x
_Crc32.52 = '21B4F4B5'x
_Crc32.53 = '56B3C423'x
_Crc32.54 = 'CFBA9599'x
_Crc32.55 = 'B8BDA50F'x
_Crc32.56 = '2802B89E'x
_Crc32.57 = '5F058808'x
_Crc32.58 = 'C60CD9B2'x
_Crc32.59 = 'B10BE924'x
_Crc32.60 = '2F6F7C87'x
_Crc32.61 = '58684C11'x
_Crc32.62 = 'C1611DAB'x
_Crc32.63 = 'B6662D3D'x
_Crc32.64 = '76DC4190'x
_Crc32.65 = '01DB7106'x
_Crc32.66 = '98D220BC'x
_Crc32.67 = 'EFD5102A'x
_Crc32.68 = '71B18589'x
_Crc32.69 = '06B6B51F'x
_Crc32.70 = '9FBFE4A5'x
_Crc32.71 = 'E8B8D433'x
_Crc32.72 = '7807C9A2'x
_Crc32.73 = '0F00F934'x
_Crc32.74 = '9609A88E'x
_Crc32.75 = 'E10E9818'x
_Crc32.76 = '7F6A0DBB'x
_Crc32.77 = '086D3D2D'x
_Crc32.78 = '91646C97'x
_Crc32.79 = 'E6635C01'x
_Crc32.80 = '6B6B51F4'x
_Crc32.81 = '1C6C6162'x
_Crc32.82 = '856530D8'x
_Crc32.83 = 'F262004E'x
_Crc32.84 = '6C0695ED'x
_Crc32.85 = '1B01A57B'x
_Crc32.86 = '8208F4C1'x
_Crc32.87 = 'F50FC457'x
_Crc32.88 = '65B0D9C6'x
_Crc32.89 = '12B7E950'x
_Crc32.90 = '8BBEB8EA'x
_Crc32.91 = 'FCB9887C'x
_Crc32.92 = '62DD1DDF'x
_Crc32.93 = '15DA2D49'x
_Crc32.94 = '8CD37CF3'x
_Crc32.95 = 'FBD44C65'x
_Crc32.96 = '4DB26158'x
_Crc32.97 = '3AB551CE'x
_Crc32.98 = 'A3BC0074'x
_Crc32.99 = 'D4BB30E2'x
_Crc32.100 = '4ADFA541'x
_Crc32.101 = '3DD895D7'x
_Crc32.102 = 'A4D1C46D'x
_Crc32.103 = 'D3D6F4FB'x
_Crc32.104 = '4369E96A'x
_Crc32.105 = '346ED9FC'x
_Crc32.106 = 'AD678846'x
_Crc32.107 = 'DA60B8D0'x
_Crc32.108 = '44042D73'x
_Crc32.109 = '33031DE5'x
_Crc32.110 = 'AA0A4C5F'x
_Crc32.111 = 'DD0D7CC9'x
_Crc32.112 = '5005713C'x
_Crc32.113 = '270241AA'x
_Crc32.114 = 'BE0B1010'x
_Crc32.115 = 'C90C2086'x
_Crc32.116 = '5768B525'x
_Crc32.117 = '206F85B3'x
_Crc32.118 = 'B966D409'x
_Crc32.119 = 'CE61E49F'x
_Crc32.120 = '5EDEF90E'x
_Crc32.121 = '29D9C998'x
_Crc32.122 = 'B0D09822'x
_Crc32.123 = 'C7D7A8B4'x
_Crc32.124 = '59B33D17'x
_Crc32.125 = '2EB40D81'x
_Crc32.126 = 'B7BD5C3B'x
_Crc32.127 = 'C0BA6CAD'x
_Crc32.128 = 'EDB88320'x
_Crc32.129 = '9ABFB3B6'x
_Crc32.130 = '03B6E20C'x
_Crc32.131 = '74B1D29A'x
_Crc32.132 = 'EAD54739'x
_Crc32.133 = '9DD277AF'x
_Crc32.134 = '04DB2615'x
_Crc32.135 = '73DC1683'x
_Crc32.136 = 'E3630B12'x
_Crc32.137 = '94643B84'x
_Crc32.138 = '0D6D6A3E'x
_Crc32.139 = '7A6A5AA8'x
_Crc32.140 = 'E40ECF0B'x
_Crc32.141 = '9309FF9D'x
_Crc32.142 = '0A00AE27'x
_Crc32.143 = '7D079EB1'x
_Crc32.144 = 'F00F9344'x
_Crc32.145 = '8708A3D2'x
_Crc32.146 = '1E01F268'x
_Crc32.147 = '6906C2FE'x
_Crc32.148 = 'F762575D'x
_Crc32.149 = '806567CB'x
_Crc32.150 = '196C3671'x
_Crc32.151 = '6E6B06E7'x
_Crc32.152 = 'FED41B76'x
_Crc32.153 = '89D32BE0'x
_Crc32.154 = '10DA7A5A'x
_Crc32.155 = '67DD4ACC'x
_Crc32.156 = 'F9B9DF6F'x
_Crc32.157 = '8EBEEFF9'x
_Crc32.158 = '17B7BE43'x
_Crc32.159 = '60B08ED5'x
_Crc32.160 = 'D6D6A3E8'x
_Crc32.161 = 'A1D1937E'x
_Crc32.162 = '38D8C2C4'x
_Crc32.163 = '4FDFF252'x
_Crc32.164 = 'D1BB67F1'x
_Crc32.165 = 'A6BC5767'x
_Crc32.166 = '3FB506DD'x
_Crc32.167 = '48B2364B'x
_Crc32.168 = 'D80D2BDA'x
_Crc32.169 = 'AF0A1B4C'x
_Crc32.170 = '36034AF6'x
_Crc32.171 = '41047A60'x
_Crc32.172 = 'DF60EFC3'x
_Crc32.173 = 'A867DF55'x
_Crc32.174 = '316E8EEF'x
_Crc32.175 = '4669BE79'x
_Crc32.176 = 'CB61B38C'x
_Crc32.177 = 'BC66831A'x
_Crc32.178 = '256FD2A0'x
_Crc32.179 = '5268E236'x
_Crc32.180 = 'CC0C7795'x
_Crc32.181 = 'BB0B4703'x
_Crc32.182 = '220216B9'x
_Crc32.183 = '5505262F'x
_Crc32.184 = 'C5BA3BBE'x
_Crc32.185 = 'B2BD0B28'x
_Crc32.186 = '2BB45A92'x
_Crc32.187 = '5CB36A04'x
_Crc32.188 = 'C2D7FFA7'x
_Crc32.189 = 'B5D0CF31'x
_Crc32.190 = '2CD99E8B'x
_Crc32.191 = '5BDEAE1D'x
_Crc32.192 = '9B64C2B0'x
_Crc32.193 = 'EC63F226'x
_Crc32.194 = '756AA39C'x
_Crc32.195 = '026D930A'x
_Crc32.196 = '9C0906A9'x
_Crc32.197 = 'EB0E363F'x
_Crc32.198 = '72076785'x
_Crc32.199 = '05005713'x
_Crc32.200 = '95BF4A82'x
_Crc32.201 = 'E2B87A14'x
_Crc32.202 = '7BB12BAE'x
_Crc32.203 = '0CB61B38'x
_Crc32.204 = '92D28E9B'x
_Crc32.205 = 'E5D5BE0D'x
_Crc32.206 = '7CDCEFB7'x
_Crc32.207 = '0BDBDF21'x
_Crc32.208 = '86D3D2D4'x
_Crc32.209 = 'F1D4E242'x
_Crc32.210 = '68DDB3F8'x
_Crc32.211 = '1FDA836E'x
_Crc32.212 = '81BE16CD'x
_Crc32.213 = 'F6B9265B'x
_Crc32.214 = '6FB077E1'x
_Crc32.215 = '18B74777'x
_Crc32.216 = '88085AE6'x
_Crc32.217 = 'FF0F6A70'x
_Crc32.218 = '66063BCA'x
_Crc32.219 = '11010B5C'x
_Crc32.220 = '8F659EFF'x
_Crc32.221 = 'F862AE69'x
_Crc32.222 = '616BFFD3'x
_Crc32.223 = '166CCF45'x
_Crc32.224 = 'A00AE278'x
_Crc32.225 = 'D70DD2EE'x
_Crc32.226 = '4E048354'x
_Crc32.227 = '3903B3C2'x
_Crc32.228 = 'A7672661'x
_Crc32.229 = 'D06016F7'x
_Crc32.230 = '4969474D'x
_Crc32.231 = '3E6E77DB'x
_Crc32.232 = 'AED16A4A'x
_Crc32.233 = 'D9D65ADC'x
_Crc32.234 = '40DF0B66'x
_Crc32.235 = '37D83BF0'x
_Crc32.236 = 'A9BCAE53'x
_Crc32.237 = 'DEBB9EC5'x
_Crc32.238 = '47B2CF7F'x
_Crc32.239 = '30B5FFE9'x
_Crc32.240 = 'BDBDF21C'x
_Crc32.241 = 'CABAC28A'x
_Crc32.242 = '53B39330'x
_Crc32.243 = '24B4A3A6'x
_Crc32.244 = 'BAD03605'x
_Crc32.245 = 'CDD70693'x
_Crc32.246 = '54DE5729'x
_Crc32.247 = '23D967BF'x
_Crc32.248 = 'B3667A2E'x
_Crc32.249 = 'C4614AB8'x
_Crc32.250 = '5D681B02'x
_Crc32.251 = '2A6F2B94'x
_Crc32.252 = 'B40BBE37'x
_Crc32.253 = 'C30C8EA1'x
_Crc32.254 = '5A05DF1B'x
_Crc32.255 = '2D02EF8D'x
signal EndCrc32rexXh

Crc32PrePostConditioning:
if  arg(1) = '' then
return('FFFFFFFF'x)
else
return( bitxor(arg(1), 'FFFFFFFF'x) )

UpdateCrc32:
ucCrc       = arg(1)
ucBuffer    = arg(2)
ucBufferLng = length(ucBuffer)
do  ucThisByte = 1 to ucBufferLng
ucCrcDiv256 = '00'x || left(ucCrc, 3)
ucPart1     = bitand(ucCrcDiv256, '00FFFFFF'x)
ucPart2     = bitxor(ucCrc, '000000'x || substr(ucBuffer, ucThisByte, 1))
ucArrayEl   = c2d(right(bitand(ucPart2, '000000FF'x), 1))
ucCrc       = Bitxor(ucPart1, _Crc32.ucArrayEl)
end
return(ucCrc)

Crc32InDisplayableForm:
return( c2x(arg(1)) )

EndCRC32REXXh:
CurrentFile = ''
InHexMode   = 'Y'
OnError     = ''
call DisplayCopyright
parse value arg(1) with ScriptFile OptionsCmdLine
if ScriptFile = '' then
UserSyntaxError("Expected the name of a Script File")
OptionDebugOn     = 'N'
OptionSeeCmds     = 'N'
OptionSeeProgress = 'N'
OptionsEnvironment = GetEnv('BINTOOL_OPTIONS')
Options            = OptionsEnvironment || ' ' || OptionsCmdLine
do while  Options <> ''
parse var Options ThisParm Options
parse var ThisParm ThisCmd':'ThisCmdOptions
ThisCmd = translate(ThisCmd)
select
when ThisCmd = '/SEECMDS' then
OptionSeeCmds    = SwitchWantsYesOrNo(ThisCmd, ThisCmdOptions, 'Y')
when ThisCmd = '/SEEPROGRESS' then
OptionSeeProgress = SwitchWantsYesOrNo(ThisCmd, ThisCmdOptions, 'Y')
when ThisCmd = '/DEBUG' then
do
call SwitchMustNotHaveOptions ThisCmd, ThisCmdOptions
OptionDebugOn     = 'Y'
OptionSeeCmds     = 'Y'
OptionSeeProgress = 'Y'
end
when ThisCmd = '/COLOR' | ThisCmd = '/COLOUR' then
do
call NotAvailableUnderNtYet ThisCmd
WantColor = SwitchWantsYesOrNo(ThisCmd, ThisCmdOptions, 'Y')
if  WantColor = 'N' then
call RemoveColorCodes
else
call SetColorCodes
end
otherwise
UserSyntaxError('Unknown command of "' || ThisCmd || '" specified')
end
end
if ScriptFile <> '?' then
Interactive = 'N'
else
do
Interactive       = 'Y'
OptionSeeCmds     = 'N'
OptionSeeProgress = 'Y'
end
if Interactive = 'Y' then
call ProcessInteractiveCommands
else
call ProcessWholeFile
PgmExit(ExitRc)

DisplayCopyright:
call DisplayLine ColorStartupMsg, '[]-------------------------------------------------------------------------[]'
call DisplayLine ColorStartupMsg, '| BINTOOL.CMD: Version ' || PGM_VERSION || ' (C)opyright Dennis Bareis 1998                |'
call DisplayLine ColorStartupMsg, '| http://www.labyrinth.net.au/~dbareis/index.htm (dbareis@labyrinth.net.au) |'
call DisplayLine ColorStartupMsg, '[]-------------------------------------------------------------------------[]'
say ''
return

HandleWhitespaceInCommand:
TheCmdLine = strip( translate(arg(1), ' ', Tab) )
TheCmdLine = strip( arg(1) )
if  TheCmdLine = '' then
return('')
if  left(TheCmdLine, 1) = ';' then
return('')
ColonColonPos = lastpos(ColonColon, TheCmdLine)
if  ColonColonPos <> 0 then
do
TheCmdLine = strip( left(TheCmdLine, ColonColonPos-1) )
end
return(TheCmdLine)

ProcessInteractiveCommands:
do while Interactive = 'Y'
if  CurrentFile = '' then
Prompt = '> '
else
Prompt = _filespec('name', CurrentFile) || ' @ ' || GetDisplayableCurrentOffset() || '> '
call charout , ColorPrompt || Prompt || ColorExecutingCommand
if  RexWhich = 'STANDARD_OS/2' then
UsersCmd = CmdLine("Insert", "Required")
else
UsersCmd = linein()
call charout , Reset
UsersCmd = HandleWhitespaceInCommand(UsersCmd)
if  UsersCmd = '' then
iterate
call RecordLine ''
call RecordLine UsersCmd
call ProcessOneCmd UsersCmd
end
return

ProcessWholeFile:
if  stream(ScriptFile, 'c', 'query exists') = '' then
UserSyntaxError('The script file "' || ScriptFile || '" does not exist')
CloseRc = stream(ScriptFile, 'c', 'close')
CloseRc = stream(ScriptFile, 'c', 'open Read')
CurrentLineNumber = 0
do  while lines(ScriptFile) <> 0
CurrentLine       = HandleWhitespaceInCommand( linein(ScriptFile) )
CurrentLineNumber = CurrentLineNumber + 1
if  CurrentLine = '' then
iterate
if  left(CurrentLine, 1) = ':' then
call SaveLabel     translate(substr(CurrentLine, 2))
else
call ProcessOneCmd CurrentLine
end
call IoError ScriptFile
CloseRc = stream(ScriptFile, 'c', 'close')
return

IsCommand:
FullCmd = arg(1)
Subset  = arg(2)
MinLng  = arg(3)
if  Interactive = 'Y' then
do
if  MinLng = '' then
MinLng = 0
if  abbrev(FullCmd, Subset, MinLng) = 1 then
return('Y')
else
return('N')
end
else
do
if  FullCmd == Subset then
return('Y')
else
return('N')
end

ProcessOneCmd:
TheLine = strip( ReplaceRexxVariables(arg(1)) )
parse var TheLine TheCmd ItsParameters
TheCmd        = translate(TheCmd)
ItsParameters = strip(ItsParameters)
if  OptionSeeCmds = 'Y' then
call DisplayLine ColorExecutingCommand, GetDisplayableCurrentOffset(6) || ' : ' || TheCmd || ' ' || ItsParameters
select
when IsCommand('WRITE', TheCmd) = 'Y' then
call WriteToFile ItsParameters
when IsCommand('VERIFY', TheCmd) = 'Y' then
call VerifyBytesInFile ItsParameters
when IsCommand('MOVETO', TheCmd) = 'Y' then
call ProcessCmdMoveTo ItsParameters
when IsCommand('GOTO', TheCmd) = 'Y' then
do
if  NotAllowedInInteractiveMode() <> '!' then
call GotoLabel ItsParameters
end
when TheCmd = 'OPENNEW' | TheCmd = 'OPENREAD' | TheCmd = 'OPEN' then
call ProcessCmdOpenFile TheCmd, ItsParameters
when IsCommand('CLOSE', TheCmd) = 'Y' then
call ProcessCmdCloseFile
when IsCommand('HEXADECIMAL', TheCmd) = 'Y' then
InHexMode = 'Y'
when IsCommand('DECIMAL', TheCmd, 2) = 'Y' then
InHexMode = 'N'
when IsCommand('VERIFYFILE', TheCmd, 7) = 'Y' then
call VerifyFileContents ItsParameters
when IsCommand('RECORD', TheCmd, 3) = 'Y' then
call ProcessRecordCommand ItsParameters
when IsCommand('FIND', TheCmd) = 'Y' then
call ProcessFindCommand ItsParameters, 'Y'
when IsCommand('FINDCS', TheCmd, 5) = 'Y' then
call ProcessFindCommand ItsParameters, 'N'
when IsCommand('LOCATE', TheCmd) = 'Y' then
call ProcessLocateCommand ItsParameters, 'M'
when IsCommand('LOCATE!', TheCmd, 7) = 'Y' then
call ProcessLocateCommand ItsParameters, 'N'
when IsCommand('REXX', TheCmd) = 'Y' then
do
if ItsParameters = '' then
call CommandFailure 'No parameters supplied on "REXX" command'
else
Dummy = InterpretExactCommand(ItsParameters)
end
when IsCommand('SYSTEM', TheCmd) = 'Y' then
do
if  ItsParameters = '' then
do
call AddressCmd '@CMD.EXE /K "cls & prompt BINTOOL $p$g$s'
SystemRc = Rc
end
else
do
call AddressCmd '@CMD.EXE /C ' || ItsParameters
SystemRc = Rc
call ProgressMsg 'Rc = ' || SystemRc
end
end
when IsCommand('DUMP', TheCmd) = 'Y' then
call ProcessCmdDump ItsParameters
when IsCommand('DUMPCHAR', TheCmd, 5) = 'Y' then
call ProcessDumpChar ItsParameters
when IsCommand('REBUILD', TheCmd, 3) = 'Y' then
call ProcessCmdRebuild ItsParameters
when IsCommand('ONERROR', TheCmd, 3) = 'Y' then
do
if  NotAllowedInInteractiveMode() <> '!' then
do
OnError = translate(ItsParameters)
return
end
end
when IsCommand('QUIT', TheCmd) = 'Y' | IsCommand('EXIT', TheCmd) = 'Y' | TheCmd = 'X' then
do
call OnlyAllowedInInteractiveMode
Interactive = 'N'
end
when TheCmd = '?' then
do
if  OnlyAllowedInInteractiveMode() <> '!' then
do
if  ItsParameters <> '' then
call ViewInf ItsParameters
else
call DisplayCommandSummary
end
end
when TheCmd = '??' | TheCmd = 'HELP' then
do
if  OnlyAllowedInInteractiveMode() <> '!' then
call ViewInf ItsParameters
end
otherwise
call CommandFailure 'Unknown Command of "' || TheCmd || '" specified.'
end
OnError = ''
return

DisplayCommandSummary:
say 'CLOSE            QUIT'
say 'DECIMAL          REBUILD'
say 'DUMP             RECORD'
say 'DUMPCHAR         REXX'
say 'GOTO             SYSTEM'
say 'FIND[CS]         VERIFY'
say 'HEXADECIMAL      VERIFYFILE'
say 'LOCATE[!]        WRITE'
say 'MOVETO           HELP'
say 'OPEN'
say 'OPENNEW'
say 'OPENREAD'
return

ViewInf:
call AddressCmd '@view.exe ' || ThisProgramDir || 'BINTOOL.INF ' || arg(1)
return

SetColorCodes:
EscapeChar             = d2c(27)
Reset                  = EscapeChar || '[0m'
ColorStartupMsg        = EscapeChar || '[1;33m'
ColorError             = EscapeChar || '[1;31m'
ColorProgress          = EscapeChar || '[32m'
ColorPrompt            = EscapeChar || '[1;33m'
ColorExecutingCommand  = EscapeChar || '[1;35m'
return

RemoveColorCodes:
Reset                  = ''
ColorStartupMsg        = ''
ColorError             = ''
ColorProgress          = ''
ColorPrompt            = ''
ColorExecutingCommand  = ''
return

PgmExit:
call CloseRecordFile
if  Dying = 'N' then
do
Dying = 'Y'
call ProcessCmdCloseFile
end
exit( arg(1) )
