/*
** Browser v1.0     [B.CMD]
**
** By Mark Ziller, 1994
**
** Based on code by Bruce E. Hgman
** Uses VREXX 
**
*/


/* Get any command line args */
ProgName = "Browser v1.0"
InFileSpec=""; 
parse upper arg a1 a2 a3 a4
UsesVRexx = 0



/* ================================================================== */
/* Check to see if all REXX utility functions have been Loaded        */
/* NOTE:  RxFuncQuery tests for REXX load.                            */
/* ================================================================== */
if 0 < RxFuncQuery('SysLoadFuncs') then do; 
   Call rxfuncadd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs'; 
   Call SysLoadFuncs; 
end;


/* ================================================================== 
** Load in VREXX functions now (while there is sure to be enough memory)
** ================================================================== 
*/

call CheckVRexx


/* ================================================================== 
** Save the original screen data
** ================================================================== 
*/

screen = SysTextScreenRead( 0, 0 )
parse value SysCurPos() with OrigRow OrigCol
OrigRow = OrigRow - 1
call SysCurState 'OFF'



/* ================================================================== 
** GLOBALS
** ================================================================== 
*/

Globals:

ErrorFlag = ""			/* No errors have occurred */
Yes = 1
No  = 0
OUTR='~'||'fa'x||'fa'x||'fa'x||'fa'x||'fa'x||'fa'x||'fa'x||'fa'x;
INTR=''||'06'x||'07'x||'08'x||'09'x||'0a'x||'0b'x||'0c'x||'0d'x;
bShowBlank  = 1		/* default = Show Blank Lines (1) */
bFoldLines   = 0		/* default = Do NOT Wrap Long Lines (0) */
bShowCursor = 0		/* default = Do NOT Show Cursor (0) */
Cursor   = 0			/* hide cursor if not in use */
FToggle  = 0			/* View Found Lines Only = NO (0) */
HasSearched = 0		/* No search has been performed */
BookMark.rows = 0		/* book mark data structure */
BookMark.cols  = 2
BookMark.label.1 = "Line #"
BookMark.label.2 = "Line Text"
BookMark.width.1 = 7
BookMark.width.2 = 70
SCurPos = 0
zMaxCol = 80
ColrTxt=40    
ColrTxtBg=44;
BriteTxt=0; 
BriteHd=0; 
ColrHd=30; 
ColrHdBg=46;


/* ================================================================== 
** Check for any command line arguments
** ================================================================== 
*/

passed.1  = a1
passed.2  = a2
passed.3  = a3
passed.4  = a4


do i = 1 to 3
  InFileSpec = passed.i;
  c = substr(passed.i, 1, 1)
  if c = '-' | c = '+' then 
     call ParseArg passed.i;
  else leave;
end;



/* ================================================================== 
** See if any legit filename was passed; otherwise, popup file box to get one
** ================================================================== 
*/

if InFileSpec = "" then do;
  InFileSpec = "*.*"
  signal FILEBOX
end
signal on syntax name File_Err
call SysFileTree InFileSpec, 'list', 'F'
signal off syntax
if list.0 = 1 then do;
  FName = InFileSpec
  signal ENTRY
end
if list.0 > 1 then signal FileBox;


/* ================================================================== 
** File_Error
** ================================================================== 
*/
File_Err:

InFileSpec = "*.*"
signal off syntax



/* ================================================================== 
** FileBox
** ================================================================== 
*/

FileBox:

/* first, setup VRexx calls */
call CheckVRexx;

button = VFileBox('Select file to browse:', InFileSpec, 'file')
if button = 'CANCEL' then signal CLEANUP
FName = file.vstring



/* ================================================================== 
** Main Entry Point (for re-entry to the program, e.g. after an EDIT command)
** ================================================================== 
*/

Entry:

FFName = FILESPEC("name", FName)	/* get just the file name */
call READ;




/* ================================================================== 
** MAINLOOP
** ================================================================== 
*/

MAINLOOP:
do while Action \= "EXIT"
   ReDraw = Yes			/* by default, redraw entire screen w/ each move */
   NoStatus = No			/* Don't supress status update */
   call KeyStroke

   if bShowCursor = No then do;
   select;
     when Action = "UP" then
        CurrLine = MAX(Top, CurrLine - 1)
     when Action = "DOWN" then
        CurrLine = MIN(CurrLine + 1, Bottom)
     when Action = "PAGEUP" then
        CurrLine = MAX(Top, CurrLine - LinesPerPage)
     when Action = "PAGEDOWN" then
        CurrLine = MIN(CurrLine + LinesPerPage, Bottom)
     when Action = "HOME" then
         CurrLine = Top;
     when Action = "END" then
         CurrLine = Bottom;
     when Action = "CURSOR" then do;
          bShowCursor = Yes;
          Action = "XXXX";
          Cursor = 1;
          end;
     when Action = "HELP" then
          call DoHelp;
     when Action = "SEARCH" then
          call DoSearch;
     when Action = "NEXT" then
          call DoNextSearch;
     when Action = "PREV" then
          call DoLastSearch;
     when Action = "WRITE" then
          call DoWriteResults;
     when Action = "EDIT" then
          call DoEdit;
     when Action = "GOTO" then 
          call DoGoto;
     when Action = "TVIEW" then
          call ToggleFound;
     when Action = "MARK" then
          call MarkToBook;
     when Action = "BOOK" then
          call ShowBookMark;
     when Action = "UNMARK" then
          call UnMarkBook;
     when Action = "MARKDISK" then
          call WriteBook;
     otherwise nop;
   end;  /* select */
   end; /* bShow Cursor = NO (0) */

   if bShowCursor = Yes then do;
     select;
     when Action = "UP" then do;
        if Cursor > 2 then do;
           temp = CurrLine + Cursor - 1;
           if bFoldLines = 0 & LENGTH(LineArray.temp) > 80 then do;	  
	      call ScrDisplay  Cursor+1 No TRANSLATE(LineArray.Temp, OUTR, INTR)
              temp = CurrLine + Cursor;
              call ScrDisplay  Cursor+2 No TRANSLATE(LineArray.Temp, OUTR, INTR)
              end;   /* if bFoldLines = 0 then do */
           else do;
	     call ScrDisplay  Cursor+1 No TRANSLATE(LineArray.Temp, OUTR, INTR)
           end;   /* else do;  */
           Cursor = Cursor - 1;
           temp = CurrLine + Cursor - 1;
	   call ScrDisplay  Cursor+1 Yes TRANSLATE(LineArray.Temp, OUTR, INTR)
           ReDraw = No;
           end; /* if Cursor > 1 then do; */
        else do;
           CurrLine = MAX(Top, CurrLine - 1)
           Cursor = 1;
           end; /* else do */
       end;   /*  when Action = "UP" then do;  */
     when Action = "DOWN" then do;
        if Cursor < LinesPerPage then do;
           temp = CurrLine + Cursor - 1;
	   call ScrDisplay  Cursor+1 No TRANSLATE(LineArray.Temp, OUTR, INTR)
           Cursor = Cursor + 1;
           temp = CurrLine + Cursor - 1;
	   call ScrDisplay  Cursor+1 Yes TRANSLATE(LineArray.Temp, OUTR, INTR) 
           ReDraw = No;
           end;   /*  if Cursor < LinesPerPage then do;  */
        else do;
           CurrLine = MIN(CurrLine + 1, Bottom)
           Cursor = LinesPerPage;
           end;  /* else do */
        end;   /*  when Action = "DOWN" then do;  */
     when Action = "PAGEUP" then do;
        CurrLine = MAX(Top, CurrLine - LinesPerPage)
        Cursor   = 1;
        end;  /*  when Action = "PAGEUP" then do;  */
     when Action = "PAGEDOWN" then do;
        CurrLine = MIN(CurrLine + LinesPerPage, Bottom)
        Cursor   = LinesPerPage;
        end;   /*  when Action = "PAGEDOWN" then do;  */
     when Action = "HOME" then do;
         CurrLine = Top;
         Cursor   = 1;
         end;  /*  when Action = "HOME" then do;  */
     when Action = "END" then do;
         CurrLine = Bottom;
         Cursor   = LinesPerPage;
         end;  /* when Action = "END" then do;  */
     when Action = "CURSOR" then do;
          bShowCursor = No;
          Cursor = 0;
          end;
     when Action = "HELP" then
          call DoHelp;
     when Action = "SEARCH" then
          call DoSearch;
     when Action = "NEXT" then
          call DoNextSearch;
     when Action = "PREV" then
          call DoLastSearch;
     when Action = "WRITE" then
          call DoWriteResults;
     when Action = "EDIT" then
          call DoEdit;
     when Action = "GOTO" then 
          call DoGoto;
     when Action = "TVIEW" then
          call ToggleFound;
     when Action = "MARK" then
          call MarkToBook;
     when Action = "BOOK" then
          call ShowBookMark;
     when Action = "UNMARK" then
          call UnMarkBook;
     when Action = "MARKDISK" then
          call WriteBook;
     otherwise nop;
    end;  /* select */
   end; /* bShow Cursor = YES (1) */

if CurrLine > (Bottom - LinesPerPage + 1) then do;
   CurrLine = Bottom - LinesPerPage + 1;
   if CurrLine < 1 then 
      CurrLine = 1;
end;

if ReDraw = Yes then
   call DisplayData
if ReDraw = No & NoStatus = No then do;
  if FToggle = 0 then
     ViewText = "View ALL"
  else
     ViewText = "View FOUND"
  if bShowCursor = 1 then
     CursorText = "Cursor ON"
  else
     CursorText = "Cursor OFF"
  StatusLine = "[" FFName "]     Line "||CurrLine+Cursor-1||" of "||Bottom||"    "||ViewText||"   "||CursorText||"  Marked = "||BookMark.rows
  call ScrDisplay 1 No StatusLine
end;

end /* do while action \= "EXIT" */
signal CLEANUP



/* ================================================================== 
** READ file into memory
** ================================================================== 
*/

READ:
say "[1;5;31;40m[2JWorking...[0;1;36;40m";
Drv=FILESPEC('d',FName);
if Drv='A:' | Drv='B:' then 
   OdoTrip=49; 
else 
   OdoTrip=99;

/* set up some data vars */
LineLast=0; 
LineFirst=1; 
Odo=0; 
MaxLineLen=0;
bBlankLast=0; 
InBlanks=0; 
InLines=0;

/* now read the file into the array */
do forever;
   if Lines(FName) = 0 then 
       leave;  /* at end of file? */
   LineLast=LineLast+1; 
   InLines=InLines+1;
   LineArray.LineLast=LINEIN(FName);
   Odo=Odo+1; 

/* check to see if the line should be folded (for long lines) */
   if bFoldLines > 0 then do
     LLen=LENGTH(LineArray.LineLast);
     do while LLen > zMaxCol;
       LP1=LineLast+1;
       LineArray.LP1=substr(LineArray.LineLast,zMaxCol+1);
       LineArray.LineLast=substr(LineArray.LineLast,1,zMaxCol);
       LineLast=LP1;
       LLen=LENGTH(LineArray.LineLast);
     end; /* do while LLen > zMaxCol; */
    end; /* if bFoldLines > 0 then do */
   else 
     nop;

/* check to see if we need to condense blank lines */
   if bShowBlank < 1 then do;
      if LineArray.LineLast="" | LineArray.LineLast=COPIES('20'x,LLen) then do;
         if bBlankLast > 0 then do;
            LineLast=LineLast-1; 
            InBlanks=InBlanks+1;
         end;
         bBlankLast=1;
      end;
      else bBlankLast=0;
   end;

   if Odo>OdoTrip THEN DO; 
      Odo=0;
      irc=charout(,"[s"InLines "lines read," InBlanks "blank lines dropped," InLines-InBlanks "lines kept.[u");
   END;

END; /* do forever */
irc=stream(FName,'c','close');


/* ================================================================== 
** Now get ready to display the text (part of READ)
** ================================================================== 
*/

Action   = ""
CurrLine = 1
Bottom  = LineLast
Top      = 1
LineArray.LineLast="*************** END OF FILE ***************"  
LineArray.LineLast=TRANSLATE(LineArray.LineLast,OUTR,INTR);
call GetVideoSize

if LinesPerPage > LineLast then 		/* fill in at least LinesPerPage of stuff */
  do temp = LineLast+1 to LinesPerPage+2
    LineArray.temp = " "
  end
call DisplayData
return;




/* ================================================================== 
** DisplayData (Redraw entire screen)
** ================================================================== 
*/

DisplayData:
curr        = CurrLine
if FToggle = 0 then
   ViewText = "View ALL"
else
   ViewText = "View FOUND"
if bShowCursor = 1 then
   CursorText = "Cursor ON"
else
   CursorText = "Cursor OFF"
if bShowCursor = No then
   StatusLine = "[" FFName "]     Lines "||curr||" - "||curr+LinesPerPage||" of "||Bottom||"   "||ViewText||"  "||CursorText||"  Marked = "||BookMark.rows
else
   StatusLine = "[" FFName "]     Line "||curr+Cursor-1||" of "||Bottom||"    "||ViewText||"  "||CursorText||"  Marked = "||BookMark.rows
call ScrDisplay 1 No StatusLine
do lp = 2 to LinesPerPage+1
  if lp = Cursor + 1 then
    call ScrDisplay lp Yes TRANSLATE(LineArray.curr, OUTR, INTR) 
  else
    call ScrDisplay lp No TRANSLATE(LineArray.curr, OUTR, INTR) 
  curr = curr + 1
end /* for i = 1 to nLines */
return



/* ================================================================== 
** Display one line of data
** ================================================================== 
*/

ScrDisplay:;
parse arg RowNr IsCursor LineData;
if RowNr = 1 then do; 
  SFgColr=ColrHd; 
  Bright=BriteHd; 
  SBgColr=ColrHdBg; 
end;
else do; 
  SFgColr=ColrTxt; 
  Bright=BriteTxt; 
  SBgColr=ColrTxtBg; 
end;
if IsCursor = 1 then do;
  SFgColr=32; 
  Bright=BriteTxt; 
  SBgColr=40; 
end;

irc=CHAROUT(,"["RowNr";1H["Bright";"SFgColr";"SBgColr"m[K"LineData"["RowNr";1H");
return;




/* ================================================================== 
** Get a keystroke from the keybroad and return the appropriate action
** ================================================================== 
*/

KeyStroke:;
Action = ""		/* nothing selected yet */
do forever;
   parse value SysCurPos() with VidRow VidCol;
   key=SysGetKey('noecho');
   if c2x(key)='1B' THEN DO; 
      Action="EXIT"; 
      return; 
      END;
   kv=c2d(key);
   if c2x(key)='E0' THEN DO;
      kv=1000; 
      key=SysGetkey('noecho'); 
      kv=kv+c2d(key);
   END;
   else do;
      if kv=0 THEN DO; 
         kv=1000; 
         key=SysGetKey('noecho'); 
         kv=kv+c2d(key);
      END;
   END;
      SELECT;
      when kv=1072		THEN DO; Action="UP"; return; END;
      when kv=1080		THEN DO; Action="DOWN"; return; END;
      when kv=1071		THEN DO; Action="HOME"; return; END;
      when kv=1079		THEN DO; Action="END"; return; END;
      when kv=1073		THEN DO; Action="PAGEUP"; return; END;
      when kv=1081		THEN DO; Action="PAGEDOWN"; return; END;
      when kv=99		THEN DO; Action="CURSOR"; return; END;
      when kv=1059		THEN DO; Action="HELP";return;END;
      when kv=115		THEN DO; Action="SEARCH";return;END;
      when kv=110		THEN DO; Action="NEXT";return;END;
      when kv=112		THEN DO; Action="PREV";return;END;
      when kv=43		THEN DO; Action="NEXT";return;END;
      when kv=45		THEN DO; Action="PREV";return;END;
      when kv=119		THEN DO; Action="WRITE";return;END;
      when kv=101		THEN DO; Action="EDIT";return;END
      when kv=103		THEN DO; Action="GOTO";return;END;
      when kv=118		THEN DO; Action="TVIEW";return;END;
      when kv=109		THEN DO; Action="MARK";return;END;
      when kv=98		THEN DO; Action="BOOK";return;END;
      when kv=117		THEN DO; Action="UNMARK";return;END;
      when kv=100		THEN DO; Action="MARKDISK";return;END;
      otherwise nop;
      END; /* select */
   if Action \= "" then return;
END;
return;



/* ================================================================== 
** GetVideoSize
** ================================================================== 
*/

GetVideoSize:;
   parse value SysTextScreenSize() with gMaxRow gMaxCol;
   LinesPerPage=gMaxRow-2;
   return;




/* ================================================================== 
** Parse a command line argument
** ================================================================== 
*/

ParseArg:;
parse upper arg vvv;
s = substr(vvv, 1, 1);
if s = '-' then sign = 0;
if s = '+' then sign = 1;
c = substr(vvv, 2, 2);

if c = 'W' then bFoldLines = sign;
if c = 'B'  then bShowBlank = sign;
if c = 'S' then do;
   bShowCursor = sign;
   Cursor   = 1
end;
return



/* ================================================================== 
** CheckVRexx (Load if not already loaded)
** ================================================================== 
*/

CheckVRexx:

if UsesVRexx = No then do;
  UsesVRexx = Yes;
  call RxFuncAdd 'VInit', 'VREXX', 'VINIT'
  initcode = VInit()
  if initcode = 'ERROR' then signal CLEAN_EI
  signal on failure name CLEAN_EF
  signal on halt name CLEAN_EH
  signal on syntax name CLEAN_ES
  call VDialogPos 50, 50
end;
return;




/* ================================================================== 
** Do a Search
** ================================================================== 
*/

DoSearch:

call CheckVRexx;

if FToggle = 1 then do			/* if we are in the VIEW FOUND mode */
  msg.0 = 1
  msg.1 = " Not allowed from the VIEW FOUND mode"
  call VMsgBox "Warning", msg, 1
  return;
end;
  

/* Prompt user for search text */
prompt.0 = 1
prompt.1 = 'Enter the text to search for:'
prompt.vstring = ''
button = VInputBox('Text', prompt, 30, 3)
if button = 'CANCEL' then return
SearchText = prompt.vstring

/* if another search has already been performed, then free up that memory first */
if HasSearched = 1 then 
  drop SList. SResults.


/* Now do the initial search */
rc = SysFileSearch( SearchText, FName, 'SResults', 'N' )

/* report any errors */
if rc > 0 then do;
  msg.0 = 1
  msg.1 = '   Search Error '
  rb = VMsgBox('Search', msg, 1)
  return;
end;

if SResults.0 = 0 then do;
  msg.0 = 1
  msg.1 = '   No Matching Text Found'
  rb = VMsgBox('Search', msg, 1)
  return;
end;

/* And put them in a useful format */
SList.0 = SResults.0
do i = 1 to SResults.0
   call GetNum SResults.i
   SList.i    = num
   SResults.i = newText
end; /* do i = 1 to SResults.0 */

/* Position the cursor on the first one founds */
SCurPos = 0
HasSearched = 1
call DoNextSearch


/* And give user some info and choices */
  msg.0 = 7
  msg.1 = 'Found ' || SList.0 || ' Instances of Text'
  msg.2 = ''
  msg.3 = 'Search Commands:'
  msg.4 = '   N = Goto Next Found Line'
  msg.5 = '   P = Goto Previous Found Line'
  msg.6 = '   W = Write List to disk'
  msg.7 = '   V = Toggle View Found Lines Only'
  rb = VMsgBox('Search Results', msg, 1)

/* and then return */
return;



/* ================================================================== 
** Get the line number for a search result and return it (part of SEARCH)
** ================================================================== 
*/

GetNum:

parse arg line;
rev 	  = REVERSE( line );
lst 	  = LASTPOS( ' ', rev );
rgt 	  = RIGHT( rev, LENGTH(rev) - lst );
num 	  = reverse( rgt );		/* just the line number */
newText = RIGHT( line, lst );		/* the line w/o the line number */
return;




/* ================================================================== 
** Show the next item in the found search list
** ================================================================== 
*/

DoNextSearch:

call CheckVRexx;

if FToggle = 1 then do			/* if we are in the VIEW FOUND mode */
  msg.0 = 1
  msg.1 = " Not allowed from the VIEW FOUND mode"
  call VMsgBox "Warning", msg, 1
  return;
end;


/* has any search been performed? */
if HasSearched = 0 then do;
  msg.0 = 1
  msg.1 = "  No Search Has Been Performed! "
  rb = VMsgBox("Show Next Found Line", msg, 1)
  return;
end;


SCurPos = SCurPos + 1
if SCurPos > SList.0 then do;
  msg.0 = 1
  msg.1 = '   Bottom of Document Reached '
  rb = VMsgBox('Search Results', msg, 1)
  return;
end;

if bShowCursor = Yes then do;
   Cursor   = 11;		/* sort of in the middle of the screen */
   CurrLine = SList.SCurPos - 10;
   if CurrLine < 1 then do;
      CurrLine = 1;
      Cursor   = SList.SCurPos;
      end;
   call DisplayData;
   return;
end;

if bShowCursor = No then do;
   if SList.SCurPos > 10 then do;
     CurrLine = SList.SCurPos - 10;
     call DisplayData;
     temp = SList.SCurPos;
     call ScrDisplay  12 Yes TRANSLATE(LineArray.Temp, OUTR, INTR)
     end;
   else do;
     CurrLine = 1;
     call DisplayData;
     temp = SList.SCurPos;
     call ScrDisplay  temp+1 Yes TRANSLATE(LineArray.Temp, OUTR, INTR)
     end;
   ReDraw = No;
   NoStatus = Yes;
   return;
 end;

return;




/* ================================================================== 
** Show the last item in the found search list
** ================================================================== 
*/

DoLastSearch:

call CheckVRexx;

if FToggle = 1 then do			/* if we are in the VIEW FOUND mode */
  msg.0 = 1
  msg.1 = " Not allowed from the VIEW FOUND mode"
  call VMsgBox "Warning", msg, 1
  return;
end;


/* has any search been performed? */
if HasSearched = 0 then do;
  msg.0 = 1
  msg.1 = "  No Search Has Been Performed! "
  rb = VMsgBox("Show Previous Found Line", msg, 1)
  return;
end;


SCurPos = SCurPos - 1
if SCurPos < 1 then do;
  msg.0 = 1
  msg.1 = '   Top of Document Reached '
  rb = VMsgBox('Search Results', msg, 1)
  return;
end;

if bShowCursor = Yes then do;
   Cursor   = 11;		/* sort of in the middle of the screen */
   CurrLine = SList.SCurPos - 10;
   if CurrLine < 1 then do;
      CurrLine = 1;
      Cursor   = SList.SCurPos;
      end;
   call DisplayData;
   return;
end;

if bShowCursor = No then do;
   if SList.SCurPos > 10 then do;
     CurrLine = SList.SCurPos - 10;
     call DisplayData;
     temp = SList.SCurPos;
     call ScrDisplay  12 Yes TRANSLATE(LineArray.Temp, OUTR, INTR)
     end;
   else do;
     CurrLine = 1;
     call DisplayData;
     temp = SList.SCurPos;
     call ScrDisplay  temp+1 Yes TRANSLATE(LineArray.Temp, OUTR, INTR)
     end;
   ReDraw = No;
   NoStatus = Yes;
   return;
 end;

return;




/* ================================================================== 
** DoWriteResults       (Write search results to disk)
** ================================================================== 
*/

DoWriteResults:

call CheckVRexx;

if SList.0 = 0 then do;
  msg.0 = 1
  msg.1 = "  No Search Results to Write!"
  rb = VMsgBox("Write Search Results", msg, 1)
  return;
end;

/* get a filename */
button = VFileBox('Select file to write results to:', '*.*', 'file')
if button = 'CANCEL' then return;
TFName = file.vstring

/* see if the file already exits */
rc=SysFileTree(TFName, xme, 'F', '*****','*****')
if xme.0 = 0 then signal WRITEIT

/* since it already exits, prompt for desired action */
msg.0 = 3
msg.1 = "Overwrite file ["||FILESPEC("name",TFName)||"]"
msg.2 = "Append to file ["||FILESPEC("name",TFName)||"]"
msg.3 = "Abort operation (do not write)          "
msg.vstring = msg.1					/* the default */
button = VRadioBox('File Already Exists!', msg, 1)

/* now take the approprite action */
if msg.vstring = msg.1 then		/* delete the old file first */
  rc = SysFileDelete(TFName)
if msg.vstring = msg.2 then 
  signal WRITEIT			/* no action required -- will overwrite */
if msg.vstring = msg.3 then
  return;				/* changed their mind -- return */

/* now write the results */
WRITEIT:
'@echo off'
do i = 1 to SResults.0
  irc=lineout(TFName, SResults.i);
end;
irc = Stream(TFName, 'c', 'close')

/* and show use that is was done */
msg.0 = 1
msg.1 = ' ' || SList.0 || ' Lines Written to File ' || TFName
rb = VMsgBox('Search Results', msg, 1)
return;




/* ================================================================== 
** Toggle View Found Lines Only
** ================================================================== 
*/

ToggleFound:

/* see if there are any search results! */
if HasSearched = 0 then do;
  call CheckVRexx;
  msg.0 = 1
  msg.1 = "  No Search Results to View! "
  rb = VMsgBox("Write Search Results", msg, 1)
  return;
end;


/* Switch ON (start to show only found lines) */
if FToggle = 0	then do;		/* is View Found Lines Only OFF */
  do i = 0 to Bottom			/* copy the file into temp space */
    tempArray.i = LineArray.i
  end;  /* do i = 0 to Bottom */
  tempBottom = Bottom;		/* and save the other vars, too */
  do i = 1 to SResults.0			/* copy the search results to the view screen */
    LineArray.i = SResults.i
  end;  /* do i = 1 to SResults.0 */
  Bottom = SResults.0			/* and reset other vars */
  CurrLine = 1
  if bShowCursor = Yes then
    Cursor = 1;
end;  /* if FToggle = 0	then do; */

/* Switch OFF (go back to normal display) */
if FToggle = 1	then do;		/* is View Found Lines Only ON */
  do i = 1 to tempBottom		/* copy file back into line array */
    LineArray.i = tempArray.i
  end;  /*  do i = 1 to tempBottom  */
  Bottom = tempBottom		/* and reset other vars */
  CurrLine = 1
  if bShowCursor = Yes then
    Cursor = 1;
  drop tempArray.			/* free up memory */
end;  /* if FToggle = 1 then do; */

/* now flip the toggle indicator switch */
if FToggle = 1 then
   FToggle = 0
else
   FToggle = 1

return;






/* ================================================================== 
** DoEdit     (Call OS/2 editor for the file being viewed.)
** ================================================================== 
*/

DoEdit:

/* Make sure that is what the user really wants */
call CheckVRexx;
msg.0 = 1
msg.1 = "  Edit this file?"
rb = VMsgBox('Help', msg, 3)
if rb = "CANCEL" then return;	

/* call the system editor with for the file */
'E 'FName

/* and then re-load the file (in case it changed) */
call READ

/* and then return to calling routine */
return;





/* ================================================================== 
** DoGoto           (Goto a specified line number in the file)
** ================================================================== 
*/

DoGoto:

/* Make sure that is what the user really wants */
call CheckVRexx;
prompt.0 = 1
prompt.1 = '  Enter line number:      '
prompt.vstring = ''
button = VInputBox('Goto', prompt, 20, 3)
if button = 'CANCEL' then return
LineNumber = prompt.vstring

/* make sure it is in bounds */
if LineNumber < 1 | LineNumber > Bottom then do;
  msg.0 = 1
  msg.1 = "  Line number out of range!"
  rb = VMsgBox('Error', msg, 1)
  return;
end;

/* otherwise, goto that line number and redisplay screen */
CurrLine = LineNumber
if bShowCursor = Yes then
  Cursor = 1;
return;






/* ================================================================== 
** MarkToBook                          (Mark a line and add to the book mark list)
** ================================================================== 
*/

MarkToBook:

/* first, setup VRexx calls */
call CheckVRexx;

/* if the cursor is not on, how can the select a line? */
if bShowCursor = 0 then do;
  msg.0 = 1
  msg.1 = "  Cursor must be on to mark lines!"
  call VMsgBox "Mark Line to BookMark", msg, 1
  return;
end;

/* then add the line to the bookmark list */
temp1 = BookMark.rows + 1
temp2 = CurrLine + Cursor - 1
BookMark.temp1.1 = CurrLine + Cursor - 1
BookMark.temp1.2 = LEFT(LineArray.temp2, 70)
BookMark.rows = BookMark.rows + 1

return;




/* ================================================================== 
** UnMarkBook                          (un-Mark a line from the book mark list)
** ================================================================== 
*/

UnMarkBook:

/* first, setup VRexx calls */
call CheckVRexx;

/* is the bookmark empty? */
if BookMark.rows = 0 then do;
  msg.0 = 1
  msg.1 = "  No lines marked "
  call VMsgBox "BookMark", msg, 1
  return;
end;

/* get the current line and see if it is in the bookmark */
temp1 = CurrLine + Cursor - 1		/* the line we are on now */
found = 0
do i = 1 to BookMark.rows
   if BookMark.i.1 = temp1 then do;
      found = i 
      leave
   end;
end;  /* do i = 1 to BookMark.rows */

/* did we find it? */
if found = 0 then do;
  msg.0 = 1
  msg.1 = "  That line is not marked! "
  call VMsgBox "UnMark Line", msg, 1
  return;
end;

/* unmark the line */
do i = found to BookMark.rows		/* move data up one row */
  nxt = i + 1
  BookMark.i.1 = BookMark.nxt.1
  BookMark.i.2 = BookMark.nxt.2
end;   /* do i = found to BookMark.rows */
BookMark.rows = BookMark.rows - 1		/* now one less row */

/* and return */
return;




/* ================================================================== 
** ShowBookMark 				(Display the BookMark List)
** ================================================================== 
*/

ShowBookMark:

MarkToBook:

/* first, setup VRexx calls */
call CheckVRexx;

/* make sure that at least one line has been entered */
if BookMark.rows = 0 then do;
  msg.0 = 1
  msg.1 = "  No lines marked "
  call VMsgBox "BookMark", msg, 1
  return;
end;

/* show it */
button = VTableBox("BookMark List", BookMark, 1, 75, 10, 3)
if button = "CANCEL" then return;

/* go to the selected line */
temp1 = BookMark.vstring
temp2 = BookMark.temp1.1
Cursor   = 11;	
CurrLine = temp2 - 10;
if CurrLine < 1 then do;
  CurrLine = 1;
  Cursor   = temp2;
end;
call DisplayData;

/* and return */
return;




/* ================================================================== 
** WriteBook       		(Write marked lines to disk)
** ================================================================== 
*/

WriteBook:

call CheckVRexx;

if BookMark.rows = 0 then do;
  msg.0 = 1
  msg.1 = "  No Marked Lines to Write!"
  rb = VMsgBox("Write Marked Lines", msg, 1)
  return;
end;

/* get a filename */
button = VFileBox('Select file to write marked lines to:', '*.*', 'file')
if button = 'CANCEL' then return;
TFName = file.vstring

/* see if the file already exits */
rc=SysFileTree(TFName, xme, 'F', '*****','*****')
if xme.0 = 0 then signal WRITEIT2

/* since it already exits, prompt for desired action */
msg.0 = 3
msg.1 = "Overwrite file ["||FILESPEC("name",TFName)||"]"
msg.2 = "Append to file ["||FILESPEC("name",TFName)||"]"
msg.3 = "Abort operation (do not write)          "
msg.vstring = msg.1					/* the default */
button = VRadioBox('File Already Exists!', msg, 1)

/* now take the approprite action */
if msg.vstring = msg.1 then		/* delete the old file first */
  rc = SysFileDelete(TFName)
if msg.vstring = msg.2 then 
  signal WRITEIT2			/* no action required -- will overwrite */
if msg.vstring = msg.3 then
  return;				/* changed their mind -- return */

/* now write the results */
WRITEIT2:
'@echo off'
do i = 1 to BookMark.rows;
  temp = BookMark.i.1
  irc=lineout(TFName, LineArray.temp);
end;
irc = Stream(TFName, 'c', 'close')

/* and show use that is was done */
msg.0 = 1
msg.1 = ' ' || BookMark.rows || ' Lines Written to File ' || TFName
rb = VMsgBox('Write Marked Lines', msg, 1)
return;






/* ================================================================== 
** DoHelp (Display help screens)
** ================================================================== 
*/

DoHelp:

/* first, setup VRexx calls */
call CheckVRexx;

/* Show help screen */

msg.0 = 9
msg.1 = "CURSOR MOVEMENT/SCROLLING"
msg.2 = ""
msg.3 = "  Page Up/Down            = PgUp/PgDn"
msg.4 = "  Top of Document          = Home"
msg.5 = "  Bottom of Document      = End"
msg.6 = "  Scroll                      = Up/Down"
msg.7 = "  Toggle Cursor On/Off     = C"
msg.8 = "  Goto to line number       = G"
msg.9 = "  Exit Program              = ESC"
rb = VMsgBox(ProgName"      Help - Page 1 of 5", msg, 3)
if rb = "CANCEL" then return;	/* do they want to see more? */

msg.0 = 7
msg.1 = "SEARCH COMMANDS"
msg.2 = ""
msg.3 = "  Perform a new Search      = S"
msg.4 = "  Go to Next Found Line      = N or +"
msg.5 = "  Go to Previous Found Line = P or -"
msg.6 = "  Write Search Results       = W"
msg.7 = "  Toggle View Found Only    = V"
rb = VMsgBox(ProgName"      Help - Page 2 of 5", msg, 3)
if rb = "CANCEL" then return;	/* do they want to see more? */

msg.0 = 6
msg.1 = "BOOKMARK COMMANDS"
msg.2 = ""
msg.3 = "  Mark Line to BookMark      = M"
msg.4 = "  Unmark Line from BookMark = U"
msg.5 = "  Show BookMark List         = B"
msg.6 = "  Write Marked Lines to Disk = D"
rb = VMsgBox(ProgName"      Help - Page 4 of 3", msg, 3)
if rb = "CANCEL" then return;	/* do they want to see more? */

msg.0 = 4
msg.1 = "OTHER COMMANDS"
msg.2 = ""
msg.3 = "  Edit document             = E"
msg.4 = "  Exit Program              = ESC"
rb = VMsgBox(ProgName"      Help - Page 4 of 5", msg, 3)
if rb = "CANCEL" then return;	/* do they want to see more? */

msg.0 = 10
msg.1 = "Usage:"
msg.2 = "    B [options] [filename or filespec]"
msg.3 = ""
msg.4 = "Options:   +option or -option"
msg.5 = "    s = Show cursor (OFF)"
msg.6 = "    w = Wrap long lines (OFF)"
msg.7 = "    b = kill groups of Blank lines (OFF)"
msg.8 = ""
msg.9 = "Filename:"
msg.10= "  e.g. c:\config.sys OR c:\docs\*.txt"
rb = VMsgBox(ProgName"      Help - Page 5 of 4", msg, 1)


return;
end;




/* ================================================================== 
** Exit Code and Error Traps
** ================================================================== 
*/

CLEAN_E:	/* an error occured */
  ErrorFlag = "Error"
  Signal CLEANUP

CLEAN_EI:
  ErrorFlag = "Init"
  UsesVRexx = Yes
  signal CLEANUP

CLEAN_EF:
  ErrorFlag = "Failure"
  Signal CLEANUP

CLEAN_EH:
  ErrorFlag = "Halt"
  signal CLEANUP

CLEAN_ES:
  ErrorFlag = "Syntax"
  signal CLEANUP


CLEANUP:	/* normal exit */
if UsesVRexx = Yes then
   call VExit				/* clean up VRexx stuff */
FgColr    = 40				/* restore default colors */
SBgColr  = 40
RowNr   = 1
LineData = "Test Pattern"
irc=CHAROUT(,"["RowNr";1H["Bright";"FgColr";"SBgColr"m[K"LineData"["RowNr";1H");  /* set the colors to the correct default */
call SysCls
call SysCurState 'ON'			/* turn the cursor back on */
irc  = CHAROUT(,screen)		/* restore the original screen */
pos = SysCurPos(OrigRow, OrigCol)	/* and cursor position */
if ErrorFlag \= "" then 
  say "An Error Occurred. Type = " ErrorFlag
exit;
