/*******************************************************/
/* Set error traps to force clean up on failures       */
/*******************************************************/
Signal On Failure Name CLEANUP
Signal On Halt Name CLEANUP
Signal On Syntax Name CLEANUP

/*******************************************************/
/*  Initialize Visual REXX button values               */
/*******************************************************/
Ok         = 1
Cancel     = 2
OkOrCancel = 3
Yes        = 4
No         = 5
YesOrNo    = 6

/*******************************************************/
/*  Set up a conditional loop.                         */
/*******************************************************/
eoj = 0
Do Until eoj

/*******************************************************/
/*  Initialize Visual REXX environment                 */
/*******************************************************/
   Call RxFuncAdd 'VInit', 'VREXX', 'VINIT'
   initcode = VInit()
   If initcode = 'ERROR' Then
      signal CLEANUP
   Call VDialogPos 50, 50 /* All dialog boxes centered */

/*******************************************************/
/*  Allow the user to select which BackMaster Function */
/*  to execute this time around.                       */
/*******************************************************/
   type.0 = 5
   type.1 = 'Full Backup of all partitions'
   type.2 = 'Incremental Backup of all partitions  '
   type.3 = 'Quick Erase Cartridges'
   type.4 = 'Format Cartridges'
   type.5 = 'Display BackMaster Log'
   choice = VRadioBox('Select Backup Type', type, OkOrCancel)
   Call VExit
   If choice = 'OK' Then
      Do
         Select
            When type.vstring = type.1 Then
               Do
                  Call FullBkup
                  eoj = 1
               End
            When type.vstring = type.2 Then
               Do
                  Call IncrBkup
                  eoj = 1
               End
            When type.vstring = type.3 Then
               Call ZapTapes
            When type.vstring = type.4 Then
               Call TpFormat
            When type.vstring = type.5 Then
               Call BMLog
            Otherwise
               Nop
         End
      End
   Else
      eoj = 1
End
Exit
CLEANUP:
   Call VExit
   Exit
