/***************************************************/
/* REXX Procedure to display the current           */
/* BackMaster Log File.                            */
/***************************************************/
'@ECHO OFF'
editor = 'EPM.EXE'

/***************************************************/
/* Initialize REXXUtil environment (if not present)*/
/***************************************************/
rxload = RxFuncQuery('SysLoadFuncs')
If rxload Then
   Do
      Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      Call sysloadfuncs
   End

/***************************************************/
/*  Locate the active BackMaster directory         */
/***************************************************/
bmname = SysSearchPath('PATH', 'BACKMAST.EXE')
If bmname \= '' Then
   Do
      bmdrive = Filespec('D', bmname)
      bmpath = Filespec('P', bmname)
      bmpath = bmdrive||bmpath

/***************************************************/
/*  Launch the Enhanced editor to view the log.    */
/***************************************************/
      'START /WIN' editor bmpath||'BACKMAST.LOG'
   End

/*******************************************************/
/*  If RexxUtil loaded, drop it before ending.         */
/*******************************************************/
If rxload Then
   Call SysDropFuncs

Exit
