/*------------------------------------------------------------------------*\
|                                                                          |
|           9603LS01.CMD - Version 1.0 - Version Date 1995-12-02           |
|                 Copyright (C) 1995 by C F S Nevada, Inc.                 |
|                                                                          |
|                  by Dick Goran  - Voice    702-732-9616                  |
|                                 - FAX      702-732-3847                  |
|                                 - CIS      71154,2002                    |
|                                 - Internet dgoran@cfsrexx.com            |
|                                 - WWW      <http://www.cfsrexx.com>      |
|                                                                          |
| ------------------------------------------------------------------------ |
|                Requires: WPTOOLS.DLL  - (c) Henk Kelder                  |
\*------------------------------------------------------------------------*/
/*

   Add all Connect-related .INF and .HLP files on the boot drive that
   are not currently referenced in <WP_INFO> or certain other folders to
   a the <WP_INFO> folder (.INF) or a new folder (.HLP).

   A description of this program is contained in The REXX Column, OS/2
   Magazine - March, 1996. (h:\os2-mag\9603ls01.cmd)

*/                                                                /* 0024 */
GBL. = ''             /* initialize stem */                       /* 0025 */
parse Arg             GBL.command_line                            /* 0026 */
parse Version         GBL.REXX_version,                           /* 0027 */
                      GBL.REXX_version_level,                     /* 0028 */
                      GBL.REXX_version_day,                       /* 0029 */
                      GBL.REXX_version_month,                     /* 0030 */
                      GBL.REXX_version_year .                     /* 0031 */
parse upper Source    GBL.operating_system,                       /* 0032 */
                      GBL.calling_environment,                    /* 0033 */
                      GBL.program_path_and_name                   /* 0034 */
GBL.environment     = 'OS2ENVIRONMENT'                            /* 0035 */
GBL.boot_drive      = LEFT( VALUE( 'RUNWORKPLACE',, GBL.environment ), 2 )
GBL.program_version = 1.0           /* version / mod of this program */
GBL.program_name    = STRIP( FILESPEC( 'N', GBL.program_path_and_name ) )
GBL.program_path    = STRIP( FILESPEC( 'D', GBL.program_path_and_name ) ||,
                             FILESPEC( 'P', GBL.program_path_and_name ) )
                                                                  /* 0041 */
parse var GBL.program_name,                                       /* 0042 */
   GBL.program_fn '.',                                            /* 0043 */
   GBL.program_fe                                                 /* 0044 */
call TIME 'E'                       /* set elapsed timer - sssss.uuuuu */
say 'Begin' GBL.program_name 'at' TIME('N')                       /* 0046 */
                                                                  /* 0047 */
/*---------------*\                                               /* 0048 */
|  Register APIs  |                                               /* 0049 */
\*---------------*/                                               /* 0050 */
/* REXXUTIL */                                                    /* 0051 */
if RxFuncQuery( 'SysLoadFuncs' ) = 0 then                        /* 0052 */
   do                                                             /* 0053 */
      call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'   /* 0054 */
      call SysLoadFuncs                                           /* 0055 */
   end                                                            /* 0056 */
                                                                  /* 0057 */
/* WPTOOLS */                                                     /* 0058 */
if RxFuncQuery( 'WPToolsLoadFuncs' ) = 0 then                    /* 0059 */
   do                                                             /* 0060 */
      call RxFuncAdd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
      call WPToolsLoadFuncs                                       /* 0062 */
   end                                                            /* 0063 */
                                                                  /* 0064 */
/*------------------------*\                                      /* 0065 */
|  Enable trap processing  |                                      /* 0066 */
|    if REXXLIB present    |                                      /* 0067 */
\*------------------------*/                                      /* 0068 */
   SIGNAL ON ERROR                                                /* 0069 */
   SIGNAL ON FAILURE                                              /* 0070 */
   SIGNAL ON HALT                                                 /* 0071 */
   SIGNAL ON NOVALUE                                              /* 0072 */
   SIGNAL ON SYNTAX                                               /* 0073 */
                                                                  /* 0074 */
/*----------------------*\                                        /* 0075 */
|  Miscellaneous values  |                                        /* 0076 */
\*----------------------*/                                        /* 0077 */
GBL.connect_related_directories =,                                /* 0078 */
   'GRPWARE',                                                     /* 0079 */
   'IBMCOM',                                                      /* 0080 */
   'IBMLAN',                                                      /* 0081 */
   'LANLK',                                                       /* 0082 */
   'MPTN',                                                        /* 0083 */
   'MUGLIB',                                                      /* 0084 */
   'NSC',                                                         /* 0085 */
   'TCPIP',                                                       /* 0086 */
   'WAL',                                                         /* 0087 */
   ''                                                             /* 0088 */
                                                                  /* 0089 */
p=0                                                               /* 0090 */
p=p+1; GBL.path_list.p = TRANSLATE( VALUE( 'BOOKSHELF',, GBL.environment) )
p=p+1; GBL.path_list.p = TRANSLATE( VALUE( 'HELP',,      GBL.environment) )
p=p+1; GBL.path_list.p = TRANSLATE( VALUE( 'ETC',,       GBL.environment) )
p=p+1; GBL.path_list.p = TRANSLATE( VALUE( 'DPATH',,     GBL.environment) )
p=p+1; GBL.path_list.p = TRANSLATE( VALUE( 'PATH',,      GBL.environment) )
       GBL.path_list.0 = p                                        /* 0096 */
                                                                  /* 0097 */
GBL.warp        = ( RxFuncQuery( 'SysMoveObject' ) = 0 )          /* 0098 */
GBL.warp_peer   = ( SysIni( 'USER', 'PM_Workplace:Location', 'WP_PEER' ) = '' )
                                                                  /* 0100 */
lowercase     ='abcdefghijklmnopqrstuvwxyz'                       /* 0101 */
uppercase     ='ABCDEFGHIJKLMNOPQRSTUVWXYZ'                       /* 0102 */
                                                                  /* 0103 */
view_path_and_file_name =,                                        /* 0104 */
   SysSearchPath( 'PATH', 'VIEW.EXE' )                            /* 0105 */
viewhelp_path_and_file_name =,                                    /* 0106 */
   SysSearchPath( 'PATH', 'VIEWHELP.EXE' )                        /* 0107 */
                                                                  /* 0108 */
/*------------------------------------------------------------*\  /* 0109 */
|  Get current contents of the Information (<WP_INFO>) folder  |  /* 0110 */
\*------------------------------------------------------------*/  /* 0111 */
/* info_stem will contain either an object ID or a handle */      /* 0112 */
info_object_id = '<WP_INFO>'                                      /* 0113 */
                                                                  /* 0114 */
say '   Extracting contents of' info_object_id                    /* 0115 */
call WPToolsFolderContent info_object_id, 'info_stem'             /* 0116 */
if RESULT = 1 then                                               /* 0117 */
   do                                                             /* 0118 */
      say '   Unable to get contents of' info_object_id           /* 0119 */
      call EOJ                                                    /* 0120 */
   end                                                            /* 0121 */
                                                                  /* 0122 */
/*---------------------------------------------------------*\     /* 0123 */
|  Extract name of .INF or .HLP file from <WP_INFO> object  |     /* 0124 */
\*---------------------------------------------------------*/     /* 0125 */
existing_inf_hlp_table. = ''        /* associative array of INF & HLP files */
                                                                  /* 0127 */
do i = 1 to info_stem.0                                           /* 0128 */
                                                                  /* 0129 */
   /*---------------------------------------------*\              /* 0130 */
   |  Get contents (i.e. setup string) for object  |              /* 0131 */
   \*---------------------------------------------*/              /* 0132 */
   call WPToolsQueryObject info_stem.i, 'class', 'title', 'setup', 'location'
   if RESULT = 1 then                                            /* 0134 */
      do                                                          /* 0135 */
         say '   Unable to retrieve contents of' info_stem.i      /* 0136 */
         iterate i                                                /* 0137 */
      end                                                         /* 0138 */
                                                                  /* 0139 */
   /*-------------------------------------------------------*\    /* 0140 */
   |  Find .INF file name used as parameter to VIEW.EXE      |    /* 0141 */
   |                         or                              |    /* 0142 */
   |       .HLP file name used as parameter to VIEWHELP.EXE  |    /* 0143 */
   \*-------------------------------------------------------*/    /* 0144 */
   uppercase_setup = TRANSLATE( setup )                           /* 0145 */
   implied_file_extension = ''                                    /* 0146 */
   select                                                         /* 0147 */
      when POS( 'EXENAME=VIEWHELP', uppercase_setup ) > 0 then    /* 0148 */
         do                                                       /* 0149 */
            implied_file_extension = 'HLP'                        /* 0150 */
         end                                                      /* 0151 */
      when POS( 'EXENAME=VIEW', uppercase_setup ) > 0 then        /* 0152 */
         do                                                       /* 0153 */
            implied_file_extension = 'INF'                        /* 0154 */
         end                                                      /* 0155 */
      otherwise                                                   /* 0156 */
         do                                                       /* 0157 */
            iterate i                                             /* 0158 */
         end                                                      /* 0159 */
   end                                                            /* 0160 */
                                                                  /* 0161 */
   /*---------------------------------*\                          /* 0162 */
   |  Get file name used as parameter  |                          /* 0163 */
   \*---------------------------------*/                          /* 0164 */
   parse value uppercase_setup with,                              /* 0165 */
      'PARAMETERS=',                                              /* 0166 */
      parameter_value,                                            /* 0167 */
      ';'                                                         /* 0168 */
   parse value FILESPEC( 'N', parameter_value ) with,             /* 0169 */
      parameter_fn,                                               /* 0170 */
      '.',                                                        /* 0171 */
      parameter_fext                                              /* 0172 */
   select                                                         /* 0173 */
      when parameter_fext = '' then                               /* 0174 */
         do                                                       /* 0175 */
            /* supply implied file extension */                   /* 0176 */
            parameter_value =,                                    /* 0177 */
               parameter_value || '.' || implied_file_extension   /* 0178 */
         end                                                      /* 0179 */
      when WORDS( parameter_fext ) > 1 then                       /* 0180 */
         do                                                       /* 0181 */
            /* drop additional parameters */                      /* 0182 */
            parameter_fext =,                                     /* 0183 */
               WORD( parameter_fext, 1 )                          /* 0184 */
            parameter_value =,                                    /* 0185 */
               parameter_fn || '.' || parameter_fext              /* 0186 */
         end                                                      /* 0187 */
      otherwise                                                   /* 0188 */
         nop                                                      /* 0189 */
   end                                                            /* 0190 */
                                                                  /* 0191 */
   /*------------------------------------------------------*\     /* 0192 */
   |  Add full path of INF / HLP file to associative array  |     /* 0193 */
   |  of objects referenced with Information folder         |     /* 0194 */
   \*------------------------------------------------------*/     /* 0195 */
   /* SysSearchPath() can not be used */                          /* 0196 */
   parameter_path =,                                              /* 0197 */
      FILESPEC( 'D', parameter_value ) ||,                        /* 0198 */
      FILESPEC( 'P', parameter_value )                            /* 0199 */
   if parameter_path = '' then                                   /* 0200 */
      do                                                          /* 0201 */
         existing_inf_hlp_table.PARAMETER_VALUE = i               /* 0202 */
      end                                                         /* 0203 */
   else                                                           /* 0204 */
      do                                                          /* 0205 */
         say COPIES( ' ', 6 ) || 'Searching for path for' parameter_value
         call ADD_FULL_PATHED_INF_HLP_TO_ASSOCIATIVE_ARRAY parameter_value
      end                                                         /* 0208 */
                                                                  /* 0209 */
end                                                               /* 0210 */
                                                                  /* 0211 */
/*------------------------------------------------------------------------*\
|                                                                          |
|     Build combined stem of all .INF & .HLP files in Connect-related      |
|                               directories                                |
|                                                                          |
\*------------------------------------------------------------------------*/
combined_stem.0 = 0                                               /* 0218 */
                                                                  /* 0219 */
do w = 1 to WORDS( GBL.connect_related_directories )              /* 0220 */
   directory = WORD( GBL.connect_related_directories, w )         /* 0221 */
   call ADD_HLP_INF_FILES_TO_COMBINED_STEM directory              /* 0222 */
end                                                               /* 0223 */
                                                                  /* 0224 */
/*---------------------------------*\                             /* 0225 */
|  Folder object for new HLP files  |                             /* 0226 */
\*---------------------------------*/                             /* 0227 */
hlp_folder_location = '<WP_DESKTOP>'                              /* 0228 */
hlp_folder_class    = 'WPFolder'                                  /* 0229 */
hlp_folder_title    = 'Connect related^HLP Files'                 /* 0230 */
hlp_folder_setup    =,                                            /* 0231 */
   'ALWAYSSORT=YES;'                        ||,                   /* 0232 */
   'ICONVIEW=FLOWED,MINI;'                  ||,                   /* 0233 */
   'OBJECTID=<' || hlp_folder_title || '>;' ||,                   /* 0234 */
   ''                                                             /* 0235 */
call SysCreateObject hlp_folder_class,,                           /* 0236 */
                     hlp_folder_title,,                           /* 0237 */
                     hlp_folder_location,,                        /* 0238 */
                     hlp_folder_setup,,                           /* 0239 */
                     'REPLACE'                                    /* 0240 */
                                                                  /* 0241 */
                                                                  /* 0242 */
/*---------------------------------*\                             /* 0243 */
|  WPProgram setup for new objects  |                             /* 0244 */
\*---------------------------------*/                             /* 0245 */
hlp_location     = '<' || hlp_folder_title || '>'                 /* 0246 */
inf_location     = '<WP_INFO>'                                    /* 0247 */
                                                                  /* 0248 */
/*------------------------------------------*\                    /* 0249 */
|  Compare INF / HLP files with contents of  |                    /* 0250 */
|  WP_INFO folder and add non-existing item  |                    /* 0251 */
|  to new folder on Desktop                  |                    /* 0252 */
\*------------------------------------------*/                    /* 0253 */
say '   Adding new objects to' inf_location '/' hlp_location      /* 0254 */
new_object_count = 0                                              /* 0255 */
do i = 1 to combined_stem.0                                       /* 0256 */
                                                                  /* 0257 */
   parse upper value combined_stem.i with,                        /* 0258 */
      inf_hlp_date,                                               /* 0259 */
      inf_hlp_time,                                               /* 0260 */
      inf_hlp_size,                                               /* 0261 */
      inf_hlp_attr,                                               /* 0262 */
      inf_hlp_path_and_file_name                                  /* 0263 */
   inf_hlp_path_and_file_name = STRIP( inf_hlp_path_and_file_name )
                                                                  /* 0265 */
   /*-------------------------------------*\                      /* 0266 */
   |  Ignore entries alreday in <WP_INFO>  |                      /* 0267 */
   |  or other specific directories        |                      /* 0268 */
   \*-------------------------------------*/                      /* 0269 */
   if existing_inf_hlp_table.INF_HLP_PATH_AND_FILE_NAME = '' then
      do                                                          /* 0271 */
         iterate i                                                /* 0272 */
      end                                                         /* 0273 */
                                                                  /* 0274 */
   /*-------------------------------------*\                      /* 0275 */
   |  Extract title from .INF / .HLP file  |                      /* 0276 */
   \*-------------------------------------*/                      /* 0277 */
   call STREAM inf_hlp_path_and_file_name, 'C', 'OPEN READ'       /* 0278 */
   inf_hlp_area = CHARIN( inf_hlp_path_and_file_name, 1, 512)     /* 0279 */
   call STREAM inf_hlp_path_and_file_name, 'C', 'CLOSE'           /* 0280 */
                                                                  /* 0281 */
   if LEFT( inf_hlp_area, 3 ) = 'HSP' then                       /* 0282 */
      do                                                          /* 0283 */
         /* ignore unrecognizeable format */                      /* 0284 */
         iterate i                                                /* 0285 */
      end                                                         /* 0286 */
   hold_area = SUBSTR( inf_hlp_area, 108, 256 ) /* short for performance */
   parse value hold_area with,                                    /* 0288 */
      inf_hlp_title,                                              /* 0289 */
      '00'x                                                       /* 0290 */
                                                                  /* 0291 */
   /*----------------------------------------------------*\       /* 0292 */
   |  Edit title removing any necessary punctuation       |       /* 0293 */
   |  and adding file system name as second or only line  |       /* 0294 */
   \*----------------------------------------------------*/       /* 0295 */
   remove_characters = '<>*";'                                    /* 0296 */
   inf_hlp_title =,                                               /* 0297 */
      SPACE( TRANSLATE( inf_hlp_title,,                           /* 0298 */
                        COPIES( ' ', LENGTH(remove_characters) ),,
                        remove_characters ) )                     /* 0300 */
   if inf_hlp_title = '' then                                    /* 0301 */
      do                                                          /* 0302 */
         inf_hlp_title =,                                         /* 0303 */
            inf_hlp_title || '^' /* force second line */          /* 0304 */
      end                                                         /* 0305 */
   inf_hlp_title =,                                               /* 0306 */
      inf_hlp_title                                      ||,      /* 0307 */
      '(' || TRANSLATE( inf_hlp_path_and_file_name,,              /* 0308 */
                        lowercase, uppercase ) || ')'             /* 0309 */
                                                                  /* 0310 */
   /*-------------------------------------------*\                /* 0311 */
   |  Build WPProgram object for INF / HLP file  |                /* 0312 */
   \*-------------------------------------------*/                /* 0313 */
   if RIGHT( inf_hlp_path_and_file_name, 4 ) = '.HLP' then        /* 0314 */
      do                                                          /* 0315 */
         exe_name  = viewhelp_path_and_file_name                  /* 0316 */
         location  = hlp_location                                 /* 0317 */
         object_id = ''                                           /* 0318 */
      end                                                         /* 0319 */
   else                                                           /* 0320 */
      do                                                          /* 0321 */
         exe_name  = view_path_and_file_name                      /* 0322 */
         location  = inf_location                                 /* 0323 */
         object_id = 'OBJECTID=<' || inf_hlp_title || '>;'        /* 0324 */
      end                                                         /* 0325 */
   setup_string =,                                                /* 0326 */
      'CCVIEW=NO;'                                          ||,   /* 0327 */
      'ICONRESOURCE=60 PMWP;'                               ||,   /* 0328 */
      'EXENAME=' || exe_name || ';'                         ||,   /* 0329 */
      'PARAMETERS=' || inf_hlp_path_and_file_name || ';'    ||,   /* 0330 */
      object_id                                             ||,   /* 0331 */
      ''                                                          /* 0332 */
                                                                  /* 0333 */
   new_object_count = new_object_count + 1                        /* 0334 */
   say COPIES( ' ', 6 ) || 'Adding:' inf_hlp_title                /* 0335 */
   call SysCreateObject 'WPProgram',,                             /* 0336 */
                        inf_hlp_title,,                           /* 0337 */
                        location,,                                /* 0338 */
                        setup_string,                             /* 0339 */
                        'UPDATE'                                  /* 0340 */
   if RESULT = 1 then                                            /* 0341 */
      do                                                          /* 0342 */
         say '   Unable to create object for' inf_hlp_title       /* 0343 */
      end                                                         /* 0344 */
                                                                  /* 0345 */
end                                                               /* 0346 */
                                                                  /* 0347 */
/*--------------------------*\                                    /* 0348 */
|  Show total new objects &  |                                    /* 0349 */
|  open folders              |                                    /* 0350 */
\*--------------------------*/                                    /* 0351 */
if new_object_count > 0 then                                      /* 0352 */
   do                                                             /* 0353 */
      say COPIES( ' ', 3 ) ||,                                    /* 0354 */
          new_object_count ||,                                    /* 0355 */
          ' new objects added to' inf_location '/' hlp_location   /* 0356 */
      call SysOpenObject inf_location, 1, 1                       /* 0357 */
      call SysOpenObject hlp_location, 1, 1                       /* 0358 */
   end                                                            /* 0359 */
                                                                  /* 0360 */
call EOJ 0                                                        /* 0361 */
                                                                  /* 0362 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                Add .INF / .HLP file to associative array                 |
|                                                                          |
\*------------------------------------------------------------------------*/
ADD_FULL_PATHED_INF_HLP_TO_ASSOCIATIVE_ARRAY:                     /* 0368 */
   Procedure expose,                                              /* 0369 */
      GBL. existing_inf_hlp_table.                                /* 0370 */
                                                                  /* 0371 */
fn_fext = ARG(1)                                                  /* 0372 */
                                                                  /* 0373 */
do p = 1 to GBL.path_list.0                                       /* 0374 */
   path_names = GBL.path_list.p                                   /* 0375 */
   do while path_names = ''                                      /* 0376 */
      parse value path_names with,                                /* 0377 */
         token,                                                   /* 0378 */
         ';',                                                     /* 0379 */
         path_names                                               /* 0380 */
      call SysFileTree token || '\' || fn_fext, 'temp_stem', 'O'  /* 0381 */
      if temp_stem.0 = 1 then                                     /* 0382 */
         do                                                       /* 0383 */
            full_pathed_name = TRANSLATE( temp_stem.1 )           /* 0384 */
            existing_inf_hlp_table.FULL_PATHED_NAME = '*'         /* 0385 */
            return                                                /* 0386 */
         end                                                      /* 0387 */
   end                                                            /* 0388 */
end                                                               /* 0389 */
return                                                            /* 0390 */
                                                                  /* 0391 */
                                                                  /* 0392 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                  Add INF & HLP files to a combined stem                  |
|                                                                          |
\*------------------------------------------------------------------------*/
ADD_HLP_INF_FILES_TO_COMBINED_STEM:                               /* 0398 */
   Procedure expose,                                              /* 0399 */
      GBL. combined_stem.                                         /* 0400 */
                                                                  /* 0401 */
directory = '\' || ARG( 1 )                                       /* 0402 */
                                                                  /* 0403 */
/*---------------------------------------*\                       /* 0404 */
|  Find drive for specified path (Assume  |                       /* 0405 */
|  BOOK & HELP to be the same drive)      |                       /* 0406 */
\*---------------------------------------*/                       /* 0407 */
drive_letter_colon = ''                                           /* 0408 */
do p = 1 to GBL.path_list.0                                       /* 0409 */
   ptr = POS( directory, GBL.path_list.p )                        /* 0410 */
   if ptr > 0 then                                                /* 0411 */
      do                                                          /* 0412 */
         drive_letter_colon =,                                    /* 0413 */
            SUBSTR( GBL.path_list.p, ptr - 2, 2 )                 /* 0414 */
         leave p                                                  /* 0415 */
      end                                                         /* 0416 */
end                                                               /* 0417 */
                                                                  /* 0418 */
if drive_letter_colon = '' then                                   /* 0419 */
   do                                                             /* 0420 */
      say '   Unable to locate path of' directory                 /* 0421 */
      return                                                      /* 0422 */
   end                                                            /* 0423 */
                                                                  /* 0424 */
call SysFileTree drive_letter_colon ||directory || '\*.*',,       /* 0425 */
                 'temp_stem', 'FS'                                /* 0426 */
                                                                  /* 0427 */
do t = 1 to temp_stem.0                                           /* 0428 */
   parse upper value temp_stem.t with,                            /* 0429 */
      temp_date,                                                  /* 0430 */
      temp_time,                                                  /* 0431 */
      temp_size,                                                  /* 0432 */
      temp_attr,                                                  /* 0433 */
      temp_path_and_file_name                                     /* 0434 */
   temp_path_and_file_name = STRIP( temp_path_and_file_name )     /* 0435 */
                                                                  /* 0436 */
   temp_file_extension = RIGHT( temp_path_and_file_name, 3 )      /* 0437 */
   if temp_file_extension = 'HLP',                               /* 0438 */
         &,                                                       /* 0439 */
      temp_file_extension = 'INF' then                           /* 0440 */
      do                                                          /* 0441 */
         iterate t                                                /* 0442 */
      end                                                         /* 0443 */
                                                                  /* 0444 */
   c = combined_stem.0 + 1                                        /* 0445 */
   combined_stem.0 = c                                            /* 0446 */
   combined_stem.c = temp_stem.t                                  /* 0447 */
end                                                               /* 0448 */
                                                                  /* 0449 */
return                                                            /* 0450 */
                                                                  /* 0451 */
/*------------------------------------------------------------------------*\
|                                                                          |
|                                End of Job                                |
|                                                                          |
\*------------------------------------------------------------------------*/
EOJ:                                                              /* 0457 */
   Procedure expose,                                              /* 0458 */
      GBL.                                                        /* 0459 */
                                                                  /* 0460 */
if ARG() = 0 then                                                 /* 0461 */
   eoj_rc = 0                                                     /* 0462 */
else                                                              /* 0463 */
   eoj_rc = ARG(1)                                                /* 0464 */
                                                                  /* 0465 */
elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu */
parse value elapsed_time with seconds '.' micro_seconds           /* 0467 */
if LEFT( micro_seconds, 1, 1 ) >= 5 then                          /* 0468 */
   seconds = seconds + 1                                          /* 0469 */
ss = FORMAT( seconds // 60, 2 )                                   /* 0470 */
minutes = ( seconds - ss ) / 60                                   /* 0471 */
mm = FORMAT( minutes // 60, 2 )                                   /* 0472 */
hh = FORMAT( ( minutes - mm ) / 60, 2 )                           /* 0473 */
duration = hh':'mm':'ss                                           /* 0474 */
                                                                  /* 0475 */
program_name = TRANSLATE( FILESPEC( 'N', GBL.program_path_and_name ) )
say 'EOJ  ' program_name 'at' TIME('N') ||,                       /* 0477 */
    ', duration' TRANSLATE( duration, '0', ' ' )                  /* 0478 */
exit eoj_rc                                                       /* 0479 */
                                                                  /* 0480 */
                                                                  /* 0481 */
!tr!=VALUE('TRACE',,'OS2Environment'); if !tr!<>'' then do;TRACE(!tr!);nop;end
/*------------------------------------------------------------------------*\
|                                                                          |
|                              Trap Routines                               |
|                                                                          |
\*------------------------------------------------------------------------*/
ERROR:   call TRAP_PROCESSING SIGL, 'ERROR',   RC                 /* 0488 */
FAILURE: call TRAP_PROCESSING SIGL, 'FAILURE', RC                 /* 0489 */
HALT:    call TRAP_PROCESSING SIGL, 'HALT',    ''                 /* 0490 */
NOVALUE: call TRAP_PROCESSING SIGL, 'NOVALUE', ''                 /* 0491 */
SYNTAX:  call TRAP_PROCESSING SIGL, 'SYNTAX',  RC                 /* 0492 */
                                                                  /* 0493 */
/* Rev. 95/10/14 */                                               /* 0494 */
TRAP_PROCESSING:                                                  /* 0495 */
   parse Source . . TRAP.path_and_program                         /* 0496 */
   trap.line_nbr = ARG(1)                                         /* 0497 */
   if POS( ':', TRAP.path_and_program ) > 0 then                  /* 0498 */
      /* get source line if it is available */                    /* 0499 */
      do t = 1                                                    /* 0500 */
         trap_source_line.t =  SOURCELINE( trap.line_nbr )        /* 0501 */
         trap_source_line.0 = t                                   /* 0502 */
         trap.line_nbr      = trap.line_nbr + 1                   /* 0503 */
         if RIGHT( trap_source_line.t, 1 ) = ',' then            /* 0504 */
            do                                                    /* 0505 */
               leave                                              /* 0506 */
            end                                                   /* 0507 */
      end                                                         /* 0508 */
   else                                                           /* 0509 */
      /* program is running in macrospace */                      /* 0510 */
      do                                                          /* 0511 */
         TRAP.path_and_program = STRIP( DIRECTORY(), 'T', '\' ) || '\' ||,
                                 TRAP.path_and_program            /* 0513 */
         trap_source_line.1 = 'Source line is not available.'     /* 0514 */
         trap_source_line.0 = 1                                   /* 0515 */
      end                                                         /* 0516 */
                                                                  /* 0517 */
   parse value FILESPEC( 'N', TRAP.path_and_program ) with,       /* 0518 */
      TRAP.fn '.' TRAP.fe                                         /* 0519 */
   trap_file_name = FILESPEC( 'D', TRAP.path_and_program ) ||,    /* 0520 */
                    FILESPEC( 'P', TRAP.path_and_program ) ||,    /* 0521 */
                    TRAP.fn || '.' || 'DMP'                       /* 0522 */
                                                                  /* 0523 */
   /*------------------------------------------*\                 /* 0524 */
   |  check for reason not to create .DMP file  |                 /* 0525 */
   \*------------------------------------------*/                 /* 0526 */
   if ARG(2) = 'HALT' then                                        /* 0527 */
      do                                                          /* 0528 */
         trap_file_name = ''                                      /* 0529 */
      end                                                         /* 0530 */
   if RxFuncQuery( 'VARDUMP' ) <> 0 then                          /* 0531 */
      do                                                          /* 0532 */
         trap_file_name = ''                                      /* 0533 */
      end                                                         /* 0534 */
   if POS( ':', trap_file_name ) = 0 then                         /* 0535 */
      do                                                          /* 0536 */
         trap_file_name = ''                                      /* 0537 */
      end                                                         /* 0538 */
                                                                  /* 0539 */
   /*------------------------*\                                   /* 0540 */
   |  Build trap message box  |                                   /* 0541 */
   \*------------------------*/                                   /* 0542 */
   dbl.h    = 'CD'x                 /*  double line - horizontal   */
   dbl.v    = 'BA'x                 /*  double line - vertical     */
   dbl.bl   = 'C8'x                 /*  double line - bottom left  */
   dbl.br   = 'BC'x                 /*  double line - bottom right */
   dbl.tl   = 'C9'x                 /*  double line - top left     */
   dbl.tr   = 'BB'x                 /*  double line - top right    */
   trap.red = '1B'x || '[1;37;41m'  /* bright white on red          */
   trap.dul = '1B'x || '[0m'        /* reset to normal              */
                                                                  /* 0551 */
   say ' '                                                        /* 0552 */
   trap_error_description =,                                      /* 0553 */
      'Error line = ' || ARG(1) ||,                               /* 0554 */
      '; ' ||,                                                    /* 0555 */
      ARG(2) ||,                                                  /* 0556 */
      ' error.'                                                   /* 0557 */
   if ARG(3) <> '' then                                           /* 0558 */
      trap_error_description = trap_error_description ||,         /* 0559 */
                               '  Return code = ' || ARG(3)       /* 0560 */
   trap.width = MAX( 74, LENGTH( trap_error_description ) )       /* 0561 */
   say trap.red || dbl.tl || COPIES( dbl.h,trap.width + 2 ) || dbl.tr || trap.dul
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( TRAP.fn'.'TRAP.fe,trap.width )    dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( trap_error_description, trap.width ) dbl.v || trap.dul
   if trap_file_name <> '' then                                   /* 0566 */
      do                                                          /* 0567 */
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v     CENTER( 'See: ' || trap_file_name,,  /* 0569 */
                                     trap.width )  dbl.v  || trap.dul
      end                                                         /* 0571 */
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.bl || COPIES( dbl.h,trap.width + 2 ) || dbl.br || trap.dul
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul      /* 0574 */
   say trap.red || LEFT( 'Source line(s) at time of trap:', trap.width + 4 ) || trap.dul
   do t = 1 to trap_source_line.0                                 /* 0576 */
      say trap.red || LEFT( '   ' || trap_source_line.t, trap.width + 4 ) || trap.dul
   end                                                            /* 0578 */
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul      /* 0579 */
                                                                  /* 0580 */
   /*---------------------------------*\                          /* 0581 */
   |  Create .DMP file if appropriate  |                          /* 0582 */
   \*---------------------------------*/                          /* 0583 */
   if trap_file_name <> '' then                                   /* 0584 */
      do                                                          /* 0585 */
         call SysFileDelete trap_file_name                        /* 0586 */
         /* remove meaningless labels from dump for clarity */    /* 0587 */
         drop dbl. TRAP. RC RESULT SIGL !tr!                      /* 0588 */
         call VARDUMP trap_file_name  /* write variables to program.DMP file */
      end                                                         /* 0590 */
   exit 253                                                       /* 0591 */
/*---------  REXX Cross Reference  - Created: 12/10/95 4:54pm ----------*\
       H:\OS2-MAG\9603LS01.CMD - Directory time stamp 12/10/95 4:52p

---- VARIABLES ----
!tr!                0482<  0482   0482   0588
GBL.                0025<  0370   0400   0459
GBL.REXX_version    0027
GBL.REXX_version_day
                    0029
GBL.REXX_version_level
                    0028
GBL.REXX_version_month
                    0030
GBL.REXX_version_year
                    0031
GBL.boot_drive      0036<
GBL.calling_environment
                    0033
GBL.command_line    0026
GBL.connect_related_directories
                    0078<  0220   0221
GBL.environment     0035<  0036   0091   0092   0093   0094   0095
GBL.operating_system
                    0032
GBL.path_list.0     0096<  0374   0409
GBL.path_list.p     0091<  0092<  0093<  0094<  0095<  0375   0410   0414
GBL.program_fe      0044
GBL.program_fn      0043
GBL.program_name    0038<  0042   0046
GBL.program_path    0039<
GBL.program_path_and_name
                    0034   0038   0039   0040   0476
GBL.program_version
                    0037<
GBL.warp            0098<
GBL.warp_peer       0099<
RC                  0488   0489   0492   0588
RESULT              0117   0134   0341   0588
SIGL                0488   0489   0490   0491   0492   0588
TRAP.               0588
TRAP.fe             0519   0564
TRAP.fn             0519   0522   0564
TRAP.path_and_program
                    0496   0498   0512<  0513   0518   0520   0521
Version             0027
c                   0445<  0446
combined_stem.      0400
combined_stem.0     0218<  0256   0445   0446<
combined_stem.c     0447<
combined_stem.i     0258
dbl.                0588
dbl.bl              0545<  0573
dbl.br              0546<  0573
dbl.h               0543<  0562   0573
dbl.tl              0547<  0562
dbl.tr              0548<  0562
dbl.v               0544<  0563   0563   0564   0564   0565   0565   0568
                    0568   0569   0570   0572   0572
directory           0221<  0222   0402<  0410   0421   0425
drive_letter_colon  0408<  0413<  0419   0425
duration            0474<  0478
elapsed_time        0466<  0467
eoj_rc              0462<  0464<  0479
exe_name            0316<  0322<  0329
existing_inf_hlp_table.
                    0126<  0370
existing_inf_hlp_table.PARAMETER_VALUE
                    0202<
existing_inf_hlp_table.INF_HLP_PATH_AND_FILE_NAME
                    0270
existing_inf_hlp_table.FULL_PATHED_NAME
                    0385<
fn_fext             0372<  0381
full_pathed_name    0384<
hh                  0473<  0474
hlp_folder_class    0229<  0236
hlp_folder_location
                    0228<  0238
hlp_folder_setup    0231<  0239
hlp_folder_title    0230<  0234   0237   0246
hlp_location        0246<  0254   0317   0356   0358
hold_area           0287<  0288
i                   0128   0137   0158   0202   0256   0272   0285
implied_file_extension
                    0146<  0150<  0154<  0178
inf_hlp_area        0279<  0282   0287
inf_hlp_attr        0262
inf_hlp_date        0259
inf_hlp_path_and_file_name
                    0263   0264<  0264   0278   0279   0280   0308   0314
                    0330
inf_hlp_size        0261
inf_hlp_time        0260
inf_hlp_title       0289   0297<  0298   0301   0303<  0304   0306<  0307
                    0324   0335   0337   0343
inf_location        0247<  0254   0323   0356   0357
info_object_id      0113<  0115   0116   0119
info_stem.0         0128
info_stem.i         0133   0136
location            0317<  0323<  0338
lowercase           0101<  0309
micro_seconds       0467   0468
minutes             0471<  0472   0473
mm                  0472<  0473   0474
new_object_count    0255<  0334<  0334   0352   0355
object_id           0318<  0324<  0331
p                   0090<  0091<  0091   0092<  0092   0093<  0093   0094<
                    0094   0095<  0095   0096   0374   0409   0415
parameter_fext      0172   0174   0180   0183<  0184   0186
parameter_fn        0170   0186
parameter_path      0197<  0200
parameter_value     0167   0169   0177<  0178   0185<  0198   0199   0206
                    0207
path_names          0375<  0376   0377   0380
program_name        0476<  0477
ptr                 0410<  0411   0414
remove_characters   0296<  0299   0300
seconds             0467   0469<  0469   0470   0471
setup               0145
setup_string        0326<  0339
ss                  0470<  0471   0474
t                   0428   0442   0500   0502   0576
temp_attr           0433
temp_date           0430
temp_file_extension
                    0437<  0438   0440
temp_path_and_file_name
                    0434   0435<  0435   0437
temp_size           0432
temp_stem.0         0382   0428
temp_stem.1         0384
temp_stem.t         0429   0447
temp_time           0431
token               0378   0381
trap.dul            0550<  0562   0563   0564   0565   0568   0570   0572
                    0573   0574   0575   0577   0579
trap.line_nbr       0497<  0501   0503<  0503
trap.red            0549<  0562   0563   0564   0565   0568   0569   0572
                    0573   0574   0575   0577   0579
trap.width          0561<  0562   0563   0564   0565   0568   0570   0572
                    0573   0574   0575   0577   0579
trap_error_description
                    0553<  0559<  0559   0561   0565
trap_file_name      0520<  0529<  0533<  0535   0537<  0566   0569   0584
                    0586   0589
trap_source_line.0  0502<  0515<  0576
trap_source_line.1  0514<
trap_source_line.t  0501<  0504   0577
uppercase           0102<  0309
uppercase_setup     0145<  0148   0152   0165
view_path_and_file_name
                    0104<  0322
viewhelp_path_and_file_name
                    0106<  0316
w                   0220   0221
with                0165   0169   0258   0288   0377   0429   0467   0518
x                   0290   0543   0544   0545   0546   0547   0548   0549
                    0550

---- LABELS ----
ADD_FULL_PATHED_INF_HLP_TO_ASSOCIATIVE_ARRAY
                    0207   0368:
ADD_HLP_INF_FILES_TO_COMBINED_STEM
                    0222   0398:
EOJ                 0120   0361   0457:
ERROR               0069   0488:
FAILURE             0070   0489:
HALT                0071   0490:
NOVALUE             0072   0491:
RxFuncAdd           0054   0061
SYNTAX              0073   0492:
SysLoadFuncs        0055
SysOpenObject       0357   0358
TRAP_PROCESSING     0488   0489   0490   0491   0492   0495:
WPToolsFolderContent
                    0116
WPToolsLoadFuncs    0062
WPToolsQueryObject  0133

---- FUNCTIONS ----
ARG                 0372   0402   0461   0464   0497   0527   0554   0556
                    0558   0560
CENTER              0564   0565   0569
CHARIN              0279
COPIES              0206   0299   0335   0354   0562   0563   0568   0572
                    0573   0574   0579
DIRECTORY           0512
FILESPEC            0038   0039   0040   0169   0198   0199   0476   0518
                    0520   0521
FORMAT              0470   0472   0473
LEFT                0036   0282   0468   0575   0577
LENGTH              0299   0561
MAX                 0561
POS                 0148   0152   0410   0498   0535
RIGHT               0314   0437   0504
RxFuncQuery         0052   0059   0098   0531
SOURCELINE          0501
SPACE               0298
STREAM              0278   0280
STRIP               0038   0039   0264   0435   0512
SUBSTR              0287   0414
SysCreateObject     0236   0336
SysFileDelete       0586
SysFileTree         0381   0425
SysIni              0099
SysSearchPath       0105   0107
TIME                0045   0046   0466   0477
TRACE               0482
TRANSLATE           0091   0092   0093   0094   0095   0145   0298   0308
                    0384   0476   0478
VALUE               0036   0091   0092   0093   0094   0095   0482
VARDUMP             0589
WORD                0184   0221
WORDS               0180   0220

\*-------------------  End of REXX Cross Reference  -------------------*/
