/*****************************************************************************/
/* Lotus 1-2-3 For OS/2 sample @function. 											  */
/* 																								  */
/* @REXX("REXXMATH.CMD",op1,operator,op2)                                    */
/* 																								  */
/* Returns the arithmetic result of applying 'operator' to 'op1' and 'op2'.  */
/* Operator must be one of the REXX binary operators. 							  */
/* 																								  */
/* @REXX("REXXMATH.CMD logFileName",op1,operator,op2)                        */
/* 																								  */
/* Writes any TRACE or SAY output to a log file named 'logFileName'.         */
/* 																								  */
/* Copyright (c) 1991 Lotus Development Corporation.	This code is supplied  */
/* on an 'as is' basis as an example only.  This code has only received      */
/* informal testing by Lotus.  Permission is granted	to copy and modify	  */
/* this code to your heart's content.  No warrenties expressed or implied.   */
/* Remember, your mileage may vary.  Let us know if you find support of REXX */
/* by 1-2-3 useful.																			  */
/*****************************************************************************/
PARSE ARG op1, operator, op2
IF op1 = "?" THEN SIGNAL Tell     /* give info if called with "?" as 1st arg */
INTERPRET "result =" op1 operator op2
RETURN result

Tell: 													  /* return a brief description */
RETURN '@REXX("REXXMATH.CMD",op1,operator,op2) ==> returns result of' ,
	"applying the REXX operator to op1 and op2."
