!.HEADER
! 
! 
! Program Name     - SELFLD.PRG
! 
! Program Function - Program Task for the Sample Lotus Notes Query application
!                    This program provides a dialog allowing the user to 
!                    select the field names to be retrieved from the Lotus Notes database.
!  
! 
! Called by        - LNQMAIN.PRG
! 
! Calls            - <none>
! 
!.spec winsize MAX MAX
!.spec textcol 0 17
!.HEADER
!
! DEFINITION
! Some ASL commands can be placed outside of the normal block
! structure. This block is provided to allow such commands to
! be accomodated
!
! Assign boolean variables
!
DECLARE TASK NUMERIC yes = 1
DECLARE TASK NUMERIC no  = 0
!
DECLARE TASK CHAR[4] ThisTask = A.System.ThisTask
!
! ON SELECT
! This block is triggered whenever the user selects a control
! or menu entry.
!
ON SELECT
DO
  CASE A.System.Object
    !
    WHEN "T.W_selfld.PUSH1"
    DO
      CASE A.System.Boxnumber
        WHEN 1
        DO
          ! 'Push' button marked 'Select All'
          DEFINE SelList[0]

          DO cc=1:FieldList[0]'ENTRIES            ! update unselected items
            INSERT SelList[0]=cc
          END

          CALL T.W_SelFld.LIST1'SETCHECK(SelList[0])
        END
        !
        WHEN 2
        DO
          ! 'Push' button marked 'Deselect All'
          DEFINE SelList[0]

          CALL T.W_SelFld.LIST1'SETCHECK(SelList[0])

        END
        !
      END
    END
    !
    WHEN "T.W_selfld.STD_PUSH"
    DO
      CASE A.System.Boxnumber
        WHEN 1                                    ! button marked 'OK'
        DO
          DEFINE SelList[0]
          CALL T.W_SelFld.LIST1'QUERYCHECK(SelList)

          ! Interpret OK on a primary window as required
          DEFINE (?pSelectFlag)[0]
          COPY SelList,(?pSelectFlag)             ! caller's vectors

          LET T..W_SelFld'VISIBLE = No

          SIGNAL PROGRAM A.System.Master

        END
        !
        WHEN 2                                    ! button marked 'Cancel'
        DO

          LET T..W_SelFld'VISIBLE = No
        END
        !
        WHEN 3                                    ! button marked 'Help'
        DO
          ! help button
          NOTHING
        END
        !
      END
    END
    !
    WHEN "T.W_selfld.LIST1"
    DO
      ! list box set for single select mode

    END
  END
END
!
! ON DATA
! This block responds to controls which can accept data entry.
! It is executed whenever the cursor leaves the control after
! data has been changed. This is normally used to provide input
! validation.
!
ON DATA
DO
  CASE A.System.Object
    !
  END
END
!
! ON START
! This block is executed when the program is initially invoked.
! It is normally used to initialize variables needed during
! program execution and to open the main window of the
! application.
!
ON START(pSelectFlag,pColumnName,pOwnerWindow)
DO
  DECLARE GLOBAL POINTER pSelectFlag              ! pointer to vector of columns selected
  DECLARE GLOBAL POINTER pColumnName              ! pointer to vector of column names
  !
  ! Open the object store holding the user library
  !
  OPEN OBJECTSTORE MyLib,
   NAME ="UserLib.A95",
   LOCATION = S.Control.Path
  !
  ! Call procedure to define data for list control(s)
  !
  CALL List_Define

  COPY (?pColumnName),FieldList                   ! copy the data from the caller's vector
  COPY (?pSelectFlag),SelList                     ! copy the data from the caller's vector

  DEFINE SetCheck[0]
  DO ss=1:SelList[0]'ENTRIES
    IF SelList[ss]
      INSERT SetCheck[0]=ss
  END

  !
  OPEN WINDOW W_selfld, , "I.Windows.selfld",
   OWNERWINDOW = (?pOwnerWindow)

  MODIFY W_SelFld,                                ! prohibit window from being
   MINX = W_SelFld'SIZEX,                         ! sized smaller than when it
   MINY = W_SelFld'SIZEY                          ! was opened


  LET MarginRight = W_selfld'SIZEX -              ! store details of Listbox & Window
   T.W_selfld.LIST1'SIZEX -                       ! to be used for resizing
   T.W_selfld.LIST1'X

  LET MarginTop = W_selfld'SIZEY -
   T.W_selfld.LIST1'SIZEY -
   T.W_selfld.LIST1'Y


  CALL T.W_selfld.LIST1'SETCHECK(SetCheck[0])
  !
  ! assign the default push button
  !
  LET T.W_selfld.STD_PUSH[0]'DEFAULT = 1
  !
  ! assign the help button
  !
  LET T.W_selfld.STD_PUSH[0]'HELPBUTTON = 3

END
!
! Construct the arrays needed to support list controls
!
PROCEDURE List_Define
DO
  !
  ! Define data to handle list 'T.W_selfld.LIST1'
  !
  DEFINE FColumns[0]                              ! REFERENCE vector
  DEFINE FLayout[0]                               ! EXPRESSION vector
  !
  ! fill the EXPRESSION vector
  !
  INSERT FLayout[0]="WIDTH=200 SEPARATOR=YES JUST=LEFT READONLY=YES"
  !
  ! Initialise the referred vectors. These are the vectors
  ! which will contain the data to be displayed
  !
  DEFINE FieldList[0]
  DEFINE Selected[0]
  !
  ! fill the REFERENCE vector to point to these vectors
  !
  INSERT FColumns[0] = "FieldList"
END
!
! ON QUIT
! This block is executed when the user uses Close in the
! system menu.
! For a secondary window this would imply, 'shut the window'.
! For a primary window the implication is, 'close the
! Application'.
!
ON QUIT
DO
  CASE A.System.Object

    WHEN "T..W_selfld"                            ! primary window
      LET T..W_SelFld'VISIBLE = No

    OTHERWISE
      SHUT ?A.System.Object

  END
END
!
! ON ENTER
! This block is executed when the user hits the enter key.
! This is normally coded to be equivalent to selecting
! the default push button (often the OK button).
!
ON ENTER
DO
  IF A.System.Object = "T..W_selfld"
  DO
    LET A.System.BoxNumber = T.W_selfld.Std_Push[0]'DEFAULT
    LET A.System.Object = POINTER(T.W_selfld.Std_Push[0])
    RUN PROGRAM ThisTask, SELECT
  END
END
!
! ON OPEN
! The OPEN event is signalled whenever the user 'double clicks'
! or opens a LIST control
!
ON OPEN
DO
  IF A.System.Object = "T.W_selfld.LIST1"
  DO
    !
  END
END
!
! ON DESKTOP
! This block is signaled if the user modifies the window in any
! way, for example, resizing or using the maximize or minimize
! icons. Code here will take account of any such actions, for
! example, by resizing controls to account for a new window
! size.
!
ON DESKTOP
DO

  CASE A.System.Operation
    WHEN "MAX"
    DO
      !

      MODIFY T.W_selfld.LIST1,
       SIZEX = T..W_selfld'SIZEX - MarginRight -
       T.W_selfld.LIST1'X,
       SIZEY = T..W_selfld'SIZEY - MarginTop -
       T.W_selfld.LIST1'Y

    END
    !
    WHEN "NORM"
    DO
      !
      MODIFY T.W_selfld.LIST1,
       SIZEX = T..W_selfld'SIZEX - MarginRight -
       T.W_selfld.LIST1'X,
       SIZEY = T..W_selfld'SIZEY - MarginTop -
       T.W_selfld.LIST1'Y
    END
    !
    WHEN "SIZE"
    DO
      ! Respond to window sizing ( for example by
      ! repositioning or resizing controls )
      MODIFY T.W_selfld.LIST1,
       SIZEX = T..W_selfld'SIZEX - MarginRight -
       T.W_selfld.LIST1'X,
       SIZEY = T..W_selfld'SIZEY - MarginTop -
       T.W_selfld.LIST1'Y
    END
    !
  END


END
!
! ERROR event
! This block is executed when there is a run-time error.
! You can trap errors here or allow the error message provided
! to identify the error and stop the program.
!

ON ERROR
DO
  DECLARE CHAR[7] ans
  DECLARE NUMERIC i
  !
  ! Message to identify failing module and line
  !
  LET ans = DIALOG("FTB7004", 0,
   A.System.ErrorModule,
   A.System.ErrorLine)

  DO i = 1 : A.System.ErrorNumber[0]'ENTRIES
    IF ans = "CANCEL"
      TERMINATE
      !
      ! Display system message corresponding to error
      !
    LET ans = DIALOG ("FTB" || A.System.Errornumber[i], 0,
     A.System.ErrorInfo[i])
  END

  STOP
END
!
! ON STOP
! This block is executed when the program is terminated.
! You should use the block to carry out any housekeeping
! required before closing
!
ON STOP
DO
  !
  STOP
END
! Add your code for this Event below.

ON QUEUE
DO
  DEFINE FieldList[0]
  DEFINE SelList[0]

  COPY (?pColumnName),FieldList
  COPY (?pSelectFlag),SelList

  DEFINE SetCheck[0]
  DO ss=1:SelList[0]'ENTRIES
    INSERT SetCheck[0]=SelList[ss]
  END

  CALL T.W_selfld.LIST1'SETCHECK(SetCheck[0])

  LET T..W_SelFld'VISIBLE = Yes
END
