!.HEADER
! 
! 
! Program Name     - SELDOC.PRG
! 
! Program Function - Program Task for the Sample Lotus Notes Query application
!                    This program provides a dialog allowing the user to 
!                    add selection criteria to be used when querying the Notes database.
!                    The user types in selection criteria in Lotus Notes SELECT syntax
!  
! 
! Called by        - LNQMAIN.PRG
! 
! Calls            - <none>
! 
!.spec winsize MAX MAX
!.spec edit 1
!.spec textcol 0 17
!.HEADER
!
! DEFINITION
! Some ASL commands can be placed outside of the normal block
! structure. This block is provided to allow such commands to
! be accomodated
!
! Assign boolean variables
!
DECLARE TASK NUMERIC yes = 1
DECLARE TASK NUMERIC no  = 0
!
DECLARE TASK CHAR[4] ThisTask = A.System.ThisTask
!
! ON SELECT
! This block is triggered whenever the user selects a control
! or menu entry.
!
ON SELECT
DO
  CASE A.System.Object
    !
    WHEN "T.W_seldoc.PUSH1"
    DO
      ! 'Push' button marked '...'
    END
    !
    WHEN "T.W_seldoc.STD_PUSH"
    DO
      CASE A.System.Boxnumber
        WHEN 1                                    ! button marked 'OK'
        DO
          ! Interpret OK on a primary window as required
          DEFINE (?pSelection)[0]                 ! copy back to callers vector
          COPY Expression,(?pSelection)

          LET T..W_SelDoc'VISIBLE = No

        END
        !
        WHEN 2                                    ! button marked 'Reset'
        DO
          !
          DEFINE Expression[0]                    ! clear current vector
          COPY (?pSelection),Expression           ! and refresh from caller
        END
        !
        WHEN 3                                    ! button marked 'Cancel'
        DO
          LET T..W_SelDoc'VISIBLE = No
        END
        !
        WHEN 4                                    ! button marked 'Help'
        DO
          ! help button
          NOTHING
        END
        !
      END
    END
  END
END
!
! ON DATA
! This block responds to controls which can accept data entry.
! It is executed whenever the cursor leaves the control after
! data has been changed. This is normally used to provide input
! validation.
!
ON DATA
DO
  CASE A.System.Object
    !
    WHEN "T.W_seldoc.SLE1"
    DO
      ! React to change to data variable 'Expression[Top]'
    END
    !
  END
END
!
! ON START
! This block is executed when the program is initially invoked.
! It is normally used to initialize variables needed during
! program execution and to open the main window of the
! application.
!
ON START(pOwnerWindow,pSelection)
DO
  DECLARE GLOBAL POINTER pSelection
  DECLARE GLOBAL POINTER pOwnerWindow
  !
  ! Open the object store holding the user library
  !
  OPEN OBJECTSTORE MyLib,
   NAME ="UserLib.A95",
   LOCATION = S.Control.Path
  !
  ! Assign all variables referred by the windows
  !
  DEFINE Expression[0]                            ! used by SLE control 'T.W_seldoc.SLE1'
  COPY (?pSelection),Expression

  LET Top = 1                                     ! used as index by 'SLE' control 'T.W_seldoc.SLE1'
  !
  OPEN WINDOW W_seldoc, , "I.Windows.seldoc",
   OWNERWINDOW = ?pOwnerWindow

  LET T.W_seldoc.PUSH1[0]'ENABLED = No            ! temporarily disable the expression builder button
  !
  ! assign the default push button
  !
  LET T.W_seldoc.STD_PUSH[0]'DEFAULT = 1
  !
  ! assign the help button
  !
  LET T.W_seldoc.STD_PUSH[0]'HELPBUTTON = 4
END
!
! ON QUIT
! This block is executed when the user uses Close in the
! system menu.
! For a secondary window this would imply, 'shut the window'.
! For a primary window the implication is, 'close the
! Application'.
!
ON QUIT
DO
  CASE A.System.Object

    WHEN "T..W_seldoc"                            ! primary window
      LET T..W_SelDoc'VISIBLE = No

    OTHERWISE
      SHUT ?A.System.Object

  END
END
!
! ON ENTER
! This block is executed when the user hits the enter key.
! This is normally coded to be equivalent to selecting
! the default push button (often the OK button).
!
ON ENTER
DO
  IF A.System.Object = "T..W_seldoc"
  DO
    LET A.System.BoxNumber = T.W_seldoc.Std_Push[0]'DEFAULT
    LET A.System.Object = POINTER(T.W_seldoc.Std_Push[0])
    RUN PROGRAM ThisTask, SELECT
  END
END
!
! ON OPEN
! The OPEN event is signalled whenever the user 'double clicks'
! or opens a LIST control
!
ON OPEN
DO
  CASE A.System.Object
    WHEN "T.W_formbldr.LIST1"
    DO
      !
    END
    !
    WHEN "T.W_formbldr.LIST2"
    DO
      !
    END
    !
  END
END
!
! ON DESKTOP
! This block is signaled if the user modifies the window in any
! way, for example, resizing or using the maximize or minimize
! icons. Code here will take account of any such actions, for
! example, by resizing controls to account for a new window
! size.
!
ON DESKTOP
DO
  CASE A.System.Object
    WHEN "T..W_seldoc"
    DO
      CASE A.System.Operation
        WHEN "MAX"
        DO
          !
        END
        !
        WHEN "NORM"
        DO
          !
        END
        !
        WHEN "SIZE"
        DO
          ! Respond to window sizing ( for example by
          ! repositioning or resizing controls )
        END
        !
      END
    END
  END
END
!
! ERROR event
! This block is executed when there is a run-time error.
! You can trap errors here or allow the error message provided
! to identify the error and stop the program.
!

ON ERROR
DO
  DECLARE CHAR[7] ans
  DECLARE NUMERIC i
  !
  ! Message to identify failing module and line
  !
  LET ans = DIALOG("FTB7004", 0,
   A.System.ErrorModule,
   A.System.ErrorLine)

  DO i = 1 : A.System.ErrorNumber[0]'ENTRIES
    IF ans = "CANCEL"
      TERMINATE
      !
      ! Display system message corresponding to error
      !
    LET ans = DIALOG ("FTB" || A.System.Errornumber[i], 0,
     A.System.ErrorInfo[i])
  END

  STOP
END
!
! ON STOP
! This block is executed when the program is terminated.
! You should use the block to carry out any housekeeping
! required before closing
!
ON STOP
DO
  !
  STOP
END
!
! ON SCROLL
! This event is activated whenver the user manipulates
! a scroll bar.
! Window scroll controls or individual scroll controls
! will activate this event, but not scroll controls
! on LIST boxes or MLE controls where scrolling is
! automatically handled by the control.
!
ON SCROLL
DO
  CASE A.System.Object
    !
    WHEN "T.W_seldoc.SCROLL1"                     ! Scroll control
    DO
      CASE A.System.Scroll
        !
        WHEN "V"                                  ! Select on vertical thumb
        DO
          ! Moved thumb, add code to check A.System.ScrollAmt
        END
        !
        WHEN "U"                                  ! Select on unit up
        DO
          ! Insert code to move one unit up
        END
        !
        WHEN "D"                                  ! Select on unit down
        DO
          ! Insert code to move one unit down
        END
        !
      END
    END                                           ! end WHEN 'T.W_seldoc.SCROLL1'
    !
  END
END
! Add your code for this Event below.

ON QUEUE
DO
  DEFINE Expression[0]
  COPY (?pSelection),Expression

  LET T..W_SelDoc'VISIBLE = Yes
END
