!.HEADER
! 
! 
! Program Name     - MSG.PRG
! 
! Program Function - Program Task for the Sample Lotus Notes Query application
!                    This program provides a dialog allowing the user to 
!                    view messages returned across the Notes interface after
!                    a query is executed.
!  
! 
! Called by        - LNQMAIN.PRG
! 
! Calls            - <none>
!.spec winsize 420 118
!.spec edit 1
!.spec textcol 0 17
!.spec appdest 0 j:\install\notes\new\lnq.apl
!.HEADER
!
! DEFINITION
! Some ASL commands can be placed outside of the normal block
! structure. This block is provided to allow such commands to
! be accomodated
!
! Assign boolean variables
!
DECLARE TASK NUMERIC yes = 1
DECLARE TASK NUMERIC no  = 0
!
DECLARE TASK CHAR[4] ThisTask = A.System.ThisTask
!
! ON SELECT
! This block is triggered whenever the user selects a control
! or menu entry.
!
ON SELECT
DO
  CASE A.System.Object
    !
    WHEN "T.W_msg.STD_PUSH"
    DO
      CASE A.System.Boxnumber
        WHEN 1                                    ! button marked 'Print'
        DO
          !
          CALL Print(POINTER(A.Lotus.ErrorInfo[0]),"Message Log")
        END
        !
        WHEN 2                                    ! button marked 'Cancel'
        DO
          LET T..W_msg'VISIBLE = No
        END
        !
        WHEN 3                                    ! button marked 'Help'
        DO
          ! help button
          NOTHING
        END
        !
      END
    END
    !
    WHEN "T.W_msg.LIST1"
    DO
      ! list box set for single select mode
    END
  END
END
!
! ON DATA
! This block responds to controls which can accept data entry.
! It is executed whenever the cursor leaves the control after
! data has been changed. This is normally used to provide input
! validation.
!
ON DATA
DO
  CASE A.System.Object
    !
  END
END
!
! ON START
! This block is executed when the program is initially invoked.
! It is normally used to initialize variables needed during
! program execution and to open the main window of the
! application.
!
ON START(pOwnerWindow)
DO
  !
  ! Open the object store holding the user library
  !


  LIBRARY ASL "MyLib.AppDevl",
   FILE_GET,
   PRINT
  !
  ! Call procedure to define data for list control(s)
  !
  CALL List_Define
  !
  OPEN WINDOW W_msg, , "I.Windows.msg",
   OWNERWINDOW = (?pOwnerWindow)

  LET MarginRight = w_msg'SIZEX -
   T.w_msg.LIST1'SIZEX -
   T.w_msg.LIST1'X

  LET MarginTop = w_msg'SIZEY -
   T.w_msg.LIST1'SIZEY -
   T.w_msg.LIST1'Y

  !
  ! assign the default push button
  !
  LET T.W_msg.STD_PUSH[0]'DEFAULT = 1
  !
  ! assign the help button
  !
  LET T.W_msg.STD_PUSH[0]'HELPBUTTON = 3
  !
  ! assign the column titles for list controlLIST1
  LET T.W_msg.LIST1'COLTITLE1="Title_1"
  !
END
!
! Construct the arrays needed to support list controls
!
PROCEDURE List_Define
DO
  !
  ! Define data to handle list 'T.W_msg.LIST1'
  !
  DEFINE Columns[0]                               ! REFERENCE vector
  DEFINE Layout[0]                                ! EXPRESSION vector
  !
  ! fill the EXPRESSION vector
  !
  INSERT Layout[0]="WIDTH=400 SEPARATOR=YES JUST=LEFT READONLY=YES"
  !
  ! Initialise the referred vectors. These are the vectors
  ! which will contain the data to be displayed
  !
  DEFINE Messages[0]


  !
  ! fill the REFERENCE vector to point to these vectors
  !
  INSERT Columns[0] = "A.Lotus.ErrorInfo"
  !
  ! create and fill the titles vector
  !
  DEFINE Title_1[0]
  INSERT Title_1[0] = "Messages"
END
!
! ON QUIT
! This block is executed when the user uses Close in the
! system menu.
! For a secondary window this would imply, 'shut the window'.
! For a primary window the implication is, 'close the
! Application'.
!
ON QUIT
DO
  CASE A.System.Object

    WHEN "T..W_msg"                            ! primary window
      LET T..W_Msg'VISIBLE = No

    OTHERWISE
      SHUT ?A.System.Object

  END
END
!
! ON ENTER
! This block is executed when the user hits the enter key.
! This is normally coded to be equivalent to selecting
! the default push button (often the OK button).
!
ON ENTER
DO
  IF A.System.Object = "T..W_msg"
  DO
    LET A.System.BoxNumber = T.W_msg.Std_Push[0]'DEFAULT
    LET A.System.Object = POINTER(T.W_msg.Std_Push[0])
    RUN PROGRAM ThisTask, SELECT
  END
END
!
! ON OPEN
! The OPEN event is signalled whenever the user 'double clicks'
! or opens a LIST control
!
ON OPEN
DO
  IF A.System.Object = "T.W_msg.LIST1"
  DO
    !
  END
END
!
! ON DESKTOP
! This block is signaled if the user modifies the window in any
! way, for example, resizing or using the maximize or minimize
! icons. Code here will take account of any such actions, for
! example, by resizing controls to account for a new window
! size.
!
ON DESKTOP
DO
  CASE A.System.Object
    WHEN "T..W_msg"
    DO
       CASE A.System.Operation
        WHEN "MAX"
        DO
          !

          MODIFY T.w_msg.LIST1,
           SIZEX = T..w_msg'SIZEX - MarginRight -
           T.w_msg.LIST1'X,
           SIZEY = T..w_msg'SIZEY - MarginTop -
           T.w_msg.LIST1'Y

        END
        !
        WHEN "NORM"
        DO
          !
          MODIFY T.w_msg.LIST1,
           SIZEX = T..w_msg'SIZEX - MarginRight -
           T.w_msg.LIST1'X,
           SIZEY = T..w_msg'SIZEY - MarginTop -
           T.w_msg.LIST1'Y
        END
        !
        WHEN "SIZE"
        DO
          ! Respond to window sizing ( for example by
          ! repositioning or resizing controls )
          MODIFY T.w_msg.LIST1,
           SIZEX = T..w_msg'SIZEX - MarginRight -
           T.w_msg.LIST1'X,
           SIZEY = T..w_msg'SIZEY - MarginTop -
           T.w_msg.LIST1'Y
        END
        !
      END
    END
  END
END
!
! ERROR event
! This block is executed when there is a run-time error.
! You can trap errors here or allow the error message provided
! to identify the error and stop the program.
!

ON ERROR
DO
  DECLARE CHAR[7] ans
  DECLARE NUMERIC i
  !
  ! Message to identify failing module and line
  !
  LET ans = DIALOG("FTB7004", 0,
   A.System.ErrorModule,
   A.System.ErrorLine)

  DO i = 1 : A.System.ErrorNumber[0]'ENTRIES
    IF ans = "CANCEL"
      TERMINATE
      !
      ! Display system message corresponding to error
      !
    LET ans = DIALOG ("FTB" || A.System.Errornumber[i], 0,
     A.System.ErrorInfo[i])
  END

  STOP
END
!
! ON STOP
! This block is executed when the program is terminated.
! You should use the block to carry out any housekeeping
! required before closing
!
ON STOP
DO
  !
  STOP
END
! Add your code for this Event below.

ON QUEUE
DO
  LET T..W_msg'VISIBLE = Yes
END
