!.HEADER
! ! Code generated  4-17-95 at 10:39 P.M.
! ! from WINDOW 'E:\visqdevt\LotNotes\visnote\ToNotes.wdw'
! 
! ! Windows referred:-
! ! 'E:\visqdevt\LotNotes\visnote\ToNotes.wdw' established as main window
!.spec winsize 436 244
!.spec textcol 0 17
!.spec appdest 1 D:\temp\batnot
!.HEADER
!
! DEFINITION
! Some ASL commands can be placed outside of the normal block
! structure. This block is provided to allow such commands to
! be accomodated
!
! Assign boolean variables
!
DECLARE TASK NUMERIC yes = 1
DECLARE TASK NUMERIC no  = 0
!
DECLARE TASK CHAR[4] ThisTask = A.System.ThisTask
!
! Open the library and declare the required functions
!
LIBRARY ASL "MyLib..AppDevL",
 App_Icon

!
! ON START
! This block is executed when the program is initially invoked.
! It is normally used to initialize variables needed during
! program execution and to open the main window of the
! application.
!
!
ON START(FileName, AppIdentifier, AppName)
DO

  ! Open the library with the prompter for global variables
  LIBRARY ASL "G..GeneralLib",
   VALID_NAME

  OPEN objectstore p,
   name = s.control.mribase,
   location = s.control.path


  ! Disable BREAKs so that they may only be collected in the Batch_proc
  BREAK DISABLE

  ! Define Current Position
  g_CurLoc = A.System.StartDs'Location
  IF Split(g_CurLoc,Length(g_CurLoc),1) = "\"
    g_CurLoc = Split(g_CurLoc,1,Length(g_CurLoc)-1)

    ! Set the full path and name for the batch data table from the
    ! @Path variable passed to the programme at startup
    !
  LET BatchPath = GLOBAL("BatchName")
  !

  !
  ! Validate the path that the user has given
  !
  LET vname = name(BatchPath)
  LET vpath = location(BatchPath)
  IF novalue(vname) | novalue(vpath)
    LET validate = 1
  ELSE
    LET Validate = VALID_NAME(vname,vpath)
  IF validate \= 0
  DO
    ! If invalid get the user to enter one
    OPEN FILEDLG FileSelect,
     name = "*.*",
     EA = "IBMTABLE"

    LET BatchPath = FileSelect'OPEN()
    SHUT FileSelect
    ! If still invalid, or user quits then stop
    LET vname = name(BatchPath)
    LET vpath = location(BatchPath)
    IF novalue(vname) | novalue(vpath)
      LET validate = 1
    ELSE
      LET Validate = VALID_NAME(vname,vpath)
    IF validate \= 0
    DO
      ERROR 1,"No valid Batch File was selected.  Program terminated."
      STOP
    END
  END

  ! Stop the programme if none was specified
  !
  IF BatchPath = ""
  DO
    ERROR 1,"No full name was specied for the batch table at startup (@Path=...)."
    STOP
  END

  !
  ! Open the object store holding the user library
  !
  OPEN OBJECTSTORE MyLib,
   NAME ="UserLib.A95",
   LOCATION = S.Control.Path

  OPEN SYSTEM Sys                                 ! establish connection with OS/2

  !
  ! Assign all variables referred by the windows
  !
  LET now = ""~TIME(,"hhmm")
  LET date = DATE()                               ! used by SLE control named 'T.W_BATONOT.SLE3'
  LET hours = SPLIT(now,1,2)                      ! used by SLE control named 'T.W_BATONOT.SLE1'
  LET MESSAGE = "Establishing connection with Lotus Notes..."! used by Text control named 'T.W_BATONOT.TEXT3'
  LET minutes = SPLIT(now,3,2)                    ! used by SLE control named 'T.W_BATONOT.SLE2'

  ! Set the default radio variables in case they are not changed
  LET ErrorNotify = 0
  LET TimerFunction = "Today"

  ! Open the main window
  OPEN WINDOW W_BATONOT, , "I.Windows.BATONOT"

  ! Disable the modify button
  LET T.W_BATONOT.STD_PUSH[2]'enabled = 0

  FORGIVE
    LET NotesPath = Sys'SEARCHPATH(               ! locate the Notes directory
     "NOTES.EXE",                                 ! by searching for the Notes program file
     "PATH")                                      ! in the PATH setting of CONFIG.SYS
  IF A.System.ErrorNumber
  DO
    ERROR 1,"Unable to open LotusNotes Object. Check that Lotus Notes is installed." ||
     " correctly. The Lotus Notes directory must be in PATH and LIBPATH."
    STOP
  END

  FORGIVE                                         !Open the lotus notes object and check status
    OPEN LOTUSNOTES Lotus

  IF Lotus'CODE > 0
  DO
    MESSAGE "FTB0003",0,Lotus'REASON
    SHUT Lotus
    STOP
  END

  ! Display status
  LET MESSAGE = "Connecting to required servers..."
  CALL T.W_BATONOT.TEXT3'REFRESH

  !
  CALL App_Icon(POINTER(W_ToNotes[0]))

  !Open the Batch Table
  OPEN TABLE BatchTab,                            !Open the batch table
   LOCATION = LOCATION(BatchPath),
   NAME = NAME(BatchPath)

  ! Establish connection with all servers listed in batch table
  CALL Connect


  ! Display status
  LET MESSAGE = "Connected successfully to Lotus Notes and Servers. Modify the settings and press 'Activate'"
  CALL T.W_BATONOT.TEXT3'REFRESH

END
!
! ON DATA
! This block responds to controls which can accept data entry.
! It is executed whenever the cursor leaves the control after
! data has been changed. This is normally used to provide input
! validation.
!
ON DATA
DO
  CASE A.System.Object
    !
    WHEN "T.W_BATONOT.SLE1"
    DO
      ! React to change to data variable 'hours'
    END
    !
    WHEN "T.W_BATONOT.SLE2"
    DO
      ! React to change to data variable 'minutes'
    END
    !
    WHEN "T.W_BATONOT.SLE3"
    DO
      ! React to change to data variable 'date'
    END
    !

  END
END
!
! ON SOURCE
! This event is signalled when there has been Direct Manipulation
! between this application and some other application.
! This applications Source window has been dropped onto a target
! window. The owner of the target window is asking for data about
! this application.
!
ON SOURCE(pStream)
DO
  DECLARE POINTER pStream
  !
  CASE (?pStream)'FORMAT
    !
    WHEN "IBMAPPLICATN"
    DO
      IF (?pStream)'REFERENCE
      DO
        OPEN REFERENCE Reference,
         SOURCETYPE = "FILE",
         NAME       = NAME(AppIdentifier),
         LOCATION   = LOCATION(AppIdentifier)

        CALL Reference'SAVE(pStream)
        SHUT Reference
      END
    END
    !
    ! Add code for any other formats here
    !
  END
  !
  CALL (?pStream)'FINISHED()
  SHUT(?pStream)
END
!
! ERROR event
! This block is executed when there is a run-time error.
! You can trap errors here or allow the error message provided
! to identify the error and stop the program.
!

ON ERROR
DO
  DECLARE CHAR[7] ans
  DECLARE NUMERIC i
  !
  ! Message to identify failing module and line
  !
  LET ans = DIALOG("FTB7004", 0,
   A.System.ErrorModule,
   A.System.ErrorLine)

  DO i = 1 : A.System.ErrorNumber[0]'ENTRIES
    IF ans = "CANCEL"
      TERMINATE
      !
      ! Display system message corresponding to error
      !
    LET ans = DIALOG ("FTB" || A.System.Errornumber[i], 0,
     A.System.ErrorInfo[i])
  END

  STOP
END
!
! ON STOP
! This block is executed when the program is terminated.
! You should use the block to carry out any housekeeping
! required before closing
!
ON STOP
DO

  SHUT W_tonotbat
  SHUT BatchTimer
  SHUT BatchTable
  SHUT Lotus
  !
  STOP
  !

END
!
! User specified procedures may have up to 20 passed parameters.
! Procedures may be called as functions (using the RETURN
! facility to return a value) or may be called as normal
! procedures.
!
! This procedure validates key notes' fields
!
PROCEDURE Valid_Parms
DO
  IF NOVALUE(NotesServer)=Yes |                   ! is the database name empty?
   NOVALUE(NotesDB)=Yes |                         ! is the Formname empty?
   NOVALUE(NotesForm)=Yes |                       ! is the RichTextField name empy?
   NOVALUE(FieldName)=Yes                         ! is the FieldName empty?
    RETURN No                                     ! if so, then return a 0 (No)
  ELSE
    RETURN Yes                                    ! if not return a 1 (Yes)
END
!
! User specified procedures may have up to 20 passed parameters.
! Procedures may be called as functions (using the RETURN
! facility to return a value) or may be called as normal
! procedures.
!
! This procedure handles the batch process reading each row of data in from the specified table
! and then calling the transfer routine
!
PROCEDURE Batch_proc
DO
  LET ErrorCount = 0
  DEFINE errors[0]
  DO row = 1 : BatchTab.FileName[0]'ENTRIES       !Repeat the transfer procedure for every row in the table

    !Scan the columns into the data variables
    LET NotesServer = BatchTab.NotesServer[row]
    LET NotesDB = BatchTab.NotesDB[row]
    LET NotesForm = BatchTab.NotesForm[row]
    LET FieldName = BatchTab.FieldName[row]
    LET NotesDocumentId = BatchTab.NotesDocument[row]
    LET FullFileName = BatchTab.FileName[row]
    LET FileType = BatchTab.FileType[row]
    LET UpdateMode = BatchTab.UpdateMode[row]

    IF LOCATION(FullFileName) = ""                !Use the batch table's path if a full path is not specified in the table
    THEN LET FullFileName = LOCATION(BatchPath)||"\"||FullFileName
      MODIFY Lotus,                               !Modify the lotus object's settings
       SERVERNAME = NotesServer,
       DIRECTORY = "",
       DATABASE = NotesDB,
       FORMNAME = NotesForm

      ! Display status
    LET MESSAGE = STRING("Transferring '_' to Notes."||CHAR(13)||"Press 'Ctrl' + 'Break' to abort transfer.",FullFileName)
    CALL T.W_BATONOT.TEXT3'REFRESH

    ! Call the file transfer routine
    CALL transfer

    ! Enable 'Ctrl + Break' abortion of transfer
    IF BREAK()
    DO
      LET ErrorFlag = "Break"
      CALL log_error
      RETURN
    END
  END
END
!
! User specified procedures may have up to 20 passed parameters.
! Procedures may be called as functions (using the RETURN
! facility to return a value) or may be called as normal
! procedures.
!
! This procedure handles the transfer of all the supported formats to Lotus notes
! using the data supplied by the Batch_proc
!
PROCEDURE transfer
DO
  TRACE STATEMENT
  IF Valid_Parms()=No                             ! check to ensure that all necessary
  DO                                              ! parameters are entered
    LET ErrorFlag = "Parameters"
    CALL log_error
    RETURN                                        ! return to Wait state
  END

  ! Check for extended attributes and existance of specified file
  FORGIVE
    OPEN file attrib,
     name = name(FullFileName),
     location = location(FullFileName),
     mode = "READ"
  IF A.System.ErrorNumber \= 0
  DO
    LET ErrorFlag = "Path"                        ! Checks for the existance of the file
    CALL log_error
    SHUT attrib
    RETURN
  END
  LET Eattribute = attrib'OBJECTCLASS
  IF FileType \= "PCX"
  DO
    IF Eattribute \= ""
      LET FileType = Eattribute
  END
  SHUT attrib

  CASE FileType
    ! Add the formats you are accepting and what you want to do with them
    ! here.

    WHEN "IBMREPORT"
    DO

      OutPutFile = String("_\REPORT.TXT",g_CurLoc)

      CALL Sys'INCLUDETEMP( OutPutFile )
      FORGIVE
        OPEN ?"IBMREPORT" ThisReport,             !Open IBMREPORT object using the current path
         IDENTIFIER = FullFileName,
         DIALOG = 0
      IF A.System.ErrorNumber \= 0 | ThisReport'CODE
      DO
        CALL log_error
        SHUT ThisReport
        RETURN
      END

      ! Remove the report's margins, eliminating some plain text problems.
      CALL ThisReport'PAGESETUP("U",,,0,0,,,)

      CALL ThisReport'COPYTO(OutputFile,"TEXT")
      FORGIVE
        CALL Lotus'StoreInNotes(
         FieldName,                               ! the name of the RichText field for the Report
         NotesDocumentId,                         ! the Document to update (or empty to create a new one)
         OutputFile,                              ! the Report output file (must have extension of TXT)
         UpdateMode)                              ! the update mode used with the file (Append or Replace)

      IF Lotus'CODE \= 0
      DO
        ErrorFlag = "Notes"
        CALL log_error
        SHUT ThisReport
      END

      SHUT ThisReport                             ! and then the Report

    END


    WHEN "IBMCHART"
    DO

      OutPutFile = String("_\CHART.PCX",g_CurLoc)
      CALL Sys'INCLUDETEMP( OutPutFile )
      FORGIVE
        OPEN ?"IBMCHART" ThisChart,               ! Open the IBMCHART object using the current path
         IDENTIFIER = FullFileName,
         DIALOG = 0
      IF A.System.ErrorNumber \= 0 | ThisChart'CODE
      DO
        LET ErrorFlag = "Path"
        CALL log_error
        SHUT ThisChart
        RETURN
      END
      CALL ThisChart'COPYTO(OutputFile,"PCX")
      FORGIVE
        CALL Lotus'StoreInNotes(
         FieldName,                               ! the name of the RichText field for the Report
         NotesDocumentId,                         ! the Document to update (or empty to create a new one)
         OutputFile,                              ! the Report output file (must have extension of TXT)
         UpdateMode)                              ! the update mode used with the file (Append or Replace)

      IF Lotus'CODE > 0
      DO
        ErrorFlag = "Notes"
        CALL log_error
      END


      SHUT ThisChart                              ! and then the Chart

      !
    END

    WHEN "PCX"                                    ! Handles PCX file transfer
    DO
      IF DELWORD(NAME(FullFileName),1,1,".") = "PCX"! Check for .PCX file extension
        OutputFile = FullFileName                 ! If it has one then use the file
      ELSE
      DO
        OutPutFile = String("_\PCX.PCX",g_CurLoc)
        CALL Sys'INCLUDETEMP( OutPutFile )
        FORGIVE
          CALL sys'COPY(FullFileName,OutPutFile)  ! If it doesn't have one then create a temporary
        IF A.System.ErrorNumber \= 0
        DO
          LET ErrorFlag = "Path"                  ! Checks the non .PCX's file path
          CALL log_error
          RETURN
        END
      END

      FORGIVE
        CALL Lotus'StoreInNotes(
         FieldName,                               ! the name of the RichText field for the Report
         NotesDocumentId,                         ! the Document to update (or empty to create a new one)
         OutputFile,                              ! the Report output file (must have extension of TXT)
         UpdateMode)                              ! the update mode used with the file (Append or Replace)

      IF Lotus'CODE > 0                           ! Send errors to the error handler
      DO                                          ! N.B. this one now handles .PCX paths' errors
        ErrorFlag = "Notes"
        CALL log_error
      END

      !
    END

    WHEN "BITMAP"                                 ! Handles BMP file transfer
    DO
      IF DELWORD(NAME(FullFileName),1,1,".") = "BMP"! Check for .BMP file extension
        OutputFile = FullFileName                 ! If it has one then use the file
      ELSE
      DO
        OutPutFile = String("_\BMP.BMP",g_CurLoc)
        CALL Sys'INCLUDETEMP( OutPutFile )

        FORGIVE
          CALL sys'COPY(FullFileName,OutPutFile)  ! If it doesn't have one then create a temporary

        IF A.System.ErrorNumber \= 0
        DO
          LET ErrorFlag = "Path"                  ! Checks the non .BMP's file path
          CALL log_error
          RETURN
        END
      END

      FORGIVE
        CALL Lotus'StoreInNotes(
         FieldName,                               ! the name of the RichText field for the Report
         NotesDocumentId,                         ! the Document to update (or empty to create a new one)
         OutputFile,                              ! the Report output file (must have extension of TXT)
         UpdateMode)                              ! the update mode used with the file (Append or Replace)

      IF Lotus'CODE > 0                           ! Send errors to the error handler
      DO                                          ! N.B. this one now handles .BMP paths' errors
        ErrorFlag = "Notes"
        CALL log_error
      END
      !
    END

    OTHERWISE
    DO
      LET ErrorFlag = "Parameters"
      CALL Log_error
    END

  END
  RETURN
END
!
! User specified procedures may have up to 20 passed parameters.
! Procedures may be called as functions (using the RETURN
! facility to return a value) or may be called as normal
! procedures.
!
! This procedure establishes a connection with all of the Notes
! Servers listed in the batch table, by calling the GetFileList
! function.  This ensures that the batch programme is logged
! onto all the servers which it will use (as if it is not logged
! on the user will be promted to enter the password).
!
PROCEDURE Connect
DO

  DEFINE Dirs[0]
  DEFINE DBList[0]
  DEFINE DBInfo[0]

  DO row = 1 : BatchTab.NotesServer[0]'ENTRIES

    FORGIVE                                       ! If the server doesn't exist then don't crash
      MODIFY Lotus,
       SERVERNAME = BatchTab.NotesServer[row],    !Change server to that of the current row
       DIRECTORY  = ""
    IF A.System.ErrorNumber \= 0
      ERROR 1,"The server in row _ of the transfer is not responding.  Unable to connect to this server"

    CALL Lotus'GetFileList( Pointer( Dirs[0] ), Pointer( DBList[0] ), Pointer( DBInfo[0] ) )!Establish a connection to it

  END
END
!
! User specified procedures may have up to 20 passed parameters.
! Procedures may be called as functions (using the RETURN
! facility to return a value) or may be called as normal
! procedures.
! 
! This procedure processes all non-fatal errors
!
PROCEDURE Log_error
DO

  CASE ErrorFlag                                  !Get the correct error message for the loggable errors
    WHEN "Parameters"
      LET ErrorMessage = STRING("Error in row _ of table (DocumentID is the only optional field); This file was not transferred",row)
    WHEN "Path"
      LET ErrorMessage = STRING("Error in row _ of table (The path does not exist); This file was not transferred",row)
    WHEN "Notes"
      LET ErrorMessage = STRING("Error in row _ of table (_ _); This file may not have been transferred.",
       row,Lotus'CODE,Lotus'REASON)
    WHEN "Break"
      LET ErrorMessage = "Transfer aborted by 'Ctrl' + 'Break'"
  END
  ErrorCount = ErrorCount + 1                     !Update the count of the total number of loggable errors
  IF ErrorNotify = 1
    ERROR 1,ErrorMessage
  INSERT errors[0] = ErrorMessage

END
! Add your code for this Event below.

ON TIMER
DO

  ! Notify user of activity
  LET MESSAGE = "A Batch has been started by the timer..."
  CALL T.W_BATONOT.TEXT3'REFRESH

  !Reset timer for next execution - depending upon the user settings
  CASE TimerFunction
    WHEN "Daily"                                  !Daily timer
    DO
      ! Get tomorrow's date
      LET date = DURATION(date,1)

      ! Activate next timer
      CALL BatchTimer'AT(BatchTime,date)

    END
    WHEN "Weekly"                                 !Weekly timer
    DO
      ! Get the date next week
      LET date = DURATION(date,7)

      ! Activate next timer
      CALL BatchTimer'AT(BatchTime,date)

    END
    WHEN "Today"                                  !This day only timer
    DO
    END
  END

  ! Call the batch job
  CALL batch_proc

  ! Display the next date
  CALL T.W_BATONOT.SLE3'REFRESH

  ! Save all the generated errors
  CALL save_errors

  ! Display status
  LET MESSAGE = STRING("Finished the batch '_' on _ at _. There were _ errors (see BATCHLOG).",BatchPath,DATE(),TIME(),ErrorCount)
  CALL T.W_BATONOT.TEXT3'REFRESH

END
!
! User specified procedures may have up to 20 passed parameters.
! Procedures may be called as functions (using the RETURN
! facility to return a value) or may be called as normal
! procedures.
!
! This procedure saves batch execution details including all non-
! fatal errors to the log file: BATCHLOG
!
PROCEDURE save_errors
DO

  ! Display status
  LET MESSAGE = "Saving Batch details..."
  CALL T.W_BATONOT.TEXT3'REFRESH

  ! Open the file object in append mode
  OPEN FILE output,
   NAME = "BATCHLOG",
   LOCATION = LOCATION(BatchPath),
   MODE = "APPEND"

  ! Generate the job details
  LET details = STRING("Batch job using _ table on _. Started at _. Finished at _. Completed with _ errors.",BatchPath,DATE(),BatchTime,TIME(),ErrorCount)

  ! Output the batch job's details to the file
  CALL output'PUT(details, LINE())

  !Error logging
  IF ErrorCount \= 0
  DO
    CALL output'PUT("*****START OF LOGGED ERRORS*****", LINE())

    ! Output the errors to the file
    DO i = 1 : errors[0]'ENTRIES
      CALL output'PUT(errors[i], LINE())
    END

    CALL output'PUT("*****END OF LOGGED ERRORS*****", LINE())
  END

  ! Close the file
  SHUT output

END
!
! ON QUIT
! This block is executed when the user uses Close in the
! system menu.
! For a secondary window this would imply, 'shut the window'.
! For a primary window the implication is, 'close the
! Application'.
!
ON QUIT
DO
  CASE A.System.Object

    WHEN "T..W_BATONOT"                           ! primary window
    DO
      button = DIALOG("FTB0008",0,"Do you want to quit? All batch transfers will be cancelled.")
      IF button = "Yes"
        RUN PROGRAM ThisTask, STOP
    END
    OTHERWISE
      SHUT ?A.System.Object
  END
END
!
! ON SELECT
! This block is triggered whenever the user selects a control
! or menu entry.
!
ON SELECT
DO
  CASE A.System.Object
    !
    WHEN "T.W_BATONOT.STD_PUSH"                   ! Std cloned push buttons
    CASE A.System.Boxnumber
      WHEN "2"
      DO
        ! 'Push' button marked 'Modify'
        SHUT BatchTimer
        CALL controls(1)
        LET T.W_BATONOT.STD_PUSH[2]'enabled = 0
        !LET T.W_BATONOT.STD_PUSH[1]'enabled = 1

        ! Display status
        LET MESSAGE = "Modify the settings and press 'Activate'"
        CALL T.W_BATONOT.TEXT3'REFRESH

      END
      !
      WHEN "1"
      DO
        ! 'Push' button marked 'Activate'
        CALL controls(0)
        LET T.W_BATONOT.STD_PUSH[2]'enabled = 1
        OPEN TIMER BatchTimer
        LET BatchTime = TIME(hours||":"||minutes)
        CALL BatchTimer'AT(BatchTime,date)

        ! Display status
        LET MESSAGE = "Batch timer is set, press 'Modify' to change the settings"
        CALL T.W_BATONOT.TEXT3'REFRESH

      END
    END
    !
    WHEN "T.W_BATONOT.RADIO1"
    DO
      CASE A.System.Boxnumber
        WHEN 1                                    ! button marked 'Continue'
        DO
          ! 'Radio' button marked 'Continue'
          LET ErrorNotify = 0
        END
        !
        WHEN 2                                    ! button marked 'Stop'
        DO
          ! 'Radio' button marked 'Stop'
          LET ErrorNotify = 1
        END
        !
      END
    END
    !
    WHEN "T.W_BATONOT.RADIO2"
    DO
      CASE A.System.Boxnumber
        WHEN 1                                    ! button marked 'No'
        DO
          ! 'Radio' button marked 'No'
          TimerFunction = "Today"
        END
        !
        WHEN 2                                    ! button marked 'Every Day'
        DO
          ! 'Radio' button marked 'Every Day'
          TimerFunction = "Daily"
        END
        !
        WHEN 3                                    ! button marked 'Every Week'
        DO
          ! 'Radio' button marked 'Every Week'
          TimerFunction = "Weekly"
        END
        !
      END
    END
  END
END
!
! User specified procedures may have up to 20 passed parameters.
! Procedures may be called as functions (using the RETURN
! facility to return a value) or may be called as normal
! procedures.
!
! This procedure changes the 'enabled status of a large number of the buttons
!
PROCEDURE controls(status)
DO

let T.W_BATONOT.RADIO1[0]'enabled = status
let T.W_BATONOT.RADIO2[0]'enabled = status
let T.W_BATONOT.SLE1'enabled = status
let T.W_BATONOT.SLE2'enabled = status
let T.W_BATONOT.SLE3'enabled = status
let T.W_BATONOT.STD_PUSH[1]'enabled = status

END
