/*      VIPER Database Engine
        Search using RxViperSearchRecord example.
        Copyright (c) - 1995 by Douglas A. Bebber
*/


/* Register the VIPER Database Engine functions... */
rc = RxFuncAdd("SysLoadViperFuncs","Viper", "SysLoadViperFuncs")
call SysLoadViperFuncs

/* OPEN THE DATABASE */
status = RxViperOpenDatabase('CUSTOMER', 'LNAME')
if status = 0 then
Do
        say 'Failed to open CUSTOMER database using the LNAME index!'
        exit
End
else
        say 'Successfully opened CUSTOMER database using the LNAME index!'

/* Set up record to search for... */
SearchField.0 = 9
SearchField.1 = '123-45-6789'
SearchField.2 = 'Doe'     
SearchField.3 = 'John'    
SearchField.4 = 'D'
SearchField.5 = '1212 West Lake Drive'
SearchField.6 = 'Cedar Rapids'
SearchField.7 = 'IA'
SearchField.8 = '52804'
SearchField.9 = '(319) 322-8876'
status = RxViperSearchRecord('CUSTOMER', 'LNAME', SearchField.)
if status = 0 then
        say 'SearchRecord function failed!'
if status = 1 then
        say 'Found the record!'
if status = 2 then
        say 'Record not found!'

/* GET THE RECORD AND DISPLAY IT */
if status = 1 then
Do
status = RxViperGetRecord('CUSTOMER', 'LNAME', Fields.)
if status = 1 then
do
        do index = 1 to Fields.0
                say Fields.index
        end
end

End
status = RxViperCloseDatabase('CUSTOMER')
if status = 0 then
Do
        say 'Failed to close CUSTOMER database!'
        exit
End
else
        say 'Successfully closed CUSTOMER database!'

