/*      VIPER Database Engine
        Search using RxViperSearchKey example.
        Copyright (c) - 1995 by Douglas A. Bebber
*/


/* Register the VIPER Database Engine functions... */
rc = RxFuncAdd("SysLoadViperFuncs","Viper", "SysLoadViperFuncs")
call SysLoadViperFuncs

/* OPEN THE DATABASE */
status = RxViperOpenDatabase('CUSTOMER', 'LNAME')
if status = 0 then
Do
        say 'Failed to open CUSTOMER database using the LNAME index!'
        exit
End
else
        say 'Successfully opened CUSTOMER database using the LNAME index!'


/* Using the LNAME index which has 2 key fields (Last Name, and First Name):  */
SearchKey.0 = 2
SearchKey.1 = 'Doe'     /* Last name to search for */
SearchKey.2 = 'John'    /* First name to search for */

status = RxViperSearchKey('CUSTOMER', 'LNAME', SearchKey.)
if status = 0 then
        say 'SearchKey function failed!'
if status = 1 then
        say 'Found the record!'
if status = 2 then
        say 'Record not found, database cursor moved to nearest record meeting search criteria!'

/* GET THE RECORD AND DISPLAY IT */
status = RxViperGetRecord('CUSTOMER', 'LNAME', Fields.)
if status = 1 then
do
        do index = 1 to Fields.0
                say Fields.index
        end
end


status = RxViperCloseDatabase('CUSTOMER')
if status = 0 then
Do
        say 'Failed to close CUSTOMER database!'
        exit
End
else
        say 'Successfully closed CUSTOMER database!'

