/*      VIPER Database Engine
        Create a database and database index example.
        Copyright (c) - 1995 by Douglas A. Bebber
*/


/* Register the VIPER Database Engine functions... */
rc = RxFuncAdd("SysLoadViperFuncs","Viper", "SysLoadViperFuncs")
call SysLoadViperFuncs

/* The CUSTOMER database used in these examples is created here. The CUSTOMER
    database field definition is detailed below:

        ID
        Last Name
        First Name
        MI
        Address
        City
        State
        ZIP
        Phone

        Now we will create this database:
*/

DatabaseFields.0 = 9    /* 9 fields in the CUSTOMER database */
DatabaseFields.1 = 'ID'
DatabaseFields.2 = 'Last Name'
DatabaseFields.3 = 'First Name'
DatabaseFields.4 = 'MI'
DatabaseFields.5 = 'Address'
DatabaseFields.6 = 'City'
DatabaseFields.7 = 'State'
DatabaseFields.8 = 'Zip'
DatabaseFields.9 = 'Phone'

rc = RxViperCreateDatabase('CUSTOMER', '0', DatabaseFields.)
if rc = 0 then
        say 'Error creating the CUSTOMER database!'
else
        say 'Successfully created the CUSTOMER database!'

/****************************************************************************/
/* Now create an index to order customer names alphabetically by Last Name, then First Name */
/*****************************************************************************/


KeyFields.0 = 2
KeyFields.1 = 'Last Name'
KeyFields.2 = 'First Name'

rc = RxViperCreateIndex('CUSTOMER', 'LNAME', KeyFields.)
if rc = 0 then
        say 'Error creating the CUSTOMER database LNAME index!'
else
        say 'Successfully created the CUSTOMER database LNAME index!'


/****************************************************************************/
/* Now create an index to order customer names by State then alphabetically by Last Name,   */
/* then First Name                                                                                 */
/****************************************************************************/


KeyFields.0 = 3
KeyFields.1 = 'State'
KeyFields.2 = 'Last Name'
KeyFields.3 = 'First Name'

rc = RxViperCreateIndex('CUSTOMER', 'STATE', KeyFields.)
if rc = 0 then
        say 'Error creating the CUSTOMER database STATE index!'
else
        say 'Successfully created the CUSTOMER database STATE index!'

/****************************************************************************/
/* Now lets just add a few records into the database:                                            */
/****************************************************************************/
Record.0 = 9
Record.1 = '123-45-6789'
Record.2 = 'Doe'
Record.3 = 'John'
Record.4 = 'D'
Record.5 = '1212 West Lake Drive'
Record.6 = 'Cedar Rapids'
Record.7 = 'IA'
Record.8 = '52804'
Record.9 = '(319) 322-8876'
rc = RxViperAddRecord('CUSTOMER','LNAME', Record.) /* Specify any index, all indexes are updated */
if rc = 0 then
        say 'Error adding record to the CUSTOMER database!'
else
        say 'Successfully added record to the CUSTOMER database!'

Record.0 = 9
Record.1 = '123-45-6790'
Record.2 = 'Doe'
Record.3 = 'Jane'
Record.4 = 'T'
Record.5 = '1212 West Lake Drive'
Record.6 = 'Cedar Rapids'
Record.7 = 'IA'
Record.8 = '52804'
Record.9 = '(319) 322-8876'
rc = RxViperAddRecord('CUSTOMER','LNAME', Record.) /* Specify any index, all indexes are updated */
if rc = 0 then
        say 'Error adding record to the CUSTOMER database!'
else
        say 'Successfully added record to the CUSTOMER database!'


Record.0 = 9
Record.1 = '323-19-0020'
Record.2 = 'Smith'
Record.3 = 'Bob'
Record.4 = 'G'
Record.5 = '1004 South Williamson Parkway - Building #43, Suite #2987'
Record.6 = 'Sarasota'
Record.7 = 'FL'
Record.8 = '34231'
Record.9 = '(941) 322-4576'
rc = RxViperAddRecord('CUSTOMER','LNAME', Record.) /* Specify any index, all indexes are updated */
if rc = 0 then
        say 'Error adding record to the CUSTOMER database!'
else
        say 'Successfully added record to the CUSTOMER database!'


/****************************************************************************/
/* Now close the database file:                                                                    */
/****************************************************************************/

rc = RxViperCloseDatabase('CUSTOMER')
if rc = 0 then
        say 'Error closing the new CUSTOMER database!'
else
        say 'Successfully closed the new CUSTOMER database!'


call SysDropFuncs
