/*====================================================================*/
/*  Name:  EHSINUCB.CMD  -  CMD file for installation                 */
/*====================================================================*/
/*                                                                    */
/*  Licensed Materials - Property of IBM                              */
/*                                                                    */
/*  5621-404 (C) Copyright IBM Corp. 1993                             */
/*  5622-018 (C) Copyright IBM Corp. 1993                             */
/*                                                                    */
/*  All rights reserved.                                              */
/*  US Government Users Restricted Rights -                           */
/*  Use, duplication or disclosure restricted                         */
/*  by GSA ADP Schedule Contract with IBM Corp.                       */
/*                                                                    */
/*  See Copyright Instructions.                                       */
/*                                                                    */
/*====================================================================*/
/* Create User's Guide Object in SearchManager folder  */

arg filepath

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

inffile.=""
res = SysFileTree(filepath'\EHSA7MST.INF',inffile,'FO')
if res=0 & inffile.1\="" then do
   objset = 'EXENAME=VIEW.EXE;PARAMETERS='filepath'\EHSA7MST.INF;OBJECTID=<EHS_BOOK>'
   if SysCreateObject(WPProgram,"Retrieval and Indexing",'<EHS_PROD>',objset,'r') then
     say '.'
   else
     nop /* signal END */
end

samppath=filepath'\HowToUse.DOC'

/* build ea value  -  add long name to sample directories   */
/* 0xfdffxxxx' where xxxx is a USHORT containing the length */

longname='How to use the Try-Out version...'
test='fdff'D2X(LENGTH(longname) + 4 + LENGTH(samppath),2)'00'
longname=x2c(test)longname''x2c('0d0a')'('samppath')'
res = SysPutEA(samppath,'.LONGNAME',longname)
/*if res \== 0 then                                           */
/*   say 'Warning: Longname processing failed - continue....' */

objset = 'SHADOWID='samppath';OBJECTID=<EHS_DEMO>'
if SysCreateObject(WPShadow, "How to use the Try-Out version...", '<EHS_PROD>',objset,'r') then
  say '.'
else
  nop /*  signal END */

samppath=filepath'\ORDERING.TXT'

/* build ea value  -  add long name to sample directories   */
/* 0xfdffxxxx' where xxxx is a USHORT containing the length */

longname='Ordering the original product'
test='fdff'D2X(LENGTH(longname) + 4 + LENGTH(samppath),2)'00'
longname=x2c(test)longname''x2c('0d0a')'('samppath')'
res = SysPutEA(samppath,'.LONGNAME',longname)
/*if res \== 0 then                                           */
/*   say 'Warning: Longname processing failed - continue....' */

objset = 'SHADOWID='samppath';OBJECTID=<EHS_ORDER>'
if SysCreateObject(WPShadow, 'Ordering the original product', '<EHS_PROD>',objset,'r') then
  say '.'
else
  nop /*  signal END */

END:
return
