/*====================================================================*/
/*  Name:  EHSINSCS.CMD  -  CMD file for installation                 */
/*====================================================================*/
/*                                                                    */
/*  Licensed Materials - Property of IBM                              */
/*                                                                    */
/*  5622-018 (C) Copyright IBM Corp. 1993                             */
/*                                                                    */
/*  All rights reserved.                                              */
/*  US Government Users Restricted Rights -                           */
/*  Use, duplication or disclosure restricted                         */
/*  by GSA ADP Schedule Contract with IBM Corp.                       */
/*                                                                    */
/*  See Copyright Instructions.                                       */
/*                                                                    */
/*====================================================================*/
/* Create Search Service and Sample Documents objects for SM/2 (SWS)  */

arg filepath

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

samppath=filepath'\DOCS'
sampath2=filepath'\DEMO'

/* build ea value  -  add long name to sample directory     */
/* 0xfdffxxxx' where xxxx is a USHORT containing the length */

longname='Sample documents'
test='fdff'D2X(LENGTH(longname) + 4 + LENGTH(samppath),2)'00'
longname=x2c(test)longname''x2c('0d0a')'('samppath')'
res = SysPutEA(samppath,'.LONGNAME',longname)
/*if res \== 0 then                                           */
/*   say 'Warning: Longname processing failed - continue....' */

longnam2='Demo documents'
test='fdff'D2X(LENGTH(longnam2) + 4 + LENGTH(sampath2),2)'00'
longnam2=x2c(test)longnam2''x2c('0d0a')'('sampath2')'
res = SysPutEA(sampath2,'.LONGNAME',longnam2)
/*if res \== 0 then                                           */
/*   say 'Warning: Longname processing failed - continue....' */

objset = 'OBJECTID=<EHS_SERV>;LOCATION=0;ICONVIEWPOS=15 45 50 30;NODELETE=YES;SERVERNAME=SM2'
if SysCreateObject(WPZEHSS, "Search Service", '<EHS_PROD>', objset,'r') then
  say '.'
else
  signal END

objset = 'SHADOWID='samppath';OBJECTID=<EHS_SD>'
if SysCreateObject(WPShadow, "Sample documents", '<EHS_SERV>',objset,'r') then
  say '.'
else
  signal END

objset = 'SHADOWID='sampath2';OBJECTID=<EHS_DD>'
if SysCreateObject(WPShadow, "Demo documents", '<EHS_SERV>',objset,'r') then
  say '.'
else
  signal END

END:

return
