/*====================================================================*/
/*  Name:  EHSINMCN.CMD  -  Installation (2nd part) CMD file          */
/*====================================================================*/
/*                                                                    */
/*  Licensed Materials - Property of IBM                              */
/*                                                                    */
/*  5621-404 (C) Copyright IBM Corp. 1993                             */
/*  5622-018 (C) Copyright IBM Corp. 1993                             */
/*                                                                    */
/*  All rights reserved.                                              */
/*  US Government Users Restricted Rights -                           */
/*  Use, duplication or disclosure restricted                         */
/*  by GSA ADP Schedule Contract with IBM Corp.                       */
/*                                                                    */
/*  See Copyright Instructions.                                       */
/*                                                                    */
/*====================================================================*/
/* De-Register SearchManager Classes                   */
/* Register SearchManager Classes                      */
/* Create SearchManager Object on desktop              */
/* Call other CMD's                                    */
/* Create Installation Utility Object in SM folder     */

arg filepath docpath

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
'@echo off'
if filepath = "" then
  signal USAGE
call SysCls

share = 'OS2ENVIRONMENT'
dpath = VALUE('EHSDATA',,share)

If dpath = "" then
  do
     say "The environment variables are not correct!"
     say "Before starting SearchManager/2 you should reboot your system."
     say ''
     say "Press enter to continue"
     pull
     signal END
  end /* do */

/* Register the WPS Classes */
Say 'Initializing SearchManager/2'
Say 'Please wait...'

dll1=filepath'\DLL\EHSUIDMC.DLL'
rc6= SysRegisterObjectClass("WPZEHSD",dll1)
if rc6=1 then Say '.'

dll2=filepath'\DLL\EHSUIQMC.DLL'
rc7= SysRegisterObjectClass("WPZEHSQ",dll2)
if rc7=1 then Say '.'

dll3=filepath'\DLL\EHSUIIMC.DLL'
rc8= SysRegisterObjectClass("WPZEHSI",dll3)
if rc8=1 then Say '.'

dll4=filepath'\DLL\EHSUISMC.DLL'
rc9= SysRegisterObjectClass("WPZEHSS",dll4)
if rc9=1 then Say '.'

dll5=filepath'\DLL\EHSUIFMC.DLL'
rc0= SysRegisterObjectClass("WPZEHSF",dll5)
if rc0=1 then Say '.'

if SysCreateObject(WPZEHSF,"SearchManager/2",'<WP_DESKTOP>','OBJECTID=<EHS_PROD>;ICONVIEWPOS=5 60 55 35','r') then
  say '.'

call ehsinscs.cmd filepath
call ehsinucb.cmd filepath

objset = 'PROGTYPE=WINDOWABLEVIO;EXENAME=CMD.EXE;OBJECTID=<EPFINSTS>;STARTUPDIR='filepath';PARAMETERS=/C 'filepath'\EHSINSTS.EXE;MINIMIZED=YES;ICONFILE='filepath'\EHSIICIS.ICO'
if SysCreateObject(WPProgram,"Installation Utility",'<EHS_PROD>',objset,'r') then
  say '.'
else
  signal END

signal END

USAGE:
say '  Register the SearchManager/2 Workplace Shell classes and'
say '  create the SearchManager/2 folder on the desktop.'
say '  Usage: '
say '                    EHSINNEW path1 path2'
say '  where path1 is the product program directory (example: D:\SM2)'
say '        path2 is the sample documents directory (example: D:\SM2\DOCS)'
signal END

ERROR:
say 'Error during second part of installation.'
say 'Check the environment,  reboot and try again.'
say 'Press enter to continue'
pull

END:
exit 0
