/*====================================================================*/
/*  Name:  EHSINMCN.CMD  -  Installation (2nd part) CMD file          */
/*====================================================================*/
/*                                                                    */
/*  Licensed Materials - Property of IBM                              */
/*                                                                    */
/*  5621-404 (C) Copyright IBM Corp. 1993                             */
/*  5622-018 (C) Copyright IBM Corp. 1993                             */
/*                                                                    */
/*  All rights reserved.                                              */
/*  US Government Users Restricted Rights -                           */
/*  Use, duplication or disclosure restricted                         */
/*  by GSA ADP Schedule Contract with IBM Corp.                       */
/*                                                                    */
/*  See Copyright Instructions.                                       */
/*                                                                    */
/*====================================================================*/
/* De-Register SearchManager Classes                   */
/* Register SearchManager Classes                      */
/* Create SearchManager Object on desktop              */
/* Call other CMD's                                    */
/* Create Installation Utility Object in SM folder     */

arg filepath .

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
echo off
call SysCls

share = 'OS2ENVIRONMENT'
dpath = VALUE('EHSDATA',,share)

If dpath = "" then
  do
     say "The environment variables are not correct!"
     say "Before starting SearchManager/2 you should reboot your system."
     say ''
     say "Press enter to continue"
     pull
     signal END
  end /* do */

/* Append hypertag to Sample Document */
found.0=0
sampfile=filepath'\DOCS\SMPIND03.TXT'
rc=SysFileSearch("<*VIEW:",sampfile,"found.")
if rc=0 & found.0=0 then do
   rc=lineout(sampfile,"<*VIEW:" filepath"\EHSA7MST.INF type of document index*> ")
   rc=lineout(sampfile)
end

/* Execution of Automatic Indexing ? */
Say 'To use SearchManager effectively and to get to know'
Say 'the functions it offers, read the "How to use..."'
Say 'information offered when you open the SearchManager/2'
Say 'window after this initialization has finished.'
Say 'This information assumes that you have the'
Say 'provided sample documents available, and that they'
Say 'have been put into an index.'
Say
Say 'Do you want the sample documents to be put into an'
Say 'index automatically during initialization?'
Say ''
Say 'Y(es) or N(o)?'
answer=linein()
answer=left(answer,1)
answer=translate(answer,'YN','yn','.')
do while answer\='Y' & answer\='N'
   Say 'Only Y(es) or N(o) can be entered.'
   answer=linein()
   answer=left(answer,1)
   answer=translate(answer,'YN','yn','.')
end
if answer='Y' & filepath\="" then do
   'sm2 start sm2 >NUL'
   'ehsupdir' filepath'\demo' filepath'\docs'
end
else
   nop
call SysCls

/* Register the WPS Classes */
Say 'Initializing SearchManager/2'
Say 'Please wait...'

dll1=filepath'\DLL\EHSUIDMC.DLL'
rc6= SysRegisterObjectClass("WPZEHSD",dll1)
if rc6=1 then Say '.'
else signal ERROR

dll2=filepath'\DLL\EHSUIQMC.DLL'
rc7= SysRegisterObjectClass("WPZEHSQ",dll2)
if rc7=1 then Say '.'
else signal ERROR

dll3=filepath'\DLL\EHSUIIMC.DLL'
rc8= SysRegisterObjectClass("WPZEHSI",dll3)
if rc8=1 then Say '.'
else signal ERROR

dll4=filepath'\DLL\EHSUISMC.DLL'
rc9= SysRegisterObjectClass("WPZEHSS",dll4)
if rc9=1 then Say '.'
else signal ERROR

dll5=filepath'\DLL\EHSUIFMC.DLL'
rc0= SysRegisterObjectClass("WPZEHSF",dll5)
if rc0=1 then Say '.'
else signal ERROR

if SysCreateObject(WPZEHSF,"SearchManager/2",'<WP_DESKTOP>','OBJECTID=<EHS_PROD>;ICONVIEWPOS=5 60 55 35','r') then
  say '.'
else signal ERROR

call ehsinscs.cmd filepath
call ehsinucb.cmd filepath

objset = 'PROGTYPE=WINDOWABLEVIO;EXENAME=CMD.EXE;OBJECTID=<EPFINSTS>;STARTUPDIR='filepath';PARAMETERS=/C 'filepath'\EHSINSTS.EXE;MINIMIZED=YES;ICONFILE='filepath'\EHSIICIS.ICO'
if SysCreateObject(WPProgram,"Installation Utility",'<EHS_PROD>',objset,'r') then
  say '.'
else
  signal END

start ' /B /C /FS ehsinwps d "<EHS_START>" >NUL'

signal END

ERROR:
say 'Error during second part of installation.'
say 'Check the environment,  reboot and try again.'
say 'Press enter to continue'
pull

END:
exit 0
