/*====================================================================*/
/*  Name:  EHSINDEL.CMD  -  Delete SM objects                         */
/*====================================================================*/
/*                                                                    */
/*  Licensed Materials - Property of IBM                              */
/*                                                                    */
/*  5621-404 (C) Copyright IBM Corp. 1993                             */
/*  5622-018 (C) Copyright IBM Corp. 1993                             */
/*                                                                    */
/*  All rights reserved.                                              */
/*  US Government Users Restricted Rights -                           */
/*  Use, duplication or disclosure restricted                         */
/*  by GSA ADP Schedule Contract with IBM Corp.                       */
/*                                                                    */
/*  See Copyright Instructions.                                       */
/*                                                                    */
/*====================================================================*/
/* delete object */
arg obid
'@echo off'

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

if obid = "" then do
  say 'This CMD file will delete SM/2 objects -           '
  say 'Enter:  EHSINDEL A  to delete ALL objects          '
  say 'Enter:  EHSINDEL S  to delete Server object        '
  say 'Enter:  EHSINDEL B  to delete User''s Guide object '
 end
if obid = "A" then
  signal ALL
else
  do
  if obid = "S" then
    signal SERVER
  else
    do
    if obid = "B" then
      signal BOOK
    else
      if obid = "R" then
        signal DEREGISTER
      else
        signal END
    end
 end
ALL:
ehsinwps 's "<EHS_PROD>" NODELETE=NO'
ehsinwps 'd "<EHS_PROD>"'
signal END
SERVER:
ehsinwps 's "<EHS_SERV>"  EHSCOMMAND=DELETE'
signal END
BOOK:
ehsinwps 'd "<EHS_BOOK>"'
signal END
DEREGISTER:
/* Deregister the WPS Classes */
say '  The SearchManager/2 Workplace Shell classes will be'
say '  deregistered. After this, please restart the system.'
say '  The SearchManager/2 objects will not be available any more.'
say '  To register the classes again, use EHSINNEW.CMD'
pause
rc1= SysDeregisterObjectClass("WPZEHSF")
rc2= SysDeregisterObjectClass("WPZEHSS")
rc3= SysDeregisterObjectClass("WPZEHSI")
rc4= SysDeregisterObjectClass("WPZEHSQ")
rc5= SysDeregisterObjectClass("WPZEHSD")
say '  Please shutdown the system now'
signal END
END:
exit
