/* Kuvert/2 2.11 Installation */
'@Echo Off'
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX
Call SysCls
Say 'Installation von Kuvert/2 Version 2.11...'
Say ''
Result = SysFileTree( 'KUVERT.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: KUVERT.EXE nicht gefunden! Installation abgebrochen.'
  Signal DONE
  End
Result = SysFileTree( 'KUVERT.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: KUVERT.HLP nicht gefunden! Installation abgebrochen.'
  Signal DONE
  End
Result = SysFileTree( 'PRINTQ.DLL', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: PRINTQ.DLL nicht gefunden! Installation abgebrochen.'
  Signal DONE
  End
Result = SysFileTree( 'KUVERT.DAT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: KUVERT.DAT nicht gefunden! Installation abgebrochen.'
  Signal DONE
  End
Result = SysFileTree( 'KUVERT.DOC', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: KUVERT.DOC nicht gefunden! Installation abgebrochen.'
  Signal DONE
  End
Result = SysFileTree( 'LIZENZ.TXT', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: LIZENZ.TXT nicht gefunden! Installation abgebrochen.'
  Signal DONE
  End
Say 'Bitte geben Sie den vollen Namen des Ordners an, in dem Sie'
Say 'Kuvert/2 installieren mchten (Standard ist C:\OS2\APPS): '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'
Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEHLER: Ordner konnte nicht erzeugt werden. Installation abgebrochen.'
    Signal DONE
    End
  End
Folder = '<WP_DESKTOP>'
Say 'Das Programmobjekt fr Kuvert/2 wird auf der Arbeitsoberflche erzeugt.'
Say ''

Say 'Kopieren von KUVERT.EXE nach' Directory '...'
Copy KUVERT.EXE Directory                  '1>NUL'
Say 'Kopieren von KUVERT.HLP nach' Directory '...'
Copy KUVERT.HLP Directory                  '1>NUL'
Say 'Kopieren von PRINTQ.DLL nach' Directory '...'
Copy PRINTQ.DLL Directory                  '1>NUL'
Say 'Kopieren von KUVERT.DAT nach' Directory '...'
Copy KUVERT.DAT Directory                  '1>NUL'
Say 'Kopieren von KUVERT.DOC nach' Directory '...'
Copy KUVERT.DOC Directory                  '1>NUL'
Say 'Kopieren von LIZENZ.TXT nach' Directory '...'
Copy LIZENZ.TXT Directory                  '1>NUL'
Say ''
Say 'Erzeugen des Programmobjekts...'
Say ''
Type = 'WPProgram'
Title = 'Kuvert/2'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\KUVERT.EXE;STARTUPDIR='Directory';ASSOCFILTER=*.DAT;OBJECTID=<KUVERT>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result = 1 Then
  Say 'Kuvert/2 wurde erfolgreich installiert.'
  Say 'Bitte stellen Sie sicher, da der Ordner' Directory 'in'
  Say 'der LIBPATH-Anweisung in Ihrer CONFIG.SYS-Datei angefhrt ist.'
  Say 'Lesen Sie vor der Verwendung von Kuvert/2 die Online-Hilfe'
  Say 'von Kuvert/2 sowie KUVERT.DOC.'
  Say 'Um sich als Kuvert/2-Benutzer registrieren zu lassen, senden'
  Say 'Sie bitte 25 DM (in bar) an folgende Adresse:'
  Say '  Peter Wansch'
  Say '  Hagenbachgasse 37'
  Say '  3423 St. Andr-Wrdern'
  Say '  sterreich'
  Exit
Else
  Say 'FEHLER: Programmobjekt konnte nicht erzeugt werden. Installation abgebrochen.'
  Exit

FAILURE:
Say 'Installationsfehler.'
Signal DONE
HALT:
Say 'Installationsfehler.'
Signal DONE
SYNTAX:
Say 'Installationsfehler.'
Signal DONE
DONE:
Exit
