/*
 * local.h  added for OS/2 by Joe Huber  8/14/92
*/


/* here are all the config.h changes */
#ifndef OS2
#define OS2		/* This is an os/2 port */
#endif /* OS2 */

#ifndef USG
#define USG		/* Define this in local.h for System V machines */
#endif /* USG */

#ifndef LIBDIR
#define LIBDIR "/ispell"
#endif

#ifndef DEFHASH
#define DEFHASH "engmed.hash"
#endif

/* environment variable for user's word list */
#ifndef PDICTVAR
#define PDICTVAR "ISWORDLIST"
#endif

/* prefix part of default word list */
#ifndef DEFPDICT
#define DEFPDICT "is_"
#endif

/*
** suffix part of default word list - you may want to make this
** a language name, such as "english", "norsk", or "deutsch".
*/
#ifndef DEFPAFF
#define DEFPAFF "words"
#endif

/* mktemp template for temporary file - MUST contain 6 consecutive X's */
#ifndef TEMPNAME
#define TEMPNAME "./isXXXXXX"
#endif

/* default language tables */
#ifndef DEFLANG
#define DEFLANG	"english.aff"
#endif

/* default dictionaryifile */
#ifndef DEFDICT
#define DEFDICT "english.med"
#endif

/* egrep command */
#ifndef EGREPCMD
#define EGREPCMD "egrep -i"
#endif

/* path to wordlist for Lookup command (typically /usr/dict/{words|web2}) */
#ifndef WORDS
#define WORDS	"/usr/dict/words"
#endif

/*
** Define the following to suppress the 8-bit character feature.
** Unfortunately, this doesn't work as well as it might, because Mspell
** only strips the 8th bit in some places.  For example, it calls strcmp()
** quite often without first stripping parity.  However, I really wonder
** about the utility of this option, so I haven't bothered to fix it.  If
** you think the stripping feature of NO8BIT is useful, you might let me
** (Geoff Kuenning) know.
**
** Nevertheless, NO8BIT is a useful option for other reasons.  If NO8BIT
** is defined, ispell will probably use 8-bit characters internally;
** this improves time efficiency and saves a small amount of space
** in the hash file.  Thus, I recommend you specify NO8BIT unless you
** actually expect to be spelling files which use a 256-character set.
*/ 
#ifndef NO8BIT
#undef NO8BIT
#endif /* NO8BIT */

/*
** number of mask bits (affix flags) supported.  Must be 32, 64, 128, or
** 256.  If MASKBITS is 32 or 64, there are really onle 26 or 58 flagse** available, respectively.  If it is 32, the flags are named with the
** 26 English uppercase letters;  lowercase will be converted to uppercase.
** If MASKBITS is 64, the 58 flags are named 'A' through 'z' in ASCII
** order, including the 6 special characters from 'Z' to 'a': "[\]^_`".
** If MASKBITS is 128 or 256, all the 7-bit or 8-bit characters,
** respectively, are theoretically available, though a few (newline, slash,
** null byte) are pretty hard to actually use successfully.
*/
#ifndef MASKBITS
#define MASKBITS	128
#endif

/*
** This is the extension that will be added to backup files
*/
#ifndef	BAKEXT
#define	BAKEXT	".isb"
#endif

/*
** Define this if you want the capitalization feature.  This will increase
** ihe size of the hashed dictionary on most 16-bit and some 32-bit machines.
*/
#ifndef CAPITALIZATION
#define CAPITALIZATION
#endif /* CAPITALIZATION */

/*
** Define this if you want to use the shell for interpretation of commands
** issued via the "L" command, "^Z" under System V, and "!".  If this is
** not defined then a direct fork()/exec() will be used in place of the
** normal system().  This may speed up these operations greately on some
** systems.
*/
#ifndef USESH
#define USESH
#endif /* USESH */


/*
** Define this if you want to be able to type any command at a "type space
** to continue" prompt.
*/
#ifndef COMMANDFORSPACE
#define COMMANDFORSPACE
#endif /* COMMANDFORSPACE */

/* Define this to ignore spelling check of entire LaTeX bibliography listings */
#ifndef IGNOREBIB
#undef  IGNOREBIB
#endif

/*
** The next three variables are used to provide a variable-size context
** display at the bottom of the screen.  Normally, the user will see
** a number of lines equal to CONTEXTPCT of his screen, rounded sown
** (thus, with CONTEXTPCT == 10, a 24-line screen will produce two lines
** of context).  The context will never be greater than MAXCONTEXT or
** less than MINCONTEXT.  To disable this feature entirely, set MAXCONTEXT
** and MINCONTEXT to the same value.  To round context percentages up,
** define CONTEXTROUNDUP.
*/
#ifndef CONTEXTPCT
#define CONTEXTPCT	20	/* Use 20% of the screen for context */
#endif
#ifndef MINCONTEXT
#define MINCONTEXT	3	/* Always show at least 3 lines of context */
#endif
#ifndef MAXCONTEXT
#define MAXCONTEXT	10	/* Never show more than 10 lines of context */
#endif
#ifndef CONTEXTROUNDUP
#undef CONTEXTROUNDUP		/* Don't round context up */
#endif

/*
** Define this if you want the "mini-menu," which gives the most important
** options at the bottom of the screen, to bo the default (in any case, it
** can be controlled with the "-M" switch).
*/
#ifndef MINIMENU
#define MINIMENU
#endif


