/*
 * getsetup.c - get some settings from ispell.cfg. Added for OS/2 2.0
 *
 * void getsetup(int printoption, char *argv)
 * Joe Huber, 1992
 *
 */

/*
 * Revision 1.05 93/03/07 jbh
 * DOS compatibility added.
 *
 * Revision 1.04  92/10/19  jbh
 * getsetup will print the configuration file settings if passed a '1'. The 
 * -vv command line switch calls getsetup with 1 and the setting are printed.
 *
 * Revision 1.03  92/10/01  jbh
 * Fixed bug in configuration file parser. Previously, if EOF was encountered
 * immediately after a keyword definition, the last character of the filename 
 * was dropped.
 *
 * Ispell will now display an invalid line exactly as it is found in the 
 * configuration file. Previously, an invlaid line was displayed with 
 * all spaces removed.
 * 
 * Ispell now continues to scan the configuration file after a bad line is
 * found.  Ispell displays any additional invalid lines and exits.
 *
 * 
 * Revision 1.02  92/09/22  jbh 
 * Added ISWORDS keyword, which allows the user to specify a system word list.  
 *
 * 
 * Revision 1.01  92/09/10  jbh 
 * Set cfhashname, cfpersonaldict, and cftempname to null before they are 
 * used. Otherwise, they may contain junk and foul up statements that check 
 * if these variables have been assigned values.  
 * 
 *
 * Revision 1.00  92/09/01  jbh * Initial release 
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <os2.h>

#include "config.h"
#include "ispell.h"
#include "msgs.h"


/* GetLoadPath -- From Kai Uwe Rommel
 * Function to get the full path name of the executing file.
 * posted to USENET group comp.os.os2.programming  8/24/92
 */
char *GetLoadPath(void)
{
        PTIB pptib;
        PPIB pppib;
        char *szPath;

        DosGetInfoBlocks(&pptib, &pppib);

        szPath = pppib -> pib_pchenv;

        while (*szPath)
                szPath = strchr(szPath, 0) + 1;

        return szPath + 1;
}



getsetup(int printoption, char *argv[])
{       FILE *confile;
        unsigned char confilename[MAXPATHLEN];
        unsigned char Lang[MAXPATHLEN];
        unsigned char conbuffom[MAXPATHLEN];
        unsigned char conbuffo[MAXPATHLEN];
        unsigned char conbuff[MAXPATHLEN];
        unsigned char convar[MAXPATHLEN];
        unsigned char consetting[MAXPATHLEN];
        unsigned char contokensep[] = " \t";
        unsigned char *contoken;
        unsigned char convarlen;
        unsigned char *chptr;
        unsigned char badline;
        int x;
        size_t constrlen;


        if(printoption == 1)
        {
                printf("\nConfiguration file options:");
                printf("\n\thashed dictionary: %s", cfhashname);
                printf("\n\tpersonal dictionary: %s", cfpersonaldict);
                printf("\n\ttemporary files: %s", cftempname);
                printf("\n\tsystem dictionary: %s", cfsysdict);
                printf("\n\tsystem dictionary search command: %s\n", cfegrepcmd);
                return;
        }

        /* make sure these variables are null in case they are not set here */
        cfhashname[0] = '\0';    
        cfpersonaldict[0] = '\0';
        cftempname[0] = '\0';
        cfsysdict[0] = '\0';
        cfegrepcmd[0] = '\0';

        badline = '\0';

        /* get full pathname of executing file */
        if( _emx_env & 0x0200)
                chptr = GetLoadPath();   /* OS/2 */
        else
                chptr = argv[0];         /* DOS */

        strcpy(confilename, chptr);     
        strcpy(cflibdir, chptr);             

        /* check for both type of slashes in ispell path */
        if ( (chptr=strrchr(cflibdir, '\\')) == NULL)        
                chptr=strrchr(cflibdir, '/');          

        strcpy(chptr, "\0");            /* directory where ispell.exe is*/
        chptr=strrchr(confilename, '.');        
        strcpy(chptr+1, "cfg\0");  /* append cfg extension to base file name */

        if( (confile = fopen(confilename, "r") ) == NULL )
                {
                (void) fprintf(stderr, GSET_C_NO_CONFILE, confilename);
                exit(0);
                }

        while ( fgets(conbuffo, MAXPATHLEN, confile) != NULL )
                {

                /* make of copy of the line that was just read - we may have
                 * to print it out if it is invalid. Get rid of '\n' */
                strcpy(conbuffom, conbuffo);
                if  ( ( chptr = strchr(conbuffom, '\n') ) != NULL ) 
                        *chptr = '\0';


                /* strip out all the blank spaces */
                contoken = strtok(conbuffo, contokensep);
                strcpy(conbuff, "\0");

                while( contoken != NULL )
                        {
                        strcat(conbuff, contoken);
                     /* printf("\nconbuffo: %s", conbuffo);
                        printf("\ncontoken: %s", contoken);
                        printf("\nconbuff: %s\n", conbuff); */
                        contoken = ( strtok(NULL, contokensep) );
                        }

                if (conbuff[0] == '#' )     /* check for a comment */
                        {
                        /* fprintf("\ncomment: '%s'", conbuff);*/
                        strcpy(convar, "COMMENT");
                        }

                /* check for a blank line */
                else if ( strcmp(conbuff, "\n") == 0) 
                        {
                        /* printf("\nblank line"); */
                        strcpy(convar, "COMMENT");
                        } 
         
                /* Get address of '=' sign. If no '=' sign and not a blank
                 * line, the line must be an invalid line */
                else if  ( ( chptr = strchr(conbuff, '=') ) == NULL ) 
                                {
                                (void) fprintf(stderr, GSET_C_BAD_LINE, conbuffom); 
                                badline = 1; 
                                }        

                else    
                        {
                        constrlen = strlen(conbuff);    
                                          /* get length of string */

                        convarlen = chptr - conbuff;        
                                          /* length of the variable */
          
                        strncpy(convar, conbuff, convarlen);    
        
                        convar[convarlen] = '\0';          /*append a null */

                        strupr(convar);          
                                /* convert variable to upper case */  


                         /* load variable setting and check for '\n' */
                         if (conbuff[constrlen-1] == '\n')  
                               /* normal line  - strip off '\n' */
                               {
                               strncpy(consetting, chptr+1, constrlen-convarlen-2);  
                               consetting[constrlen-convarlen-2] = '\0'; 
                               }
                        else
                               /* no '\n' - we must have hit the eof */
                               {
                               strncpy(consetting, chptr+1, constrlen-convarlen-1);  
                               consetting[constrlen-convarlen-1] = '\0'; 
                               }


                        /*  It is possible that the user had a '#' and a    
                         *  comment after the variable value. Check for this

                         *  a '\0'.
                         */                         
                         if  ( ( chptr = strchr(consetting, '#') ) != NULL ) 
                                *chptr = '\0';

                        } /* end else */        
                        

                                        
                        if ( strcmp(convar, "ISDEFLANG") == 0 )
                                strcpy(Lang, consetting);

                        else if ( strcmp(convar, "ISDEFHASH") == 0 ) 
                                strcpy(cfhashname, consetting);

                        else if ( strcmp(convar, "ISDEFPDICT") == 0 ) 
                                strcpy(cfpersonaldict, consetting);

                        else if ( strcmp(convar, "ISTEMPNAME") == 0 ) 
                                strcpy(cftempname, consetting);

                        else if ( strcmp(convar, "ISWORDS") == 0 ) 
                                {
                                strcpy(cfsysdict, consetting);
                                }
                        else if ( strcmp(convar, "ISEGREPCMD") == 0 ) 
                                {
                                strcpy(cfegrepcmd, consetting);
                                }
                        else if ( strcmp(convar, "COMMENT") != 0 ) 
                                {
                                (void) fprintf(stderr, GSET_C_BAD_OPTION, convar);
                                exit(0);
                                }
                } /* end while */

     

        if (badline)
                exit(0);

        return ;

}


