/*------------------------------------------------------------------------*\
|                                                                          |
|           SLPOS2.CMD  - Version 1.0 - Version Date 1994-12-30            |
|                         Version 2.0 - Version Date 1995-12-13            |
|                         Version 3.0 - Version Date 1996-11-12            |
|               Copyright (C) 1994-96 by C F S Nevada, Inc                 |
|                                                                          |
|                  by Dick Goran  - Voice    702-732-9616                  |
|                                 - FAX      702-732-3847                  |
|                                 - CIS      71154,2002                    |
|                                 - Internet dgoran@cfsrexx.com            |
|                                                                          |
| ------------------------------------------------------------------------ |
|  REXXLIB.DLL  - OS/2 REXX external function library                      |
|                 (c) Copyright 1992-94 Quercus Systems                    |
|                 is used only in the event of a REXX trap and is optional.|
\*------------------------------------------------------------------------*/

say "  ͻ"
say "   THIS PROGRAM PRESUMES THAT YOUR SEIKO LABEL PRNTER FUNCTIONS UNDER "
say "   NATIVE DOS. IF THIS IS NOT THE CASE, PLEASE DON'T BOTHER RUNNING   "
say "   THIS PROGRAM.                                                      "
say "  ͼ"

/*

   This program creates a DOS full screen session object for SLP /
   SLPPRO use. Also, it creates a .BAT file (SLP-INIT.BAT) in the SLP
   / SLPPRO directory.

   It may be necessary to adjust the value assigned to the variables
   SLP_DRIVER and COM_PORT below.

   There is no currently no perceptible means of allowing label printing
   to continue if the Seiko session is switched to the background.

   This program may be distributed free of charge and without any
   warranty so long as the enclosed copyright remains intact.

   Updates:
   --------
   12/13/95 2.0   Correct error when asking for SLP path choice when no
                  choices exist.
                  Setup string changes including SESSION_PRIORITY when
                  running under Warp.

   11/11/96 3.0   Change boot drive retrieval method
                  Changed VDM settings
                  Tset under Warp 4 with SLP PRO printer
*/

/*---------------------------------------*\
|  Adjust the next two values within the  |
|    quotes (apostrophes) as necessary    |
\*---------------------------------------*/
SLP_DRIVER = 'SLPPRO.SYS'           /* must contain driver name  */
COM_PORT   = 'COM3'                 /* must contain correct COM? */
/*----------------------------------------*\
|  Adjust the above two values within the  |
|    quotes (apostrophes) as necessary     |
\*----------------------------------------*/


GBL. = ''             /* initialize stem */
parse Arg             GBL.command_line
parse Version         GBL.REXX_version,
                      GBL.REXX_version_level,
                      GBL.REXX_version_day,
                      GBL.REXX_version_month,
                      GBL.REXX_version_year .
parse upper Source    GBL.operating_system,
                      GBL.calling_environment,
                      GBL.program_path_and_name
GBL.environment     = 'OS2ENVIRONMENT'
GBL.program_version = 3.0           /* version / mod of this program */
GBL.program_name    = STRIP( FILESPEC( 'N', GBL.program_path_and_name ) )
GBL.program_path    = STRIP( FILESPEC( 'D', GBL.program_path_and_name ) ||,
                             FILESPEC( 'P', GBL.program_path_and_name ) )
parse upper value VALUE( 'PATH',, GBL.environment ) with '\OS2\SYSTEM' -2,
                      GBL.boot_drive                                       +2

parse var GBL.program_name,
   GBL.program_fn '.',
   GBL.program_fe
call TIME 'E'                       /* set elapsed timer - sssss.uuuuu */
say 'Begin' GBL.program_name 'at' TIME('N')

/*---------------*\
|  Register APIs  |
\*---------------*/
/* REXXUTIL */
if RxFuncQuery( 'SysLoadFuncs' ) = 0 then
   do
      call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
      call SysLoadFuncs
   end

GBL.warp      = ( RxFuncQuery( 'SysMoveObject' ) = 0 )
GBL.warp_peer = ( SysIni( 'USER', 'PM_Workplace:Location', '<PEER_LOGOFF>' ) = 'ERROR:' )
GBL.warp_40   = ( SysIni( 'USER', 'PM_Workplace:Location', '<WP_HWMGR>' )    = 'ERROR:' )

/*------------------------*\
|  Enable trap processing  |
\*------------------------*/
   SIGNAL ON ERROR
   SIGNAL ON FAILURE
   SIGNAL ON HALT
   SIGNAL ON NOVALUE
   SIGNAL ON SYNTAX

/*------------------------*\
|  Box drawing characters  |
\*------------------------*/
dbl.h     = ''                     /* double line - horizontal            */
dbl.v     = ''                     /* double line - vertical              */
dbl.bl    = ''                     /* double line - bottom left           */
dbl.br    = ''                     /* double line - bottom right          */
dbl.tl    = ''                     /* double line - top left              */
dbl.tr    = ''                     /* double line - top right             */
dbl.t_d   = ''                     /* double line - "T" down              */
dbl.t_l   = ''                     /* double line - "T" left              */
dbl.t_r   = ''                     /* double line - "T" right             */
dbl.t_u   = ''                     /* double line - "T" up                */
dbl.cross = ''                     /* double line - cross bar             */

/*------------------------------------*\
|  Determine if COM.SYS / VCOM.SYS is  |
|  being used vs. SIO.SYS / VSIO.SYS   |
\*------------------------------------*/
COM_SYS_in_use = 0
SIO_SYS_in_use = 0

config_sys_path_and_name =,
   GBL.boot_drive || '\CONFIG.SYS'
config_sys_size =,
   STREAM( config_sys_path_and_name, 'C', 'QUERY SIZE' )
config_sys_area =,
   TRANSLATE( CHARIN( config_sys_path_and_name, 1, config_sys_size ) )
call STREAM config_sys_path_and_name, 'C', 'CLOSE'

COM_SYS_search_arg =,
   '0D0A'x                     ||,
   'DEVICE='                   ||,
   TRANSLATE( GBL.boot_drive ) ||,
   '\OS2\BOOT\COM.SYS'
if POS( COM_SYS_search_arg, config_sys_area ) > 0 then
   do
      COM_SYS_in_use = 1
   end
else
   do
      SIO_SYS_in_use = DETERMINE_IF_SIO_IN_USE()
      com1_value = ( RIGHT( com_port, 1 ) = 1 )
      com2_value = ( RIGHT( com_port, 1 ) = 2 )
      com3_value = ( RIGHT( com_port, 1 ) = 3 )
      com4_value = ( RIGHT( com_port, 1 ) = 4 )
   end

/*---------------------------------------*\
|  Attempt to determine SLP drive & path  |
\*---------------------------------------*/
slp_path   = FIND_SLP_PATH()
if slp_path = '' then
   do
      say 'Unable to determine SLP path'
      call EOJ
   end

/*--------------------------------------------------------------*\
|  Build OS/2 object on Dektop and put shadow in STARTUP folder  |
\*--------------------------------------------------------------*/
device_list =,
   'SIZE=0 ' || GBL.boot_drive || '\OS2\MDOS\ANSI.SYS,'     ||,
   'SIZE=0 ' || slp_path || slp_driver

slp_bat_file     = slp_path ||,
                   'SLP-INIT.BAT'
slp_location     = '<WP_DESKTOP>'
slp_class        = 'WPProgram'
slp_title        = 'SEIKO Label^Printer'
slp_object_id    = '<' || TRANSLATE( slp_title, ' ', '^' ) || '>'

slp_setup_string =,
   'EXENAME=command.com;'                                  ||,
   'PARAMETERS=/k' slp_bat_file || ';'                     ||,
   'CCVIEW=NO;'                                            ||,
   'ICONFILE=' || GBL.program_path || 'SLPOS2.ICO;'        ||,
   'MINIMIZED=NO;'                                         ||,
   'PROGTYPE=VDM;'                                         ||,
   'SET AUDIO_ADAPTER_SHARING=None;'                       ||,
   'SET DOS_BACKGROUND_EXECUTION=1;'                       ||,
   'SET DOS_DEVICE=' || device_list || ';'                 ||,
   'SET DOS_HIGH=1;'                                       ||,
   'SET DOS_UMB=1;'                                        ||,
   'SET DPMI_DOS_API=DISABLED;'                            ||,
   'SET DPMI_MEMORY_LIMIT=0;'                              ||,
   'SET HW_ROM_TO_RAM=1;'                                  ||,
   'SET HW_TIMER=1;'                                       ||,
   'SET IDLE_SECONDS=60;'                                  ||,
   'SET IDLE_SENSITIVITY=100;'                             ||,
   'SET INT_DURING_IO=1;'                                  ||,
   'SET KBD_ALTHOME_BYPASS=1;'                             ||,
   ''

/* COM.SYS vs. SIO.SYS differences */
if SIO_SYS_in_use = 0 then
   do
      slp_setup_string =,
         slp_setup_string                                  ||,
         'SET SIO_Allow_Access_COM1=' || com1_value || ';' ||,
         'SET SIO_Allow_Access_COM2=' || com2_value || ';' ||,
         'SET SIO_Allow_Access_COM3=' || com3_value || ';' ||,
         'SET SIO_Allow_Access_COM4=' || com4_value || ';' ||,
         'SET SIO_Mode_FIFO_Load_Count=1;'                 ||,
         'SET SIO_Mode_OCTS=Ignore CTS During Transmit;'   ||,
         'SET SIO_Mode_RTS=No Change at OPEN or CLOSE;'    ||,
         'SET SIO_Mode_XON/XOFF=Received XON is flow control;' ||,
         ''
   end
else
   do
      slp_setup_string =,
         slp_setup_string                            ||,
         'SET COM_DIRECT_ACCESS=1;'                  ||,
         'SET COM_HOLD=1;'                           ||,
         'SET COM_SELECT=' || com_port ||';'         ||,
         ''
   end

/* Session priority requires Warp */
if GBL.warp then
   do
      slp_setup_string =,
         slp_setup_string                            ||,
         'SET SESSION_PRIORITY=32;'                  ||,
         ''
   end

/* object ID always last */
slp_setup_string =,
   slp_setup_string                    ||,
   'OBJECTID=' || slp_object_id || ';' ||,
   ''

call SysCreateObject slp_class,,
                     slp_title,,
                     slp_location,,
                     slp_setup_string,,
                     'REPLACE'
if RESULT = 1 then
   do
      say slp_title ||,
          ' created successfully'
      /*----------------------------------------------------------------------*\
      |  Remove comment (/* & */ pair) lines surrounding the following state-  |
      |  ments to have Seiko label printer shadowed to your Startup folder     |
      \*----------------------------------------------------------------------*/
      /* Remove this line to shadow Seiko Label printer to Startup folder
      call SysCreateShadow slp_object_id, '<WP_START>'
      if RESULT = 1 then
         do
            say slp_title ||,
                ' has been shadowed to your Statup folder'
         end
      else
         do
            say 'Unable to shadow ' ||,
                slp_title           ||,
                ' to your Statup folder'
         end
         Remove this line to shadow Seiko Label printer to Startup folder */
   end
else
   do
      say 'Unable to create ' ||,
          slp_title
   end

/*--------------------------*\
|  Create SLP-INIT.BAT file  |
\*--------------------------*/
parse value slp_driver with,
   fn '.' fext                      /* SLPPRO */

b=0
b=b+1; bat_line.b = '@echo off'
b=b+1; bat_line.b = 'rem ͻ'
b=b+1; bat_line.b = 'rem  The following MODE statement is not necessary if your DOS session '
b=b+1; bat_line.b = 'rem  is normally 25 lines by 80 columns.                               '
b=b+1; bat_line.b = 'rem ͼ'
b=b+1; bat_line.b = 'mode co80,25'
b=b+1; bat_line.b = 'SET PROMPT=$e[0;37;44m$t$h$h$h $p$e $e[m '
b=b+1; bat_line.b = FILESPEC( 'D', slp_path )
b=b+1; bat_line.b = 'cd' STRIP( FILESPEC( 'P', slp_path ), 'T', '\' )
b=b+1; bat_line.b = 'lh ' || fn || ' /R'
b=b+1; bat_line.b = 'cls'
       bat_line.0 = b

call SysFileDelete slp_bat_file
do b = 1 to bat_line.0
   call LINEOUT slp_bat_file, bat_line.b
end
call STREAM slp_bat_file, 'C', 'CLOSE'

call EOJ 0


/*------------------------------------------------------------------------*\
|                                                                          |
|    Try to determine from CONFIG.SYS if Gwinn's SIO / VSIO are in use     |
|                                                                          |
\*------------------------------------------------------------------------*/
DETERMINE_IF_SIO_IN_USE:
   Procedure expose,
      GBL.,
      config_sys_area
parse value config_sys_area with,
   pre_SIO_SYS,
   '\SIO.SYS ',
   post_SIO_SYS

if post_SIO_SYS = '' then
   do
      return 0                      /* can't find \SIO.SYS */
   end
crlf_pos = LASTPOS( '0D0A'x, pre_SIO_SYS ) /* find end of previous line */
if crlf_pos = 0 then
   do
      return 0                      /* can't find previous cr / lf */
   end
SIO_SYS_line_beginning =,
   RIGHT( pre_SIO_SYS, LENGTH( pre_SIO_SYS ) - crlf_pos - 1 )
if LEFT( SIO_SYS_line_beginning, 7 ) = 'DEVICE=' then
   do
      return 0                      /* line may be commented out */
   end
SIO_SYS_line_beginning_pos = crlf_pos + 2
parse value config_sys_area with,
   . =(SIO_SYS_line_beginning_pos),
   SIO_SYS_line,
   '0D0A'x .

return SIO_SYS_line

/*------------------------------------------------------------------------*\
|                                                                          |
|                              Find SLP Path                               |
|                                                                          |
\*------------------------------------------------------------------------*/
FIND_SLP_PATH:
   Procedure expose,
      GBL.

say 'Searching for directory containing Seiko Label Printer files'
say '   (Please be patient)'
potential_slp_path_table.0 = 0      /* initialize table count */

drive_list = SysDriveMap( 'C', 'LOCAL' ) /* get a list of all drives */

do drive_number = 1 to WORDS( drive_list )

   drive_letter_colon    = WORD( drive_list, drive_number )
   parse value SysDriveInfo( drive_letter_colon ) with,
      . free_bytes . .
   if free_bytes = '',
         |,
      free_bytes = 0 then
      do
         iterate drive_number
      end

   /*---------------------------------------------*\
   |  Look for SLP*.SYS as a tentative indication  |
   \*---------------------------------------------*/
   call SysFileTree drive_letter_colon || '\SLP*.SYS',,
                    'slp_sys_stem',,
                    'FS'
   if slp_sys_stem.0 = 0 then iterate  /* ignore this drive */

   /*----------------------------*\
   |  Add to potential path list  |
   \*----------------------------*/
   do sss = 1 to slp_sys_stem.0
      parse value slp_sys_stem.sss with,
         slp_sys_date,
         slp_sys_time,
         slp_sys_size,
         slp_sys_attr,
         slp_sys_path_and_name
      slp_sys_path_and_name = STRIP( slp_sys_path_and_name )

      p = potential_slp_path_table.0 + 1
      potential_slp_path_table.0 = p
      potential_slp_path_table.p = FILESPEC( 'D', slp_sys_path_and_name ) ||,
                                   FILESPEC( 'P', slp_sys_path_and_name )
   end

end

select
   when potential_slp_path_table.0 = 1 then
      do
         return potential_slp_path_table.1
      end
   when potential_slp_path_table.0 = 0,
               |,
        potential_slp_path_table.0 > 9 then
      do forever
         /*-----------------------------*\
         |  Ask user to supply SLP path  |
         \*-----------------------------*/
         say 'Enter path where Seiko label printer files were installed.'
         pull reply
         test_path = reply
         if RIGHT( test_path, 1 ) = '\' then
            do
               test_path = test_path || '\'
            end
         call SysFileTree test_path || '*.*', 'test_stem', 'F'
         if test_stem.0 > 0 then
            do
               return test_path
            end
         say reply ||,
             ' is not a valid path'
         say ''
      end
   otherwise
      do forever
         /*-----------------------------------*\
         |  Ask which one to select from list  |
         \*-----------------------------------*/
         say 'Enter the number associated with the correct SLP path:'
         do p = 1 to potential_slp_path_table.0
            say COPIES( ' ', 3 )             ||,
                p                            ||,
                COPIES( ' ', 2 )             ||,
                STRIP( potential_slp_path_table.p, 'T', '\' )
         end
         pull p
         if ( p > 0 )  &  ( p <= potential_slp_path_table.0 ) then
            do
               return potential_slp_path_table.p
            end
         say '   Error. Reply must be between 1 and ' ||,
             potential_slp_path_table.0
         say ''
      end
return ''
end


/*------------------------------------------------------------------------*\
|                                                                          |
|                                End of Job                                |
|                                                                          |
\*------------------------------------------------------------------------*/
EOJ:
   Procedure expose,
      GBL.

if ARG() = 0 then
   eoj_rc = 0
else
   eoj_rc = ARG(1)

elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu */
parse value elapsed_time with seconds '.' micro_seconds
if LEFT( micro_seconds, 1, 1 ) >= 5 then
   seconds = seconds + 1
ss = FORMAT( seconds // 60, 2 )
minutes = ( seconds - ss ) / 60
mm = FORMAT( minutes // 60, 2 )
hh = FORMAT( ( minutes - mm ) / 60, 2 )
duration = hh':'mm':'ss

program_name = TRANSLATE( FILESPEC( 'N', GBL.program_path_and_name ) )
say 'EOJ  ' program_name 'at' TIME('N') ||,
    ', duration' TRANSLATE( duration, '0', ' ' )
exit eoj_rc


!tr! = VALUE('TRACE',,GBL.environment); if !tr! = '' then do; TRACE(!tr!); nop; end
/*------------------------------------------------------------------------*\
|                                                                          |
|                              Trap Routines                               |
|                                                                          |
\*------------------------------------------------------------------------*/
ERROR:   call TRAP_PROCESSING SIGL, 'ERROR',   RC
FAILURE: call TRAP_PROCESSING SIGL, 'FAILURE', RC
HALT:    call TRAP_PROCESSING SIGL, 'HALT',    ''
NOVALUE: call TRAP_PROCESSING SIGL, 'NOVALUE', ''
SYNTAX:  call TRAP_PROCESSING SIGL, 'SYNTAX',  RC

/* Rev. 95/10/14 */
TRAP_PROCESSING:
   parse Source . . TRAP.path_and_program
   trap.line_nbr = ARG(1)
   if POS( ':', TRAP.path_and_program ) > 0 then
      /* get source line if it is available */
      do t = 1
         trap_source_line.t =  SOURCELINE( trap.line_nbr )
         trap_source_line.0 = t
         trap.line_nbr      = trap.line_nbr + 1
         if RIGHT( trap_source_line.t, 1 ) = ',' then
            do
               leave
            end
      end
   else
      /* program is running in macrospace */
      do
         TRAP.path_and_program = STRIP( DIRECTORY(), 'T', '\' ) || '\' ||,
                                 TRAP.path_and_program
         trap_source_line.1 = 'Source line is not available.'
         trap_source_line.0 = 1
      end

   parse value FILESPEC( 'N', TRAP.path_and_program ) with,
      TRAP.fn '.' TRAP.fe
   trap_file_name = FILESPEC( 'D', TRAP.path_and_program ) ||,
                    FILESPEC( 'P', TRAP.path_and_program ) ||,
                    TRAP.fn || '.' || 'DMP'

   /*------------------------------------------*\
   |  check for reason not to create .DMP file  |
   \*------------------------------------------*/
   if ARG(2) = 'HALT' then
      do
         trap_file_name = ''
      end
   if RxFuncQuery( 'VARDUMP' ) = 0 then
      do
         trap_file_name = ''
      end
   if POS( ':', trap_file_name ) = 0 then
      do
         trap_file_name = ''
      end

   /*------------------------*\
   |  Build trap message box  |
   \*------------------------*/
   dbl.h    = 'CD'x                 /*  double line - horizontal   */
   dbl.v    = 'BA'x                 /*  double line - vertical     */
   dbl.bl   = 'C8'x                 /*  double line - bottom left  */
   dbl.br   = 'BC'x                 /*  double line - bottom right */
   dbl.tl   = 'C9'x                 /*  double line - top left     */
   dbl.tr   = 'BB'x                 /*  double line - top right    */
   trap.red = '1B'x || '[1;37;41m'  /* bright white on red          */
   trap.dul = '1B'x || '[0m'        /* reset to normal              */

   say ' '
   trap_error_description =,
      'Error line = ' || ARG(1) ||,
      '; ' ||,
      ARG(2) ||,
      ' error.'
   if ARG(3) = '' then
      trap_error_description = trap_error_description ||,
                               '  Return code = ' || ARG(3)
   trap.width = MAX( 74, LENGTH( trap_error_description ) )
   say trap.red || dbl.tl || COPIES( dbl.h,trap.width + 2 ) || dbl.tr || trap.dul
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( TRAP.fn'.'TRAP.fe,trap.width )    dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( trap_error_description, trap.width ) dbl.v || trap.dul
   if trap_file_name = '' then
      do
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v     CENTER( 'See: ' || trap_file_name,,
                                     trap.width )  dbl.v  || trap.dul
      end
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.bl || COPIES( dbl.h,trap.width + 2 ) || dbl.br || trap.dul
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul
   say trap.red || LEFT( 'Source line(s) at time of trap:', trap.width + 4 ) || trap.dul
   do t = 1 to trap_source_line.0
      say trap.red || LEFT( '   ' || trap_source_line.t, trap.width + 4 ) || trap.dul
   end
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul

   /*---------------------------------*\
   |  Create .DMP file if appropriate  |
   \*---------------------------------*/
   if trap_file_name = '' then
      do
         call SysFileDelete trap_file_name
         /* remove meaningless labels from dump for clarity */
         drop dbl. TRAP. RC RESULT SIGL !tr!
         call VARDUMP trap_file_name  /* write variables to program.DMP file */
      end
   exit 253
