/*
 * Install Seiko SLP
 *
 * Author: Bill Schindler
 * Date:   10 August 1999
 *
 * Installs the Seiko Smart Label Printer label layouts into Smack!'s profile.smr.
 */

IF LoadRexxUtil() THEN EXIT

profile = 'profile.smr'

IF Stream(profile, 'C', 'Query Exists') = '' THEN
 DO
  SAY 'Error: "' || profile || '" was not found.'
  SAY
  SAY '  InstSLP.cmd and SeikoSLP.smr should be placed in Smack!''s program'
  SAY '  directory. InstSLP should then be run from Smack!''s program directory.'
  EXIT
 END

didInsert = 0
tmp = 'profile.tmp'
CALL SysFileDelete tmp

DO i = 1 WHILE Lines(profile) > 0
  line = LineIn(profile)
  IF \ didInsert THEN
   DO
    test = Strip(Space(Translate(line)))
    IF Word(test, 1) = 'CALL' |,
       Pos('LOAD AVERY', test) <> 0 |,
       Pos('DEFINE COLORS', test) <> 0 THEN
     DO
      CALL LineOut tmp, '/* Load Seiko SLP label definitions */'
      CALL LineOut tmp, 'CALL "SeikoSLP.smr"'
      didInsert = 1
     END
   END
  /* Deal with the case where SeikoSLP is already installed */
  test = Strip(Translate(Space(line)))
  IF Pos('SEIKOSLP', test) = 0 &,
     Pos('SEIKO SLP', test) = 0 THEN
   DO
    CALL LineOut tmp, line
   END
END

CALL Stream profile, 'C', 'Close'
CALL Stream tmp, 'C', 'Close'

CALL SysFileDelete profile
'@ren' tmp profile '> nul'

SAY 'Seiko SLP label layouts have been added to Smack!''s profile.'

EXIT

/*------------------------------------------------------------------------
 * Load RexxUtil
 */
LoadRexxUtil: PROCEDURE
  IF RxFuncQuery('SysLoadFuncs') THEN
    DO
    IF RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs') THEN
      DO
      SAY "Error: Couldn't load RexxUtil library."
      RETURN 1
      END
    CALL SysLoadFuncs
    END
  RETURN 0
