/* rprint - Reverse order Text Printing for ASCII text files */
/* last rev 1/13/93 */
/* Gregory Spath */

'@echo off'
pagelength = 66  /* Set these parameters up to match your printer and system. */
pagewidth = 80   /* A neat addition that I didn't bother with would be to add */
trnchar = 222    /* special printer control codes for condensed print, etc. */
tempdir = "f:"   /* The pagelength and pagewidth variables make it easy to do this */

parse arg infile
if infile = '' then call help


/* read the data file and count the lines, truncating where necessary */
instring = linein(infile, 1, 1)
if length(instring) > pagewidth then
	instring = substr(instring,1,pagewidth - 1)''d2c(trnchar)
fline.1 = instring
filesize = 1
do while lines(infile) = 1
	filesize = filesize + 1
	instring = linein(infile)
	if length(instring) > pagewidth then
		instring = substr(instring,1,pagewidth - 1)''d2c(trnchar)
	fline.filesize = instring
end

/* fill in the odd page with blank lines */
oddpagelength = filesize//pagelength 
blanklines = pagelength - oddpagelength
if oddpagelength > 0 then
	do i = (filesize + 1) to (filesize + blanklines)
		fline.i = " "
	end

/* print last page first, first page last */ 
killstring = 'if exist 'tempdir'printer.txt erase 'tempdir'printer.txt'
killstring

filesize = i - 1
start = filesize - pagelength +1
do while start > 0
	do i = start to start + pagelength - 1
		call lineout tempdir"printer.txt", fline.i
	end
	start = start - pagelength
end

print tempdir"printer.txt"
		
exit

help:
say 'USAGE: RPRINT FILENAME'
exit
