/***************************************************************************
 *                                                                         *
 *  Install Prt2Up                                                         *
 *                                                                         *
 *  This REXX script installs the Prt2Up program in a directory            *
 *  of your choice and creates a program reference object on the           *
 *  desktop.                                                               *
 *                                                                         *
 *  After installation has been completed, you may move the                *
 *  program reference object to any workplace shell folder.                *
 *                                                                         *
 *  Prt2Up (c) Copyright 1993 Software Architects, Inc.                    *
 *                                                                         *
 *  First published in PC Magazine, US Edition, August 1993                *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *  Load RexxUtil interface                                                *
 ***************************************************************************/

Call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
Call SysLoadFuncs;

call SysCls                         /* Clear the screen */


call signon
call getdir
call copyfiles
call createobj
call signoff
exit


/***************************************************************************
 *                                                                         *
 *  signon: Tell the user what's happening and ask if he/she wants to      *
 *          continue with installation process.                            *
 *                                                                         *
 ***************************************************************************/

signon: procedure

say " "
say "   ͻ"
say "                                                                           "
say "                       Install Prt2Up n-Up Print Utility                   "
say "                                                                           "
say "      This program will install Prt2Up in a directory of your choice and   "
say "      create a Prt2Up object on your desktop.                              "
say "                                                                           "
say "      Press 'C' to cancel installation or any key to continue.             "
say "                                                                           "
say "   ͼ"
say " "

pull response .

if response = 'C' then do
    say 'Installation of Prt2Up cancelled at your request.'
    exit
end

return      /* User wants to continue installation */


/***************************************************************************
 *                                                                         *
 *  getdir: Ask the user for the directory in which Prt2Up is to be        *
 *          installed.  Create the directory if needed, or ask if an       *
 *          existing directory should be used.                             *
 *                                                                         *
 ***************************************************************************/

getdir: procedure expose targetdir

getdirretry:

say " "
say "Enter the drive and directory in your PATH that Prt2Up should be"
say "installed in or press enter to install in C:\PRT2UP"

pull targetdir

if targetdir = " " then do
    targetdir = "C:\Prt2Up"             /* Set default if user didn't enter */
end

rk = SysMkDir(targetdir)               /* Try to create the directory */

if rk = 0 then return                   /* If successful, we have a directory */

if rk = 5 then do
    say " "
    say "Directory " targetdir " already exists."
    say "Press Y to use this directory.  Press any other key to enter"
    say "a new directory name."

    pull response .
    if response = 'Y' then return
                      else signal getdirretry

end

if rk = 3 then do
    say " "
    say "This installation program can create only one additional level"
    say "in the directory tree.  It appears you may have asked for"
    say "additional levels to be created."
    say " "
    say "Press any key to re-enter the directory name."

    pull response .
    signal getdirretry

end

say "An error occurred while trying to make the directory: " targetdir
say " "
say "Prt2Up installation is unable to complete and is terminating now."
say " "
say "Please see READ.ME file to learn how to install Prt2Up manually."
say " "

exit

/***************************************************************************
 *                                                                         *
 *  copyfiles: Copy all Prt2Up files to the target directory               *
 *                                                                         *
 ***************************************************************************/
copyfiles: procedure expose targetdir

'copy prt2.cmd' targetdir
'copy prt2up.*' targetdir

if rc = 0 then return

say " "
say "***** An error occurred copying Prt2Up to" targetdir
say "      Installation of Prt2Up is unable to complete and is terminating"
say "      now."
say " "
exit


/***************************************************************************
 *                                                                         *
 *  createobj: Create the program reference object for Prt2Up              *
 *                                                                         *
 ***************************************************************************/

createobj: procedure expose targetdir

say 'Creating Prt2Up object on desktop ...'

rk = SysCreateObject( "WPProgram", "Prt2Up", "<WP_DESKTOP>", "OBJECTID=<Prt2Up>;EXENAME="targetdir"\prt2up.exe")

if rk = 0 then do
    say " "
    say "***** Install was unable to create a Prt2Up object on your desktop."
    say "      Please see READ.ME file for directions on how to create a"
    say "      a Prt2Up program object manually."
    say " "
    say "      Files have been copied to " targetdir " but Prt2Up object"
    say "      on desktop has not been created."
    say " "
    say '      Press Enter key to terminate installation.'

    pull response .
    exit
end

return

/***************************************************************************
 *                                                                         *
 *  signoff: Tell the user installation has been completed successfully    *
 *                                                                         *
 ***************************************************************************/

signoff: procedure

say ' '
say 'Installation of Prt2Up has completed successfully.'
say 'Press Enter key now.'

pull response .
exit

