/************************************************************************/

/*    This PGM adds PM_SPOOLER_DRVSHARE entries to the OS2SYS.INI			*/   

/*	Usage: [drive:][path]SETUPDRV /options:parm1 parm2				*/

/*	   /l   (List PM_SPOOLER_DRVSHARE entries on this work station)		*/

/*	   /a:server_name driver_path   (Add entry)						*/

/*	   /f:[drive:][path]filename   (File input of server names)				*/

/*	   /d   (Delete print_server name(s))							*/

/*												*/	

/*********************START OF PGM**************************************/

parse upper arg input1 key_value			/*Parse input for requests*/

parse var input1 .'/'request':'key_name		/*get Request and Parm1*/

if 0 < RxFuncQuery('SysLoadFuncs') THEN 		/*determine if SysLoadFuncs need loaded*/

     do

	call  RxFuncAdd  'SysLoadFuncs','RexxUtil','SysLoadFuncs'

	call  SysLoadFuncs

     end

sysini_file=value('SYSTEM_INI',,'OS2ENVIRONMENT') /*get the "system" ini loc*/

ini_app = 'PM_SPOOLER_DRVSHARE'

enter = '0D'x

crlf = '0D0A'x

tab = '09'x

call nls_translation				/*init messages "THIS ARE THE ONLY TRANSLATIONS"*/

	select

	  when request = 'L' then			/*List request*/

		call l_process

	  when request = 'F' then			/*File input request*/

		call f_process

	  when request = 'A' then			/*Add server request*/

		call a_process

	  when request = 'D' then			/*Delete request*/

		call d_process

	   otherwise					/*Signal Help screen*/

		say syntax;call help

	end /*select*/

	    signal end					/*End program*/

/*********************START OF PROCEDURES************************/

l_process:						/*List procedure*/

	rc = SysIni(sysini_file,ini_app,'ALL:',ini_data) /*initialize INI buffers*/

	if ini_data.0 > 0 then

	  do

	   say list1 

	    do i = 1 to ini_data.0

                key_value = SysIni(sysini_file,ini_app,ini_data.i)

		say list2 ini_data.i tab,

		list3 key_value

	    end i

	  end /*do*/

	else say list4

    return

a_process:						/*Add procedure*/

	if (key_name <> '') & (key_value <> '') then	 /*validation tests for NOT blank*/

	  do						/*this may be improved*/

	    if SysIni(sysini_file,ini_app,key_name,key_value) <> 'ERROR' then 

	     do

		say key_name key_value add2

		call l_process

	     end

	  else say add1		

	  end

	else call help	

     return	

f_process:						/*File input procedure*/

	if key_name = '' then do			/*help/return if no file name*/			

	  call help;return;end/*do*/

	rc = SysFileTree(key_name,inp_file,'F')	/*Search for input file*/

	if inp_file.0 = 0 then				/*File Not Found*/

	  do					

	    say file1

	    signal end					/*End Program*/

	  end 

	j = 0						/*file found,process*/

	do while lines(key_name)			/*Read file in*/

	  in_data = linein(key_name)

	  if substr(in_data,1,1) <> ';' then		/*not a comment*/

	    do		  

	      j = j+1					/*bump the counter*/

	      line.j = in_data				/*add the line the the stem*/

	    end/*do*/

	end/*while*/

	   rc = lineout(key_name)			/*Close file*/

	line.0 = j					/*Set the stem*/

	do j = 1 to line.0

          pos = pos(tab,line.j)				/*prime for 1st read*/

	   do while pos <> 0				/*this replaces TABs with ''*/

	     line.j = delstr(line.j,pos,1)		/*delete TAB*/

	     line.j = insert('',line.j,pos-1,1)		/*insert blank*/		

             pos = pos(tab,line.j)			/*look for next TAB*/

	   end/*do*/ 	

	  parse upper var line.j key_name key_value	/*init name/value*/

	  key_name = strip(key_name)		/*remove blanks*/

	  key_value = strip(key_value)

	if (key_name <> '') & (key_value <> '') then	 /*validation tests for NOT blank*/

	  do						/*this may be improved*/

	    if SysIni(sysini_file,ini_app,key_name,key_value) <> 'ERROR' then 

	     do						/*create entry*/

		say key_name key_value add2		/*report successful add*/

	     end/*do*/

	    else say add1				/*report not created*/		

	  end/*do*/

	else say file2 j file3 				/*report invalid input*/ 	

	end j 		

   return

d_process:						/*Delete server procedure*/

     DO FOREVER			/*exit from this procedure by <ENTER> at PULL*/	

	rc = SysIni(sysini_file,ini_app,'ALL:',ini_data) /*initialize INI buffers*/

	if ini_data.0 = 0 then 

	  do

	     say dele3

	     return

	  end/*do*/  	

	say list5 

	   do i = 1 to ini_data.0			/*list available entries*/

	     say i'.' ini_data.i

	   end i				

inp_again:

	PULL input					/*get the input*/

	if input = '' then				/*<ENTER>*/

	 do 

	    say dele1					/*Delete ended,return*/

	    return	

	  end

	else if (input < 1) | (input > ini_data.0) then /*validate input*/	

	     do						/*Invalid,redo*/

		say dele2 ini_data.0

	        signal inp_again

	     end /*do*/

	rc = SysIni(sysini_file,ini_app,ini_data.input,'DELETE:')  /*do the Delete*/

	signal d_process	

      END/*do forever*/	

help:							/*Screen help procedure*/

	say help1

	say help2

	say help3

	say help4

	say help5  

     return

/******************************************************************

********     NLS TRANSLATION SECTION     *****************************

******************************************************************/ 

nls_translation:

	syntax =  'Invalid Option, use the following syntax;'

	help1 = 'Usage: [drive:][path]SETUPDRV /options:parm1 parm2'

	help2 = '   /l   (List 'ini_app' entries on this work station)'

	help3 = '   /a:server_name driver_path   (Add entry)'

	help4 = '   /f:[drive:][path]filename   (File input of server names)'  

	help5 = '   /d   (Delete print_server name(s))'

	list1 = 'Contents of the 'ini_app' are;'

	list2 = 'Server name ='

	list3 = 'Driver location ='

	list4 = 'There are no entries in' ini_app

	list5 = '  Enter the number of the server entry to be removed,',

		  ' <ENTER> to end Delete'	

	dele1 = ' Delete request completed'

	dele2 = ' Invalid selection, select a number from 1 to'

	dele3 = ' There are no server entries to be deleted'

	file1 = ' Input file not found, correct name/location'

	file2 = ' Input for selection' 

	file3 = 'invalid, Please correct'

	add1 = 'ERROR, entry not created'

	add2 = 'created'

   return

end:

		call Rxfuncdrop(SysLoadFuncs)

   exit

