#define INCL_DOS
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <os2.h>
#include "gsos2.h"

#define BUFSIZE   2048
#define CMD_PIPE_BUFF 16384L

void  WriteStdOut (void *t);
void  ReadWinIn (void *t);
void  WriteCmdPipe (void *t);

HPIPE  HPipeStdIn, HPipeStdOut, HPipeWinIn, HPipeCmdPipe;
HEV    hevPipesOpened;         /*  Handle to event semaphore  */

main (int argc, char *argv[])
{
    ULONG       cbWritten;
    TID         ThreadId;
    int         i;
    CHAR        buf [BUFSIZE], *p, *q;
    STARTDATA           StartData;      /*  Start session data structure  */
    ULONG               SessID;         /*  Session ID (returned)  */
    PID                 pid;            /*  Process ID (returned)  */
    static UCHAR        PgmTitle [] = "GhostScript 2.6.1";
                                        /*  Program title string  */
    static UCHAR        PgmName [] = "gsos2pm.exe";
                                        /*  Program pathname string  */
    UCHAR               PgmInputs[1024]; /*  Input arguments to the program  */
    UCHAR               ObjBuf[100];    /*  Object buffer  */
    APIRET              rc;             /*  Return code  */
    BOOL                quote;


    /*  Create named pipes in nonblocking mode so DosConnectNPipe would  */
    /*    return immediately and put the pipes in listening mode.        */

    rc = DosCreateNPipe(PIPE_GS_STDIN, &HPipeStdIn,
                        NP_INHERIT | NP_ACCESS_OUTBOUND,
                        NP_NOWAIT | NP_TYPE_BYTE | NP_READMODE_BYTE | 0x01,
                        4096L, 0L, 10000L);
    if (rc != 0)
    {
        printf("DosCreateNPipe (gsstdin) error: return code = %ld.\n", rc);
        DosExit (EXIT_PROCESS, 1L);
    }

    rc = DosCreateNPipe(PIPE_GS_STDOUT, &HPipeStdOut,
                        NP_INHERIT | NP_ACCESS_INBOUND,
                        NP_NOWAIT | NP_TYPE_BYTE | NP_READMODE_BYTE | 0x01,
                        0L, 4096L, 10000L);
    if (rc != 0)
    {
        printf("DosCreateNPipe (gsstdout) error: return code = %ld.\n", rc);
        DosExit (EXIT_PROCESS, 1L);
    }

    rc = DosCreateNPipe(PIPE_GS_WININ, &HPipeWinIn,
                        NP_INHERIT | NP_ACCESS_INBOUND,
                        NP_NOWAIT | NP_TYPE_BYTE | NP_READMODE_BYTE | 0x01,
                        0L, 4096L, 10000L);
    if (rc != 0)
    {
        printf("DosCreateNPipe (gswinin) error: return code = %ld.\n", rc);
        DosExit (EXIT_PROCESS, 1L);
    }

    rc = DosConnectNPipe (HPipeWinIn);

    rc = DosConnectNPipe (HPipeStdOut);

    rc = DosConnectNPipe (HPipeStdIn);

    DosCreateEventSem (SEM_NAMED_PIPES, &hevPipesOpened, 0L, FALSE);

    p = PgmInputs;
    for (i = 1; i < argc; i++)
    {
	quote = (strchr(argv[i], ' ') != NULL);
	if (quote)
	  *p++ = '"';
	for (q = argv[i]; *q; q++)
	{
	  if (*q == '"' || *q == '\\')
	    *p++ = '\\';
	  *p++ = *q;
	}
	if (quote)
	  *p++ = '"';
        *p++ = ' ';
    }
    *p = '\0';

    /*  Specify the various session start parameters.  */

    StartData.Length = sizeof(STARTDATA);
    StartData.Related = SSF_RELATED_CHILD;
    StartData.FgBg = SSF_FGBG_BACK;
    StartData.TraceOpt = SSF_TRACEOPT_NONE;
    StartData.PgmTitle = PgmTitle;
    StartData.PgmName = PgmName;
    StartData.PgmInputs = PgmInputs;
    StartData.TermQ = 0;
    StartData.Environment = 0;
    StartData.InheritOpt = SSF_INHERTOPT_PARENT;
    StartData.SessionType = SSF_TYPE_PM;
    StartData.IconFile = 0;
    StartData.PgmHandle = 0;
    StartData.PgmControl = SSF_CONTROL_INVISIBLE;
    StartData.InitXPos = 0;
    StartData.InitYPos = 0;
    StartData.InitXSize = 200;
    StartData.InitYSize = 200;
    StartData.Reserved = 0;
    StartData.ObjectBuffer = ObjBuf;
    StartData.ObjectBuffLen = sizeof (ObjBuf);

    rc = DosStartSession (&StartData, &SessID, &pid);

    if (rc != 0)
    {
        printf ("DosStartSession error: return code = %ld.\n", rc);
        DosExit (EXIT_PROCESS, 1L);
    }

    /*  Wait until named pipes have been opened by gsos2pm.exe before */
    /*    setting the named pipes to blocking mode.                   */
    DosWaitEventSem (hevPipesOpened, SEM_INDEFINITE_WAIT);

    DosSetNPHState (HPipeWinIn, NP_WAIT | NP_READMODE_BYTE);
    DosSetNPHState (HPipeStdOut, NP_WAIT | NP_READMODE_BYTE);
    DosSetNPHState (HPipeStdIn, NP_WAIT | NP_READMODE_BYTE);

    /*  Create a thread that reads input from the drawing window  */
    /*    and writes them to the stdin of GhostScript.            */
    ThreadId = _beginthread (ReadWinIn, NULL, 0x20000, NULL);
    if (ThreadId == -1)
    {
        printf("_beginthread (ReadWinIn) error!\n");
        DosExit (EXIT_PROCESS, 1L);
    }

    /*  Create a thread that reads the output from the stdout of  */
    /*    GhostScript and writes them to the console.             */
    ThreadId = _beginthread (WriteStdOut, NULL, 0x20000, NULL);
    if (ThreadId == -1)
    {
        printf("_beginthread (WriteStdOut) error!\n");
        DosExit (EXIT_PROCESS, 1L);
    }

    /*  Create a thread that simulates a command pipe for Ghostscript  */
    ThreadId = _beginthread (WriteCmdPipe, NULL, 0x20000, NULL);
    if (ThreadId == -1)
    {
        printf("_beginthread (WriteCmdPipe) error!\n");
        DosExit (EXIT_PROCESS, 1L);
    }

    while (fgets (buf, BUFSIZE - 1, stdin) != NULL)
        DosWrite (HPipeStdIn, buf, (ULONG) strlen (buf), &cbWritten);
}


/*  This thread reads the output from the stdout of GhostScript and  */
/*    writes them to the console.                                    */
void WriteStdOut (void *t)
{
    ULONG ulBytesRead;
    CHAR buf [BUFSIZE];

    do
    {
        DosRead (HPipeStdOut, buf, BUFSIZE - 1, &ulBytesRead);
        if (ulBytesRead > 0)
        {
            buf [ulBytesRead] = '\0';
            fputs (buf, stdout);
            fflush (stdout);
        }
    }
    while (ulBytesRead > 0);

    /*  GhostScript has exited, and has closed the named pipe HPipeStdOut.  */
    /*    So terminate all the threads in the process using DosExit with    */
    /*    the EXIT_PROCESS parameter.                                       */

    DosExit (EXIT_PROCESS, 0L);
}


/*  This thread reads the input from the drawing window and writes them  */
/*    to the stdin of GhostScript.                                       */
void ReadWinIn (void *t)
{
    ULONG cbWritten, length;
    CHAR buf [BUFSIZE], *pchar;

    pchar = buf;

    do
    {
        DosRead (HPipeWinIn, pchar, BUFSIZE - 1, &length);
        if (length > 0)
        {
            switch (*pchar)
            {
                case '\n':
                    pchar += 1;
                    DosWrite (1, "\r\n", 2, &cbWritten);
                    DosWrite (HPipeStdIn, buf, (ULONG) (pchar - buf),
                              &cbWritten);
                    pchar = buf;
                    break;

                case '\b':
                    if (pchar - buf > 0)
                    {
                        DosWrite (1, "\b \b", 3, &cbWritten);
                        pchar -= 1;
                    }
                    break;

                default:
                    DosWrite (1, pchar, 1, &cbWritten);
                    pchar += 1;
                    break;
            }
        }
    }
    while (length > 0);
}


/*  This thread simulates a command pipe for GhostScript  */
void WriteCmdPipe (void *t)
{
    ULONG ulBytesRead;
    CHAR buf [BUFSIZE];
    APIRET rc;
    FILE *pipe;


    /*  Create a named pipe in blocking mode  */
    rc = DosCreateNPipe(PIPE_GS_CMDPIPE, &HPipeCmdPipe,
                        NP_INHERIT | NP_ACCESS_INBOUND,
                        NP_WAIT | NP_TYPE_BYTE | NP_READMODE_BYTE | 0x01,
                        0L, CMD_PIPE_BUFF, 10000L);

    if (rc != 0)
    {
        printf("DosCreateNPipe (gscmdpip) error: return code = %ld.\n", rc);
        DosExit (EXIT_PROCESS, 1L);
    }

    rc = DosConnectNPipe (HPipeCmdPipe);
    DosRead (HPipeCmdPipe, buf, BUFSIZE - 1, &ulBytesRead);
    buf [ulBytesRead] = '\0';

    if ((pipe = popen (buf, "wb")) == NULL)
    {
        printf ("Error: unable to open command pipe!\n");
        DosExit (EXIT_PROCESS, 1L);
    }

    DosPostEventSem (hevPipesOpened);
    /*  Inform the Ghostscript thread in gspm.exe that we have  */
    /*    established a pipe to the program requested.            */

    do
    {
        DosRead (HPipeCmdPipe, buf, BUFSIZE - 1, &ulBytesRead);

        if (ulBytesRead > 0)
            fwrite (buf, (size_t) ulBytesRead, 1, pipe);

    }
    while (ulBytesRead > 0);

    pclose (pipe);
}
