/*********************************************************************
  STYLUS.cmd
 *********************************************************************

   REXX-Script, um ASCII-Dateien 
	- 1 spaltig in Schnschrift oder
	- 2-spaltig in kleiner Schrift auszudrucken.

   This REXX-Script prints ASCII-Files on an Epson Stylus 
   either nice in 1 colums or double columned in a very small font.


  Untersttzte Druckeroptionen:
	siehe Hilfe am Ende der Datei

 *** Anmerkungen: ***
  * Beim Stylus sollte man im Setup-Modus als Standard-Codepage
    die PC437 einstellen, damit der Drucker denselben Zeichensatz
    wie der PC druckt.
  * Dieses Skript wurde aus meinem FX80-PrettyPrinter abgeleitet, der
    als fx80_2up.zip in gut sortierten BBS und OS/2 Servern gefunden
    werden kann.

 *FOR THE ENGLISH-SPEAKING 'rest of the world':
  There is no separate english version of this script. If you
  make modifications to this, you can use the english version of
  the companion-script fx80.cmd (which is named fx80.us) to get
  a grip on what happens where.

 *********************************************************************

  Dieses REXX-Script ist FREEWARE. Benutzung und Anpassung ausdrcklich
  erlaubt, solange u.a. CopyRight-Nachricht im Source verbleibt.

  Falls jemand Funktionalitt hinzufgt, bitte ich darum, die modifizierte
  Quelle zugeschickt mit einem kurzen Kommentar zugeschickt zu bekommen.
  Adresse:  Ralf Grohmann, Winterlinger Weg 8, 70567 Stuttgart, Germany
            oder per email: rgr@softpro.de

   (c) Ralf Grohmann 5/95

  Updates:
   Version 1.0 - first release
 *********************************************************************/
ARG DATEI MODE opt1 opt2 opt3

say '**** ASCII-Drucker fr Epson Stylus V 1.0           (c) 1995 Ralf Grohmann ****'

IF mode<>'STE' & mode<>'STX' & mode<>'STK' & mode <>'STS' & mode<>'SCR' then do
    call help
    EXIT
    END
IF datei='/h' | datei='/?' | datei='-?' | datei='-h' then do
    call help
    EXIT
    END

IF lines(datei)=0 then do
    say 'Fehler Datei <' datei '> nicht gefunden!'
    EXIT
    END

/* Parse Options */
pagepause=no
header=yes
test=no
opt1=left(opt1,2)
opt2=left(opt2,2)
opt3=left(opt3,2)
if opt1='/P' | opt2='/P' | opt3='/P' then pagepause=yes
if opt1='/T' | opt2='/T' | opt3='/T' then test=yes
if opt1='/N' | opt2='/N' | opt3='/N' then header=no

/****  Druck-Parameter: *****
  initstring : Initialisierungs-String fr Ausgabemedium
  sep:         Separator (Zwischen den Spalten, Breite:2)
  cret:        Newline (Um eine neue Zeile zu beginnen)
  ffeed:       FormFeed (Am Ende jeder Seite gesendet)
  pglen:       Seitenlaenge
  maxzl:       Spaltenbreite
  pageno:      Anfangs-Seitennummer
  protocol:    yes|no (ob eine Zustandsanzeige generiert werden soll)
  dest:        Ziel der Ausgabe, 'prn:' oder 'stdout:' oder so
  columns:     Anzahl Spalten pro Zeile, 1 oder 2
  headin:      Eingangsstring Kopfzeile
  headout:     Wird nach der Kopfzeile gedruckt
*/
/* Einige allgemeine Einstellungen */
esc = d2c(27)
cret = D2C(13) D2C(10)
ffeed = D2C(12)
RESET = ESC || '@' /* Reset */

/*****  EPSON Stylus kleinst-modus ********/
IF MODE='STX' THEN DO
/* Reset - Font: Prestige -- Kleine Schrift -- 18/180 Pt Zeilenabstand -- linker Rand 5 */
initstring=RESET||ESC||"k"||d2c(2)||ESC||"X"||d2c(18)||d2c(16)||d2c(0)||ESC || "3" || d2c(18)
sep='  '
pglen=105
maxzl=79
pageno=1
protocol=YES
columns=2
headin=ESC || "-" || d2c(1) 
headout=ESC || "-" || d2c(0)
dest='prn:'
END

/*****  EPSON Stylus kleinst-modus ********/
IF MODE='STS' THEN DO
initstring=RESET||ESC||"k"||d2c(2)||ESC||"g"||ESC || "3" || d2c(18)
sep='  '
pglen=105
maxzl=59
pageno=1
protocol=YES
columns=2
headin=ESC || "q" || d2c(3)|| ESC || "-" || d2c(1) 
headout=ESC || "q" || d2c(0) ||ESC || "-" || d2c(0)
dest='prn:'
END

/*****  EPSON Stylus kleiner Courier-modus aber 1spaltig********/
IF MODE='STK' THEN DO
initstring=RESET||ESC||"k"||d2c(2)||ESC||"g"||ESC || "3" || d2c(18)
sep='  '
pglen=106
maxzl=120
pageno=1
protocol=YES
columns=1
headin=ESC || "q" || d2c(3)|| ESC || "-" || d2c(1) 
headout=ESC || "q" || d2c(0) ||ESC || "-" || d2c(0)
dest='prn:'
END


/*****  EPSON Stylus Schnschrift, 1spaltig *********/
IF MODE='STE' THEN DO
initstring=RESET||ESC||"k"||d2c(0)||ESC||"M"||ESC || "0"
sep=''
pglen=86
maxzl=95
pageno=1
protocol=YES
columns=1
headin=ESC||"k"||d2c(1)||ESC || "q" || d2c(3)|| ESC || "-" || d2c(1) 
headout=ESC||"k"||d2c(0)||ESC || "q" || d2c(0) ||ESC || "-" || d2c(0)
dest='prn:'
END


/***** Preview auf Screen ******/
IF mode='SCR' THEN DO
initstring='';
sep='  '
ffeed = '************---- NAECHSTE SEITE -----****************'
pglen=10
maxzl=38
pageno=1
protocol=no
columns=2
headin=""
headout=""
dest='stdout:'
END


/* HeaderString */
if columns=2 then do
hstr='Ausdruck Datei <' right(datei,min(length(datei),30)) '> am ' DATE(E)
hstr=headin||left(hstr,maxzl*2-10) ' Seite: '
/*  hstr2=right('',maxzl*2+length(sep),'-') */
end
else do
hstr='Ausdruck Datei <' right(datei,min(length(datei),30)) '> am ' DATE(E)
hstr=headin||left(hstr,maxzl-12) ' Seite: '
/* hstr2=right('',maxzl,'-') */
end

/* Drucker initialisieren */
IF test=no THEN
   r=charout(dest,initstring);

/***** EINLESEN **********/
i=1
side=0
aktzl=0
DO WHILE lines(datei)
  instring=LINEIN(datei)
  if length(instring)>maxzl then
       in.i.side=LEFT(instring,maxzl-1) || '>'
  else in.i.side=LEFT(instring,maxzl)
  aktzl=aktzl+1
  i=i+1
  IF i=pglen+1 & side=0 THEN DO
          side=1
          if columns=1 then DO
            CALL printside
            side=0
            DROP in.
            END
          i=1
          END
  IF i=pglen+1 & side=1 THEN DO
          CALL printside
          side=0
          i=1
          DROP in.
          END
END /* DO WHILE LINES */

/* DEBUG: SAY 'xxxx' i side columns */
if i >= 1 THEN DO
          CALL printside
          DROP in.
          END

if test=no then SAY 'Datei ' datei ' gedruckt (' aktzl ' Zeilen, ' pageno-1' Seiten ).'
 else SAY 'Datei ' datei ' getestet (' aktzl ' Zeilen, ' pageno-1' Seite(n) ).'
r=out('')
if test=no then
   r=charout(dest,RESET);
EXIT


/*********************************************************************/
/* Prozedur um eine Seite zu drucken */
/* printside: PROCEDURE EXPOSE pglen in. sep cret */
printside:
/* DEBUG say '***** i= ' i ' side= ' side */

IF protocol=yes THEN say 'Drucke Seite ' pageno
IF header=yes THEN
  IF test=no THEN
    r=charout(dest,hstr || format(pageno,3) || cret|| headout) /*  || hstr2 ) */
pageno=pageno+1
if columns=2 then DO pr_t = 1 TO pglen BY 1
  DROP temp
  IF side=0 & i > pr_t THEN temp=in.pr_t.0 || sep
  IF side=0 & i <= pr_t THEN leave
  IF side=1 & i > pr_t THEN temp=in.pr_t.0 || sep || in.pr_t.1
  IF side=1 & i <= pr_t THEN temp=in.pr_t.0 || sep
  r=out(temp)
 END
ELSE DO pr_t = 1 TO pglen BY 1
 if pr_t < i then r=out(in.pr_t.0)
 END
r=out(ffeed)
if pagepause=yes then do
   say 'Return fr nchste Seite'
   parse pull arg
   end
RETURN

/*********************************************************************/
/* Prozedur zum Ausdrucken
   Ersetzt Sonderzeichen < 32 Hex durch BLANKS
*/
out:
PARSE ARG string

string=TRANSLATE(string,' ',XRANGE('00'x,'1F'x))

if test=no then do
    res=CHAROUT(dest , string || cret)
    if res <> 0 THEN
        SAY 'Fehler! ' res ' Zeichen konnten nicht ausgegeben werden.'
    END
RETURN 0

/*********************************************************************/
/* Hilfe-Ausgabe */
help: PROCEDURE
SAY
SAY 'Aufruf: stylus <Name-of-file-to-be-printed> <mode> [opts]'
SAY
SAY 'mode: STS|STE|SCR  (Ausgabemedium angeben)'

SAY '       STE - 1spaltig, RomanFont, 95 Zeichen auf 85 Zeilen'
SAY '       STK - 1spaltig, Courier, 120 Zeichen auf 106 Zeilen'
SAY '       STS - 2spaltig, 2 mal 59 Zeichen auf 106 Zeilen'
SAY '       STX - 2spaltig, 2 mal 79 Zeichen auf 105 Zeilen'
SAY '       SCR - Testausgabe auf Bildschirm'
SAY 'opts:  /Test - Ausgabe nicht ausfhren.'
SAY '       /Pagepause - Warten nach jeder Seite?'
SAY '       /Noheader - Drucke ohne Seitenkopf (Dateiname etc)'
SAY '    '
SAY '    (Dieses Programm druckt nach PRN:)'
RETURN