/*  delete all but for OS/2  */
/*  Jeff Elkins 1992 */

/* Modified by Dirk Terrell to check for calls with no */
/* files matching the exclusion criteria */

CALL RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
CALL RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'

ARG ext1 ext2 ext3 ext4 ext5 ext6 ext7 ext8 ext9 ext10

IF STRIP(ext1,'B') = '' THEN
	DO 
             SAY 'You must enter a argument holding 1 to 10 file templates'
             SAY
             SAY 'I.E. *.exe *.cmd *.com passed as a template string'
             SAY 'would delete all files which don''t match the'
             SAY 'supplied file extensions'
             EXIT 3
	END

t.1  = ext1
t.2  = ext2
t.3  = ext3
t.4  = ext4
t.5  = ext5
t.6  = ext6
t.7  = ext7
t.8  = ext8
t.9  = ext9
t.10 = ext10


file_error.0   = 'File deleted successfully. '
file_error.2   = 'Error.  File not found. '
file_error.3   = 'Error.  Path not found. '
file_error.5   = 'Error.  Access denied. '
file_error.26  = 'Error.  Not DOS disk. '
file_error.32  = 'Error.  Sharing violation. '
file_error.36  = 'Error.  Sharing buffer exceeded. '
file_error.87  = 'Error.  Invalid parameter. '
file_error.206 = 'Error.  Filename exceeds range error. '


/***********************************************************/
/* hide the files to be kept                               */
/***********************************************************/

Found=0 /* Added by DT */
DO x = 1 TO 10
ext = t.x
IF STRIP(ext,'B') <> '' THEN DO
   rc=SysFileTree(ext, dir_list, 'F', '*****','**+**')
   If dir_list.0<>0 then Found=1 /* Added by DT */
   END
END

/***********************************************************/
/* See if any files match the exclusion criteria           */
/* Added by DT  January, 1996                              */
/***********************************************************/

If Found=0 then do
   Say " "
   Say "WARNING: No files matched the specified exclusion criteria."
   Exit
end  /* Do */

/**************************************************************/
/* pull the files to be deleted into a stem, then delete them */
/**************************************************************/


rc=SysFileTree('*.*', del_file, 'FO', '**-**','*****')

df = del_file.0

DO x = 1 TO df
        rc = SysFileDelete(del_file.x)
        SAY del_file.x '........' file_error.RC
END


/**************************************************************/
/* unhide the hidden files                                    */
/**************************************************************/



DO x = 1 TO 10
ext = t.x
IF STRIP(ext,'B') <> '' THEN
   rc=SysFileTree(ext, dir_list, 'F', '**+**','**-**')
END

say
say df 'files deleted'
exit