#include "defalloc.h"
#include "algo.h"
#include "tempbuf.cpp"  // Can also just compile and link with this file
#include "heap.h"
#include "function.h"

#include "random.cpp"   // Can also just compile and link with this file

//Rand is used to fill the array with sequential numbers
class Rand{
   int I;

public:
   Rand(unsigned long X):I(X){}

   int operator()(){return I++;}
};


void
main(int argc, char *argv[])

{
    int    *last1;
    int    *middle;
    int     test_sequence1[15];

    middle = test_sequence1 + 10;
    last1 = test_sequence1 + 15;


    ostream_iterator<int> out_stream(cout, " ");
    less<int> less_than;

    generate((int*)test_sequence1, last1, Rand(0));
    copy((int*)test_sequence1, last1, out_stream), cout << endl;
    // Output: 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14

    random_shuffle((int*)test_sequence1, last1);
    copy((int*)test_sequence1, last1, out_stream), cout << endl;
    // Output: (the sequence of 0 through 14 with elements in random order)

    sort((int*)test_sequence1, last1);
    copy((int*)test_sequence1, last1, out_stream), cout << endl;
    // Output: 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14

    random_shuffle((int*)test_sequence1, last1);
    copy((int*)test_sequence1, last1, out_stream), cout << endl;
    // Output: (the sequence of 0 through 14 with elements in random order)

    sort((int*)test_sequence1, last1, less_than);
    copy((int*)test_sequence1, last1, out_stream), cout << endl;
    // Output: 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14


    random_shuffle((int*)test_sequence1, last1);
    copy((int*)test_sequence1, last1, out_stream), cout << endl;
    // Output: (the sequence of 0 through 14 with elements in random order)

    stable_sort((int*)test_sequence1, last1);
    copy((int*)test_sequence1, last1, out_stream), cout << endl;
    // Output: 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14

    random_shuffle((int*)test_sequence1, last1);
    copy((int*)test_sequence1, last1, out_stream), cout << endl;
    // Output: (the sequence of 0 through 14 with elements in random order)

    stable_sort((int*)test_sequence1, last1, less_than);
    copy((int*)test_sequence1, last1, out_stream), cout << endl;
    // Output: 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14


    random_shuffle((int*)test_sequence1, last1);
    copy((int*)test_sequence1, last1, out_stream), cout << endl;
    // Output: (the sequence of 0 through 14 with elements in random order)

    partial_sort((int*)test_sequence1, middle, last1);
    copy((int*)test_sequence1, last1, out_stream), cout << endl;
    // Output: 0 1 2 3 4 5 6 7 8 9 1? 1? 1? 1? 1?

}
