//-------------------------------------------------------------------------
// The following is part of the VIOWIN user-interface library source code.
// The code is copyright (c) 1994-1995 by Larry Salomon, Jr. and may not
// be used in a for-profit application without the expressed, written
// consent of Larry Salomon, Jr.  All rights reserved.
//-------------------------------------------------------------------------
#ifndef VIOWIN_INCLUDED
#define VIOWIN_INCLUDED

typedef struct _VWSWP {
   LONG lX;
   LONG lY;
   ULONG ulCx;
   ULONG ulCy;
} VWSWP, *PVWSWP;

#define VWSV_ERRORFREQ           0
#define VWSV_NOTEFREQ            1
#define VWSV_WARNINGFREQ         2
#define VWSV_ERRORDURATION       3
#define VWSV_NOTEDURATION        4
#define VWSV_WARNINGDURATION     5
#define VWSV_CXSCREEN            6
#define VWSV_CYSCREEN            7
#define VWSV_INSERTMODE          8
#define VWSV_CTIMERS             9

#define VWSV_CSYSVALUES          10

typedef BOOL (* EXPENTRY PFNDLLINIT)(VOID);
typedef MRESULT (* EXPENTRY PFNVWWP)(PVOID,ULONG,MPARAM,MPARAM);

#define VW_HABST_MONINITGOOD     0x00000001L
#define VW_HABST_MONINITBAD      0x00000002L
#define VW_HABST_MONSHOULDTERM   0x00000004L
#define VW_HABST_MONTERM         0x00000008L

#define VW_HABST_CREATINGDESK    0x00000010L

typedef struct _VWAB {
   ULONG ulSzStruct;
   ULONG ulStatus;
   HCMMEM hcmWork;
   HCLLIST hclClasses;
   HCLLIST hclWindows;
   HCLLIST hclTimers;
   HMODULE hmClasses;
   BOOL bIsSendMsg;
   struct _VWWND *hwndFocus;
   struct _VWCURSORINFO *pciCursor;
   USHORT usCursorState;
   LONG alSysValues[VWSV_CSYSVALUES];
} VWAB, *HVWAB;

typedef struct _VWWND {
   ULONG ulSzStruct;
   struct _VWCLASSINFO *pciClass;
   USHORT usId;
   ULONG ulStyle;
   VWSWP swpSwp;
   LONG lForeClr;
   LONG lBackClr;
   PCHAR pchText;
   PVOID pvData[2];
} VWWND, *HVWWND;
typedef HVWWND *PHVWWND;

typedef struct _VWQMSG {
   HVWWND hwndWnd;
   ULONG ulMsg;
   MPARAM mpParm1;
   MPARAM mpParm2;
} VWQMSG, *PVWQMSG;

typedef struct _VWCURSORINFO {
   HVWWND hwndWnd;
   SHORT sX;
   SHORT sY;
   USHORT usCx;
   USHORT usCy;
   USHORT usFlags;
} VWCURSORINFO, *PVWCURSORINFO;

typedef struct _VWTIMERINFO {
   ULONG ulSzStruct;
   HVWWND hwndWnd;
   ULONG ulId;
   ULONG ulTimeout;
   BOOL bStop;
   TID tidThread;
} VWTIMERINFO, *PVWTIMERINFO;

#define VW_SIZEQUEUE             50

typedef struct _VWMQ {
   ULONG ulSzStruct;
   VWQMSG aqmMsgs[VW_SIZEQUEUE];
   ULONG ulHead;
   ULONG ulTail;
} VWMQ, *HVWMQ;

typedef struct _VWCLASSINFO {
   CHAR achName[256];
   PFNVWWP pfnWndProc;
} VWCLASSINFO, *PVWCLASSINFO;

BOOL EXPENTRY vwInitialize(VOID);
BOOL EXPENTRY vwTerminate(VOID);

LONG EXPENTRY vwQuerySysValue(ULONG ulIndex);
BOOL EXPENTRY vwSetSysValue(ULONG ulIndex,LONG lValue);

BOOL EXPENTRY vwGetMsg(PVWQMSG pqmMsg);
BOOL EXPENTRY vwDispatchMsg(PVWQMSG pqmMsg);

BOOL EXPENTRY vwRegisterClass(PCHAR pchClass,PFNVWWP pfnWndProc);
BOOL EXPENTRY vwQueryClassName(HVWWND hwndWnd,ULONG ulSzBuf,PCHAR pchBuf);
BOOL EXPENTRY vwQueryClassInfo(PCHAR pchClass,PVWCLASSINFO pciInfo);

BOOL EXPENTRY vwCreateCursor(HVWWND hwndWnd,
                             SHORT sX,
                             SHORT sY,
                             USHORT usCx,
                             USHORT usCy,
                             USHORT usFlags);
BOOL EXPENTRY vwDestroyCursor(HVWWND hwndWnd);
BOOL EXPENTRY vwShowCursor(HVWWND hwndWnd,BOOL bShow);
BOOL EXPENTRY vwQueryCursorInfo(PVWCURSORINFO pciInfo);

HVWWND EXPENTRY vwCreateWindow(PCHAR pchClass,
                               USHORT usId,
                               ULONG ulStyle,
                               PCHAR pchText,
                               LONG lX,
                               LONG lY,
                               ULONG ulCx,
                               ULONG ulCy,
                               LONG lForeClr,
                               LONG lBackClr);
BOOL EXPENTRY vwDestroyWindow(HVWWND hwndWnd);

BOOL EXPENTRY vwIsWindow(HVWWND hwndWnd);
BOOL EXPENTRY vwIsWindowEnabled(HVWWND hwndWnd);
HVWWND EXPENTRY vwWindowFromID(USHORT usId);
BOOL EXPENTRY vwEnableWindow(HVWWND hwndWnd,BOOL bEnable);
BOOL EXPENTRY vwSetWindowText(HVWWND hwndWnd,PCHAR pchText);
BOOL EXPENTRY vwQueryWindowText(HVWWND hwndWnd,ULONG ulSzBuf,PCHAR pchBuf);
ULONG EXPENTRY vwQueryWindowTextLength(HVWWND hwndWnd);

BOOL EXPENTRY vwQueryWindowPos(HVWWND hwndWnd,PVWSWP pswpSwp);
BOOL EXPENTRY vwQueryWindowRect(HVWWND hwndWnd,PRECTL prclRect);

PVOID EXPENTRY vwQueryWindowPtr(HVWWND hwndWnd,ULONG ulPtr);
BOOL EXPENTRY vwSetWindowPtr(HVWWND hwndWnd,ULONG ulPtr,PVOID pvData);
SHORT EXPENTRY vwQueryWindowUShort(HVWWND hwndWnd,LONG lIndex);
BOOL EXPENTRY vwSetWindowUShort(HVWWND hwndWnd,LONG lIndex,USHORT usValue);
LONG EXPENTRY vwQueryWindowULong(HVWWND hwndWnd,LONG lIndex);
BOOL EXPENTRY vwSetWindowULong(HVWWND hwndWnd,LONG lIndex,ULONG ulValue);
HVWWND EXPENTRY vwQueryWindow(HVWWND hwndWnd,LONG lCmd);

LONG EXPENTRY vwQueryForeColor(HVWWND hwndWnd);
LONG EXPENTRY vwQueryBackColor(HVWWND hwndWnd);
BOOL EXPENTRY vwSetForeColor(HVWWND hwndWnd,LONG lColor);
LONG EXPENTRY vwSetBackColor(HVWWND hwndWnd,LONG lColor);

BOOL EXPENTRY vwUpdateWindow(HVWWND hwndWnd);

MRESULT EXPENTRY vwSendMsg(HVWWND hwndWnd,
                           ULONG ulMsg,
                           MPARAM mpParm1,
                           MPARAM mpParm2);
BOOL EXPENTRY vwPostMsg(HVWWND hwndWnd,
                        ULONG ulMsg,
                        MPARAM mpParm1,
                        MPARAM mpParm2);
BOOL EXPENTRY vwInSendMsg(VOID);

MRESULT EXPENTRY vwDefWindowProc(HVWWND hwndWnd,
                                 ULONG ulMsg,
                                 MPARAM mpParm1,
                                 MPARAM mpParm2);

BOOL EXPENTRY vwSetFocus(HVWWND hwndWnd);
HVWWND EXPENTRY vwQueryFocus(VOID);

BOOL EXPENTRY vwAlarm(USHORT usType);

BOOL EXPENTRY vwInflateRect(PRECTL prclRect,SHORT sDx,SHORT sDy);
BOOL EXPENTRY vwIsRectEmpty(PRECTL prclRect);
BOOL EXPENTRY vwIntersectRect(PRECTL prclDest,PRECTL prclSrc1,PRECTL prclSrc2);

SHORT EXPENTRY vwDrawText(HVWWND hwndWnd,
                          SHORT sLenText,
                          PCHAR pchText,
                          PRECTL prclRect,
                          LONG lForeClr,
                          LONG lBackClr,
                          USHORT usFlags);
BOOL EXPENTRY vwFillRect(HVWWND hwndWnd,PRECTL prclRect,LONG lColor);

BOOL EXPENTRY vwLoadString(ULONG ulId,ULONG ulSzBuf,PCHAR pchBuf);

BOOL EXPENTRY vwStartTimer(HVWWND hwndWnd,ULONG ulId,ULONG ulTimeout);
BOOL EXPENTRY vwStopTimer(HVWWND hwndWnd,ULONG ulId);

#define VWCLR_BLACK              0L
#define VWCLR_DARKBLUE           1L
#define VWCLR_DARKGREEN          2L
#define VWCLR_DARKCYAN           3L
#define VWCLR_DARKRED            4L
#define VWCLR_DARKPINK           5L
#define VWCLR_BROWN              6L
#define VWCLR_PALEGRAY           7L
#define VWCLR_DARKGRAY           8L
#define VWCLR_BLUE               9L
#define VWCLR_GREEN              10L
#define VWCLR_CYAN               11L
#define VWCLR_RED                12L
#define VWCLR_PINK               13L
#define VWCLR_YELLOW             14L
#define VWCLR_WHITE              15L

#define VWWC_BUTTON              "VwButtonClass"
#define VWWC_ENTRYFIELD          "VwEntryfieldClass"
#define VWWC_LISTBOX             "VwListboxClass"
#define VWWC_SCROLLBAR           "VwScrollbarClass"
#define VWWC_STATIC              "VwStaticClass"

#define VWWID_MAX                ((USHORT)0x3FFF)
#define VWWID_DESKTOP            ((USHORT)(VWWID_MAX+1))

#define VWHWND_DESKTOP           ((HVWWND)1)

#endif                           // #ifndef VIOWIN_INCLUDED
